/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.CompositeFeatureGuid;
import ventus.util.MerlinUtil;

public record ObjSource<ObjT extends IMerlinObj>(Class<ObjT> type, Function<ObjT, String> format, Supplier<? extends Stream<? extends ObjT>> getObjs) {
    public static <ObjT extends IMerlinObj> ObjSource<ObjT> includeNull(Class<ObjT> type, String nullName, Function<ObjT, String> nonNullFormat, Supplier<? extends Stream<? extends ObjT>> getNonNullObjs) {
        return ObjSource.includeNull(type, nullName, nonNullFormat, MerlinUtil.sortByName(nonNullFormat), getNonNullObjs);
    }

    public static <ObjT extends IMerlinObj> ObjSource<ObjT> includeNull(Class<ObjT> type, String nullName, Function<ObjT, String> nonNullFormat, Comparator<ObjT> nonNullComparator, Supplier<? extends Stream<? extends ObjT>> getNonNullObjs) {
        return new ObjSource<ObjT>(type, nullName != null ? obj -> obj == null ? nullName : (String)nonNullFormat.apply(obj) : nonNullFormat, nullName != null ? () -> Stream.concat(Stream.of((IMerlinObj)null), ((Stream)getNonNullObjs.get()).sorted(nonNullComparator)) : () -> ((Stream)getNonNullObjs.get()).sorted(nonNullComparator));
    }

    public static <ObjT extends IMerlinObj> ObjSource<ObjT> concat(ObjSource<ObjT> source, ObjT elem) {
        return new ObjSource<ObjT>(source.type, source.format, () -> Stream.concat(Stream.of(elem), source.getObjs.get()));
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(VentusData data, Class<T> type, String nullName) {
        return ObjSource.fromModelRobust(data, type, nullName, Predicates.alwaysTrue());
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(VentusData data, Class<T> type, String nullName, Predicate<? super T> filter) {
        return ObjSource.fromModelRobust((VentusData)data, type, (String)nullName, filter, null, (IMerlinObj[])new IMerlinObj[0]);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(VentusData vd, Class<T> type, String nullName, Predicate<? super T> filter, Comparator<T> nonNullSorter, T ... specialValues) {
        Supplier<Stream> getBaseObjs = () -> {
            Stream<Object> stream = type.equals(Material.class) ? vd.materials.flatten(type, filter).stream() : vd.getChildren().stream().filter(member -> member instanceof Composite).map(member -> (Composite)member).flatMap(comp -> comp.flatten(type, filter).stream());
            if (nonNullSorter == null) {
                ArrayList values = stream.collect(Collectors.toCollection(() -> new ArrayList()));
                Comparator sort = MerlinUtil.getSorter(vd, values);
                Collections.sort(values, sort);
                return values.stream();
            }
            return stream.sorted(nonNullSorter);
        };
        Supplier<Stream> getObjs = () -> {
            Stream<Object> result = Stream.empty();
            if (nullName != null && Stream.of(specialValues).noneMatch(v -> v == null)) {
                result = Stream.of((IMerlinObj)null);
            }
            result = Stream.concat(result, Stream.of(specialValues));
            return Stream.concat(result, (Stream)getBaseObjs.get());
        };
        Function<IMerlinObj, String> format = nullName == null ? MerlinUtil::getName : v -> v == null ? nullName : MerlinUtil.getName(v);
        return new ObjSource<IMerlinObj>(type, format, getObjs);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromRoot(VentusData vd, Composite<? extends IMerlinObj> root, Class<T> clazz, Predicate<? super T> availFilter) {
        return ObjSource.fromRoot(vd, root, clazz, availFilter, null);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromRoot(VentusData vd, Composite<? extends IMerlinObj> root, Class<T> clazz, Predicate<? super T> availFilter, Comparator<T> sorter) {
        Predicate<Object> filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        return new ObjSource<IMerlinObj>(clazz, MerlinUtil::getName, () -> {
            Stream stream = root.flatten(clazz, filter).stream();
            if (sorter == null) {
                ArrayList objs = stream.collect(Collectors.toCollection(() -> new ArrayList()));
                Comparator sort = MerlinUtil.getSorter(vd, objs);
                Collections.sort(objs, sort);
                return objs.stream();
            }
            return stream.sorted(sorter);
        });
    }

    public static ObjSource<Floor> getFloors(VentusData vd, String nullName) {
        return ObjSource.includeNull(Floor.class, null, MerlinUtil::getName, (f1, f2) -> f1.getWorkingZ().compareTo(f2.getWorkingZ()), () -> vd.floors.flatten(Floor.class).stream());
    }

    public static ObjSource<ISchematicRoom> getZones(VentusData vd, String nullName) {
        return ObjSource.includeNull(ISchematicRoom.class, nullName, MerlinUtil::getName, () -> vd.floors.flatten(ISchematicRoom.class).stream());
    }

    public static ObjSource<Material> getMaterials(VentusData vd, String nullName) {
        return ObjSource.includeNull(Material.class, nullName, MerlinUtil::getName, () -> vd.materials.flatten(Material.class).stream());
    }

    public static <RootT extends Composite<ObjT>, ObjT extends IMerlinObj> ObjSource<ObjT> getFeature(VentusData vd, CompositeFeatureGuid<RootT, ObjT> guid, String nullName) {
        return ObjSource.includeNull(guid.objType, nullName, MerlinUtil::getName, () -> ((Composite)vd.getComponentData(guid)).flatten(guid.objType).stream());
    }
}

