/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.gui.ObjSource;
import ventus.gui.guiUtil;
import ventus.util.MerlinUtil;

public class MerlinComboBox<T extends IMerlinObj>
extends guiComboBox<T>
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private final VentusData d_data;
    private Semaphore d_updateLock = new Semaphore(1);
    private ObjSource<T> d_source;

    public MerlinComboBox(VentusData md, Class<T> type, T ... specialValues) {
        this(md, type, Predicates.alwaysTrue(), (IMerlinObj[])specialValues);
    }

    public MerlinComboBox(VentusData md, Class<T> type, Predicate<? super T> filter, T ... specialValues) {
        this(md, type, filter, null, (IMerlinObj[])specialValues);
    }

    public MerlinComboBox(VentusData md, Class<T> type, Predicate<? super T> filter, Comparator<T> sorter, T ... specialValues) {
        this(md, ObjSource.fromModelRobust((VentusData)md, type, null, filter, sorter, specialValues));
    }

    public MerlinComboBox(final VentusData md, final ObjSource<T> source) {
        this.d_data = md;
        this.d_source = source;
        SwingUtilities.invokeLater(() -> md.getEvents().addObserver(this));
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Function<IMerlinObj, String> format = v -> source.type() != null && source.type().isInstance(v) ? source.format().apply((IMerlinObj)source.type().cast(v)) : MerlinUtil.getName(v);
                if (value == null) {
                    this.setText(MerlinComboBox.this.d_source.format().apply(null));
                } else if (!guiUtil.decorateComboRenderer(md, MerlinComboBox.this, list, format, value, this, isSelected, cellHasFocus)) {
                    this.setText("");
                }
                return this;
            }
        });
        this.updateEntries();
    }

    public Semaphore getUpdateLock() {
        return this.d_updateLock;
    }

    public void setSource(ObjSource<T> source) {
        if (this.d_source.equals(source)) {
            return;
        }
        this.d_source = source;
        this.updateEntries();
    }

    public ObjSource<T> getSource() {
        return this.d_source;
    }

    protected String getName(VentusData md, Object o) {
        if (!(o instanceof IMerlinObj)) {
            return o == null ? "" : o.toString();
        }
        EntryPoint<IMerlinObj> ep = EntryPointFactory.get((IMerlinObj)o);
        return ep.tvEntryPoint.getName(md, (IMerlinObj)o);
    }

    protected List<T> getItems(VentusData md) {
        return this.d_source.getObjs().get().collect(Collectors.toList());
    }

    private void updateEntries() {
        IMerlinObj selItem = (IMerlinObj)this.getSelectedItem();
        List<T> items = this.getItems(this.d_data);
        this.setItems(items);
        if (items.contains(selItem)) {
            this.setSelectedItem(selItem);
        } else if (!items.isEmpty()) {
            this.setSelectedIndex(0);
        }
    }

    @Override
    public void update(Events events) {
        if (this.d_source.type() == null) {
            return;
        }
        if (!this.d_updateLock.tryAcquire()) {
            return;
        }
        try {
            IEventRecord<T> evt = events.getEvents(this.d_source.type(), new Class[0]);
            if (!evt.getAddedObjs().isEmpty() || !evt.getRemovedObjs().isEmpty()) {
                this.updateEntries();
            } else if (evt.hasChangedObjs()) {
                this.repaint();
            }
        }
        finally {
            this.d_updateLock.release();
        }
    }

    public static class MerlinComboBoxWithEmptyOption<T extends IMerlinObj>
    extends MerlinComboBox<T> {
        private static final long serialVersionUID = 1L;

        public MerlinComboBoxWithEmptyOption(VentusData md, Class<T> type, String msg, Predicate<? super T> filter) {
            super(md, ObjSource.fromModelRobust((VentusData)md, type, (String)msg, filter, new MerlinUtil.SortByName(), (IMerlinObj[])new IMerlinObj[0]));
        }

        public MerlinComboBoxWithEmptyOption(VentusData md, Class<T> type, String msg) {
            this(md, type, msg, Predicates.alwaysTrue());
        }

        public MerlinComboBoxWithEmptyOption(VentusData md, Class<T> type, Predicate<? super T> filter) {
            this(md, type, Intl.intl("[None]"), filter);
        }

        public MerlinComboBoxWithEmptyOption(VentusData md, Class<T> type) {
            this(md, type, Intl.intl("[None]"));
        }

        @Override
        public int getSelectedIndex() {
            int index = super.getSelectedIndex();
            if (index == -1) {
                index = 0;
            }
            return index;
        }
    }
}

