/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.weather;

import java.util.Arrays;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.feature.Feature;
import ventus.feature.FeatureGuid;
import ventus.feature.comps.BasicHotkey;
import ventus.feature.comps.DefaultFlatDataModel;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.ScenarioParameterSrcProps;
import ventus.feature.weather.EditWeatherAction;
import ventus.feature.weather.PrjDataWriterWeatherComp;
import ventus.feature.weather.WeatherOISHandler;
import ventus.feature.weather.WeatherProps;

public class WeatherFeature {
    public static final FeatureGuid<WeatherProps> GUID = new FeatureGuid<WeatherProps>("Weather.data", WeatherProps.class);

    public static Feature create() {
        DefaultFlatDataModel<WeatherProps> dataModel = new DefaultFlatDataModel<WeatherProps>(GUID, WeatherProps::new);
        WeatherOISHandler oisHandler = new WeatherOISHandler();
        PrjDataWriterWeatherComp dataWriter = new PrjDataWriterWeatherComp(dataModel);
        IAppMenuItem menuItem = root -> root.getNode("model").add(10, (Object)EditWeatherAction.UI_HOOK.getMenuItem());
        BasicHotkey<UIHook> hotkey = new BasicHotkey<UIHook>("editWeather", ShortcutInfo.Category.MODEL, EditWeatherAction.UI_HOOK, false);
        ScenarioParameterSrcProps<WeatherProps> scenariosComp = new ScenarioParameterSrcProps<WeatherProps>(dataModel, Arrays.asList(WeatherProps.ambientTemp, WeatherProps.windDirection));
        return new Feature(menuItem, hotkey, dataModel, oisHandler, dataWriter, scenariosComp);
    }
}

