/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsField;
import ventus.feature.tags.TagsUtil;

public class MixedTagsAddOp {
    public static final UIHook UI_HOOK_ADD = new UIHook(new AddTagsOp(), Intl.intl("Add Tags"));
    public static final UIHook UI_HOOK_REMOVE = new UIHook(new RemoveTagsOp(), Intl.intl("Remove Tags"));

    public static void modifyTags(VentusApp app, VentusData md, String title, BiFunction<VentusData, Set<String>, Set<Tag>> convertModTags, BiFunction<Set<Tag>, Set<Tag>, Set<Tag>> modifyTags) {
        ModifyMixedTagsDlg editTagsDlg = new ModifyMixedTagsDlg((Window)app.getActiveFrame(), title);
        if (editTagsDlg.doModal() != 1) {
            return;
        }
        Set strTags = (Set)editTagsDlg.tags.getValue();
        try (VentusData.WriteLock lock = md.lockWrite();){
            HashMap<Set, Set> tagsCache = new HashMap<Set, Set>();
            Set getObjs = md.selection.getSelected(IMerlinObj.class);
            Undo.begin(title);
            Set<Tag> modTags = convertModTags.apply(md, strTags);
            if (!modTags.isEmpty()) {
                List<IMerlinObj> modObjs = CompElementActions.flattenToLocallyDefined(VentusData.TAGS, getObjs);
                ArrayList<Pair<IMerlinObj, Set>> modifications = new ArrayList<Pair<IMerlinObj, Set>>(modObjs.size());
                for (IMerlinObj iMerlinObj : modObjs) {
                    Set<Tag> newTags;
                    Set oldTags = iMerlinObj.getWithDetails(VentusData.TAGS).orElse(Collections.emptySet());
                    if (oldTags == (newTags = modifyTags.apply(oldTags, modTags))) continue;
                    Set replTags = tagsCache.computeIfAbsent(newTags, t -> t);
                    modifications.add(new Pair<IMerlinObj, Set>(iMerlinObj, replTags));
                }
                if (!modifications.isEmpty()) {
                    modifications.stream().map(p -> (IMerlinObj)p.v1).forEach(o -> o.insertUndoEntry_propRestore(VentusData.TAGS));
                    for (Pair pair : modifications) {
                        ((IMerlinObj)pair.v1).set(VentusData.TAGS, (Set)pair.v2);
                    }
                }
            }
            Undo.end(md);
        }
    }

    public static class ModifyMixedTagsDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final TagsField tags = new TagsField();

        public ModifyMixedTagsDlg(Window owner, String title) {
            super(owner, title, 9);
            this.tags.setEmptyAllowed(false);
            this.tags.setNullAllowed(false);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(Intl.intl("Tags:"), this.tags, 1.0, 0);
            gb.finalizeRows();
            this.setResizable(true);
        }
    }

    public static class AddTagsOp
    extends AMerlinOp {
        @Override
        public void run(VentusApp app, VentusData md) {
            MixedTagsAddOp.modifyTags(app, md, Intl.intl("Add Tags"), (vd, strTags) -> TagsUtil.getOrCreateTags(strTags, vd), (oldTags, modTags) -> {
                if (oldTags.isEmpty()) {
                    return modTags;
                }
                if (oldTags.containsAll((Collection<?>)modTags)) {
                    return oldTags;
                }
                LinkedIdentityHashSet result = new LinkedIdentityHashSet(oldTags);
                result.addAll(modTags);
                return result;
            });
        }
    }

    public static class RemoveTagsOp
    extends AMerlinOp {
        @Override
        public void run(VentusApp app, VentusData md) {
            MixedTagsAddOp.modifyTags(app, md, Intl.intl("Remove Tags"), (vd, strTags) -> TagsUtil.getExistingTags(strTags, vd, s -> {}), (oldTags, modTags) -> {
                block3: {
                    block2: {
                        if (oldTags.isEmpty()) break block2;
                        if (!modTags.stream().noneMatch(oldTags::contains)) break block3;
                    }
                    return oldTags;
                }
                LinkedIdentityHashSet result = new LinkedIdentityHashSet(oldTags);
                result.removeAll((Collection<?>)modTags);
                return result.isEmpty() ? Collections.emptySet() : result;
            });
        }
    }
}

