/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesData;
import ventus.feature.species.SpeciesEditor;
import ventus.feature.species.SpeciesManager;
import ventus.feature.species.SpeciesRoot;
import ventus.gui.ManagerDlg;
import ventus.unitsystem.UnitSystem;

public class SpeciesMgrDlg
extends ManagerDlg<Species, SpeciesManager> {
    private static final long serialVersionUID = 1L;
    private final SpeciesEditor d_editor;
    private SpeciesManager d_manager;

    public SpeciesMgrDlg(JFrame owner, UnitSystem us) {
        super(owner, Intl.intl("Edit Species"), Species.class);
        this.d_editor = new SpeciesEditor(us);
        this.createActions();
        this.updateActions();
    }

    private void createActions() {
        this.addAction(new guiAction(Intl.intl("New..."), this::createNew));
        this.addAction(new guiAction(Intl.intl("Duplicate..."), this::duplicate));
        this.addAction(new ManagerDlg.RenameAction(this, Species.NAME), x$0 -> super.canRename(x$0));
        this.addAction(new ManagerDlg.DeleteAction(this), x$0 -> super.canDelete(x$0));
    }

    public void init(VentusData data, SpeciesManager manager, Species node) {
        super.init(data, manager, this.d_editor, SpeciesData.ICON);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
        } else {
            this.getList().select(node);
        }
        this.d_editor.init((Species)this.getList().getSelectedItem());
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        SpeciesRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        final guiTextField nameField = new guiTextField(ng.generateValidName(Intl.intl("Species")));
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SpeciesMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Species"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            root.add(new Species(nameField.getValue()));
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        SpeciesRoot root = this.d_manager.getRoot();
        Species selected = (Species)this.getList().getSelectedItem();
        guiComboBox<Species> basedOnComboBox = new guiComboBox<Species>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                Species item = (Species)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SpeciesMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Species"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            Species species = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new Species(name);
            species.setName(name);
            root.add(species);
            this.getList().updateModelView(this.d_manager);
        }
    }
}

