/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.awt.Color;
import java.awt.Component;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Box;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.ComponentSizeFixer;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.feature.props.IDisplayProp;
import ventus.feature.species.Species;
import ventus.gui.ManagerDlg;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class SpeciesEditor
extends guiPanel
implements IEditor<Species> {
    private static final long serialVersionUID = 1L;
    private final Bindings d_bindings = new Bindings();
    private final List<Consumer<Species>> d_onInit = new ArrayList<Consumer<Species>>();

    public SpeciesEditor(UnitSystem us) {
        super(new MigLayout("insets 0", "[left][grow][right]"));
        guiTextField name = new guiTextField();
        this.d_onInit.add(spec -> {
            name.setText(spec.getName());
            name.setEnabled(false);
        });
        guiTextField desc = this.d_bindings.bind(Species.DESC, new guiTextField());
        ColorButton color = this.d_bindings.bind(Species.COLOR, guiUtil.newColorButton());
        SpeciesEditor.addRow((guiPanel)this, Species.NAME.name, Intl.intl("Unique species name\nIf this is <b>H2O</b>, this species will be used as water vapor and concentration will be affected by humidity."), name, "growx, wrap");
        SpeciesEditor.addRow((guiPanel)this, Species.DESC, desc, "width pref*2.5, growx, wrap");
        SpeciesEditor.addRow((guiPanel)this, Species.COLOR, color, "sg 1, wrap");
        this.add((Component)new guiSeparator(), "growx, span, wrap");
        ValueField<UnitDouble> molarMass = this.d_bindings.bind(Species.MOLAR_MASS, ValueFields.udFld(UnitSystem.getType(18, false), UnitDoubleVR.ge(1.0, SI.GRAM.divide(SI.MOLE))));
        ValueField<UnitDouble> defaultConcentration = this.d_bindings.bind(Species.DEFAULT_CONCENTRATION, ValueFields.udFld(UnitSystem.getType(25, false), UnitDoubleVR.ge(0.0, Unit.ONE)));
        guiComboBox<Species.TraceContaminant> traceContaminant = guiUtil.newCombo(trace -> new Pair<String, String>(trace.name, trace.desc), Species.TraceContaminant.values());
        this.d_bindings.bind(traceContaminant, new Binding<Species>(data -> traceContaminant.setSelectedItem(data.get(Species.TRACE_CONTAMINANT)), data -> data.set(Species.TRACE_CONTAMINANT, (Species.TraceContaminant)traceContaminant.getSelectedItem())));
        guiPanel propsPanel = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        SpeciesEditor.addRow(propsPanel, Species.MOLAR_MASS, molarMass, new String[0]);
        SpeciesEditor.addRow(propsPanel, Species.TRACE_CONTAMINANT, traceContaminant, new String[0]);
        SpeciesEditor.addRow(propsPanel, Species.DEFAULT_CONCENTRATION, defaultConcentration, new String[0]);
        this.add((Component)propsPanel, "grow, span, wrap");
        ComponentSizeFixer.fromExistingContainer(this).setAllPreferredWidthToMax();
    }

    private static List<Component> addRow(guiPanel migPanel, IDisplayProp<?> prop, Component comp, String ... compConstraints) {
        return SpeciesEditor.addRow(migPanel, prop.getDisplayName(), prop.getDisplayDesc(), comp, compConstraints);
    }

    private static List<Component> addRow(guiPanel migPanel, String name, String desc, Component comp, String ... compConstraints) {
        ArrayList<Component> comps = new ArrayList<Component>();
        guiLabel label = guiUtil.lblPropHtml(name, desc);
        comps.add(label);
        migPanel.add(label);
        Component glue = Box.createGlue();
        comps.add(glue);
        migPanel.add(glue, "");
        comps.add(comp);
        if (compConstraints.length > 0) {
            migPanel.add(comp, String.join((CharSequence)", ", compConstraints));
        } else {
            migPanel.add(comp, "wrap");
        }
        return comps;
    }

    @Override
    public void init(Species dataObj) {
        ManagerDlg.defaultInit(this, dataObj, obj -> {
            this.setEnabled(dataObj != null);
            this.d_bindings.load(dataObj);
            this.d_onInit.forEach(handler -> handler.accept(dataObj));
        });
    }

    @Override
    public Species commit(Species dataObj) {
        return ManagerDlg.defaultCommit(this, dataObj, Intl.intl("Edit Species"), "SpeciesEditor.commit", obj -> this.d_bindings.store(dataObj));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private static class Bindings {
        private final Map<Component, Binding<Species>> d_bindings = new HashMap<Component, Binding<Species>>();

        public void load(Species dataObj) {
            for (Binding<Species> binding : this.d_bindings.values()) {
                binding.updateComp.accept(dataObj);
            }
        }

        public void store(Species dataObj) {
            for (Map.Entry<Component, Binding<Species>> entry : this.d_bindings.entrySet()) {
                Component comp = entry.getKey();
                if (!comp.isShowing() || !comp.isEnabled()) continue;
                entry.getValue().updateData.accept(dataObj);
            }
        }

        public <F extends Component> F bind(F comp, Binding binding) {
            this.d_bindings.put(comp, binding);
            return comp;
        }

        public <T, F extends Component> F bind(TypedProp<T> prop, F fld) {
            F f = fld;
            Objects.requireNonNull(f);
            F f2 = f;
            int n = 0;
            Binding<Species> bindObj = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{guiTextField.class, ValueField.class, ColorButton.class, guiCheckBox.class}, f2, n)) {
                case 0 -> {
                    guiTextField textField = (guiTextField)f2;
                    yield new Binding<Species>(data -> textField.setValue((String)data.get(prop)), data -> data.set(prop, textField.getValue()));
                }
                case 1 -> {
                    ValueField vf = (ValueField)f2;
                    yield new Binding<Species>(data -> vf.setValue(data.get(prop)), data -> data.set(prop, vf.getValue()));
                }
                case 2 -> {
                    ColorButton colorButton = (ColorButton)f2;
                    yield new Binding<Species>(data -> colorButton.setColor((Color)data.get(prop)), data -> data.set(prop, colorButton.getColor()));
                }
                case 3 -> {
                    guiCheckBox checkBox = (guiCheckBox)f2;
                    yield new Binding<Species>(data -> checkBox.setSelected((Boolean)data.get(prop)), data -> data.set(prop, checkBox.isSelected()));
                }
                default -> throw new IllegalArgumentException(fld.getClass().getName() + " not supported");
            };
            return this.bind(fld, bindObj);
        }
    }

    private static class Binding<T> {
        public final Consumer<T> updateComp;
        public final Consumer<T> updateData;

        public Binding(Consumer<T> updateComp, Consumer<T> updateData) {
            this.updateComp = updateComp;
            this.updateData = updateData;
        }
    }
}

