/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.props.TypedProps;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesData;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.util.Dependencies;

public class SourceSinkElement
extends NamedMerlinObj
implements Serializable,
ISurrogate,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<SourceSinkElement> PROP_TYPES = new PropertyDefs<SourceSinkElement>(SourceSinkElement.class, PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<String> DESC = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.DESC", "", Intl.intl("Description"), Intl.intl("Source/Sink element description.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> DESCRIPTION = PROP_TYPES.storeDirectWrapper(VentusData.DESCRIPTION, DESC).attrFinish();
    public static final DisplayProp<Color> COLOR = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.COLOR", Color.class, Color.BLACK, Intl.intl("Color"), Intl.intl("Source/Sink element color.")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsWrapper(VentusData.SEARCH_COLOR).attrGetter(elem -> elem.get(COLOR), COLOR, new TypedProp[0]).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final DisplayProp<Species> SPECIES = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.Species", Species.class, null, Intl.intl("Species"), Intl.intl("Species of contaminant to add or remove.")).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, Species.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.singleObj(PropComparisons.getFeatureSrc(SpeciesData.GUID, Intl.intl("<none>")))).attrFinish();
    public static final DisplayProp<SourceSinkModel> MODEL = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.MODEL", SourceSinkModel.class, SourceSinkModel.CONSTANT_COEFFICIENT, Intl.intl("Model"), Intl.intl("Source/Sink generation model.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.options((ILabeled[])SourceSinkModel.values())).attrFinish();
    public static final DisplayProp<GenRateUnit> GEN_RATE_UNIT = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.GEN_RATE_UNIT", GenRateUnit.class, GenRateUnit.MASS_RATE, Intl.intl("Rate Units"), Intl.intl("Units to use for specifying generation and removal rates.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.options((ILabeled[])GenRateUnit.values())).attrFinish();
    public static final DisplayProp<UnitDouble> GENERATION_RATE_MASS = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.GENERATION_RATE", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Generation Mass Rate"), Intl.intl("Rate at which contaminant is added."), 26).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(26)).attrFinish();
    public static final DisplayProp<UnitDouble> REMOVAL_RATE_MASS = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.REMOVAL_RATE", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Removal Mass Rate"), Intl.intl("Rate at which contaminant is removed."), 26).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(26)).attrFinish();
    public static final DisplayProp<UnitDouble> GENERATION_RATE_VOLUME = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.GENERATION_RATE_VOLUME", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)), Intl.intl("Generation Volume Rate"), Intl.intl("Rate at which contaminant is added."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(17)).attrFinish();
    public static final DisplayProp<UnitDouble> REMOVAL_RATE_VOLUME = (DisplayProp)DisplayProps.build((Object)"SourceSinkElement.REMOVAL_RATE_VOLUME", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)), Intl.intl("Removal Volume Rate"), Intl.intl("Rate at which contaminant is removed."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(17)).attrFinish();
    private PropertySet d_properties = new PropertySet();

    public SourceSinkElement(String name, Species species) {
        this(name, species, theUtil.newRandomSatColor());
    }

    public SourceSinkElement(String name, Species species, Color color) {
        super(name);
        this.set(SPECIES, species);
        this.set(COLOR, color);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        if (VentusOIS.isPrior(is, VentusIO.Version.VER_215)) {
            Object GENERATION_RATE_LEGACY_VOL = TypedProps.build((Object)"SourceSinkElement.GENERATION_RATE", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND))).attrToProp();
            Object REMOVAL_RATE_LEGACY_VOL = TypedProps.build((Object)"SourceSinkElement.REMOVAL_RATE", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND))).attrToProp();
            if (this.d_properties.get(GEN_RATE_UNIT) == GenRateUnit.VOLUME_RATE) {
                this.d_properties.set(GENERATION_RATE_VOLUME, (UnitDouble)this.d_properties.get(GENERATION_RATE_LEGACY_VOL));
                this.d_properties.set(REMOVAL_RATE_VOLUME, (UnitDouble)this.d_properties.get(REMOVAL_RATE_LEGACY_VOL));
                this.d_properties.set(GENERATION_RATE_MASS, (UnitDouble)SourceSinkElement.GENERATION_RATE_MASS.defVal);
                this.d_properties.set(REMOVAL_RATE_MASS, (UnitDouble)SourceSinkElement.REMOVAL_RATE_MASS.defVal);
            }
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    protected PropertyDefs<SourceSinkElement> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public SourceSinkElement clone() {
        return (SourceSinkElement)super.clone();
    }

    public static enum GenRateUnit implements ILabeled
    {
        MASS_RATE(Intl.intl("Mass"), Intl.intl("Rates by unit mass per unit time."), SI.KILOGRAM.divide(SI.SECOND)),
        VOLUME_RATE(Intl.intl("Volume"), Intl.intl("Rates by unit volume per unit time.\nDepends on Species Molar Mass.\nNOTE: For simulation, this rate will be converted\nto a Mass rate at standard temperature and pressure."), SI.METER.pow(3).divide(SI.SECOND));

        public final String name;
        public final String desc;
        public final Unit defaultUnit;

        private GenRateUnit(String name, String desc, Unit defaultUnit) {
            this.name = name;
            this.desc = desc;
            this.defaultUnit = defaultUnit;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SourceSinkModel implements ILabeled
    {
        CONSTANT_COEFFICIENT(Intl.intl("Constant Coefficient"), Intl.intl("Contaminant generation and removal rates are constant."), "ccf");

        public final String name;
        public final String desc;
        public final String type;

        private SourceSinkModel(String name, String desc, String type) {
            this.name = name;
            this.desc = desc;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return this.name;
        }
    }
}

