/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.simparams;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.data.AFlatModelData;
import ventus.feature.props.PropertyDefs;
import ventus.feature.props.TypedProps;

public class SimParamsProps
extends AFlatModelData {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<SimParamsProps> PROP_TYPES = SimParamsProps.newPropertyDefs(SimParamsProps.class, new PropertyDefs[0]);
    public static final TypedProp<Boolean> runSteady = TypedProps.build((Object)"runSteady", true).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Boolean> varyDensity = TypedProps.build((Object)"varyDensity", false).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<Integer> maxIteration = TypedProps.build((Object)"maxIteration", 20).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> defaultZoneTemp = TypedProps.build("defaultZoneTemp", UnitDouble.class, new UnitDouble(20.0, SI.CELSIUS)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<AirflowSimMethod> airflowSimMethod = TypedProps.build("airflowSimMethod", AirflowSimMethod.class, AirflowSimMethod.STEADY).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<ContaminantSimMethod> contaminantSimMethod = TypedProps.build("contaminantSimMethod", ContaminantSimMethod.class, ContaminantSimMethod.STEADY).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> simulationTime = TypedProps.build("simulationTime", UnitDouble.class, new UnitDouble(20.0, NonSI.MINUTE)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final TypedProp<UnitDouble> simulationTimestep = TypedProps.build("simulationTimestep", UnitDouble.class, new UnitDouble(1.0, SI.SECOND)).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();

    protected PropertyDefs<SimParamsProps> getPropertyDefs() {
        return PROP_TYPES;
    }

    public static enum AirflowSimMethod {
        STEADY(Intl.intl("Steady"), Intl.intl("Calculate a single set of airflows.")),
        TRANSIENT(Intl.intl("Transient"), Intl.intl("Calculate airflows that vary over time."));

        public final String name;
        public final String desc;

        private AirflowSimMethod(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    public static enum ContaminantSimMethod {
        STEADY(Intl.intl("Steady"), Intl.intl("Calculate a single set of contaminant concentrations.")),
        TRANSIENT(Intl.intl("Transient"), Intl.intl("Calculate contaminant concentrations that vary over time."));

        public final String name;
        public final String desc;

        private ContaminantSimMethod(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

