/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.runsim;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.apache.commons.io.FilenameUtils;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CancelledException;
import ventus.actions.MerlinOp;
import ventus.actions.Save;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.ScenarioData;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.VentusEvents;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IAppToolbarButton;
import ventus.feature.comps.IHotkey;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.comps.IScenarioParameterSrc;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.gui.RunSimDlg;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjWriter;
import ventus.io.contamx.RunUtil;
import ventus.mv.ModelView;

class RunSimulation
implements IAppMenuItem,
IAppToolbarButton,
IHotkey<UIHook> {
    public static final Icon ICON = UIHook.loadIcon("ventus/icons/run16.png");
    public static final String OUTPUT_FILE_NAME = Intl.intl("log.txt");
    private final UIHook runHook = new UIHook((MerlinOp)new RunSimulationOp(), Intl.intl("&Run Simulation...,-,Run Simulation"), ICON);
    private final Shortcut<UIHook> runShortcut = new Shortcut<UIHook>(new ShortcutInfo("runSimulation", ShortcutInfo.Category.SIMULATION), this.runHook);
    private final UIHook showSummaryFileHook = new UIHook((MerlinOp)new ShowSummaryFileOp(), Intl.intl("&Show Summary File...,-,Show Summary File"), null);

    @Override
    public void addMenuItems(GroupedSequence root) {
        root.getNode("simulation").add(35, (Object)new JPopupMenu.Separator());
        root.getNode("simulation").add(36, (Object)this.runHook);
        root.getNode("results").add(100, (Object)this.showSummaryFileHook);
    }

    @Override
    public void addToolbarButtons(GroupedSequence root) {
        root.add(100, (Object)new JToolBar.Separator(null));
        root.add(101, (Object)this.runHook);
    }

    @Override
    public Shortcut<UIHook> getKeyboardShortcut() {
        return this.runShortcut;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    private static void processModel(VentusApp app, VentusData vd, Consumer<String> profileBegin, Runnable profileEnd) throws CancelledException {
        RunSimulation.quickCheckForErrors(app, vd);
        profileBegin.accept(Intl.intl("Checking errors..."));
        RunSimulation.thoroughCheckForErrors(app, vd);
        profileEnd.run();
    }

    public static void quickCheckForErrors(VentusApp app, VentusData vd) throws CancelledException {
        Collection<SimError> errors = EntryPointFactory.get(vd).tvEntryPoint.getErrors(vd, vd);
        errors.removeIf(e -> e.type.equals((Object)SimError.Type.RESULTS));
        if (!errors.isEmpty()) {
            String msg;
            SimError.Level maxLevel = SimError.Level.MODERATE;
            for (SimError error : errors) {
                if (error.level.severity <= maxLevel.severity) continue;
                maxLevel = error.level;
            }
            if (maxLevel == SimError.Level.CRITICAL) {
                msg = Intl.intl("The model contains errors.  Expand the tree on the left to identify the errors.");
                JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Model Errors"), 0);
                throw CancelledException.INSTANCE;
            }
            msg = Intl.intl("The model contains warnings.  Expand the tree on the left to identify the warnings.\nWould you like to ignore the warnings and continue?");
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, Intl.intl("Model Problems"), 0, 2);
            if (option != 0) {
                throw CancelledException.INSTANCE;
            }
        }
    }

    private static void thoroughCheckForErrors(VentusApp app, VentusData vd) throws CancelledException {
        List<SimError> errors = RunSimulation.getDeepErrors(vd);
        if (!errors.isEmpty()) {
            RunSimulation.promptToManageErrors(app, vd, errors);
        }
    }

    private static List<SimError> getDeepErrors(VentusData md) {
        ArrayList<SimError> errors = new ArrayList<SimError>();
        Consumer<SimError> addError = e -> {
            if (e != null) {
                errors.add((SimError)e);
            }
        };
        RunSimulation.getRuntimeErrors(md, ((FlowPathRoot)md.getComponentData(FlowPathsFeature.GUID)).getChildren(), addError);
        RunSimulation.getRuntimeErrors(md, md.floors.getDeepMembers(SchematicRoom.class), addError);
        return errors;
    }

    private static void promptToManageErrors(VentusApp app, final VentusData vd, Collection<? extends SimError> errors) throws CancelledException {
        if (errors.isEmpty()) {
            return;
        }
        IFilteredCollection<SimError> criticalErrors = theUtil.filter(errors, e -> e.level == SimError.Level.CRITICAL);
        IFilteredCollection<SimError> moderateErrors = theUtil.filter(errors, e -> e.level == SimError.Level.MODERATE);
        IFilteredCollection<SimError> showErrors = !criticalErrors.isEmpty() ? criticalErrors : moderateErrors;
        WarningReport<SimError> report = new WarningReport<SimError>(SimError.class, new int[]{0, 1, 2}, new String[]{Intl.intl("Message"), Intl.intl("How to Fix"), Intl.intl("Components")}, 0);
        for (SimError error : showErrors) {
            report.addWarning(error);
        }
        int investigateBtn = 2;
        WarningDlg<SimError> errDialog = new WarningDlg<SimError>(app.getActiveFrame(), !criticalErrors.isEmpty() ? Intl.intl("Model Errors") : Intl.intl("Model Warnings"), !criticalErrors.isEmpty() ? Intl.intl("The following errors must be fixed before continuing.") : Intl.intl("The following issues might cause problems with the simulation. What would you like to do?"), report, !criticalErrors.isEmpty() ? investigateBtn | 0x10 : investigateBtn | 1 | 8 | 0x10, !criticalErrors.isEmpty() ? WarningDlg.Severity.ERROR : WarningDlg.Severity.WARNING);
        JButton resetToSelectedBtn = new JButton(Intl.intl("Show Selected Objects"));
        resetToSelectedBtn.setToolTipText(Intl.intl("Reset the view to the objects that may have caused the problems."));
        Consumer<List> selectObjs = objs -> {
            AMerlinOp selOp = new AMerlinOp((List)objs){
                final /* synthetic */ List val$objs;
                {
                    this.val$objs = list;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(VentusApp app, VentusData vd) {
                    try (VentusData.WriteLock lock = vd.lockWrite();){
                        Undo.begin(Intl.intl("Select Warning Objects"));
                        Undo.insertUndoEntry_restoreSelection(vd);
                        vd.selection.set(this.val$objs);
                        Undo.end(vd);
                    }
                }
            };
            UIHook.run((Component)resetToSelectedBtn, "Select Warning Objects", selOp, 0);
        };
        resetToSelectedBtn.addActionListener(e -> {
            List warnings = errDialog.getSelectedWarnings();
            if (warnings.isEmpty()) {
                JOptionPane.showMessageDialog(errDialog, Intl.intl("Select at least one row first."), Intl.intl("Select a Row"), 2);
                return;
            }
            List objs = warnings.stream().flatMap(se -> se.causeObjs.stream()).collect(Collectors.toList());
            if (objs.isEmpty()) {
                JOptionPane.showMessageDialog(errDialog, Intl.intl("There are no objects associated with the selected rows."), Intl.intl("No Objects"), 2);
                return;
            }
            selectObjs.accept(objs);
            ModelView mv = app.getModelView();
            mv.getResetViewToSelOp().run(UIHook.getComponent(e));
        });
        errDialog.getActionPanel().add((Component)resetToSelectedBtn, 0);
        resetToSelectedBtn.setVisible(false);
        BiConsumer<Integer, String> changeBtnText = (i, text) -> {
            JButton btn = errDialog.getButton((int)i);
            if (btn == null) {
                return;
            }
            btn.setPreferredSize(null);
            btn.setText((String)text);
        };
        BiConsumer<Integer, Boolean> setBtnVisible = (i, vis) -> {
            JButton btn = errDialog.getButton((int)i);
            if (btn != null) {
                btn.setVisible((boolean)vis);
            }
        };
        setBtnVisible.accept(16, false);
        if (criticalErrors.isEmpty()) {
            errDialog.getButton(1).setText(Intl.intl("Ignore"));
            errDialog.getButton(1).setToolTipText(Intl.intl("Ignore the errors and continue with the simulation."));
            errDialog.getButton(8).setToolTipText(Intl.intl("Cancel the simulation."));
        }
        changeBtnText.accept(investigateBtn, Intl.intl("Investigate"));
        errDialog.getButton(investigateBtn).setToolTipText(Intl.intl("Cancel the simulation and investigate errors."));
        final IEventObserver cancelObserver = events -> {
            IEventRecord<IMerlinObj> oevts = events.getEvents(IMerlinObj.class, new Class[0]);
            if (oevts.hasRemovedObjs()) {
                Set<IMerlinObj> removed = oevts.getRemovedObjs();
                errDialog.removeIf(err -> err.causeObjs.stream().anyMatch(removed::contains));
            }
        };
        vd.getEvents().addObserver(cancelObserver);
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        final SecondaryLoop waitLoop = eq.createSecondaryLoop();
        boolean[] investigating = new boolean[]{false};
        errDialog.getButton(investigateBtn).addActionListener(e -> {
            int opt;
            if (criticalErrors.isEmpty() && (opt = JOptionPane.showConfirmDialog(errDialog, Intl.intl("Are you sure you want to cancel the simulation and investigate errors?"), Intl.intl("Cancel Simulation?"), 0, 3)) != 0) {
                return;
            }
            resetToSelectedBtn.setVisible(true);
            setBtnVisible.accept(16, true);
            setBtnVisible.accept(investigateBtn, false);
            setBtnVisible.accept(8, false);
            setBtnVisible.accept(1, false);
            errDialog.setMessage(Intl.intl("Investigate the following errors:"));
            errDialog.getTable().getSelectionModel().addListSelectionListener(le -> {
                if (!le.getValueIsAdjusting()) {
                    List objs = errDialog.getSelectedWarnings().stream().flatMap(se -> se.causeObjs.stream()).collect(Collectors.toList());
                    if (objs.isEmpty()) {
                        return;
                    }
                    selectObjs.accept(objs);
                }
            });
            investigating[0] = true;
            waitLoop.exit();
        });
        errDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                vd.getEvents().removeObserver(cancelObserver);
                waitLoop.exit();
            }
        });
        errDialog.doModeless();
        waitLoop.enter();
        int status = errDialog.getStatus();
        if (investigating[0] || status != 1 || !criticalErrors.isEmpty()) {
            throw new CancelledException();
        }
    }

    private static void getRuntimeErrors(VentusData vd, Collection<? extends IMerlinObj> objs, Consumer<SimError> addError) {
        for (IMerlinObj iMerlinObj : objs) {
            for (SimError e : EntryPointFactory.get(iMerlinObj).tvEntryPoint.getRuntimeErrors(vd, iMerlinObj)) {
                addError.accept(e);
            }
            RunSimulation.getRuntimeErrors(vd, iMerlinObj.getChildren(), addError);
        }
    }

    private static class RunSimulationOp
    extends AMerlinOp {
        private RunSimulationOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(VentusApp app, VentusData md) {
            JFrame parentFrame = app.getActiveFrame();
            if (!Save.saveToFile(app, md, false)) {
                return;
            }
            ScenarioData scenarioInfo = new ScenarioData(md, app.getComponents(IScenarioParameterSrc.class));
            File vntsFile = new File(md.filename);
            String baseName = FilenameUtils.getBaseName(vntsFile.getPath());
            ArrayList<File> needToDeleteOldFiles = new ArrayList<File>();
            HashMap<Map<TypedProp, Object>, File> scenarioPrjFiles = new HashMap<Map<TypedProp, Object>, File>();
            for (Map<TypedProp, Object> scenario : scenarioInfo.getAllScenarios()) {
                String scenarioId = baseName + scenarioInfo.getNameFromMapping(md, scenario);
                File folder = new File(vntsFile.getParentFile(), scenarioId);
                File input = new File(folder, scenarioId + ".prj");
                scenarioPrjFiles.put(scenario, input);
                if (!folder.exists()) continue;
                String[] outputFileExtns = new String[]{".lfr", ".nfr", ".xrf", ".sqlite3", ".xlog", ".sim"};
                List<File> existing = Arrays.stream(outputFileExtns).map(extn -> new File(folder, scenarioId + extn)).filter(outputFile -> outputFile.exists()).toList();
                needToDeleteOldFiles.addAll(existing);
            }
            if (!needToDeleteOldFiles.isEmpty()) {
                String msg2 = Intl.intl("Previous output files exist. Delete and continue?");
                String title = Intl.intl("Delete Old Output Files");
                int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg2, title, 2);
                if (option != 0) {
                    return;
                }
                needToDeleteOldFiles.forEach(f -> f.delete());
            }
            RunSimDlg dlg = new RunSimDlg(parentFrame);
            dlg.beginWaitCursor();
            Handler dlgHandler = dlg.createLogHandler();
            dlgHandler.setLevel(Level.INFO);
            Logger.getLogger("").addHandler(dlgHandler);
            DlgActionListener actionListener = new DlgActionListener(vntsFile.getParentFile().getAbsolutePath());
            dlg.addListener(actionListener);
            theTimer timer = new theTimer();
            Consumer<String> profileBegin = msg -> {
                dlg.printToLog((String)msg);
                timer.reset();
            };
            Runnable profileEnd = () -> {
                dlg.printToLog(String.format("Done (%.2f s)", timer.curr()));
                timer.reset();
            };
            try {
                dlg.doModeless();
                RunSimulation.processModel(app, md, profileBegin, profileEnd);
            }
            catch (CancelledException e) {
                dlg.setVisible(false);
                return;
            }
            finally {
                dlg.endWaitCursor();
            }
            new Thread(() -> {
                Consumer<Object> postEvent = evt -> md.uiLater(() -> {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        md.getEvents().changed(VentusEvents.EVT_OBJ, evt);
                    }
                });
                try {
                    dlg.setState(0);
                    postEvent.accept(new VentusEvents.SimulationBatchBegin());
                    HashMap<File, PrjData> runData = new HashMap<File, PrjData>();
                    profileBegin.accept("Collecting .PRJ Data...");
                    try (VentusData.ReadLock lock = md.lockRead();){
                        void var13_15;
                        boolean bl = false;
                        while (var13_15 < scenarioInfo.getScenarioCount()) {
                            Map<TypedProp, Object> scenario = scenarioInfo.getScenario((int)var13_15);
                            runData.put((File)scenarioPrjFiles.get(scenario), ScenarioData.getScenarioPrjData(app.getComponents(IPrjDataWriter.class), app, md, scenario));
                            ++var13_15;
                        }
                    }
                    profileEnd.run();
                    for (Map.Entry entry : runData.entrySet()) {
                        File prjInputFile = (File)entry.getKey();
                        PrjData data = (PrjData)entry.getValue();
                        if (!prjInputFile.getParentFile().exists()) {
                            boolean result = prjInputFile.getParentFile().mkdir();
                            assert (result);
                        }
                        try (PrintStream stream = new PrintStream(prjInputFile, StandardCharsets.UTF_8);
                             OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
                             PrintWriter writer = new PrintWriter((Writer)streamWriter, true);){
                            PrjWriter.writePrjFile(writer, data);
                        }
                        dlg.printToLog(Intl.intlf("============ %s", prjInputFile.getName()));
                        int code = RunUtil.run(app.getInstallDir(), prjInputFile, data, dlg);
                        RunUtil.fixSqlite3OutputFilename(prjInputFile, baseName);
                        postEvent.accept(new VentusEvents.SimulationComplete(data, prjInputFile, code));
                        dlg.printToLog("\n");
                    }
                    File recentLogFile = new File(vntsFile.getParentFile(), OUTPUT_FILE_NAME);
                    if (!recentLogFile.exists()) {
                        boolean bl = recentLogFile.createNewFile();
                        assert (bl);
                    }
                    try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                         PrintStream ps = new PrintStream((OutputStream)byteArrayOutputStream, true, StandardCharsets.UTF_8);
                         FileWriter fw = new FileWriter(recentLogFile, StandardCharsets.UTF_8);){
                        dlg.writeLogText(ps);
                        fw.append(byteArrayOutputStream.toString(StandardCharsets.UTF_8));
                    }
                    dlg.setState(3);
                    dlg.printToLog("DONE!");
                    postEvent.accept(new VentusEvents.SimulationBatchEnd());
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    Logger.getLogger("").removeHandler(dlgHandler);
                }
            }).start();
        }
    }

    private static class ShowSummaryFileOp
    extends AMerlinOp {
        private ShowSummaryFileOp() {
        }

        private void showUnableToLocateFileError(VentusApp app) {
            String msg = Intl.intl("Unable to locate file. Have you run the simulation?");
            JOptionPane.showMessageDialog(app.getMainFrame(), msg);
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            if (md.filename == null) {
                this.showUnableToLocateFileError(app);
                return;
            }
            File vntsFile = new File(md.filename);
            File recentFile = new File(vntsFile.getParentFile(), OUTPUT_FILE_NAME);
            if (!recentFile.exists()) {
                this.showUnableToLocateFileError(app);
                return;
            }
            try {
                Desktop.getDesktop().open(recentFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class DlgActionListener
    implements RunSimDlg.DlgListener {
        private final String initialDir;

        public DlgActionListener(String initialDir) {
            this.initialDir = initialDir;
        }

        @Override
        public void actionOK(RunSimDlg dlg) {
        }

        @Override
        public void actionCancel(RunSimDlg dlg) {
        }

        @Override
        public void actionStop(RunSimDlg dlg) {
        }

        @Override
        public void actionLog(RunSimDlg dlg) {
            guiJFXFileChooser chooser = new guiJFXFileChooser(OUTPUT_FILE_NAME, this.initialDir, null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_TEXT);
            File f = chooser.showSaveDialog();
            if (f == null) {
                return;
            }
            try {
                PrintStream ps = new PrintStream(f, StandardCharsets.UTF_8);
                dlg.writeLogText(ps);
                ps.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

