/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import thunderheadeng.animate.DefaultFrameSrc;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.IFrameSrc;
import thunderheadeng.animate.InterpInfo;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import ventus.VentusApp;
import ventus.feature.comps.IFeatureAnimator;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;

public class ZoneDataNodeAnimator
implements IFeatureAnimator,
IEventObserver,
IAnimator {
    private IFrameSrc<DataNodeFrame> d_frameSrc = new DefaultFrameSrc<DataNodeFrame>();
    private final Set<DataNode.ZoneVisLeaf> d_dataLeaves = new LinkedIdentityHashSet<DataNode.ZoneVisLeaf>();

    @Override
    public void update(Events events) {
        IEventRecord<DataNode.ZoneVisLeaf> leafRecords = events.getEvents(DataNode.ZoneVisLeaf.class, new Class[0]);
        if (leafRecords.hasAddedObjs()) {
            Collection<DataNode.ZoneVisLeaf> visLeaves = ((DataNode.ResultsRoot)VentusApp.getAppData().getComponentData(ResultsDataComp.GUID)).flatten(DataNode.ZoneVisLeaf.class);
            this.d_dataLeaves.addAll(visLeaves);
            this.d_frameSrc = this.createFrameSrc(visLeaves);
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
        if (events.getEvents(DataNode.VisLeaf.class, new Class[0]).hasRemovedObjs()) {
            this.d_dataLeaves.removeAll(leafRecords.getRemovedObjs());
            EventQueue.invokeLater(() -> events.changed(VentusApp.getAppData(), ANIMATION_CHANGED));
        }
    }

    private IFrameSrc<DataNodeFrame> createFrameSrc(Collection<DataNode.ZoneVisLeaf> leaves) {
        DefaultFrameSrc<DataNodeFrame> frameSrc = new DefaultFrameSrc<DataNodeFrame>();
        for (DataNode.ZoneVisLeaf leaf : leaves) {
            int i = 0;
            while (i < leaf.getTimes().length) {
                int currFrame = i++;
                frameSrc.computeFrame(leaf.getTimes()[currFrame], (time, oldFrame) -> {
                    DataNodeFrame frame = oldFrame == null ? new DataNodeFrame() : oldFrame;
                    frame.add(leaf, new FrameData(leaf.getTemperatures()[currFrame], leaf.getPressures()[currFrame], leaf.getDensities()[currFrame]));
                    return frame;
                });
            }
        }
        return frameSrc;
    }

    @Override
    public boolean update(IAnimSession session) {
        VentusApp.getAppData().pauseUpdates();
        double time = session.get(IAnimSession.TIME);
        InterpInfo<DataNodeFrame> ii = this.d_frameSrc.getFrames(time);
        for (DataNode.ZoneVisLeaf leaf : this.d_dataLeaves) {
            FrameData frame1Data = ii.frame1().getData(leaf);
            leaf.setAnimationData(frame1Data.temperature, frame1Data.pressure, frame1Data.density);
        }
        VentusApp.getAppData().resumeUpdates();
        return true;
    }

    @Override
    public Pair<Double, Double> getTimeRange() {
        if (this.d_dataLeaves.isEmpty()) {
            return new Pair<Double, Double>(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        return this.d_frameSrc.getTimeRange();
    }

    private static class DataNodeFrame {
        private final Map<DataNode.ZoneVisLeaf, FrameData> d_vals = new IdentityHashMap<DataNode.ZoneVisLeaf, FrameData>();

        private DataNodeFrame() {
        }

        public FrameData getData(DataNode.ZoneVisLeaf leaf) {
            return this.d_vals.get(leaf);
        }

        public void add(DataNode.ZoneVisLeaf leaf, FrameData val) {
            this.d_vals.put(leaf, val);
        }
    }

    private record FrameData(double temperature, double pressure, double density) {
    }
}

