/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import thunderheadeng.util.Pair;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.io.contamx.PrjData;
import ventus.util.Sqlite3Util;

public class OutputDataReaderZoneVis {
    public static List<ZoneData> getZoneResults(PrjData inputData, File prjFile, String extn) {
        ArrayList<ZoneData> zones = new ArrayList<ZoneData>();
        ArrayList<String> species = new ArrayList<String>();
        for (PrjData.Species spec : inputData.speciesList) {
            species.add(spec.name);
        }
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());){
            Statement stmt = connection.createStatement();
            stmt.setQueryTimeout(1);
            for (PrjData.Zone zone : inputData.zoneList) {
                ZoneData data = OutputDataReaderZoneVis.getZoneData(zone, species, connection, stmt);
                if (data == null) continue;
                zones.add(data);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return zones;
    }

    private static ZoneData getZoneData(PrjData.Zone zone, List<String> species, Connection connection, Statement stmt) throws SQLException {
        Object object = zone.refObj;
        if (object instanceof SchematicRoom) {
            SchematicRoom room = (SchematicRoom)object;
            String query = Sqlite3Util.tableExists(connection, "NODEZONECCDATA") ? String.format("SELECT T.Time, NZ.Temperature, NZ.Pressure, NZ.Density, NZC.*\nFROM NODEZONEFLOWDATA AS NZ\nLEFT JOIN TIME AS T ON NZ.TimeID = T.TimeID\nLEFT JOIN NODEZONECCDATA AS NZC ON NZ.TimeID == NZC.TimeID AND NZ.ZoneNumber == NZC.ZoneNumber\nWHERE NZ.ZoneNumber == %1$d;\n", zone.nr) : String.format("SELECT T.Time, NZ.Temperature, NZ.Pressure, NZ.Density\nFROM NODEZONEFLOWDATA AS NZ\nLEFT JOIN TIME AS T ON NZ.TimeID = T.TimeID\nWHERE NZ.ZoneNumber == %1$d;\n", zone.nr);
            ArrayList<Double> times = new ArrayList<Double>();
            ArrayList<Double> temperatures = new ArrayList<Double>();
            ArrayList<Double> pressures = new ArrayList<Double>();
            ArrayList<Double> densities = new ArrayList<Double>();
            HashMap concentrations = new HashMap();
            try (ResultSet rs = stmt.executeQuery(query);){
                HashMap<String, Integer> speciesColumns = new HashMap<String, Integer>();
                ResultSetMetaData rsMetaData = rs.getMetaData();
                for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                    String columnName = rsMetaData.getColumnLabel(i);
                    if (!columnName.startsWith("C")) continue;
                    speciesColumns.put(columnName, i);
                    concentrations.put(columnName, new ArrayList());
                }
                while (rs.next()) {
                    times.add(rs.getDouble(1));
                    temperatures.add(rs.getDouble(2));
                    pressures.add(rs.getDouble(3));
                    densities.add(rs.getDouble(4));
                    for (Map.Entry concentration2 : concentrations.entrySet()) {
                        ((ArrayList)concentration2.getValue()).add(rs.getDouble((Integer)speciesColumns.get(concentration2.getKey())));
                    }
                }
            }
            return new ZoneData(zone, room.getName(), ArrayUtils.toPrimitive(times.toArray(new Double[0])), ArrayUtils.toPrimitive(temperatures.toArray(new Double[0])), ArrayUtils.toPrimitive(pressures.toArray(new Double[0])), ArrayUtils.toPrimitive(densities.toArray(new Double[0])), concentrations.entrySet().stream().map(concentration -> new Pair<String, double[]>((String)species.get(Integer.parseInt(((String)concentration.getKey()).substring(1))), ArrayUtils.toPrimitive(((ArrayList)concentration.getValue()).toArray(new Double[0])))).collect(Collectors.toMap(pair -> (String)pair.v1, pair -> (double[])pair.v2)));
        }
        return null;
    }

    public static class ZoneData {
        public final PrjData.Zone refObj;
        public final String refObjDesc;
        public final double[] times;
        public final double[] temperatures;
        public final double[] pressures;
        public final double[] densities;
        public final Map<String, double[]> concentrations;

        public ZoneData(PrjData.Zone refObj, String refObjDesc, double[] times, double[] temperatures, double[] pressures, double[] densities, Map<String, double[]> concentrations) {
            this.refObj = refObj;
            this.refObjDesc = refObjDesc;
            this.times = times;
            this.temperatures = temperatures;
            this.pressures = pressures;
            this.densities = densities;
            this.concentrations = concentrations;
        }
    }
}

