/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Vector3d;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.results.DataNode;
import ventus.feature.results.DataTable;
import ventus.feature.results.OutputDataReaderVis;
import ventus.feature.results.OutputDataReaderZoneVis;
import ventus.io.contamx.PrjData;
import ventus.util.Sqlite3Util;

public class OutputDataReader {
    private static final void initSqlite() {
        File sqlTmpDir = null;
        if (Application.getApp() != null) {
            sqlTmpDir = new File(Application.getApp().getAppDataDir());
        }
        Sqlite3Util.initWithFallback(sqlTmpDir);
    }

    public static DataNode.SimulationRoot loadSimulationOutput(PrjData inputData, File prjFile, int code, DataNode.MergedData linkPathData, DataNode.MergedData nodeZoneFlowData) {
        OutputDataReader.initSqlite();
        DataNode.SimulationRoot root = new DataNode.SimulationRoot(FilenameUtils.getBaseName(prjFile.getPath()), prjFile.getPath(), inputData);
        try {
            root.add(OutputDataReader.createTextDataNode(Intl.intl("Input File (PRJ)"), prjFile, ".prj"));
            root.add(OutputDataReader.createXlogDataNode(Intl.intl("Log File (XLOG)"), prjFile, ".xlog", code));
            if (code != 0) {
                return root;
            }
            root.add(OutputDataReader.createTextDataNode(Intl.intl("Link Flows (LFR)"), prjFile, ".lfr"));
            root.add(OutputDataReader.createTextDataNode(Intl.intl("Node Flows (NFR)"), prjFile, ".nfr"));
            if (inputData.nn > 0) {
                root.add(OutputDataReader.createTextDataNode(Intl.intl("Node Concentrations (NCR)"), prjFile, ".ncr"));
            }
            root.add(OutputDataReader.createTextDataNode(Intl.intl("Cross Reference (XRF)"), prjFile, ".xrf"));
            root.add(OutputDataReader.createSqliteDataNode(Intl.intl("Data Tables (SQLITE3)"), prjFile, ".sqlite3"));
            OutputDataReader.appendMergedFlows(inputData, prjFile, ".sqlite3", root.getName(), linkPathData, nodeZoneFlowData);
            DataNode.VisRoot visRoot = new DataNode.VisRoot(Intl.intl("Path Data"));
            root.add(visRoot);
            DataNode.ZoneVisRoot zoneVisRoot = new DataNode.ZoneVisRoot(Intl.intl("Zone Data"));
            root.add(zoneVisRoot);
            List<OutputDataReaderVis.LineSegData> lineSegPairs = OutputDataReaderVis.getLineSegsResults(inputData, prjFile, ".sqlite3");
            lineSegPairs.stream().map(lineSeg -> {
                Unit udp = SI.PASCAL;
                Unit uflow0 = SI.KILOGRAM.divide(SI.SECOND);
                Vector3d dpVec = new Vector3d(lineSeg.baseGeom.dir);
                dpVec.scale(lineSeg.scaleFactorDp);
                Vector3d flow0Vec = new Vector3d(lineSeg.baseGeom.dir);
                flow0Vec.scale(lineSeg.scaleFactorFlow0);
                return new Pair<Object, DataNode.VisLeaf>(lineSeg.refObj.refObj, new DataNode.VisLeaf(lineSeg.refObjDesc, lineSeg.times, lineSeg.dps, lineSeg.flow0s, lineSeg.flow1s, udp, lineSeg.baseGeom.origin, dpVec, uflow0, lineSeg.baseGeom.origin, flow0Vec));
            }).forEach(pair -> visRoot.addLeaf((FlowPath)pair.v1, (DataNode.VisLeaf)pair.v2));
            List<OutputDataReaderZoneVis.ZoneData> zones = OutputDataReaderZoneVis.getZoneResults(inputData, prjFile, ".sqlite3");
            for (OutputDataReaderZoneVis.ZoneData zone : zones) {
                BaseUnit utemperature = SI.KELVIN;
                Unit upressure = SI.PASCAL;
                Unit udensity = SI.KILOGRAM.divide(SI.METER.pow(3));
                zoneVisRoot.addLeaf((SchematicRoom)zone.refObj.refObj, new DataNode.ZoneVisLeaf(zone.refObjDesc, zone.times, utemperature, zone.temperatures, upressure, zone.pressures, udensity, zone.densities, zone.concentrations));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return root;
    }

    private static DataNode createTextDataNode(String name, File prjFile, String extn) throws IOException {
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        if (f.exists()) {
            return new DataNode.TextData(name, f.getPath(), FileUtils.readFileToString(f, Charset.defaultCharset()));
        }
        throw new FileNotFoundException(f.getPath());
    }

    private static DataNode createXlogDataNode(String name, File prjFile, String extn, int code) throws IOException {
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        if (f.exists()) {
            return new DataNode.XLogData(name, f.getPath(), FileUtils.readFileToString(f, Charset.defaultCharset()), code);
        }
        throw new FileNotFoundException(f.getPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static DataTable loadSqliteTable(File prjFile, String extn, String query) {
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());){
            DataTable dataTable;
            block14: {
                Statement stmt = connection.createStatement();
                stmt.setQueryTimeout(1);
                ResultSet rs = stmt.executeQuery(query);
                try {
                    dataTable = DataTable.fromSqlResultSet(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return dataTable;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return DataTable.EMPTY;
        }
    }

    private static void appendMergedFlows(PrjData inputData, File prjFile, String extn, String id, DataNode.MergedData linkPathData, DataNode.MergedData nodeZoneFlowData) {
        String baseName = FilenameUtils.getBaseName(prjFile.getPath());
        File f = new File(prjFile.getParentFile(), baseName + extn);
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());){
            Statement stmt = connection.createStatement();
            stmt.setQueryTimeout(1);
            String linkPathQuery = "SELECT T.Time AS \"Time (s)\", LP.*\nFROM LINKPATHDATA AS LP\nLEFT JOIN TIME AS T ON LP.TimeID = T.TimeID;\n";
            try (ResultSet rs = stmt.executeQuery(linkPathQuery);){
                DataTable dt = DataTable.fromSqlResultSet(rs);
                HashMap nameMap = new HashMap();
                inputData.airFlowPathList.forEach(afp -> nameMap.put(afp.nr, afp.vntsDesc));
                String[] names = new String[dt.data.length];
                for (int i = 0; i < names.length; ++i) {
                    int nr = Integer.parseInt(dt.data[i][2]);
                    assert (nameMap.containsKey(nr));
                    names[i] = (String)nameMap.get(nr);
                }
                dt = dt.filterColumns(name -> !name.equals("TimeID") && !name.equals("PathNumber"));
                dt = dt.addColumn(0, "id", id);
                dt = dt.addColumn(1, "PathName", names);
                linkPathData.appendData(dt);
            }
            String nodeDataQuery = Sqlite3Util.tableExists(connection, "NODEZONECCDATA") ? "SELECT T.Time as \"Time (s)\", NZ.*, NZC.*\nFROM NODEZONEFLOWDATA AS NZ\nLEFT JOIN TIME AS T ON NZ.TimeID = T.TimeID\nLEFT JOIN NODEZONECCDATA AS NZC ON NZ.TimeID == NZC.TimeID AND NZ.ZoneNumber == NZC.ZoneNumber;\n" : "SELECT T.Time as \"Time (s)\", NZ.*\nFROM NODEZONEFLOWDATA AS NZ\nLEFT JOIN TIME AS T ON NZ.TimeID = T.TimeID;\n";
            try (ResultSet rs = stmt.executeQuery(nodeDataQuery);){
                int i;
                DataTable dt = DataTable.fromSqlResultSet(rs);
                HashMap nameMap = new HashMap();
                inputData.zoneList.forEach(zone -> nameMap.put(zone.nr, zone.name));
                String[] names = new String[dt.data.length];
                for (i = 0; i < names.length; ++i) {
                    int nz = Integer.parseInt(dt.data[i][2]);
                    assert (nameMap.containsKey(nz));
                    names[i] = (String)nameMap.get(nz);
                }
                dt = dt.filterColumns(name -> !name.equals("TimeID") && !name.equals("ZoneNumber"));
                dt = dt.addColumn(0, "id", id);
                dt = dt.addColumn(1, "ZoneName", names);
                for (i = 0; i < dt.headers.length; ++i) {
                    String header = dt.headers[i];
                    if (!header.startsWith("C")) continue;
                    try {
                        int contaminant = Integer.parseInt(header.substring(1));
                        String speciesName = inputData.findSpeciesNr((int)inputData.contaminantsList.get((int)contaminant).intValue()).name;
                        dt.headers[i] = String.format("%s Concentration (kg/kg)", speciesName);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                nodeZoneFlowData.appendData(dt);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static DataNode createSqliteDataNode(String displayName, File prjFile, String extn) {
        DataNode.TextData textData;
        block27: {
            StringBuilder sb = new StringBuilder();
            String baseName = FilenameUtils.getBaseName(prjFile.getPath());
            File f = new File(prjFile.getParentFile(), baseName + extn);
            Connection connection = DriverManager.getConnection("jdbc:sqlite:" + f.getPath());
            try {
                ArrayList<String> tableNames = new ArrayList<String>();
                Statement stmt = connection.createStatement();
                stmt.setQueryTimeout(1);
                try (ResultSet rs = stmt.executeQuery("SELECT name FROM sqlite_schema WHERE type='table' ORDER BY name");){
                    tableNames = new ArrayList();
                    while (rs.next()) {
                        tableNames.add(rs.getString(1));
                    }
                }
                for (String tableName : tableNames) {
                    ResultSet rs = stmt.executeQuery("SELECT * from " + tableName);
                    try {
                        ArrayList<String> colNames = new ArrayList<String>();
                        ResultSetMetaData rsMetaData = rs.getMetaData();
                        for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                            colNames.add(rsMetaData.getColumnLabel(i));
                        }
                        ArrayList<Integer> maxColChars = new ArrayList<Integer>();
                        for (String name : colNames) {
                            maxColChars.add(name.length());
                        }
                        ArrayList<String[]> rows = new ArrayList<String[]>();
                        while (rs.next()) {
                            int i;
                            String[] row2 = new String[colNames.size()];
                            for (i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                                String obj = rs.getString(i);
                                row2[i - 1] = obj != null ? obj : "";
                            }
                            rows.add(row2);
                            for (i = 0; i < row2.length; ++i) {
                                maxColChars.set(i, Math.max((Integer)maxColChars.get(i), row2[i].length()));
                            }
                        }
                        sb.append(tableName);
                        sb.append(System.lineSeparator());
                        sb.append(OutputDataReader.formatRow(maxColChars, colNames));
                        sb.append(System.lineSeparator());
                        rows.forEach(row -> {
                            sb.append(OutputDataReader.formatRow(maxColChars, Arrays.asList(row)));
                            sb.append(System.lineSeparator());
                        });
                        sb.append(System.lineSeparator());
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                textData = new DataNode.TextData(displayName, f.getPath(), sb.toString());
                if (connection == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return new DataNode.TextData(displayName, f.getPath(), Intl.intl("Error loading SQLITE3 data."));
                }
            }
            connection.close();
        }
        return textData;
    }

    private static String formatRow(List<Integer> minWidths, List<String> vals) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < minWidths.size(); ++i) {
            int wid = minWidths.get(i);
            String val = vals.get(i);
            String fixedWidth = String.format("%" + wid + "s", val);
            sb.append(fixedWidth);
            sb.append('\t');
        }
        return sb.toString();
    }
}

