/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.EventQueue;
import java.util.Optional;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.feature.VentusEvents;
import ventus.feature.results.DataNode;
import ventus.feature.results.OutputDataReader;
import ventus.feature.results.ResultsDataComp;

class EventHandler
implements IEventObserver {
    private final ResultsDataComp d_dataComp;

    public EventHandler(ResultsDataComp dataComp) {
        this.d_dataComp = dataComp;
    }

    @Override
    public void update(Events events) {
        events.getEvents(VentusEvents.class, new Class[0]).getChanges().forEach(obj -> {
            if (obj instanceof VentusEvents.SimulationComplete) {
                final VentusEvents.SimulationComplete evt = (VentusEvents.SimulationComplete)obj;
                EventQueue.invokeLater(() -> UIHook.run(null, "results.EventHandler.SimulationComplete", new AMerlinOp(){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        EventHandler.this.handleSimulationComplete(app, md, evt);
                    }
                }, 0));
            } else if (obj instanceof VentusEvents.SimulationBatchBegin) {
                EventQueue.invokeLater(() -> UIHook.run(null, "results.EventHandler.SimulationBatchBegin", new AMerlinOp(){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        EventHandler.this.handleBatchBegin(app, md);
                    }
                }, 0));
            } else if (obj instanceof VentusEvents.SimulationBatchEnd) {
                EventQueue.invokeLater(() -> UIHook.run(null, "results.EventHandler.BatchEnd", new AMerlinOp(){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        EventHandler.this.handleBatchEnd(app, md);
                    }
                }, 0));
            }
        });
    }

    private void handleBatchBegin(VentusApp app, VentusData data) {
        try (VentusData.WriteLock lock = data.lockWrite();){
            ((DataNode.ResultsRoot)data.getComponentData(ResultsDataComp.GUID)).clear();
        }
    }

    private void handleBatchEnd(VentusApp app, VentusData data) {
        try (VentusData.WriteLock lock = data.lockWrite();){
            Optional<DataNode.SimulationRoot> firstResult = ((DataNode.ResultsRoot)data.getComponentData(ResultsDataComp.GUID)).flatten(DataNode.SimulationRoot.class).stream().findFirst();
            if (firstResult.isPresent()) {
                firstResult.get().set(VentusData.VISIBILITY, true);
            }
        }
    }

    private void handleSimulationComplete(VentusApp app, VentusData data, VentusEvents.SimulationComplete evt) {
        DataNode.ResultsRoot root = (DataNode.ResultsRoot)data.getComponentData(ResultsDataComp.GUID);
        try (VentusData.WriteLock lock = data.lockWrite();){
            DataNode.SimulationRoot output = OutputDataReader.loadSimulationOutput(evt.prjData, evt.prjFile, evt.code, root.linkPathData, root.nodeZoneFlows);
            root.add(output);
        }
    }
}

