/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.props;

import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import thunderheadeng.Intl;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.props.IDisplayProp;
import ventus.feature.props.ISimplePropComparisonEd;
import ventus.gui.MerlinComboBox;
import ventus.gui.ObjSource;
import ventus.gui.SetChooser;
import ventus.unitsystem.UnitSystem;

public class PropComparisons {
    public static <PropValT, CompareValT> IDisplayProp.ComparisonEditorSupplier<PropValT> convert(Function<PropValT, CompareValT> valMapper, IDisplayProp.ComparisonEditorSupplier<CompareValT> comparisonEd) {
        return (parent, vd) -> new ConvertedComparison(valMapper, comparisonEd.get(parent, vd));
    }

    public static IDisplayProp.ComparisonEditorSupplier<Integer> integer() {
        return (parent, vd) -> new NumberCompare<Integer>(ValueFields.intFld(0, IntVR.unbounded()), Integer::compare);
    }

    public static IDisplayProp.ComparisonEditorSupplier<Double> dbl() {
        return (parent, vd) -> new NumberCompare<Double>(ValueFields.doubleFld(0.0, DoubleVR.unbounded()), (v1, v2) -> theUtil.relCompare(v1, v2, 1.0E-9));
    }

    public static IDisplayProp.ComparisonEditorSupplier<UnitDouble> unitdouble(int unitType) {
        return (parent, vd) -> {
            IUnitSrc unitSrc = UnitSystem.getType(unitType, true);
            return new NumberCompare<UnitDouble>(ValueFields.udFld(new UnitDouble(0.0, unitSrc.getUnit()), UnitDoubleVR.unbounded(), unitSrc), (v1, v2) -> {
                try {
                    return v1.compareToRel((UnitDouble)v2, 1.0E-9);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    assert (false);
                    return theUtil.relCompare(v1.getRawValue(), v2.getRawValue(), 1.0E-9);
                }
            });
        };
    }

    public static IDisplayProp.ComparisonEditorSupplier<Schedule> schedule(int unitType) {
        return (parent, vd) -> {
            IUnitSrc unitSrc = UnitSystem.getType(unitType, true);
            return new ScheduleCompare(ValueFields.udFld(new UnitDouble(0.0, unitSrc.getUnit()), UnitDoubleVR.unbounded(), unitSrc), (v1, v2) -> {
                try {
                    return v1.compareToRel((UnitDouble)v2, 1.0E-9);
                }
                catch (Throwable t) {
                    assert (false);
                    return theUtil.relCompare(v1.getRawValue(), v2.getRawValue(), 1.0E-9);
                }
            });
        };
    }

    public static IDisplayProp.ComparisonEditorSupplier<String> string() {
        return (parent, vd) -> new StringCompare();
    }

    public static <RefT extends IMerlinObj> IDisplayProp.ComparisonEditorSupplier<RefT> singleObj(ObjSrcSupplier<RefT> source) {
        return (parent, vd) -> new SingleObjCompare(vd, source.get(vd));
    }

    public static <RefT extends IMerlinObj> IDisplayProp.ComparisonEditorSupplier<? extends Collection<? extends RefT>> multiObj(ObjSrcSupplier<RefT> source) {
        return (parent, vd) -> new MultiObjCompare(vd, source.get(vd));
    }

    public static ObjSrcSupplier<Floor> getFloorSrc(String nullName) {
        return vd -> ObjSource.getFloors(vd, nullName);
    }

    public static ObjSrcSupplier<ISchematicRoom> getZoneSrc(String nullName) {
        return vd -> ObjSource.getZones(vd, nullName);
    }

    public static ObjSrcSupplier<Material> getMaterialSrc(String nullName) {
        return vd -> ObjSource.getMaterials(vd, nullName);
    }

    public static <RootT extends Composite<ObjT>, ObjT extends IMerlinObj> ObjSrcSupplier<ObjT> getFeatureSrc(CompositeFeatureGuid<RootT, ObjT> guid, String nullName) {
        return vd -> ObjSource.getFeature(vd, guid, nullName);
    }

    public static IDisplayProp.ComparisonEditorSupplier<Boolean> booleanYesNo() {
        return PropComparisons.booleanCustom(Intl.intl("is YES"), Intl.intl("is NO"));
    }

    public static IDisplayProp.ComparisonEditorSupplier<Boolean> booleanCustom(String trueOpt, String falseOpt) {
        return (parent, vd) -> new OptionsCompare<Boolean>(List.of(Boolean.valueOf(true), Boolean.valueOf(false)), v -> v != false ? new Pair<String, Object>(trueOpt, null) : new Pair<String, Object>(falseOpt, null), theUtil::equal);
    }

    public static <ValT> IDisplayProp.ComparisonEditorSupplier<ValT> options(Collection<? extends ValT> vals, Function<? super ValT, Pair<String, String>> format, BiPredicate<? super ValT, ? super ValT> compare) {
        return (parent, vd) -> new OptionsCompare(vals, format, compare);
    }

    public static <ValT extends ILabeled> IDisplayProp.ComparisonEditorSupplier<ValT> options(ValT ... vals) {
        return PropComparisons.options(List.of(vals), v -> guiUtil.encodeToHtmlLabel(v.getName(), v.getDescription()), theUtil::equal);
    }

    public static IDisplayProp.ComparisonEditorSupplier<Color> color(boolean includeAlpha) {
        return (parent, vd) -> new ColorComparison(includeAlpha);
    }

    public static interface ObjSrcSupplier<RefT extends IMerlinObj> {
        public ObjSource<RefT> get(VentusData var1);
    }

    private static class ColorComparison
    extends guiPanel
    implements ISimplePropComparisonEd<Color>,
    Observer {
        private static final long serialVersionUID = 1L;
        private final boolean d_includeAlpha;
        private final guiComboBox<Comparison> d_comparisonCb;
        private final ColorButton d_colorBtn;

        public ColorComparison(boolean includeAlpha) {
            this.d_includeAlpha = includeAlpha;
            this.d_comparisonCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Comparison.values());
            int colorOpts = 0;
            if (!includeAlpha) {
                colorOpts |= 1;
            }
            this.d_colorBtn = new ColorButton(colorOpts);
            this.d_colorBtn.addObserver(this);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_comparisonCb, this.d_colorBtn);
            gb.finalizeRows();
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public void update(Observable o, Object arg) {
            this.d_comm.touch(this);
        }

        @Override
        public Predicate<? super Color> getSimplePredicate() {
            Comparison comparison = this.d_comparisonCb.getSelectedItem();
            Color selColor = this.d_colorBtn.getColor();
            BiPredicate<Color, Color> compareColors = this.d_includeAlpha ? theUtil::equal : (c1, c2) -> {
                if (c1 == null) {
                    return c2 == null;
                }
                if (c2 == null) {
                    return false;
                }
                return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
            };
            return color -> comparison.test.test(compareColors.test((Color)color, selColor));
        }

        private static enum Comparison {
            IS(Intl.intl("is"), equal -> equal),
            IS_NOT(Intl.intl("is not"), equal -> equal == false);

            public final String desc;
            public final Predicate<Boolean> test;

            private Comparison(String desc, Predicate<Boolean> test) {
                this.desc = desc;
                this.test = test;
            }
        }
    }

    private static class OptionsCompare<ValT>
    extends guiPanel
    implements ISimplePropComparisonEd<ValT> {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<Comparison> d_comparisonCb;
        private final guiComboBox<? extends ValT> d_valuesCb;
        private final BiPredicate<? super ValT, ? super ValT> d_compare;

        public OptionsCompare(Collection<? extends ValT> valuesColl, Function<? super ValT, Pair<String, String>> formatVal, BiPredicate<? super ValT, ? super ValT> compare) {
            this.d_comparisonCb = valuesColl.size() > 2 ? guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Comparison.values()) : null;
            this.d_valuesCb = guiUtil.newCombo(formatVal, valuesColl);
            this.d_compare = compare;
            GridBagHelper gb = new GridBagHelper(this);
            if (this.d_comparisonCb != null) {
                gb.addRow(this.d_comparisonCb, this.d_valuesCb);
            } else {
                gb.addRow(this.d_valuesCb);
            }
            gb.finalizeRows();
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public Predicate<? super ValT> getSimplePredicate() {
            ValT selVal = this.d_valuesCb.getSelectedItem();
            if (this.d_comparisonCb != null) {
                Comparison comparison = this.d_comparisonCb.getSelectedItem();
                return val -> comparison.test.test(this.d_compare.test(val, selVal));
            }
            return val -> this.d_compare.test(val, selVal);
        }

        private static enum Comparison {
            IS(Intl.intl("is"), equal -> equal),
            IS_NOT(Intl.intl("is not"), equal -> equal == false);

            public final String desc;
            public final Predicate<Boolean> test;

            private Comparison(String desc, Predicate<Boolean> test) {
                this.desc = desc;
                this.test = test;
            }
        }
    }

    private static class MultiObjCompare<RefT extends IMerlinObj>
    extends guiPanel
    implements ISimplePropComparisonEd<Collection<? extends RefT>> {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<Comparison> d_comparisonCb = guiUtil.newCombo(comp -> new Pair<String, String>(comp.desc, comp.tooltip), Comparison.values());
        private final SetChooser<RefT> d_compareMulti;

        public MultiObjCompare(VentusData vd, ObjSource<RefT> source) {
            this.d_compareMulti = new SetChooser<RefT>(vd, Intl.intl("Select Objects"), Intl.intl("Invalid Selection"), 1, source);
            vd.getEvents().removeObserver(this.d_compareMulti);
            GridBagHelper gb = new GridBagHelper(this);
            this.addTo(gb);
            gb.finalizeRows();
        }

        private void addTo(GridBagHelper gb) {
            gb.addRow(this.d_comparisonCb, this.d_compareMulti, 1.0);
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
            this.d_compareMulti.update(events);
        }

        @Override
        public Predicate<? super Collection<? extends RefT>> getSimplePredicate() {
            Comparison comparison = this.d_comparisonCb.getSelectedItem();
            Set selection = this.d_compareMulti.getObjs();
            return val -> comparison.test.test((Collection<?>)val, selection);
        }

        private static enum Comparison {
            EXACT(Intl.intl("contains exactly"), Intl.intl("Tests if the object's value set matches the selection."), (o1, o2) -> {
                if (o1.size() != o2.size()) return false;
                if (!o1.stream().allMatch(o2::contains)) return false;
                return true;
            }),
            ANY(Intl.intl("contains any"), Intl.intl("Tests if the object's value set contains any of the selected values."), (o1, o2) -> o1.stream().anyMatch(o2::contains)),
            ALL(Intl.intl("contains all"), Intl.intl("Tests if the object's value set contains all of the selected values."), (o1, o2) -> {
                if (o1.size() < o2.size()) {
                    return false;
                }
                if (o1 instanceof Set) {
                    Set set = (Set)o1;
                    return set.containsAll((Collection<?>)o2);
                }
                if (o2.size() < 10) {
                    return o1.containsAll((Collection<?>)o2);
                }
                return new LinkedIdentityHashSet(o1).containsAll((Collection<?>)o2);
            }),
            NONE(Intl.intl("contains none"), Intl.intl("Tests if the object's value set doesn't contain any of the selected values."), (o1, o2) -> o1.stream().noneMatch(o2::contains));

            public final String desc;
            public final String tooltip;
            public final BiPredicate<? super Collection<?>, Set<?>> test;

            private Comparison(String desc, String tooltip, BiPredicate<? super Collection<?>, Set<?>> test) {
                this.desc = desc;
                this.tooltip = tooltip;
                this.test = test;
            }
        }
    }

    private static class SingleObjCompare<RefT extends IMerlinObj>
    extends guiPanel
    implements ISimplePropComparisonEd<RefT> {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<Comparison> d_comparisonCb = guiUtil.newCombo(comp -> new Pair<String, String>(comp.desc, comp.tooltip), Comparison.values());
        private final MerlinComboBox<RefT> d_compareSingle;
        private final SetChooser<RefT> d_compareMulti;

        public SingleObjCompare(VentusData vd, ObjSource<RefT> src) {
            this.d_compareMulti = new SetChooser<RefT>(vd, Intl.intl("Select Objects"), Intl.intl("Invalid Selection"), 1, src);
            this.d_compareSingle = new MerlinComboBox<RefT>(vd, src);
            vd.getEvents().removeObserver(this.d_compareMulti);
            vd.getEvents().removeObserver(this.d_compareSingle);
            Runnable updateControls = () -> {
                boolean single = this.d_comparisonCb.getSelectedItem().single;
                this.d_compareSingle.setVisible(single);
                this.d_compareMulti.setVisible(!single);
            };
            updateControls.run();
            this.d_comparisonCb.addItemListener(e -> updateControls.run());
            GridBagHelper gb = new GridBagHelper(this);
            this.addTo(gb);
            gb.finalizeRows();
        }

        private void addTo(GridBagHelper gb) {
            gb.addRow(this.d_comparisonCb, this.d_compareSingle, this.d_compareMulti, 1.0);
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
            this.d_compareMulti.update(events);
            this.d_compareSingle.update(events);
        }

        @Override
        public Predicate<RefT> getSimplePredicate() {
            Comparison comparison = this.d_comparisonCb.getSelectedItem();
            if (comparison.single) {
                IMerlinObj ref = (IMerlinObj)this.d_compareSingle.getSelectedItem();
                return val -> comparison.singleTest.test(val, ref);
            }
            Set objs = this.d_compareMulti.getObjs();
            return val -> comparison.multiTest.test(val, objs);
        }

        private static enum Comparison {
            IS(Intl.intl("is"), Intl.intl("Tests if the object's value is the selected value."), (o1, o2) -> o1 == o2, null),
            IS_NOT(Intl.intl("is not"), Intl.intl("Tests if the object's value is not the selected value."), (o1, o2) -> o1 != o2, null),
            IS_ONE_OF(Intl.intl("is any"), Intl.intl("Tests if the object's value is one of the selected values."), null, (o1, objs2) -> objs2.contains(o1)),
            IS_NONE_OF(Intl.intl("is none"), Intl.intl("Tests if the object's value is none of the selected values."), null, (o1, objs2) -> !objs2.contains(o1));

            public final String desc;
            public final String tooltip;
            public final boolean single;
            public final BiPredicate<Object, Object> singleTest;
            public final BiPredicate<Object, Set<?>> multiTest;

            private Comparison(String desc, String tooltip, BiPredicate<Object, Object> singleTest, BiPredicate<Object, Set<?>> multiTest) {
                this.desc = desc;
                this.tooltip = tooltip;
                this.single = singleTest != null;
                this.singleTest = singleTest;
                this.multiTest = multiTest;
            }
        }
    }

    private static class StringCompare
    extends guiPanel
    implements ISimplePropComparisonEd<String> {
        private static final long serialVersionUID = 1L;
        private final guiTextField d_findFld = new guiTextField();
        private final guiCheckBox d_wholeWordCB;
        private final guiCheckBox d_caseSensitiveCB;

        public StringCompare() {
            this.d_findFld.setColumns(20);
            this.d_wholeWordCB = new guiCheckBox(Intl.intl("Whole Word"));
            this.d_caseSensitiveCB = new guiCheckBox(Intl.intl("Case Sensitive"));
            GridBagHelper gb = new GridBagHelper(this);
            this.addTo(gb);
            gb.finalizeRows();
        }

        private void addTo(GridBagHelper gb) {
            gb.addRow(this.d_findFld, 1.0, this.d_wholeWordCB, this.d_caseSensitiveCB);
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public Predicate<String> getSimplePredicate() {
            String query;
            boolean caseSensitive = this.d_caseSensitiveCB.isSelected();
            boolean wholeWord = this.d_wholeWordCB.isSelected();
            String string = query = this.d_findFld.getText() != null ? this.d_findFld.getText().trim() : "";
            if (wholeWord) {
                Pattern p = !caseSensitive ? Pattern.compile("\\b" + query + "\\b", 2) : Pattern.compile("\\b" + query + "\\b");
                return str -> p.matcher((CharSequence)str).find();
            }
            if (caseSensitive) {
                return str -> str.contains(query);
            }
            String lquery = query.toLowerCase();
            return str -> str.toLowerCase().contains(lquery);
        }
    }

    private static class ScheduleCompare
    extends guiPanel
    implements ISimplePropComparisonEd<Schedule> {
        private static final long serialVersionUID = 1L;
        private final ValueField<UnitDouble> d_field;
        private final guiComboBox<Range> d_rangeCb;
        private final guiComboBox<Comparison> d_comparisonCb;
        private final Comparator<UnitDouble> d_comparator;

        public ScheduleCompare(ValueField<UnitDouble> field, Comparator<UnitDouble> comparator) {
            this.d_field = field;
            this.d_field.setNullAllowed(false);
            this.d_rangeCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Range.values());
            this.d_comparisonCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Comparison.values());
            this.d_comparator = comparator;
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(this.d_rangeCb, this.d_comparisonCb, this.d_field);
            gb.finalizeRows();
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public Predicate<Schedule> getSimplePredicate() {
            Range range = this.d_rangeCb.getSelectedItem();
            Comparison comparison = this.d_comparisonCb.getSelectedItem();
            Predicate<UnitDouble> compareInstantaneous = val -> {
                if (val == null) {
                    assert (false) : "PropComparisons.ScheduleCompare does not yet support comparing to null values. Update ScheduleCompare to handle this case.";
                    return false;
                }
                int compared = this.d_comparator.compare((UnitDouble)val, (UnitDouble)this.d_field.getValue());
                return comparison.test.test(compared);
            };
            return schedule -> range.test.test((Schedule)schedule, compareInstantaneous);
        }

        private static enum Range {
            INITIALLY(Intl.intl("is initially"), (schedule, test) -> test.test(schedule.getInitialValue())),
            EVER(Intl.intl("is ever"), (schedule, test) -> schedule.allValues().anyMatch((Predicate<UnitDouble>)test)),
            ALWAYS(Intl.intl("is always"), (schedule, test) -> schedule.allValues().allMatch((Predicate<UnitDouble>)test));

            public final String desc;
            public final BiPredicate<Schedule, Predicate<UnitDouble>> test;

            private Range(String desc, BiPredicate<Schedule, Predicate<UnitDouble>> test) {
                this.desc = desc;
                this.test = test;
            }
        }

        private static enum Comparison {
            LT("<", c -> c < 0),
            LE("\u2264", c -> c <= 0),
            GT(">", c -> c > 0),
            GE("\u2265", c -> c >= 0);

            public final String desc;
            public final IntPredicate test;

            private Comparison(String desc, IntPredicate test) {
                this.desc = desc;
                this.test = test;
            }
        }
    }

    private static class NumberCompare<NumT>
    extends guiPanel
    implements ISimplePropComparisonEd<NumT> {
        private static final long serialVersionUID = 1L;
        private final ValueField<NumT> d_field;
        private final guiComboBox<Comparison> d_comparisonCb;
        private final Comparator<NumT> d_comparator;

        public NumberCompare(ValueField<NumT> field, Comparator<NumT> comparator) {
            this.d_field = field;
            this.d_field.setNullAllowed(true);
            this.d_comparisonCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Comparison.values());
            this.d_comparator = comparator;
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(this.d_comparisonCb, this.d_field);
            gb.finalizeRows();
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public Predicate<NumT> getSimplePredicate() {
            Comparison comparison = this.d_comparisonCb.getSelectedItem();
            Object fieldVal = this.d_field.getValue();
            return val -> {
                if (val == null || fieldVal == null) {
                    switch (comparison.ordinal()) {
                        case 4: {
                            return val == null && fieldVal == null;
                        }
                        case 5: {
                            return val != null || fieldVal != null;
                        }
                    }
                    return false;
                }
                int compared = this.d_comparator.compare(val, fieldVal);
                return comparison.test.test(compared);
            };
        }

        private static enum Comparison {
            LT("<", c -> c < 0),
            LE("\u2264", c -> c <= 0),
            GT(">", c -> c > 0),
            GE("\u2265", c -> c >= 0),
            EQ("=", c -> c == 0),
            NEQ("\u2260", c -> c != 0);

            public final String desc;
            public final IntPredicate test;

            private Comparison(String desc, IntPredicate test) {
                this.desc = desc;
                this.test = test;
            }
        }
    }

    private static class ConvertedComparison<PropValT, CompareValT>
    implements ISimplePropComparisonEd<PropValT> {
        private final Function<PropValT, CompareValT> d_valMapper;
        private final ISimplePropComparisonEd<CompareValT> d_baseComparisonEd;

        public ConvertedComparison(Function<PropValT, CompareValT> valMapper, ISimplePropComparisonEd<CompareValT> baseComparisonEd) {
            this.d_valMapper = valMapper;
            this.d_baseComparisonEd = baseComparisonEd;
        }

        @Override
        public guiPanel getUi() {
            return this.d_baseComparisonEd.getUi();
        }

        @Override
        public Comm getComm() {
            return this.d_baseComparisonEd.getComm();
        }

        @Override
        public void update(Events events) {
            this.d_baseComparisonEd.update(events);
        }

        @Override
        public Predicate<? super PropValT> getSimplePredicate() {
            Predicate<CompareValT> basePred = this.d_baseComparisonEd.getSimplePredicate();
            return propVal -> basePred.test(this.d_valMapper.apply(propVal));
        }
    }
}

