/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.props;

import java.awt.Component;
import java.util.Optional;
import thunderheadeng.gui.value.IValEditor;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.ISimplePropComparisonEd;
import ventus.feature.props.PropertyDefs;

public interface IDisplayProp<T> {
    public String getGroupDisplayName();

    public String getDisplayName();

    public String getDisplayDesc();

    public ValEditorSupplier<T> getValEditorSupplier();

    default public Optional<IValEditor<T>> newValueEditor(VentusData md, boolean inline) {
        ValEditorSupplier<T> supplier = this.getValEditorSupplier();
        if (supplier == null) {
            return Optional.empty();
        }
        return Optional.of(supplier.get(md, inline));
    }

    public ComparisonEditorSupplier<T> getComparisonEditorSupplier();

    default public String formatValue(T value) {
        return IDisplayProp.format(value);
    }

    public static String format(Object value) {
        return value != null ? value.toString() : Intl.intl("<undefined>");
    }

    public static interface ValEditorSupplier<T> {
        public IValEditor<T> get(VentusData var1, boolean var2);
    }

    public static interface ComparisonEditorSupplier<ValT>
    extends PropertyDefs.IComparisonEditorSupplier<IMerlinObj, ValT> {
        public ISimplePropComparisonEd<ValT> get(Component var1, VentusData var2);
    }
}

