/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JMenu;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.plot.IPlotSrc;
import ventus.feature.plot.PlotModeDesc;
import ventus.feature.plot.ShowTimeHistoryPlotOp;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;

public class ShowContaminantTimeHistoryPlots
implements IAppMenuItem,
IPlotSrc,
IContextMenuItem,
IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("ventus/icons/results2D16.gif");
    private final JMenu d_menu;
    private final JMenu d_menuContext;
    private final List<UIHook> d_plots = new ArrayList<UIHook>();
    private final List<UIHook> d_plotsContext = new ArrayList<UIHook>();

    public ShowContaminantTimeHistoryPlots() {
        this.d_menu = new JMenu(Intl.intl("Plot Contaminants"));
        this.d_menuContext = new JMenu(Intl.intl("Plot Contaminants"));
    }

    @Override
    public void update(Events events) {
        IEventRecord<IDomainObject> changelog = events.getEvents(IDomainObject.class, new Class[0]);
        if (changelog.hasAddedObjs() || changelog.hasRemovedObjs() || changelog.containsChange(VentusData.MODEL_RESET) || changelog.containsChange(VentusData.MODEL_LOADED)) {
            VentusData vd = VentusApp.getAppData();
            assert (vd != null);
            this.updateAvailable(vd);
            this.updateEnabled(vd);
        } else if (changelog.containsChange(VentusData.SELECTION_CHANGED)) {
            VentusData vd = VentusApp.getAppData();
            assert (vd != null);
            this.updateEnabled(vd);
        }
    }

    @Override
    public void addMenuItems(GroupedSequence root) {
        root.getNode("results").add(50, (Object)this.d_menu);
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        GroupedSequence node = root.getNode("results").getOrAdd(new GroupedSequence("plot", 150, null));
        node.add(40, (Object)this.d_menuContext);
    }

    @Override
    public void addPlotActions(GroupedSequence root) {
        this.updateAvailable(VentusApp.getAppData());
        root.addAll(40, this.d_plots.toArray());
    }

    private void updateAvailable(VentusData md) {
        DataNode.ResultsRoot root = (DataNode.ResultsRoot)md.getComponentData(ResultsDataComp.GUID);
        TreeSet<String> concentrations = new TreeSet<String>();
        for (DataNode.ZoneVisLeaf leaf : root.flatten(DataNode.ZoneVisLeaf.class)) {
            concentrations.addAll(leaf.getConcentrationKeys());
        }
        this.d_plots.clear();
        this.d_plotsContext.clear();
        for (String concentration : concentrations) {
            this.d_plots.add(ShowContaminantTimeHistoryPlots.createHook(concentration, false));
            this.d_plotsContext.add(ShowContaminantTimeHistoryPlots.createHook(concentration, true));
        }
        this.d_menu.removeAll();
        for (UIHook plotMenu : this.d_plots) {
            this.d_menu.add(plotMenu);
        }
        this.d_menuContext.removeAll();
        for (UIHook plotContext : this.d_plotsContext) {
            this.d_menuContext.add(plotContext);
        }
    }

    private static UIHook createHook(String concentration, boolean context) {
        return new UIHook((MerlinOp)new ShowTimeHistoryPlotOp(new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_CONCENTRATION, concentration), context), String.format(Intl.intl("Plot %1$s Concentrations...,-,Plot %1$s Concentrations..."), concentration), ICON);
    }

    private void updateEnabled(VentusData md) {
        DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)md.getComponentData(ResultsDataComp.GUID);
        boolean hasResults = !resultsRoot.flatten(DataNode.VisLeaf.class).isEmpty() || !resultsRoot.flatten(DataNode.ZoneVisLeaf.class).isEmpty();
        boolean zonesSelected = md.selection.contains(SchematicRoom.class, DataNode.ZoneVisLeaf.class);
        this.d_menu.setEnabled(this.d_menu.getItemCount() > 0);
        this.d_menuContext.setEnabled(this.d_menuContext.getItemCount() > 0 && hasResults && zonesSelected);
    }
}

