/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.ISeries;
import thunderheadeng.gui.LWSeries;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.TypedCkBoxListPanel;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.ImageTransferrable;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.feature.plot.PlotModeDesc;
import ventus.feature.results.DataNode;
import ventus.feature.results.ResultsDataComp;
import ventus.feature.results.SelectionResultsTableUtil;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.gui.guiUtil;
import ventus.util.MerlinUtil;

public class Plot2dDlg
extends guiFrame
implements Observer,
IEventObserver {
    private static final long serialVersionUID = 2061555054401005077L;
    private final VentusData d_vd;
    private Map<SeriesItem, LWSeries> d_series = new LinkedHashMap<SeriesItem, LWSeries>();
    private final Graph d_graph;
    private final TypedCkBoxListPanel<SeriesItem> d_seriesList;
    private final guiTextField d_regexField;
    private final SelectionResultsTableUtil.SimRootCombobox d_simRootCombo;
    private final guiLabel d_filteredRowsLbl;
    private boolean d_autoRange;
    private IMode d_lastMode;
    private final Map<PlotModeDesc, IMode> d_modes = new LinkedHashMap<PlotModeDesc, IMode>();
    private final Map<PlotModeDesc, JRadioButtonMenuItem> d_rmbiModes = new LinkedHashMap<PlotModeDesc, JRadioButtonMenuItem>();
    private boolean d_annotateObjPaths = true;
    private boolean d_annotateScenarios = true;
    private static final Color[] SERIES_COLORS = new Color[]{new Color(0, 176, 80), new Color(112, 48, 160), new Color(192, 0, 0), new Color(255, 192, 0), new Color(1, 176, 240), new Color(146, 208, 80), new Color(0, 112, 192), new Color(0, 32, 96)};
    private static final int[] SERIES_LINESTYLES = new int[]{0, 1, 2, 3, 4};
    private static final int[] SERIES_MARKSTYLES = new int[]{6, 7, 8, 9, 10, 11, 12, 13};

    public Plot2dDlg(VentusData vd) {
        super(Intl.intl("Time History Data"));
        this.d_vd = vd;
        this.d_seriesList = new TypedCkBoxListPanel<SeriesItem>(SeriesItem.class, item -> item.format(this.d_annotateObjPaths, this.d_annotateScenarios));
        this.d_seriesList.addObserver(this);
        this.d_regexField = new guiTextField();
        this.d_regexField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Plot2dDlg.this.updateFilters();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Plot2dDlg.this.updateFilters();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Plot2dDlg.this.updateFilters();
            }
        });
        this.d_regexField.setToolTipText(Intl.intl("Filter by Name or Tag"));
        this.d_simRootCombo = new SelectionResultsTableUtil.SimRootCombobox();
        this.d_simRootCombo.setNullString(Intl.intl("<All>"));
        this.d_simRootCombo.addItemListener(e -> this.updateFilters());
        this.d_simRootCombo.setToolTipText(Intl.intl("Filter by data set"));
        this.d_filteredRowsLbl = new guiLabel("");
        this.d_graph = new Graph();
        this.d_graph.setLegendVisible(true);
        this.d_autoRange = true;
        this.d_lastMode = null;
        this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.PRIMARY_FLOW), new PrimaryFlowMode());
        this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.SECONDARY_FLOW), new SecondaryFlowMode());
        this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.PRESSURE_DIFF), new PressureDiffMode());
        this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_TEMP), new ZoneTempMode());
        this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_PRESSURE), new ZonePressureMode());
        this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_DENSITY), new ZoneDensityMode());
        TreeSet<String> concentrations = new TreeSet<String>();
        DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)this.d_vd.getComponentData(ResultsDataComp.GUID);
        for (DataNode.ZoneVisLeaf leaf : resultsRoot.flatten(DataNode.ZoneVisLeaf.class)) {
            concentrations.addAll(leaf.getConcentrationKeys());
        }
        for (String concentration : concentrations) {
            this.d_modes.put(new PlotModeDesc(PlotModeDesc.PlotModeType.ZONE_CONCENTRATION, concentration), new ZoneConcentrationMode(concentration));
        }
        new MouseHandler(this.d_graph);
        this.d_series = Collections.emptyMap();
        JPanel seriesListPanel = new JPanel(new MigLayout("fill, insets 8 8 8 0", "[][][grow][]", "[]8[]8[grow]"));
        seriesListPanel.add(new guiLabel(Intl.intl("Filter:")));
        seriesListPanel.add(this.d_simRootCombo);
        seriesListPanel.add((Component)this.d_regexField, "growx");
        seriesListPanel.add((Component)new JLabel(guiUtil.loadIconSvg(ResultsDataComp.class.getResource("icons/find.svg"), 16)), "wrap");
        seriesListPanel.add((Component)this.d_filteredRowsLbl, "span, wrap");
        seriesListPanel.add(this.d_seriesList, "grow, span");
        JSplitPane splitter = new JSplitPane(1, true);
        splitter.setLeftComponent(seriesListPanel);
        splitter.setRightComponent(this.d_graph);
        this.add(splitter);
        this.setJMenuBar(this.createMenus());
        this.updateFilters();
        this.updateSimRoots();
        vd.getEvents().addObserver(this);
    }

    private void updateFilters() {
        String regex;
        Predicate<Object> filter = Predicates.alwaysTrue();
        DataNode.SimulationRoot simRoot = (DataNode.SimulationRoot)this.d_simRootCombo.getSelectedItem();
        if (simRoot != null) {
            filter = filter.and(item -> item.simRoot == simRoot);
        }
        if (!(regex = this.d_regexField.getText().trim()).isEmpty()) {
            Pattern pattern = Pattern.compile(regex);
            String[] tagTokens = regex.toLowerCase().split(" ");
            filter = filter.and(item -> {
                if (pattern.matcher(item.name).find()) {
                    return true;
                }
                String tags = TagsUtil.formatTags(item.getTags());
                return Arrays.stream(tagTokens).anyMatch(tags::contains);
            });
        }
        this.d_seriesList.setFilter(filter);
        this.d_filteredRowsLbl.setText(String.format(Intl.intl("Showing %1$d of %2$d rows."), this.d_seriesList.visibleCount(), this.d_seriesList.getItems().size()));
    }

    @Override
    public boolean close() {
        boolean result = super.close();
        if (result) {
            this.d_graph.reset();
            this.d_series = Collections.emptyMap();
        }
        return result;
    }

    private JMenuBar createMenus() {
        JMenu editMenu = new JMenu(Intl.intl("Edit"));
        editMenu.add(new SelectAll());
        editMenu.add(new ClearSelection());
        editMenu.addSeparator();
        editMenu.add(new CopyGraphImage());
        MenuBuilder viewMenuBuilder = new MenuBuilder();
        viewMenuBuilder.add(new AutoRangeAction());
        viewMenuBuilder.add(new ShowLegendAction());
        viewMenuBuilder.addSeparator();
        viewMenuBuilder.add(new AnnotateObjPathsAction());
        viewMenuBuilder.add(new AnnotateScenariosAction());
        JMenu viewMenu = viewMenuBuilder.buildMenu(Intl.intl("View"));
        for (Map.Entry<PlotModeDesc, IMode> entry : this.d_modes.entrySet()) {
            this.d_rmbiModes.put(entry.getKey(), new JRadioButtonMenuItem(new ModeSelectorAction(entry.getKey())));
        }
        new guiButtonGroup(this.d_rmbiModes.values().toArray(new JRadioButtonMenuItem[0]));
        JMenu modeMenu = new JMenu(Intl.intl("Mode"));
        for (JRadioButtonMenuItem item : this.d_rmbiModes.values()) {
            modeMenu.add(item);
        }
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(editMenu);
        jMenuBar.add(viewMenu);
        jMenuBar.add(modeMenu);
        return jMenuBar;
    }

    private void repaintGraph() {
        EventQueue.invokeLater(this.d_graph::repaint);
    }

    public void updateAutoRange(boolean useOnlySelectedData) {
        if (this.d_series == null || this.d_series.isEmpty()) {
            return;
        }
        LWSeries series0 = this.d_series.values().iterator().next();
        try {
            series0.makeBoundsValid();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        double xmax = series0.getMaxX();
        this.d_graph.setRangeX(0.0, xmax * 1.05);
        double ymin = Double.MAX_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Map.Entry<SeriesItem, LWSeries> s : this.d_series.entrySet()) {
            if (!this.d_seriesList.isSelected(s.getKey()) && useOnlySelectedData) continue;
            try {
                s.getValue().makeBoundsValid();
            }
            catch (Throwable t) {
                return;
            }
            ymin = Math.min(ymin, s.getValue().getMinY());
            ymax = Math.max(ymax, s.getValue().getMaxY());
        }
        this.d_graph.setRangeY(Math.min(0.0, ymin * 1.05), ymax * 1.05);
    }

    public void updateListBox() {
        Set<SeriesItem> selected = this.d_seriesList.getSelection();
        this.d_seriesList.setItems(this.d_series.keySet());
        this.d_seriesList.setSelection(selected);
    }

    public void selectItem(SeriesItem item) {
        if (item != null) {
            this.d_seriesList.setSelected(item, true);
        }
    }

    private static IntToDoubleFunction toIntFunction(double[] arr) {
        return i -> arr[i];
    }

    private static <T> Collector<T, ?, Map<SeriesItem, LWSeries>> toSeries(Function<T, SeriesItem> getItem, Function<T, double[]> getXVals, Function<T, double[]> getYVals, Unit srcUnit, Unit targetUnit, boolean isLineStyle, boolean annotatePaths, boolean annotateSimRoots) {
        return Collector.of(LinkedHashMap::new, (map, obj) -> {
            SeriesItem item = (SeriesItem)getItem.apply(obj);
            double[] xvals = (double[])getXVals.apply(obj);
            double[] yvals = (double[])getYVals.apply(obj);
            Converter converter = srcUnit.getConverterTo(targetUnit);
            Supplier<IntStream> xIxesSrc = () -> IntStream.range(0, xvals.length);
            Supplier<IntToDoubleFunction> xDataSrc = () -> Plot2dDlg.toIntFunction(xvals);
            Supplier<IntToDoubleFunction> yDataSrc = () -> i -> converter.convert(yvals[i]);
            int col = map.size();
            int ixColor = col % SERIES_COLORS.length;
            int ixStyleLine = col / SERIES_COLORS.length % SERIES_LINESTYLES.length;
            int ixStyleMark = col / SERIES_COLORS.length % SERIES_MARKSTYLES.length;
            LWSeries s = new LWSeries(xIxesSrc, xDataSrc, yDataSrc, item.format(annotatePaths, annotateSimRoots), SERIES_COLORS[ixColor], isLineStyle ? 14 : SERIES_MARKSTYLES[ixStyleMark], isLineStyle ? SERIES_LINESTYLES[ixStyleLine] : 5, 2);
            map.put(item, s);
        }, (list1, list2) -> {
            list1.putAll(list2);
            return list1;
        }, new Collector.Characteristics[0]);
    }

    public void showSeries(Collection<SeriesItem> series) {
        for (SeriesItem item : series) {
            LWSeries s = this.d_series.get(item);
            if (s == null) continue;
            try {
                s.open();
            }
            catch (Throwable t) {
                guiUtil.showError(this, Intl.intl("Error"), Intl.intl("Could not show results"), t);
                s.close();
                return;
            }
            this.d_graph.addSeries(s);
        }
        if (this.d_autoRange) {
            this.updateAutoRange(true);
        }
        this.repaintGraph();
    }

    public void hideSeries(Collection<SeriesItem> series) {
        for (SeriesItem item : series) {
            LWSeries s = this.d_series.get(item);
            if (s == null) continue;
            this.d_graph.removeSeries(s);
            EventQueue.invokeLater(() -> s.close());
        }
        if (this.d_autoRange) {
            this.updateAutoRange(true);
        }
        this.repaintGraph();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof TypedCkBoxListPanel.EvtSelected) {
            TypedCkBoxListPanel.EvtSelected evtSelected = (TypedCkBoxListPanel.EvtSelected)arg;
            this.showSeries(evtSelected.selected());
        } else if (arg instanceof TypedCkBoxListPanel.EvtUnselected) {
            TypedCkBoxListPanel.EvtUnselected evtUnselected = (TypedCkBoxListPanel.EvtUnselected)arg;
            this.hideSeries(evtUnselected.unselected());
        }
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(DataNode.VisLeaf.class, new Class[0]).hasAddedObjs() || events.getEvents(DataNode.VisLeaf.class, new Class[0]).hasRemovedObjs() || events.getEvents(DataNode.ZoneVisLeaf.class, new Class[0]).hasAddedObjs() || events.getEvents(DataNode.ZoneVisLeaf.class, new Class[0]).hasRemovedObjs()) {
            this.refreshData();
        }
        for (EventChannel<VentusData> channel : events.getAffectedChannels(VentusData.class, new Class[0])) {
            if (channel.hasChangedObjs(VentusData.MODEL_LOADED, VentusData.MODEL_RESET)) {
                this.refreshData();
            }
            if (!channel.hasChangedObjs(VentusData.UNITSYSTEM_CHANGED)) continue;
            this.updateUnits();
        }
    }

    private void updateUnits() {
        this.refreshData();
        this.setTitle(this.d_lastMode.getModeName());
        this.d_graph.setTitle(this.d_lastMode.getGraphTitle());
        this.d_graph.setXTitle(this.d_lastMode.getAxisTitleX());
        this.d_graph.setYTitle(this.d_lastMode.getAxisTitleY());
    }

    private void switchMode(IMode mode) {
        this.d_lastMode = mode;
        this.d_series = this.getTransformedData(mode);
        this.d_graph.reset();
        this.d_graph.setAutoRangeX(false);
        this.d_graph.setAutoRangeY(false);
        this.d_graph.setRangeX(0.0, 1.0);
        this.d_graph.setRangeY(0.0, 1.0);
        this.setTitle(mode.getModeName());
        this.d_graph.setTitle(mode.getGraphTitle());
        this.d_graph.setXTitle(mode.getAxisTitleX());
        this.d_graph.setYTitle(mode.getAxisTitleY());
        this.updateAutoRange(false);
        this.updateListBox();
        if (!this.d_series.isEmpty()) {
            this.selectItem(this.d_series.keySet().iterator().next());
        }
        this.repaintGraph();
    }

    private void refreshData() {
        this.d_graph.reset();
        Set<SeriesItem> previouslySelected = this.d_seriesList.getSelection();
        this.hideSeries(this.d_series.keySet());
        this.updateSimRoots();
        this.d_series = this.getTransformedData(this.d_lastMode);
        this.updateListBox();
        this.d_seriesList.setSelection(previouslySelected);
        this.updateAutoRange(true);
        this.repaintGraph();
    }

    private void updateSimRoots() {
        DataNode.ResultsRoot root = (DataNode.ResultsRoot)VentusApp.getAppData().getComponentData(ResultsDataComp.GUID);
        this.d_simRootCombo.setItems(root.flatten(DataNode.SimulationRoot.class));
    }

    private Map<SeriesItem, LWSeries> getTransformedData(IMode mode) {
        return mode.getData(this.d_vd, this.d_annotateObjPaths, this.d_annotateScenarios);
    }

    public void open(PlotModeDesc mode, Set<Pair<DataNode.SimulationRoot, IMerlinObj>> selected) {
        this.d_rmbiModes.get(mode).setSelected(true);
        this.switchMode(this.d_modes.get(mode));
        if (!selected.isEmpty()) {
            Set toSelect = this.d_series.keySet().stream().filter(series -> series.selectableObjs().anyMatch(obj -> selected.contains(new Pair<DataNode.SimulationRoot, IMerlinObj>(series.simRoot, (IMerlinObj)obj)))).collect(Collectors.toSet());
            this.d_seriesList.setSelection(toSelect);
        }
        this.setVisible(true);
    }

    private static SeriesItem makeFlowPathItem(VentusData vd, DataNode.VisLeaf leaf) {
        return new SeriesItem(leaf.getName(), MerlinUtil.getNameWithBreadcrumbs(vd.getComponentData(FlowPathsFeature.GUID), (IMerlinObj)leaf.getCorrespondingFlowpath()), vd.hierarchy.getAncestor(leaf, false, DataNode.SimulationRoot.class, Predicates.alwaysTrue()), leaf, (IMerlinObj)leaf.getCorrespondingFlowpath());
    }

    private static SeriesItem makeZoneItem(VentusData vd, DataNode.ZoneVisLeaf leaf) {
        return new SeriesItem(leaf.getName(), MerlinUtil.getNameWithBreadcrumbs(vd.floors, (IMerlinObj)leaf.getCorrespondingRoom()), vd.hierarchy.getAncestor(leaf, false, DataNode.SimulationRoot.class, Predicates.alwaysTrue()), leaf, (IMerlinObj)leaf.getCorrespondingRoom());
    }

    public record SeriesItem(String name, String annotatedName, DataNode.SimulationRoot simRoot, DataNode resultsObj, IMerlinObj sourceObj) {
        @Override
        public int hashCode() {
            return this.resultsObj.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (!(other instanceof SeriesItem)) return false;
            SeriesItem item = (SeriesItem)other;
            if (this.resultsObj != item.resultsObj) return false;
            return true;
        }

        public String format(boolean annotatePath, boolean annotateSimRoot) {
            if (annotateSimRoot) {
                return String.format(Intl.intl("%1$s %2$s"), this.simRoot.getName(), annotatePath ? this.annotatedName : this.name);
            }
            return annotatePath ? this.annotatedName : this.name;
        }

        public Set<Tag> getTags() {
            return this.sourceObj != null ? this.sourceObj.getWithDetails(VentusData.TAGS).orElse(Set.of()) : Set.of();
        }

        public Stream<IMerlinObj> selectableObjs() {
            if (this.sourceObj != null) {
                return Stream.of(this.resultsObj, this.sourceObj);
            }
            return Stream.of(this.resultsObj);
        }
    }

    public static interface IMode {
        public Map<SeriesItem, LWSeries> getData(VentusData var1, boolean var2, boolean var3);

        public String getModeName();

        public String getGraphTitle();

        public String getAxisTitleY();

        public String getAxisTitleX();
    }

    private static class PrimaryFlowMode
    implements IMode {
        private PrimaryFlowMode() {
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Primary Flow for Selected Flow Paths");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Primary Flows");
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("Primary Flow (%s)"), VentusApp.getApp().getUnitSystem().getDesignFlowRate().toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.VisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeFlowPathItem(vd, leaf), DataNode.VisLeaf::getTimes, DataNode.VisLeaf::getPrimaryFlows, SI.KILOGRAM.divide(SI.SECOND), vd.getUnitSystem().getDesignFlowRate(), true, annotatePaths, annotateSimRoots));
        }
    }

    private static class SecondaryFlowMode
    implements IMode {
        private SecondaryFlowMode() {
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Secondary Flow for Selected Flow Paths");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Secondary Flows");
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("Secondary Flow (%s)"), VentusApp.getApp().getUnitSystem().getDesignFlowRate().toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.VisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeFlowPathItem(vd, leaf), DataNode.VisLeaf::getTimes, DataNode.VisLeaf::getSecondaryFlows, SI.KILOGRAM.divide(SI.SECOND), vd.getUnitSystem().getDesignFlowRate(), true, annotatePaths, annotateSimRoots));
        }
    }

    private static class PressureDiffMode
    implements IMode {
        private PressureDiffMode() {
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Differential Pressure for Selected Flow Paths");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Differential Pressures");
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("Differential Pressure (%s)"), VentusApp.getApp().getUnitSystem().getPressure().toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.VisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeFlowPathItem(vd, leaf), DataNode.VisLeaf::getTimes, DataNode.VisLeaf::getDifferentialPressures, SI.PASCAL, vd.getUnitSystem().getPressure(), true, annotatePaths, annotateSimRoots));
        }
    }

    private static class ZoneTempMode
    implements IMode {
        private ZoneTempMode() {
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Temperature in Selected Zones");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Zone Temperatures");
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("Temperature (%s)"), VentusApp.getApp().getUnitSystem().getTemperature().toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.ZoneVisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeZoneItem(vd, leaf), DataNode.ZoneVisLeaf::getTimes, DataNode.ZoneVisLeaf::getTemperatures, SI.KELVIN, vd.getUnitSystem().getTemperature(), true, annotatePaths, annotateSimRoots));
        }
    }

    private static class ZonePressureMode
    implements IMode {
        private ZonePressureMode() {
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Pressure in Selected Zones");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Zone Pressures");
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("Pressure (%s)"), VentusApp.getApp().getUnitSystem().getPressure().toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.ZoneVisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeZoneItem(vd, leaf), DataNode.ZoneVisLeaf::getTimes, DataNode.ZoneVisLeaf::getPressures, SI.PASCAL, vd.getUnitSystem().getPressure(), true, annotatePaths, annotateSimRoots));
        }
    }

    private static class ZoneDensityMode
    implements IMode {
        private ZoneDensityMode() {
        }

        @Override
        public String getGraphTitle() {
            return Intl.intl("Density in Selected Zones");
        }

        @Override
        public String getModeName() {
            return Intl.intl("Zone Densities");
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("Density (%s)"), VentusApp.getApp().getUnitSystem().getDensity().toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.ZoneVisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeZoneItem(vd, leaf), DataNode.ZoneVisLeaf::getTimes, DataNode.ZoneVisLeaf::getDensities, SI.KILOGRAM.divide(SI.METER.pow(3)), vd.getUnitSystem().getDensity(), true, annotatePaths, annotateSimRoots));
        }
    }

    private static class ZoneConcentrationMode
    implements IMode {
        private final String d_species;

        private ZoneConcentrationMode(String species) {
            this.d_species = species;
        }

        @Override
        public String getGraphTitle() {
            return String.format(Intl.intl("Concentration of %s in Selected Zones"), this.d_species);
        }

        @Override
        public String getModeName() {
            return String.format(Intl.intl("%s Concentrations"), this.d_species);
        }

        @Override
        public String getAxisTitleY() {
            return String.format(Intl.intl("%1$s Concentration (%2$s)"), this.d_species, VentusApp.getApp().getUnitSystem().getUnit(25).toString());
        }

        @Override
        public String getAxisTitleX() {
            return String.format(Intl.intl("Time (%s)"), SI.SECOND.toString());
        }

        @Override
        public Map<SeriesItem, LWSeries> getData(VentusData vd, boolean annotatePaths, boolean annotateSimRoots) {
            DataNode.ResultsRoot resultsRoot = (DataNode.ResultsRoot)vd.getComponentData(ResultsDataComp.GUID);
            return resultsRoot.flatten(DataNode.ZoneVisLeaf.class).stream().collect(Plot2dDlg.toSeries(leaf -> Plot2dDlg.makeZoneItem(vd, leaf), DataNode.ZoneVisLeaf::getTimes, leaf -> leaf.getConcentrations(this.d_species), Unit.ONE, Unit.ONE, true, annotatePaths, annotateSimRoots));
        }
    }

    private static class MouseHandler
    extends MouseAdapter {
        private final Graph d_graph;
        private Graph.Annotation d_annotation;
        private final NumberFormat d_format;
        private final char d_separator;

        public MouseHandler(Graph g) {
            g.addMouseListener(this);
            g.addMouseMotionListener(this);
            this.d_graph = g;
            this.d_annotation = null;
            this.d_format = new DecimalFormat("######0.##");
            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            char localeSep = symbols.getDecimalSeparator();
            this.d_separator = (char)(localeSep != ',' ? 44 : 59);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.d_annotation != null && this.d_graph.removeAnnotation(this.d_annotation)) {
                this.d_graph.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            boolean needRepaint = false;
            if (this.d_annotation != null) {
                needRepaint |= this.d_graph.removeAnnotation(this.d_annotation);
            }
            Graph.PickPointVal pickVal = new Graph.PickPointVal();
            boolean onPoint = this.d_graph.pickPoint(evt.getX(), evt.getY(), 50, pickVal);
            if (onPoint) {
                ISeries s = pickVal.series;
                double x = s.getX().applyAsDouble(pickVal.i);
                double y = s.getY().applyAsDouble(pickVal.i);
                this.d_annotation = new Graph.Annotation("(" + this.d_format.format(x) + this.d_separator + this.d_format.format(y) + ")", new Point2D.Double(x, y), s.getColor());
                needRepaint |= this.d_graph.addAnnotation(this.d_annotation);
            }
            if (needRepaint) {
                this.d_graph.repaint();
            }
        }
    }

    private class SelectAll
    extends AbstractAction {
        private static final long serialVersionUID = -8671097449597703831L;

        public SelectAll() {
            super(Intl.intl("Select All"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Plot2dDlg.this.d_seriesList.setSelectedAll(false);
            Plot2dDlg.this.d_seriesList.setSelectedAll(true);
            Plot2dDlg.this.d_seriesList.repaint();
        }
    }

    private class ClearSelection
    extends AbstractAction {
        private static final long serialVersionUID = 8369531407147046327L;

        public ClearSelection() {
            super(Intl.intl("Clear Selection"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 3));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Plot2dDlg.this.d_seriesList.setSelectedAll(false);
            Plot2dDlg.this.d_seriesList.repaint();
        }
    }

    private class CopyGraphImage
    extends AbstractAction {
        private static final long serialVersionUID = -2688794358456913913L;

        public CopyGraphImage() {
            super(Intl.intl("Copy Graph Image"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Clipboard sysClip = Plot2dDlg.this.getToolkit().getSystemClipboard();
            int scale = 2;
            BufferedImage img = new BufferedImage(Plot2dDlg.this.d_graph.getWidth() * scale, Plot2dDlg.this.d_graph.getHeight() * scale, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            g.scale(scale, scale);
            Plot2dDlg.this.d_graph.paint(g);
            try {
                sysClip.setContents(new ImageTransferrable(img), null);
            }
            catch (IllegalStateException e) {
                guiUtil.showError(Application.getApp(), Intl.intl("Clipboard Unavailable"), Intl.intl("The clipboard is unavailable."), (Throwable)e);
            }
        }
    }

    private class AutoRangeAction
    extends BooleanAction {
        private static final long serialVersionUID = -2164553495549344984L;

        public AutoRangeAction() {
            super(Intl.intl("Auto Range"), true);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_autoRange = this.isSelected();
            if (Plot2dDlg.this.d_autoRange) {
                Plot2dDlg.this.updateAutoRange(true);
                Plot2dDlg.this.d_graph.repaint();
            }
        }
    }

    private class ShowLegendAction
    extends BooleanAction {
        private static final long serialVersionUID = 6830048070776657580L;

        public ShowLegendAction() {
            super(Intl.intl("Show Legend"), Plot2dDlg.this.d_autoRange);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_graph.setLegendVisible(this.isSelected());
            Plot2dDlg.this.d_graph.repaint();
        }
    }

    private class AnnotateObjPathsAction
    extends BooleanAction {
        private static final long serialVersionUID = 4392472341570717399L;

        public AnnotateObjPathsAction() {
            super(Intl.intl("Show Group Names"), Plot2dDlg.this.d_annotateObjPaths);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_annotateObjPaths = this.isSelected();
            Plot2dDlg.this.refreshData();
            Plot2dDlg.this.updateListBox();
        }
    }

    private class AnnotateScenariosAction
    extends BooleanAction {
        private static final long serialVersionUID = 1L;

        public AnnotateScenariosAction() {
            super(Intl.intl("Show Data Set"), Plot2dDlg.this.d_annotateScenarios);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            Plot2dDlg.this.d_annotateScenarios = this.isSelected();
            Plot2dDlg.this.refreshData();
            Plot2dDlg.this.updateListBox();
        }
    }

    private class ModeSelectorAction
    extends AbstractAction {
        private static final long serialVersionUID = 7462894863188459135L;
        private final PlotModeDesc d_mode;

        public ModeSelectorAction(PlotModeDesc desc) {
            super(Plot2dDlg.this.d_modes.get(desc).getModeName());
            this.d_mode = desc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Plot2dDlg.this.switchMode(Plot2dDlg.this.d_modes.get(this.d_mode));
        }
    }
}

