/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.levels;

import java.util.ArrayList;
import java.util.Collection;
import thunderheadeng.util.WarningReport;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.windprofiles.WindProfile;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class LevelsOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVer, int streamVer, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        if (updateVer == 204 && streamVer < 204) {
            ArrayList<IMerlinObj> removedObjs = new ArrayList<IMerlinObj>();
            for (Floor floor : vd.floors.flatten(Floor.class)) {
                VentusOIS.findAndReplaceComposites(floor, name -> new GeomComposite((String)name));
                LevelsOISHandler.markAndRemoveStrandedObjs(floor, removedObjs);
            }
            changes.changeObjs.putIfAbsent(204, new ArrayList());
            changes.changeObjs.get(204).addAll(removedObjs);
        }
        return false;
    }

    private static boolean isStrandedObj(IMerlinObj child) {
        return child instanceof AHSPoint || child instanceof FlowElement || child instanceof FlowPath || child instanceof WindProfile;
    }

    private static void markAndRemoveStrandedObjs(GeomComposite root, Collection<IMerlinObj> markedObjs) {
        ArrayList<IMerlinObj> toRemove = new ArrayList<IMerlinObj>();
        Collection<IMerlinObj> children = root.getMembers();
        for (IMerlinObj child : children) {
            if (child instanceof GeomComposite) {
                LevelsOISHandler.markAndRemoveStrandedObjs((GeomComposite)child, markedObjs);
                continue;
            }
            if (!LevelsOISHandler.isStrandedObj(child)) continue;
            markedObjs.add(child);
            toRemove.add(child);
        }
        root.removeAll(toRemove);
    }
}

