/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.flowpaths.FlowPath;

public class FlowPathRoot
extends Composite<FlowPath> {
    private static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("flowpath"));

    public FlowPathRoot() {
        super(Intl.intl("Flow Paths"));
    }

    public String nextName() {
        String name = this.d_nameGen.generateName();
        this.d_nameGen.registerName(name);
        return name;
    }

    public void reset() {
        this.clear();
        this.d_nameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (!(obj instanceof FlowPathRoot)) {
            return;
        }
        FlowPathRoot root = (FlowPathRoot)obj;
        this.d_nameGen = root.d_nameGen;
    }

    @Override
    public Composite<FlowPath> newGroup(String name) {
        return new FlowPathNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Flow Path Group");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.readTopology(in);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.writeTopology(out);
        }
    }

    static class FlowPathNode
    extends Composite<FlowPath> {
        public FlowPathNode(String name) {
            super(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Flow Path Group");
        }

        @Override
        public Composite<FlowPath> newGroup(String name) {
            return new FlowPathNode(name);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.readTopology(in);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.writeTopology(out);
            }
        }
    }
}

