/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.feature.weather.WeatherFeature;
import ventus.feature.weather.WeatherProps;
import ventus.feature.windprofiles.WindProfile;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

public class FlowPathPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.AFTER_NORMAL;
    }

    private int getZoneIndex(PrjData data, ISchematicRoom room) {
        if (room.equals(FlowPath.AMBIENT_ZONE)) {
            return -1;
        }
        PrjData.Zone obj = data.findZone(room);
        return obj.nr;
    }

    private double getMultiplier(FlowElement elem, UnitDouble multiplier) {
        if (elem.get(FlowElement.POWERLAW_MODEL) == FlowElement.PowerlawModel.LEAKAGE_AREA) {
            FlowElement.LeakageAreaType laType = elem.get(FlowElement.LEAKAGE_AREA_TYPE);
            FlowElement.LeakageAreaTypeInfo laTypeInfo = new FlowElement.LeakageAreaTypeInfo(laType);
            return laTypeInfo.get(() -> multiplier.get(Unit.ONE), () -> multiplier.get(SI.METER), () -> multiplier.get(SI.METER.pow(2)));
        }
        return multiplier.get(Unit.ONE);
    }

    private int getFlowElementIndex(PrjData data, FlowElement flowElem) {
        if (flowElem != null) {
            return data.findAirFlowElem((Object)flowElem).nr;
        }
        return -1;
    }

    private double getWindSpeedModifier(VentusData md) {
        WeatherProps weather = md.getComponentData(WeatherFeature.GUID);
        double newmod = Math.pow(weather.get(WeatherProps.localTerrainConst), 2.0) * Math.pow(weather.get(WeatherProps.roofWallHeight).getValue(SI.METER) / 10.0, 2.0 * weather.get(WeatherProps.velocityProfileExpo));
        return newmod;
    }

    public static int getInferredFlags(FlowPath fp) {
        int flags = 0;
        if (fp.isExterior()) {
            flags |= 1;
        }
        return flags;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        FlowPathRoot root = (FlowPathRoot)md.getComponentData(FlowPathsFeature.GUID);
        for (FlowPath in : root.flatten(FlowPath.class)) {
            Pair<Integer, Double> multiplierSchedule = PrjUtil.maybeWriteSchedule(prjData, in.get(FlowPath.SCHEDULE_MULTIPLIER), Unit.ONE);
            PrjData.AirFlowPath out = new PrjData.AirFlowPath(in);
            prjData.airFlowPathList.add(out);
            out.nr = prjData.npath = prjData.airFlowPathList.size();
            out.vntsDesc = in.getName();
            out.flags = FlowPathPrjWriter.getInferredFlags(in);
            Pair<ISchematicRoom, ISchematicRoom> zones = in.getZonesByDirection();
            out.pzn = this.getZoneIndex(prjData, (ISchematicRoom)zones.v1);
            out.pzm = this.getZoneIndex(prjData, (ISchematicRoom)zones.v2);
            out.pe = this.getFlowElementIndex(prjData, in.get(FlowPath.FLOW_ELEMENT));
            int ixWindPress = 0;
            if (!in.get(FlowPath.CONSTANT_WIND_PRESSURE).booleanValue()) {
                PrjData.WindProfile windProfRec;
                WindProfile windPressProfRefObj = in.get(FlowPath.WIND_PROFILE);
                if (windPressProfRefObj != null && (windProfRec = prjData.findWindProfile(windPressProfRefObj)) != null) {
                    ixWindPress = windProfRec.nr;
                }
                if (ixWindPress == 0) {
                    System.err.printf("[%s] \"%s\" invalid wind profile [%s] for variable pressure, using constant wind pressure%n", this.getClass().getSimpleName(), in.getName(), in.get(FlowPath.WIND_PROFILE));
                }
            }
            out.pw = ixWindPress;
            out.ps = (Integer)multiplierSchedule.v1;
            out.pld = prjData.findLevel((Object)in.getLevel()).nr;
            out.relHt = in.getRelativeElevation().getValue(SI.METER);
            out.mult = (Double)multiplierSchedule.v2 * this.getMultiplier(in.getFlowElement(), in.getMultiplier());
            boolean exterior = FlowPath.isExterior(zones);
            out.wPset = exterior ? in.get(FlowPath.WIND_PRESSURE).getValue(SI.PASCAL) : 0.0;
            out.wPmod = exterior && out.pw != 0 ? this.getWindSpeedModifier(md) : 0.0;
            out.wazm = exterior ? in.getWallAzimuth().getValue(NonSI.DEGREE_ANGLE) : -1.0;
            out.u_Ht = 0;
            out.u_XY = 0;
            out.u_dp = 0;
            out.u_F = 0;
        }
    }
}

