/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

public class FlowPathMathUtil {
    public static final double RHO = 1.2041;
    public static final double MU = 1.81625E-5;

    public static double orificeAreaTurbulentFlow(double a, double cD) {
        return Math.sqrt(2.0) * cD * a;
    }

    public static double orificeAreaLaminarFlow(double re, double a, double cD, double dH, double exp) {
        double cT = FlowPathMathUtil.orificeAreaTurbulentFlow(a, cD);
        double fTrans = FlowPathMathUtil.fTrans(re, a, dH);
        double dpTrans = FlowPathMathUtil.dpTrans(fTrans, cT, exp);
        double cL = FlowPathMathUtil.laminarFlow(fTrans, dpTrans);
        assert (!Double.isNaN(cL));
        return cL;
    }

    public static double getFanFanLaminarFlow(double a) {
        double cturb = FlowPathMathUtil.orificeAreaTurbulentFlow(a, 0.6);
        double re = 100.0;
        double qTrans = 1.81625E-5 * re * a / (1.2041 * Math.sqrt(a));
        double dpTrans = Math.pow(Math.sqrt(1.2041) * qTrans / cturb, 2.0);
        double clam = 1.81625E-5 * qTrans / dpTrans;
        assert (!Double.isNaN(clam));
        return clam;
    }

    public static double getTwoWayLaminarFlow(double a, double dH, double cD, boolean twoOpening) {
        double fTrans = FlowPathMathUtil.fTrans(30.0, a, dH);
        double cT = twoOpening ? FlowPathMathUtil.orificeAreaTurbulentFlow(a / 2.0, cD) : FlowPathMathUtil.orificeAreaTurbulentFlow(a, cD);
        double dpTrans = FlowPathMathUtil.dpTrans(fTrans, cT, 0.5);
        double cL = FlowPathMathUtil.laminarFlow(fTrans, dpTrans);
        return cL;
    }

    public static double stairwellEffectiveArea(double a, double h, double d, boolean to) {
        return to ? a * 0.089 * h * (1.0 - 0.14 * Math.sqrt(d)) : a * 0.083 * h * (1.0 - 0.24 * Math.sqrt(d));
    }

    public static double stairwellTurbulentFlow(double a, double h, double d, boolean to) {
        return FlowPathMathUtil.stairwellTurbulentFlow(FlowPathMathUtil.stairwellEffectiveArea(a, h, d, to));
    }

    public static double stairwellTurbulentFlow(double ae) {
        return Math.sqrt(2.0) * 0.6 * ae;
    }

    public static double stairwellLaminarFlow(double a, double h, double d, double exp, boolean to) {
        double ae = FlowPathMathUtil.stairwellEffectiveArea(a, h, d, to);
        double dH = Math.sqrt(ae);
        double cT = FlowPathMathUtil.stairwellTurbulentFlow(ae);
        double fTrans = FlowPathMathUtil.fTrans(30.0, ae, dH);
        double dpTrans = FlowPathMathUtil.dpTrans(fTrans, cT, exp);
        double cL = FlowPathMathUtil.laminarFlow(fTrans, dpTrans);
        assert (!Double.isNaN(cL));
        return cL;
    }

    public static double leakageAreaTurbulentFlow(double a, double cD, double dP, double exp) {
        return a * cD * Math.sqrt(2.0) * Math.pow(dP, 0.5 - exp);
    }

    public static double leakageAreaLaminarFlow(double a, double cD, double dP, double exp) {
        double dH = Math.sqrt(a);
        double cT = FlowPathMathUtil.leakageAreaTurbulentFlow(a, cD, dP, exp);
        double fTrans = FlowPathMathUtil.fTrans(30.0, a, dH);
        double dpTrans = FlowPathMathUtil.dpTrans(fTrans, cT, exp);
        double cL = FlowPathMathUtil.laminarFlow(fTrans, dpTrans);
        assert (!Double.isNaN(cL));
        return cL;
    }

    public static double fTrans(double re, double a, double dH) {
        assert (Math.abs(dH) > 0.0);
        return 1.81625E-5 * re * a / dH;
    }

    public static double dpTrans(double fTrans, double cT, double exp) {
        assert (Math.abs(cT * Math.sqrt(1.2041)) > 0.0);
        assert (Math.abs(exp) > 0.0);
        return Math.pow(fTrans / (cT * Math.sqrt(1.2041)), 1.0 / exp);
    }

    public static double laminarFlow(double fTrans, double dpTrans) {
        assert (Math.abs(1.2041 * dpTrans) > 0.0);
        return 1.81625E-5 * fTrans / (1.2041 * dpTrans);
    }

    public static ShaftCalcOutput getShaftData(double ht, double area, double perim, double rough) {
        double MUAIR = 1.81625E-5;
        double RHOAIR = 1.2041;
        double SRHO = 1.097315;
        double DPTMIN = 1.0E-128;
        double dia = 4.0 * area / perim;
        double rr = rough / dia;
        double Re = 4000.0;
        double v = 1.81625E-5 * Re / (1.2041 * dia);
        double F1 = 1.2041 * v * area;
        double ff = FlowPathMathUtil.ffdwc(rr, Re, 0.04);
        double dP1 = 0.5 * ff * ht / dia * 1.2041 * v * v;
        double F2 = 1.2041 * (v *= 10.0) * area;
        ff = FlowPathMathUtil.ffdwc(rr, Re *= 10.0, ff);
        double dP2 = 0.5 * ff * ht / dia * 1.2041 * v * v;
        Re = 1000.0;
        double F = 1.81625E-5 * Re * area / dia;
        double expt = Math.log(F2 / F1) / Math.log(dP2 / dP1);
        double turb = F1 / (1.097315 * Math.pow(dP1, expt));
        double dP = Math.pow(F / (turb * 1.097315), 1.0 / expt);
        if (dP < 1.0E-128) {
            dP = 1.0E-128;
        }
        double lam = 1.81625E-5 * F / (1.2041 * dP);
        return new ShaftCalcOutput(expt, lam, turb);
    }

    public static double ffdwc(double ed, double Re, double f) {
        double RE_MAX_LAM = 2300.0;
        double RE_MIN_TURB = 3500.0;
        double c = 0.868589;
        double tol = 1.0E-7;
        if (Re >= 3500.0) {
            double dg;
            double b = 2.51 / Re;
            double a = ed / 3.7;
            double g = 1.0 / Math.sqrt(f);
            while (Math.abs((dg = (g + 0.868589 * Math.log(a + g * b)) / (1.0 + 0.868589 * b / (a + g * b))) / (g -= dg)) > 1.0E-7) {
            }
            f = 1.0 / (g * g);
        } else if (Re <= 2300.0) {
            f = 64.0 / Re;
        } else {
            double f0 = 0.02782608695652174;
            double f1 = FlowPathMathUtil.ffdwc(ed, 3500.0, 0.04);
            double x0 = (Re - 2300.0) / 1200.0;
            f = f1 * x0 + f0 * (1.0 - x0);
        }
        return f;
    }

    public static class ShaftCalcOutput {
        public final double flowExponent;
        public final double coefLaminar;
        public final double coefTurbulent;

        public ShaftCalcOutput(double flowExponent, double coefLaminar, double coefTurbulent) {
            this.flowExponent = flowExponent;
            this.coefLaminar = coefLaminar;
            this.coefTurbulent = coefTurbulent;
        }
    }
}

