/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.ArrayList;
import java.util.Collection;
import thunderheadeng.io.LegacyDictionary;
import thunderheadeng.util.WarningReport;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.legacy.v0201.feature.flowpaths.FlowElementRoot;

public class FlowElementOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyAlwaysFirstUpdates(VentusOIS.DecisionMaker responseHandler, WarningReport warns, VentusData vd) {
        FlowPathRoot flowPathRoot = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
        FlowElementRoot flowElementRoot = (FlowElementRoot)vd.getComponentData(FlowElementData.GUID);
        Collection<FlowPath> flowPathDeepMembers = flowPathRoot.flatten(FlowPath.class);
        Collection<FlowElement> flowElementDeepMembers = flowElementRoot.flatten(FlowElement.class);
        for (FlowPath flowPath : flowPathDeepMembers) {
            FlowElement currentFlowElement = flowPath.getFlowElement();
            FlowElement foundFlowElement = flowElementDeepMembers.stream().filter(currentFlowElement::equals).findFirst().orElse(null);
            if (foundFlowElement != null) continue;
            FlowElement surrogateFlowElement = flowElementDeepMembers.stream().filter(currentFlowElement::surrogateEquals).findFirst().orElse(null);
            if (surrogateFlowElement != null) {
                flowPath.setFlowElement(surrogateFlowElement);
                continue;
            }
            flowElementRoot.add(currentFlowElement);
        }
        return true;
    }

    @Override
    public void registerLegacyClass(LegacyDictionary dict) {
        dict.addLegClass(VentusIO.Version.VER_0202.num, "ventus.feature.flowpaths.FlowElementRoot$Default", FlowElementRoot.Default.class);
    }

    @Override
    public boolean applyVersionUpdates(int updateVer, int streamVer, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changeTracker, WarningReport warns, VentusData vd) {
        FlowElementRoot elementRoot = (FlowElementRoot)vd.getComponentData(FlowElementData.GUID);
        FlowPathRoot pathRoot = (FlowPathRoot)vd.getComponentData(FlowPathsFeature.GUID);
        if (updateVer == 204 && streamVer < 205) {
            VentusOIS.findAndReplaceComposites(elementRoot, name -> new FlowElementRoot.FlowElementNode((String)name));
            VentusOIS.findAndReplaceComposites(pathRoot, name -> new FlowPathRoot.FlowPathNode((String)name));
        }
        if (updateVer == 205 && streamVer < 205 && changeTracker.changeObjs.containsKey(204)) {
            for (IMerlinObj obj : changeTracker.changeObjs.get(204)) {
                if (obj instanceof FlowElement) {
                    elementRoot.add(obj);
                }
                if (!(obj instanceof FlowPath)) continue;
                pathRoot.add(obj);
            }
        }
        if (updateVer == 206 && streamVer < 206) {
            changeTracker.changeObjs.putIfAbsent(206, new ArrayList());
            changeTracker.changeObjs.get(206).addAll(pathRoot.flatten(FlowPath.class));
        }
        return false;
    }

    @Override
    public boolean isResolveObject(int vntsFileVersion, Object obj) {
        return vntsFileVersion < VentusIO.Version.VER_217.num && obj instanceof FlowElementRoot.Default;
    }

    @Override
    public Object getResolveObject(Object obj) {
        assert (obj instanceof FlowElementRoot.Default);
        if (obj instanceof FlowElementRoot.Default) {
            FlowElementRoot.Default def = (FlowElementRoot.Default)((Object)obj);
            return def.resolveAs;
        }
        return obj;
    }
}

