/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.data.value.IFunction1d;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.flowpaths.CubicFlowFunction;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPathMathUtil;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.feature.props.TypedProps;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.unitsystem.SIUS;

public class FlowElement
extends NamedMerlinObj
implements Serializable,
ISurrogate,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<FlowElement> PROP_TYPES = new PropertyDefs<FlowElement>(FlowElement.class, PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), NamedMerlinObj.PROP_TYPES);
    public static final TypedProp<FlowElementRoot.Default> DEFAULT_TYPE = TypedProps.build((Object)"FlowElement.DEFAULT_TYPE", FlowElementRoot.Default.class).attrStoreAsPlainOldData(PROP_TYPES).attrCloneValue((obj, val) -> null).attrFinish();
    public static final DisplayProp<String> DESC = (DisplayProp)DisplayProps.build((Object)"FlowElement.DESC", "", Intl.intl("Description"), Intl.intl("Flow Element Description")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> DESCRIPTION = PROP_TYPES.storeDirectWrapper(VentusData.DESCRIPTION, DESC).attrFinish();
    public static final DisplayProp<Color> COLOR = (DisplayProp)DisplayProps.build((Object)"FlowElement.COLOR", Color.class, Color.BLACK, Intl.intl("Color"), Intl.intl("Flow Element Color")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsWrapper(VentusData.SEARCH_COLOR).attrGetter(elem -> elem.get(COLOR), COLOR, new TypedProp[0]).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static final TypedProp<Boolean> IS_DEFAULT = TypedProps.build((Object)"FlowElement.IS_DEFAULT", false).attrStoreAsReadOnly(PROP_TYPES).attrGetter(FlowElement::isDefault, DEFAULT_TYPE, new TypedProp[0]).attrMarkTransient().attrFinish();
    public static final DisplayProp<PowerlawModel> POWERLAW_MODEL = (DisplayProp)DisplayProps.build((Object)"FlowElement.POWERLAW_MODEL", PowerlawModel.class, PowerlawModel.ORIFICE_AREA, Intl.intl("Powerlaw Model"), Intl.intl("Powerlaw Model for Element mass flow")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.options((ILabeled[])PowerlawModel.values())).attrFinish();
    public static final DisplayProp<UnitDouble> CROSS_SECTIONAL_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.CROSS_SECTIONAL_AREA", new UnitDouble(1.0, SI.METER.pow(2)), Intl.intl("Cross-Sectional Area"), Intl.intl("Total area of the opening"), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(2)).attrFinish();
    public static final DisplayProp<Double> PRESSURE_EXPONENT = (DisplayProp)DisplayProps.build((Object)"FlowElement.PRESSURE_EXPONENT", 0.65, Intl.intl("Flow Exponent"), Intl.intl("n of the mass flow powerlaw formula")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.dbl()).attrFinish();
    public static final DisplayProp<Double> DISCHARGE_COEFFICIENT = (DisplayProp)DisplayProps.build((Object)"FlowElement.DISCHARGE_COEFFICIENT", 0.6, Intl.intl("Discharge Coefficient"), Intl.intl("C of the mass flow powerlaw formula")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.dbl()).attrFinish();
    public static final DisplayProp<Double> REYNOLDS_NUMBER = (DisplayProp)DisplayProps.build((Object)"FlowElement.REYNOLDS_NUMBER", 30.0, Intl.intl("Reynolds Number"), Intl.intl("Relative ratio of viscous to inertial forces which helps dictate laminar vs. turbulent flow")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.dbl()).attrFinish();
    public static final DisplayProp<UnitDouble> STAIR_SHAFT_DZ = (DisplayProp)DisplayProps.build((Object)"FlowElement.STAIR_SHAFT_DZ", new UnitDouble(3.0, SI.METER), Intl.intl("Distance Between Levels"), Intl.intl("Vertical distance between doorways of the stairwell"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> PRESSURE_DIFFERENCE = (DisplayProp)DisplayProps.build((Object)"FlowElement.PRESSURE_DIFFERENCE", new UnitDouble(10.0, SI.PASCAL), Intl.intl("Pressure Difference"), Intl.intl("The reference pressure difference for teh associated leakager rating"), 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(15)).attrFinish();
    public static final DisplayProp<LeakageAreaType> LEAKAGE_AREA_TYPE = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_TYPE", LeakageAreaType.class, LeakageAreaType.ITEM, Intl.intl("Leakage Area Type"), Intl.intl("Determines how the total leakage area for the flow path will be calculated")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.options((ILabeled[])LeakageAreaType.values())).attrFinish();
    @Deprecated
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA", new UnitDouble(1.0, SI.METER.pow(2)), Intl.intl("Leakage Area"), Intl.intl(""), 2).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA_PER_ITEM = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_PER_ITEM", new UnitDouble(1.0, SI.METER.pow(2)), Intl.intl("Area per Item"), Intl.intl("Leakage Area per flow path item"), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(2)).attrFinish();
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA_PER_LENGTH = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_PER_LENGTH", new UnitDouble(1.0, SI.METER), Intl.intl("Area per Unit Length"), Intl.intl("Leakage Area per flow path length"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA_PER_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_PER_AREA", new UnitDouble(3.5E-4, Unit.ONE), Intl.intl("Area per Unit Area"), Intl.intl("Leakage area per flow path area"), 10).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(10)).attrFinish();
    @Deprecated
    public static final UnitDouble PRE_202_LEAKAGE_AREA_PER_AREA = new UnitDouble(1.0, Unit.ONE);
    public static final DisplayProp<UnitDouble> PEOPLE_DENSITY = (DisplayProp)DisplayProps.build((Object)"FlowElement.PEOPLE_DENSITY", new UnitDouble(0.0, Unit.ONE.divide(SI.METER.pow(2))), Intl.intl("People Density"), Intl.intl("Density of people occupying the stairwell"), 22).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(8)).attrFinish();
    public static final DisplayProp<Boolean> STAIR_TREADS_OPEN = (DisplayProp)DisplayProps.build((Object)"FlowElement.STAIR_TREADS_OPEN", false, Intl.intl("Stair Treads"), Intl.intl("The stair tread can either be open or closed, affecting airflow")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.booleanCustom(Intl.intl("is open"), Intl.intl("is closed"))).attrFinish();
    public static final DisplayProp<UnitDouble> PERIMETER = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERIMETER", new UnitDouble(10.0, SI.METER), Intl.intl("Perimeter"), Intl.intl("Length of the perimeter of the cross-sectional area of the shaft, determining hydraulic diameter"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> ROUGHNESS = (DisplayProp)DisplayProps.build((Object)"FlowElement.ROUGHNESS", new UnitDouble(0.1, SI.METER), Intl.intl("Roughness"), Intl.intl("Average size of protrusions from the shaft wall into the airflow"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> MAX_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"FlowElement.MAX_FLOW_RATE", new UnitDouble(0.02, SI.METER.pow(3).divide(SI.SECOND)), Intl.intl("Vent Max Volume Flow Rate"), Intl.intl("Maximum airflow rate allowed through paths using this element."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(27)).attrFinish();
    public static final DisplayProp<UnitDouble> REGULATING_PRESSURE = (DisplayProp)DisplayProps.build((Object)"FlowElement.REGULATING_PRESSURE", new UnitDouble(0.5, SI.PASCAL), Intl.intl("Regulating Pressure"), Intl.intl("Approximate pressure difference above which airflow will be limited to the maximum flow rate."), 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(15)).attrFinish();
    public static final DisplayProp<UnitDouble> REVERSE_FLOW_FRACTION = (DisplayProp)DisplayProps.build((Object)"FlowElement.REVERSE_FLOW_FRACTION", new UnitDouble(1.0E-4, Unit.ONE), Intl.intl("Reverse Flow Fraction"), Intl.intl("Fraction of the Maximum Flow Rate that this element is limited to when the pressure difference is negative."), 10).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(10)).attrFinish();
    public static final DisplayProp<UnitDouble> CONSTANT_FAN_MAX_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"FlowElement.CONSTANT_FAN_MAX_FLOW_RATE", new UnitDouble(1.0, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Fan Max Mass Flow Rate"), Intl.intl("Maximum constant mass flow rate allowed of this fan."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(26)).attrFinish();
    public static final DisplayProp<UnitDouble> CONSTANT_FAN_VOLUME_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"FlowElement.CONSTANT_FAN_VOLUME_FLOW_RATE", new UnitDouble(1.0, SI.METER.pow(3).divide(SI.SECOND)), Intl.intl("Fan Max Volume Flow Rate"), Intl.intl("Maximum volumetric flow rate allowed of this fan."), 27).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(27)).attrFinish();
    public static final DisplayProp<UnitDouble> PERFORMANCE_CURVE_ORIFICE_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERFORMANCE_CURVE_ORIFICE_AREA", new UnitDouble(0.01, SI.METER.pow(2)), Intl.intl("Equivalent Orifice Area"), Intl.intl("Fan opening"), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(2)).attrFinish();
    public static final DisplayProp<Double> PERFORMANCE_CURVE_CUTOFF_RATIO = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERFORMANCE_CURVE_CUTOFF_RATIO", 0.1, Intl.intl("Cut-off Ratio"), Intl.intl("Fan speed ratio")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.dbl()).attrFinish();
    public static final Function1dProp PERFORMANCE_CURVE = PROP_TYPES.storeAsPlainOldData(new Function1dProp((Object)"FlowElement.PERFORMANCE_CURVE", (IFunction1d)FlowElement.getInputDefault(), Intl.intl("Performance Curve"), Intl.intl("Edit Performance curve data"), Intl.intl("Flow Element"), new Function1dProp.Var(Intl.intl("Flow Rate"), 17, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.KILOGRAM.divide(SI.SECOND), true, true)), new Function1dProp.Var(Intl.intl("Pressure"), 15, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.PASCAL, true, true)), new Function1dProp.PredefFunction[0])).attrFinish();
    public static final Function1dProp Q_V_P_CURVE = PROP_TYPES.storeAsPlainOldData(new Function1dProp((Object)"FlowElement.Q_V_P_CURVE", (IFunction1d)FlowElement.getQvPDefault(), Intl.intl("Q vs P"), Intl.intl("Volume flow as a function of pressure difference across the element."), Intl.intl("Flow Elements"), new Function1dProp.Var(Intl.intl("Pressure"), 15, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.PASCAL, true, true)), new Function1dProp.Var(Intl.intl("Flow Rate"), 27, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.METER.pow(3).divide(SI.SECOND), true, true)), new UnitDouble[]{new UnitDouble(0.0, SIUS.unit(15)), new UnitDouble(0.0, SIUS.unit(27)), new UnitDouble(20.0, SIUS.unit(15)), new UnitDouble(20.0, SIUS.unit(27))}, new Function1dProp.PredefFunction[0])).attrFinish();
    public static final DisplayProp<UnitDouble> DOOR_HEIGHT = (DisplayProp)DisplayProps.build((Object)"FlowElement.DOOR_HEIGHT", new UnitDouble(2.0, SI.METER), Intl.intl("Height"), Intl.intl("Doorway height"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DOOR_WIDTH = (DisplayProp)DisplayProps.build((Object)"FlowElement.DOOR_WIDTH", new UnitDouble(0.8, SI.METER), Intl.intl("Width"), Intl.intl("Doorway width"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.unitdouble(0)).attrFinish();
    private PropertySet d_properties = new PropertySet();

    private static PiecewiseFunction1d getInputDefault() {
        APiecewiseFunction1d.Entry[] input = new APiecewiseFunction1d.Entry[]{new APiecewiseFunction1d.Entry(SIUS.newud(0.0, 17), SIUS.newud(150.0, 15)), new APiecewiseFunction1d.Entry(SIUS.newud(2.0, 17), SIUS.newud(125.0, 15)), new APiecewiseFunction1d.Entry(SIUS.newud(3.0, 17), SIUS.newud(110.0, 15)), new APiecewiseFunction1d.Entry(SIUS.newud(4.0, 17), SIUS.newud(60.0, 15))};
        return new PiecewiseFunction1d(input);
    }

    public FlowElement(String name) {
        this(name, null, theUtil.newRandomColor(), (PowerlawModel)FlowElement.POWERLAW_MODEL.defVal);
    }

    public FlowElement(String name, FlowElementRoot.Default defaultType, Color color, PowerlawModel law) {
        super(name);
        this.set(DEFAULT_TYPE, defaultType);
        this.set(COLOR, color);
        this.set(POWERLAW_MODEL, law);
        this.d_properties.merge(law.defaultProps);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        int version;
        is.defaultReadObject();
        if (this.d_properties.isDefined(IS_DEFAULT) && this.d_properties.get(IS_DEFAULT).booleanValue()) {
            assert (!this.d_properties.isDefined(DEFAULT_TYPE));
            this.d_properties.remove(IS_DEFAULT);
            String name = this.getName();
            for (FlowElementRoot.Default def : FlowElementRoot.Default.values()) {
                if (!def.create.apply(def).getName().equals(name)) continue;
                this.set(DEFAULT_TYPE, def);
                break;
            }
        }
        if (VentusIO.Version.VER_0201.isLater(version = VentusOIS.getVersion(is)) && this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            LeakageAreaType type = this.get(LEAKAGE_AREA_TYPE);
            UnitDouble oldAreaM2 = this.d_properties.get(LEAKAGE_AREA).convert(SI.METER.pow(2));
            if (type == LeakageAreaType.ITEM) {
                UnitDouble areaPerItem = oldAreaM2.divide(new UnitDouble(1.0, Unit.ONE));
                this.set(LEAKAGE_AREA_PER_ITEM, areaPerItem);
            } else if (type == LeakageAreaType.LENGTH) {
                UnitDouble areaPerLength = oldAreaM2.divide(new UnitDouble(1.0, SI.METER));
                this.set(LEAKAGE_AREA_PER_LENGTH, areaPerLength);
            } else if (type == LeakageAreaType.AREA) {
                UnitDouble areaPerArea = oldAreaM2.divide(new UnitDouble(1.0, SI.METER.pow(2)));
                this.set(LEAKAGE_AREA_PER_AREA, areaPerArea);
            }
            this.d_properties.remove(LEAKAGE_AREA);
        }
        if (VentusIO.Version.VER_0202.isLater(version) && this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA && this.get(LEAKAGE_AREA_TYPE) == LeakageAreaType.AREA && !this.d_properties.isDefined(LEAKAGE_AREA_PER_AREA)) {
            this.set(LEAKAGE_AREA_PER_AREA, PRE_202_LEAKAGE_AREA_PER_AREA);
        }
    }

    public boolean isDefault() {
        return this.get(DEFAULT_TYPE) != null;
    }

    public Set<Tag> getTags() {
        return this.get(TAGS);
    }

    public void setTags(Set<Tag> tags) {
        this.set(TAGS, tags);
    }

    public String getPowerlawModelType() {
        if (this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return PowerlawModel.LEAKAGE_AREA.type + this.get(FlowElement.LEAKAGE_AREA_TYPE).sequence;
        }
        return this.get(FlowElement.POWERLAW_MODEL).type;
    }

    public double getTurbulentFlow() {
        if (this.get(POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            return FlowPathMathUtil.orificeAreaTurbulentFlow(this.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.get(DISCHARGE_COEFFICIENT));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return FlowPathMathUtil.leakageAreaTurbulentFlow(this.getSingleUnitOfLeakArea().get(SI.METER.pow(2)), this.get(DISCHARGE_COEFFICIENT), this.get(PRESSURE_DIFFERENCE).get(SI.PASCAL), this.get(PRESSURE_EXPONENT));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
            return FlowPathMathUtil.stairwellTurbulentFlow(this.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.get(STAIR_SHAFT_DZ).get(SI.METER), this.get(PEOPLE_DENSITY).get(Unit.ONE.divide(SI.METER.pow(2))), this.get(STAIR_TREADS_OPEN));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.SHAFT) {
            FlowPathMathUtil.ShaftCalcOutput result = FlowPathMathUtil.getShaftData(this.get(STAIR_SHAFT_DZ).get(SI.METER), this.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.get(PERIMETER).get(SI.METER), this.get(ROUGHNESS).get(SI.METER));
            return result.coefTurbulent;
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE) {
            return FlowPathMathUtil.orificeAreaTurbulentFlow(this.get(PERFORMANCE_CURVE_ORIFICE_AREA).get(SI.METER.pow(2)), this.get(DISCHARGE_COEFFICIENT));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.TWOWAY_ONE) {
            return FlowPathMathUtil.orificeAreaTurbulentFlow(this.get(DOOR_HEIGHT).get(SI.METER) * this.get(DOOR_WIDTH).get(SI.METER), this.get(DISCHARGE_COEFFICIENT));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.TWOWAY_TWO) {
            return FlowPathMathUtil.orificeAreaTurbulentFlow(this.get(DOOR_HEIGHT).get(SI.METER) * this.get(DOOR_WIDTH).get(SI.METER) / 2.0, this.get(DISCHARGE_COEFFICIENT));
        }
        return 0.0;
    }

    private UnitDouble getSingleUnitOfLeakArea() {
        LeakageAreaType type = this.get(LEAKAGE_AREA_TYPE);
        LeakageAreaTypeInfo typeInfo = new LeakageAreaTypeInfo(type);
        UnitDouble baseValue = this.get(typeInfo.prop);
        return typeInfo.convertToAreaM2.apply(baseValue);
    }

    public static UnitDouble areaToDiameter(UnitDouble area) {
        return area.divide(new UnitDouble(Math.PI, Unit.ONE)).root(2).multiply(new UnitDouble(2.0, Unit.ONE));
    }

    public double getLaminarFlow() {
        if (this.get(POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            return FlowPathMathUtil.orificeAreaLaminarFlow(this.get(REYNOLDS_NUMBER), this.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.get(DISCHARGE_COEFFICIENT), FlowElement.areaToDiameter(this.get(CROSS_SECTIONAL_AREA)).get(SI.METER), this.get(PRESSURE_EXPONENT));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return FlowPathMathUtil.leakageAreaLaminarFlow(this.getSingleUnitOfLeakArea().get(SI.METER.pow(2)), this.get(DISCHARGE_COEFFICIENT), this.get(PRESSURE_DIFFERENCE).get(SI.PASCAL), this.get(PRESSURE_EXPONENT));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
            return FlowPathMathUtil.stairwellLaminarFlow(this.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.get(STAIR_SHAFT_DZ).get(SI.METER), this.get(PEOPLE_DENSITY).get(Unit.ONE.divide(SI.METER.pow(2))), this.get(PRESSURE_EXPONENT), this.get(STAIR_TREADS_OPEN));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.SHAFT) {
            FlowPathMathUtil.ShaftCalcOutput result = FlowPathMathUtil.getShaftData(this.get(STAIR_SHAFT_DZ).get(SI.METER), this.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.get(PERIMETER).get(SI.METER), this.get(ROUGHNESS).get(SI.METER));
            return result.coefLaminar;
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE) {
            return FlowPathMathUtil.getFanFanLaminarFlow(this.get(PERFORMANCE_CURVE_ORIFICE_AREA).get(SI.METER.pow(2)));
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.TWOWAY_ONE) {
            return this.getTwoWayLaminarFlow(false);
        }
        if (this.get(POWERLAW_MODEL) == PowerlawModel.TWOWAY_TWO) {
            return this.getTwoWayLaminarFlow(true);
        }
        return 0.0;
    }

    private double getTwoWayLaminarFlow(boolean twoOpening) {
        double h = this.get(DOOR_HEIGHT).get(SI.METER);
        double w = this.get(DOOR_WIDTH).get(SI.METER);
        double a = h * w;
        double dH = 4.0 * a / (h * 2.0 + w * 2.0);
        return FlowPathMathUtil.getTwoWayLaminarFlow(a, dH, this.get(DISCHARGE_COEFFICIENT), twoOpening);
    }

    public boolean isLeakageAreaPerItem() {
        return this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA && this.get(LEAKAGE_AREA_TYPE) == LeakageAreaType.ITEM;
    }

    protected PropertyDefs<FlowElement> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public FlowElement clone() {
        return (FlowElement)super.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isSetNameSupported() {
        return this.get(IS_DEFAULT) == false;
    }

    private static APiecewiseFunction1d getQvPDefault() {
        APiecewiseFunction1d.Entry[] input = new APiecewiseFunction1d.Entry[]{new APiecewiseFunction1d.Entry(SIUS.newud(0.0, 15), SIUS.newud(0.0, 27)), new APiecewiseFunction1d.Entry(SIUS.newud(1.0, 15), SIUS.newud(2.0, 27)), new APiecewiseFunction1d.Entry(SIUS.newud(4.0, 15), SIUS.newud(7.0, 27)), new APiecewiseFunction1d.Entry(SIUS.newud(10.0, 15), SIUS.newud(10.0, 27))};
        return new CubicFlowFunction(input);
    }

    public IFunction1d getFanPerformanceCurve() {
        assert (this.get(POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE);
        return this.get(PERFORMANCE_CURVE);
    }

    public static enum PowerlawModel implements ILabeled
    {
        ORIFICE_AREA(Intl.intl("Orifice Area"), "plr_orfc", Intl.intl("Airflow through an orifice on the face of a room.")),
        LEAKAGE_AREA(Intl.intl("Leakage Area"), "plr_leak", Intl.intl("A typical area of leakage that occurs between rooms in residential buildings.")),
        STAIRWELL(Intl.intl("Stairwell"), "plr_stair", Intl.intl("Airflow within a building stairwell.")),
        SHAFT(Intl.intl("Shaft"), "plr_shaft", Intl.intl("Airflow within a building shaft, typically for an elevator.")),
        Q_V_P(Intl.intl("Q vs P"), "csf_qsp", Intl.intl("Volume flow rate as a function of pressure difference across the element.")),
        SELF_REG_VENT(Intl.intl("Self-regulating Vent"), "srv_jwa", Intl.intl("Two-way airflow across a path with bidirectional limits on airflow rate.")),
        CONSTANT_MASS_FLOW_FAN(Intl.intl("Constant Mass Flow Fan"), "fan_cmf", Intl.intl("Airflow has a constant mass flow rate.")),
        CONSTANT_VOLUME_FLOW_FAN(Intl.intl("Constant Volume Flow Fan"), "fan_cvf", Intl.intl("Airflow has a constant volume flow rate.")),
        PERFORMANCE_CURVE(Intl.intl("Performance Curve"), "fan_fan", Intl.intl("Create a fan based on a performance curve.")),
        TWOWAY_ONE(Intl.intl("Two-way - One Opening"), "dor_door", Intl.intl("Two-way airflow for large openings such as doors.")),
        TWOWAY_TWO(Intl.intl("Two-way - Two Opening"), "dor_pl2", Intl.intl("Two-way airflow accounting for the stack effect on tall openings."));

        public final String name;
        public final String type;
        public final PropertySet defaultProps;
        public final String description;

        private PowerlawModel(String name, String type, String description) {
            this(name, type, description, Collections.emptyList());
        }

        private PowerlawModel(String name, String type, String description, List<TypedProp<?>> defaultProps) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.defaultProps = new PropertySet();
            for (TypedProp<?> prop : defaultProps) {
                this.defaultProps.set(prop, prop.defVal);
            }
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    public static enum LeakageAreaType implements ILabeled
    {
        ITEM(1, Intl.intl("Per Item")),
        LENGTH(2, Intl.intl("Per Unit Length")),
        AREA(3, Intl.intl("Per Unit Area"));

        public final String name;
        public final int sequence;

        private LeakageAreaType(int sequence, String name) {
            this.sequence = sequence;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class LeakageAreaTypeInfo {
        public final LeakageAreaType type;
        public final TypedProp<UnitDouble> prop;
        public final int unit;
        public final Function<UnitDouble, UnitDouble> convertToAreaM2;

        public LeakageAreaTypeInfo(LeakageAreaType type) {
            this.type = type;
            if (type == LeakageAreaType.ITEM) {
                this.prop = LEAKAGE_AREA_PER_ITEM;
                this.unit = 2;
                this.convertToAreaM2 = areaPerItem -> areaPerItem.multiply(new UnitDouble(1.0, Unit.ONE)).convert(SI.METER.pow(2));
            } else if (type == LeakageAreaType.LENGTH) {
                this.prop = LEAKAGE_AREA_PER_LENGTH;
                this.unit = 0;
                this.convertToAreaM2 = areaPerLength -> areaPerLength.multiply(new UnitDouble(1.0, SI.METER)).convert(SI.METER.pow(2));
            } else if (type == LeakageAreaType.AREA) {
                this.prop = LEAKAGE_AREA_PER_AREA;
                this.unit = 10;
                this.convertToAreaM2 = areaPerArea -> areaPerArea.multiply(new UnitDouble(1.0, SI.METER.pow(2))).convert(SI.METER.pow(2));
            } else {
                throw new IllegalArgumentException(type.name());
            }
        }

        public void exec(Runnable perItem, Runnable perLength, Runnable perArea) {
            if (this.type == LeakageAreaType.ITEM) {
                perItem.run();
            } else if (this.type == LeakageAreaType.LENGTH) {
                perLength.run();
            } else if (this.type == LeakageAreaType.AREA) {
                perArea.run();
            } else {
                throw new IllegalArgumentException(this.type.name());
            }
        }

        public <T> T get(Supplier<T> perItem, Supplier<T> perLength, Supplier<T> perArea) {
            if (this.type == LeakageAreaType.ITEM) {
                return perItem.get();
            }
            if (this.type == LeakageAreaType.LENGTH) {
                return perLength.get();
            }
            if (this.type == LeakageAreaType.AREA) {
                return perArea.get();
            }
            throw new IllegalArgumentException(this.type.name());
        }
    }
}

