/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.jscience.physics.units.Unit;
import ventus.data.value.APiecewiseFunction1d;
import ventus.data.value.IFunction1d;

class CubicFanPerformanceCurveUtil {
    public static final CurveData INVALID = new CurveData(new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN}, Double.NaN);

    CubicFanPerformanceCurveUtil() {
    }

    public static CurveData getCurveData(IFunction1d func, Unit ux, Unit uy) {
        return CubicFanPerformanceCurveUtil.getCurveData(CubicFanPerformanceCurveUtil.unwrap(func), ux, uy);
    }

    public static CurveData getCurveData(APiecewiseFunction1d.Entry[] entries, Unit ux, Unit uy) {
        if (entries == null || entries.length < 4) {
            assert (false);
            return INVALID;
        }
        if (ux == null) {
            ux = entries[0].x.getUnit();
        }
        if (uy == null) {
            uy = entries[0].y.getUnit();
        }
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (APiecewiseFunction1d.Entry entry : entries) {
            obs.add(entry.x.get(ux), entry.y.get(uy));
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create(3);
        double[] coefficients = fitter.fit(obs.toList());
        LaguerreSolver solver = new LaguerreSolver();
        Complex[] root = solver.solveAllComplex(coefficients, 0.0);
        double fdf = root[2].getReal();
        return new CurveData(coefficients, fdf);
    }

    public static APiecewiseFunction1d.Entry[] unwrap(IFunction1d func) {
        return func.toPiecewise(Unit.ONE).getInput();
    }

    public static class CurveData {
        public final double[] coefficients;
        public final double freeDeliveryFlow;

        public CurveData(double[] coefficients, double freeDeliveryFlow) {
            this.coefficients = coefficients;
            this.freeDeliveryFlow = freeDeliveryFlow;
        }
    }
}

