/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.find;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.gui.AObjsList;
import thunderheadeng.gui.BackgroundCompute;
import thunderheadeng.gui.SearchableComboBox;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.actions.Undo;
import ventus.actions.Visibility;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.DisplayProp;
import ventus.feature.props.IPropComparisonEd;
import ventus.feature.props.PropertyDefs;
import ventus.gui.VentusObjsList;
import ventus.gui.guiUtil;

class FindAdvancedDialog
extends guiDialog
implements Observer,
IEventObserver {
    private final VentusData d_vd;
    private final Collection<? extends IMerlinObj> d_allowedObjs;
    private final List<Class<?>> d_objTypes;
    private final Map<String, SourcedProp> d_objProps;
    private final SearchableComboBox<Class<?>> d_objTypeCombo;
    private final guiCheckBox d_visibleOnlyCheck;
    private final guiPanel d_propertiesPanel;
    private final List<PropEditor> d_propEditors;
    private final JButton d_addPropBtn;
    private BackgroundCompute<List<IMerlinObj>> d_searchCompute;
    private List<IMerlinObj> d_searchResults;
    private Iterator<IMerlinObj> d_nextIterator;
    private final AObjsList<IMerlinObj> d_resultsList;
    private final JButton d_findButton;
    private final JButton d_selectAllButton;
    private final guiLabel d_messageLabel;

    public FindAdvancedDialog(Window owner, String title, VentusData vd, Collection<? extends IMerlinObj> allowedObjs) {
        super(owner, title, 16);
        this.setResizable(true);
        this.d_vd = vd;
        this.d_allowedObjs = allowedObjs;
        this.d_objTypes = FindAdvancedDialog.getObjTypes(vd);
        this.d_objTypes.addFirst(IMerlinObj.class);
        this.d_objProps = FindAdvancedDialog.getProperties(vd, this.d_objTypes);
        this.d_propertiesPanel = new guiPanel(new MigLayout("insets 0 0 0 18"));
        this.d_propertiesPanel.setPreferredSize(new Dimension(400, 160));
        this.d_propEditors = new ArrayList<PropEditor>();
        this.d_addPropBtn = new JButton("+");
        this.d_addPropBtn.addActionListener(e -> this.promptAddProperty());
        this.regeneratePropertiesList();
        this.d_objTypeCombo = new SearchableComboBox<Class>(this.d_objTypes::stream, type -> type != IMerlinObj.class ? FindAdvancedDialog.getCategoryName(this.d_vd, type) : Intl.intl("<All>"));
        this.d_objTypeCombo.addItemListener(e -> this.clearPropertiesForType());
        this.d_visibleOnlyCheck = new guiCheckBox(Intl.intl("Search visible objects only"));
        this.d_visibleOnlyCheck.addActionListener(e -> this.updateSearch());
        JScrollPane propertiesScroll = new JScrollPane(this.d_propertiesPanel);
        propertiesScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.d_searchResults = new ArrayList<IMerlinObj>();
        this.d_nextIterator = Collections.emptyIterator();
        this.d_resultsList = new VentusObjsList(vd, Intl.intl("Select Search Results"), true, false, Collections.emptyList());
        JScrollPane objsScroll = new JScrollPane(this.d_resultsList);
        this.d_messageLabel = new guiLabel();
        this.d_findButton = new JButton("Find/Next");
        this.d_findButton.addActionListener(e -> this.findNext());
        this.d_selectAllButton = new JButton("Select All");
        this.d_selectAllButton.addActionListener(e -> this.selectAll());
        guiPanel queryPanel = new guiPanel(new MigLayout("insets 0"));
        queryPanel.add(new guiLabel(Intl.intl("Object Type:")));
        queryPanel.add(this.d_objTypeCombo, "wrap");
        queryPanel.add((Component)this.d_visibleOnlyCheck, "span, wrap");
        queryPanel.add((Component)new TitleSeparator(Intl.intl("Object Properties")), "span, grow, wrap");
        queryPanel.add((Component)propertiesScroll, "gapleft 18, span, grow, push, wrap");
        guiPanel resultsPanel = new guiPanel(new MigLayout("insets 0"));
        resultsPanel.add((Component)new TitleSeparator(Intl.intl("Search Results")), "span, grow, wrap");
        resultsPanel.add((Component)objsScroll, "gapleft 18, span, grow, push, wrap");
        resultsPanel.add((Component)this.d_messageLabel, "gapleft 18, growx");
        resultsPanel.add(this.d_findButton);
        resultsPanel.add((Component)this.d_selectAllButton, "wrap");
        JSplitPane split = new JSplitPane(0);
        split.setTopComponent(queryPanel);
        split.setBottomComponent(resultsPanel);
        this.getDialogPane().add(split);
        vd.getEvents().addObserver(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                assert (!FindAdvancedDialog.this.d_resultsList.isSelectionLinked() || FindAdvancedDialog.this.d_resultsList.isObserver()) : "FindAdvancedDialog must only be shown once";
            }

            @Override
            public void windowClosed(WindowEvent e) {
                FindAdvancedDialog.this.d_vd.getEvents().removeObserver(FindAdvancedDialog.this);
                if (FindAdvancedDialog.this.d_resultsList.isSelectionLinked()) {
                    FindAdvancedDialog.this.d_resultsList.removeObserver();
                }
            }
        });
        this.updateSearch();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateSearch();
    }

    @Override
    public void update(Events events) {
        for (PropEditor editor : this.d_propEditors) {
            editor.editor.update(events);
        }
        this.updateSearch();
    }

    private void updateSearch() {
        if (this.d_searchCompute != null) {
            this.d_searchCompute.cancel();
        }
        Class searchType = (Class)this.d_objTypeCombo.getSelectedItem();
        boolean searchVisibleOnly = this.d_visibleOnlyCheck.isSelected();
        List<PropPredicate> propPredicates = this.d_propEditors.stream().map(editor -> new PropPredicate(editor.prop, editor.editor.getPredicate())).toList();
        ConvexHull[] visibleFloorHulls = searchVisibleOnly ? Visibility.getVisibleFloorHulls(this.d_vd) : new ConvexHull[]{};
        this.d_searchCompute = BackgroundCompute.start(20L, () -> {
            try (VentusData.ReadLock lock = this.d_vd.lockRead();){
                ArrayList<IMerlinObj> modelObjs = new ArrayList<IMerlinObj>();
                for (Object child : EntryPointFactory.get(this.d_vd).tvEntryPoint.getChildren(this.d_vd, this.d_vd)) {
                    theUtil.throwIfInterrupted();
                    if (child instanceof IMerlinObj) {
                        IMerlinObj merlinObj = (IMerlinObj)child;
                        modelObjs.add(merlinObj);
                    }
                    if (!(child instanceof Composite)) continue;
                    Composite composite = (Composite)child;
                    modelObjs.addAll(composite.flatten());
                }
                Predicate<IMerlinObj> filter = obj -> {
                    if (this.d_allowedObjs != null && !this.d_allowedObjs.contains(obj)) {
                        return false;
                    }
                    if (searchType != IMerlinObj.class && obj.getClass() != searchType) {
                        return false;
                    }
                    if (searchVisibleOnly && !Visibility.isVisible(this.d_vd, obj, visibleFloorHulls)) {
                        return false;
                    }
                    for (PropPredicate pred : propPredicates) {
                        if (pred.prop.types.contains(obj.getClass())) {
                            PropValue<?> val = obj.getWithDetails(pred.prop.prop);
                            if (val.isEmpty()) {
                                return false;
                            }
                            if (pred.predicate.test(obj, val.get())) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                };
                ArrayList<IMerlinObj> resultsObjs = new ArrayList<IMerlinObj>();
                for (IMerlinObj obj2 : modelObjs) {
                    theUtil.throwIfInterrupted();
                    if (!filter.test(obj2)) continue;
                    resultsObjs.add(obj2);
                }
                ArrayList<IMerlinObj> arrayList = resultsObjs;
                return arrayList;
            }
        }, results -> {
            if (!results.equals(this.d_searchResults)) {
                this.d_searchResults = results;
                this.d_nextIterator = results.iterator();
                this.d_resultsList.setObjects((Collection<IMerlinObj>)results);
                this.d_messageLabel.setText(String.format(Intl.intl("%d Results"), results.size()));
            }
        }, 500L, () -> {
            this.d_resultsList.setObjects(Collections.emptyList());
            this.d_messageLabel.setText(Intl.intl("Searching..."));
        });
    }

    private void findNext() {
        Consumer<IMerlinObj> selectNext = obj -> {
            try (VentusData.WriteLock lock = this.d_vd.lockWrite();){
                Undo.begin(Intl.intl("Find Next"));
                Undo.insertUndoEntry_restoreSelection(this.d_vd);
                this.d_vd.selection.set(obj);
                Undo.end(this.d_vd);
            }
        };
        if (this.d_nextIterator != null && this.d_nextIterator.hasNext()) {
            selectNext.accept(this.d_nextIterator.next());
            this.d_messageLabel.setText(String.format(Intl.intl("%d Results"), this.d_searchResults.size()));
        } else if (!this.d_searchResults.isEmpty()) {
            this.d_nextIterator = this.d_searchResults.iterator();
            selectNext.accept(this.d_nextIterator.next());
            this.d_messageLabel.setText(String.format(Intl.intl("Search Wrapped"), new Object[0]));
        }
    }

    private void selectAll() {
        try (VentusData.WriteLock lock = this.d_vd.lockWrite();){
            Undo.begin(Intl.intl("Find All"));
            Undo.insertUndoEntry_restoreSelection(this.d_vd);
            this.d_vd.selection.set(this.d_searchResults);
            Undo.end(this.d_vd);
        }
        this.d_messageLabel.setText(String.format(Intl.intl("%d Results"), this.d_searchResults.size()));
    }

    private void regeneratePropertiesList() {
        this.d_propertiesPanel.removeAll();
        int i = 0;
        while (i < this.d_propEditors.size()) {
            PropEditor propEditor = this.d_propEditors.get(i);
            guiLabel propNameLbl = guiUtil.lblProp(propEditor.prop.prop);
            guiPanel editUi = propEditor.editor.getUi();
            JButton removeButton = new JButton("-");
            int removeI = i++;
            removeButton.addActionListener(e -> {
                PropEditor editor = this.d_propEditors.get(removeI);
                this.d_propEditors.remove(removeI);
                this.cleanRemovePropEditor(editor);
                this.regeneratePropertiesList();
                this.updateSearch();
            });
            propEditor.editor.getComm().addObserver(this);
            this.d_propertiesPanel.add(removeButton);
            this.d_propertiesPanel.add(propNameLbl);
            this.d_propertiesPanel.add((Component)editUi, "growx, pushx, wrap");
        }
        this.d_propertiesPanel.add((Component)this.d_addPropBtn, "wrap");
        this.d_propertiesPanel.revalidate();
    }

    private void cleanRemovePropEditor(PropEditor editor) {
        editor.editor.getComm().deleteObserver(this);
        editor.editor.getUi().setVisible(false);
    }

    private void clearPropertiesForType() {
        Class selectedType = (Class)this.d_objTypeCombo.getSelectedItem();
        if (selectedType != null && selectedType != IMerlinObj.class) {
            Iterator<PropEditor> editorIterator = this.d_propEditors.iterator();
            while (editorIterator.hasNext()) {
                PropEditor editor = editorIterator.next();
                if (editor.prop.types.contains(selectedType)) continue;
                editorIterator.remove();
                this.cleanRemovePropEditor(editor);
            }
            this.regeneratePropertiesList();
        }
        this.updateSearch();
    }

    private void promptAddProperty() {
        guiDialog propChoiceDlg = new guiDialog((Window)this, Intl.intl("Add Search Property"), 9);
        SearchableComboBox<Map.Entry> propCombo = new SearchableComboBox<Map.Entry>(() -> this.d_objProps.entrySet().stream().filter(entry -> this.d_objTypeCombo.getSelectedItem() == IMerlinObj.class || ((SourcedProp)entry.getValue()).types.contains(this.d_objTypeCombo.getSelectedItem())), Map.Entry::getKey);
        guiPanel dlgPanel = propChoiceDlg.getDialogPane();
        dlgPanel.setLayout(new MigLayout("insets 0"));
        dlgPanel.add((Component)new guiLabel(Intl.intl("Select a property to search by:")), "wrap");
        dlgPanel.add(propCombo, "wrap");
        int choice = propChoiceDlg.doModal();
        if (choice == 1) {
            SourcedProp prop = (SourcedProp)((Map.Entry)propCombo.getSelectedItem()).getValue();
            IPropComparisonEd editor = EntryPointFactory.get(prop.types.iterator().next()).getPropertyDefs(this.d_vd).getComparisonEditorSupplier(prop.prop).get(this.d_propertiesPanel, this.d_vd);
            this.d_propEditors.add(new PropEditor(prop, editor));
            this.regeneratePropertiesList();
            this.updateSearch();
        }
    }

    private static List<Class<?>> getObjTypes(VentusData vd) {
        ArrayList objTypes = new ArrayList();
        for (EntryPoint ep : EntryPointFactory.getAll()) {
            PropertyDefs defs = ep.getPropertyDefs(vd);
            if (!ep.isSearchType(vd) || defs == null || !defs.props().stream().anyMatch(prop -> defs.getComparisonEditorSupplier(prop) != null)) continue;
            objTypes.add(ep.clazz);
        }
        objTypes.sort((a, b) -> FindAdvancedDialog.getCategoryName(vd, a).compareToIgnoreCase(FindAdvancedDialog.getCategoryName(vd, b)));
        return objTypes;
    }

    private static LinkedHashMap<String, SourcedProp> getProperties(VentusData vd, Collection<Class<?>> objTypes) {
        HashMap<Object, Pair> propSources = new HashMap<Object, Pair>();
        HashMap propNameCounts = new HashMap();
        for (Class<?> type : objTypes) {
            if (type == IMerlinObj.class) continue;
            PropertyDefs propertyDefs = EntryPointFactory.get(type).getPropertyDefs(vd);
            for (TypedProp<?> prop : propertyDefs.props()) {
                if (!(prop instanceof DisplayProp)) continue;
                DisplayProp displayProp = (DisplayProp)prop;
                if (propertyDefs.getComparisonEditorSupplier(prop) == null) continue;
                propSources.compute(displayProp.key, (newKey, val) -> {
                    if (val == null) {
                        val = new Pair(displayProp, new IdentityHashSet());
                        propNameCounts.merge(displayProp.getDisplayName(), 1, Integer::sum);
                    }
                    ((IdentityHashSet)val.v2).add(type);
                    return val;
                });
            }
        }
        ArrayList<Pair<String, SourcedProp>> finalProps = new ArrayList<Pair<String, SourcedProp>>(propSources.size());
        for (Map.Entry entry : propSources.entrySet()) {
            String string;
            String disambiguatedPropName = string = ((DisplayProp)((Pair)entry.getValue()).v1).getDisplayName();
            if (propNameCounts.getOrDefault(string, 1) > 1) {
                assert (propSources.values().stream().filter(pair -> ((DisplayProp)pair.v1).getDisplayName().equalsIgnoreCase(propName)).flatMap(pair -> ((IdentityHashSet)pair.v2).stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).values().stream().noneMatch(count -> count > 1L)) : "All properties of a single object type must have distinct property names.";
                String propObjTypes = ((IdentityHashSet)((Pair)entry.getValue()).v2).stream().map(defs -> FindAdvancedDialog.getCategoryName(vd, defs)).collect(Collectors.joining(", "));
                disambiguatedPropName = String.format(Intl.intl("%1$s (%2$s)"), string, propObjTypes);
            }
            finalProps.add(new Pair<String, SourcedProp>(disambiguatedPropName, new SourcedProp((DisplayProp)((Pair)entry.getValue()).v1, (Set)((Pair)entry.getValue()).v2)));
        }
        finalProps.sort((a, b) -> ((String)a.v1).compareToIgnoreCase((String)b.v1));
        LinkedHashMap<String, SourcedProp> propsByName = new LinkedHashMap<String, SourcedProp>(finalProps.size());
        for (Pair pair2 : finalProps) {
            propsByName.put((String)pair2.v1, (SourcedProp)pair2.v2);
        }
        return propsByName;
    }

    private static String getCategoryName(VentusData vd, Class<?> clazz) {
        return EntryPointFactory.get(clazz).getCategoryName(vd, null);
    }

    private record PropEditor(SourcedProp prop, IPropComparisonEd<?, ?> editor) {
    }

    private record SourcedProp(DisplayProp<?> prop, Set<Class<?>> types) {
    }

    private record PropPredicate(SourcedProp prop, BiPredicate<?, ?> predicate) {
    }
}

