/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import thunderheadeng.util.WarningReport;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.ahs.AHSFeature;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSRoot;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSFeature;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class AHSPointOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVersion, int streamVersion, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        AHSRoot root = (AHSRoot)vd.getComponentData(AHSFeature.GUID);
        if (updateVersion == 204 && streamVersion < 204) {
            VentusOIS.findAndReplaceComposites(root, name -> new AHSRoot.AHSNode((String)name));
        }
        if (updateVersion == 205 && streamVersion < 205 && changes.changeObjs.containsKey(204)) {
            for (IMerlinObj obj : changes.changeObjs.get(204)) {
                if (!(obj instanceof AHSPoint)) continue;
                root.add(obj);
            }
        }
        if (updateVersion == 213 && streamVersion < 213) {
            SimpleAHSRoot ahsRoot = (SimpleAHSRoot)vd.getComponentData(SimpleAHSFeature.GUID);
            SimpleAHS defaultAHS = ahsRoot.getDefault();
            AHSRoot ahsPointRoot = (AHSRoot)vd.getComponentData(AHSFeature.GUID);
            for (AHSPoint point : ahsPointRoot.flatten(AHSPoint.class)) {
                point.setAHS(defaultAHS);
            }
            return true;
        }
        return false;
    }
}

