/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.value;

import java.util.List;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PlotData;
import ventus.data.value.APiecewiseFunction1d;

public class PiecewiseFunction1d
extends APiecewiseFunction1d {
    static final long serialVersionUID = 1L;
    public final APiecewiseFunction1d.Entry[] entries;

    public PiecewiseFunction1d(APiecewiseFunction1d.Entry ... entries) {
        this.entries = entries;
    }

    @Override
    public APiecewiseFunction1d.Entry[] getInput() {
        return this.entries;
    }

    @Override
    public APiecewiseFunction1d.Entry[] getOutput() {
        return this.entries;
    }

    @Override
    protected double calculateYValue(double x) {
        for (APiecewiseFunction1d.Entry e : this.entries) {
            if (e.x.get(PiecewiseFunction1d.getUnit(e)) != x) continue;
            return e.y.get(e.y.getUnit());
        }
        return 0.0;
    }

    private static Unit getUnit(APiecewiseFunction1d.Entry e) {
        return e.x.getUnit();
    }

    public static PiecewiseFunction1d newFunction(Unit xType, Unit yType, double ... entries) {
        assert (entries.length % 2 == 0);
        APiecewiseFunction1d.Entry[] oentries = new APiecewiseFunction1d.Entry[entries.length / 2];
        int m = 0;
        while (m < entries.length) {
            int ix = m / 2;
            double x = entries[m++];
            double y = entries[m++];
            oentries[ix] = new APiecewiseFunction1d.Entry(new UnitDouble(x, xType), new UnitDouble(y, yType));
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(Unit xType, Unit yType, List<Double> entries) {
        assert (entries.size() % 2 == 0);
        APiecewiseFunction1d.Entry[] oentries = new APiecewiseFunction1d.Entry[entries.size() / 2];
        int m = 0;
        while (m < entries.size()) {
            int ix = m / 2;
            double x = entries.get(m++);
            double y = entries.get(m++);
            oentries[ix] = new APiecewiseFunction1d.Entry(new UnitDouble(x, xType), new UnitDouble(y, yType));
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(UnitDouble ... entries) {
        assert (entries.length % 2 == 0);
        APiecewiseFunction1d.Entry[] oentries = new APiecewiseFunction1d.Entry[entries.length / 2];
        Unit ux = entries[0].getUnit();
        Unit uy = entries[1].getUnit();
        int m = 0;
        while (m < entries.length) {
            int ix = m / 2;
            UnitDouble x = entries[m++];
            UnitDouble y = entries[m++];
            oentries[ix] = new APiecewiseFunction1d.Entry(x, y);
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(PlotData data) {
        return PiecewiseFunction1d.newFunction(data.ux, data.uy, data.xyValues);
    }
}

