/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.value;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;
import ventus.data.value.IFunction1d;

public abstract class APiecewiseFunction1d
implements IFunction1d,
Serializable {
    static final long serialVersionUID = 1L;

    public abstract Entry[] getInput();

    public abstract Entry[] getOutput();

    @Override
    public APiecewiseFunction1d toPiecewise(Unit unit) {
        return this;
    }

    public int hashCode() {
        return 0x923498F ^ this.getInput().hashCode() ^ this.getOutput().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof APiecewiseFunction1d && theUtil.equal(((APiecewiseFunction1d)obj).getInput(), this.getInput()) && theUtil.equal(((APiecewiseFunction1d)obj).getOutput(), this.getOutput());
    }

    protected Entry[] generateOutputPoints(int n) {
        Optional<Entry> minEntry = Stream.of(this.getInput()).min(Entry::compareTo);
        Optional<Entry> maxEntry = Stream.of(this.getInput()).max(Entry::compareTo);
        if (this.getInput().length < 1) {
            return new Entry[0];
        }
        Unit ux = this.getInput()[0].x.getUnit();
        Unit uy = this.getInput()[0].y.getUnit();
        double xMin = minEntry.map(entry -> entry.x.get(ux)).orElse(0.0);
        double xMax = maxEntry.map(entry -> entry.x.get(ux)).orElse(0.0);
        double increment = (xMax - xMin) / (double)n;
        Entry[] output = new Entry[n];
        output[0] = new Entry(new UnitDouble(xMin, ux), new UnitDouble(this.calculateYValue(xMin), uy));
        double currentX = xMin + increment;
        for (int i = 1; i < n - 1; ++i) {
            output[i] = new Entry(new UnitDouble(currentX, ux), new UnitDouble(this.calculateYValue(currentX), uy));
            currentX += increment;
        }
        output[n - 1] = new Entry(new UnitDouble(xMax, ux), new UnitDouble(this.calculateYValue(xMax), uy));
        return output;
    }

    protected abstract double calculateYValue(double var1);

    public static class Entry
    implements Serializable,
    Comparable<Entry> {
        static final long serialVersionUID = 1L;
        public final UnitDouble x;
        public final UnitDouble y;

        public Entry(UnitDouble x, UnitDouble y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Entry && ((Entry)obj).x.equals(this.x) && ((Entry)obj).y.equals(this.y);
        }

        public int hashCode() {
            return 0x73F213A8 ^ Objects.hash(this.x, this.y);
        }

        @Override
        public int compareTo(Entry o) {
            return this.x.compareTo(o.x);
        }
    }
}

