/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;

public class SchematicTopology {
    private static final boolean DEBUG_PROGRESS = false;
    private final VentusData d_domain;
    private final boolean d_enabled;
    private Set<ISchematicObj> d_adds;
    private Set<ISchematicObj> d_changes;
    private Set<ISchematicObj> d_removes;
    private boolean d_updateLock = false;
    private static final Logger LOGGER = Logger.getLogger(SchematicTopology.class.getName());

    public SchematicTopology(VentusData domain, boolean enabled) {
        this.d_domain = domain;
        this.d_enabled = enabled;
        this.reset();
    }

    public synchronized void add(ISchematicObj obj) {
        if (!this.d_enabled) {
            return;
        }
        if (!this.d_removes.remove(obj)) {
            this.d_adds.add(obj);
        } else {
            this.changed(obj);
        }
    }

    public synchronized void remove(ISchematicObj obj) {
        if (!this.d_enabled) {
            return;
        }
        if (!this.d_adds.remove(obj)) {
            this.d_changes.remove(obj);
            this.d_removes.add(obj);
        }
    }

    public synchronized void changed(ISchematicObj obj) {
        if (!this.d_enabled) {
            return;
        }
        if (!this.d_adds.contains(obj) && !this.d_removes.contains(obj)) {
            this.d_changes.add(obj);
        }
    }

    private void markDirty(ISchematicObj obj) {
        for (ISchematicObj iSchematicObj : new ArrayList<ISchematicObj>(obj.getConnections())) {
            iSchematicObj.disconnectFrom(obj);
            obj.disconnectFrom(iSchematicObj);
        }
    }

    private static boolean isDescendent(Class<?> type, Class<?>[] types) {
        for (Class<?> parent : types) {
            if (!parent.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return !this.d_adds.isEmpty() || !this.d_changes.isEmpty() || !this.d_removes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() {
        if (this.d_updateLock || !this.isDirty()) {
            return;
        }
        this.d_updateLock = true;
        this.d_domain.pauseUpdates();
        try {
            ArrayList<ISchematicObj> added = new ArrayList<ISchematicObj>(this.d_adds);
            ArrayList<ISchematicObj> changed = new ArrayList<ISchematicObj>(this.d_changes);
            ArrayList<ISchematicObj> removed = new ArrayList<ISchematicObj>(this.d_removes);
            LinkedIdentityHashSet<ISchematicObj> dirtyObjs = new LinkedIdentityHashSet<ISchematicObj>();
            dirtyObjs.addAll(added);
            dirtyObjs.addAll(changed);
            Consumer<Collection> addDirty = objs -> dirtyObjs.addAll(theUtil.filter(objs, Filters.reject(this.d_removes)));
            for (ISchematicObj add : added) {
                this.markDirty(add);
            }
            for (ISchematicObj changedObj : changed) {
                addDirty.accept(changedObj.getConnections());
                this.markDirty(changedObj);
            }
            for (ISchematicObj remove : removed) {
                Collection<? extends ISchematicObj> toRemove = remove.getConnections();
                addDirty.accept(toRemove);
                for (ISchematicObj iSchematicObj : toRemove) {
                    iSchematicObj.disconnectFrom(remove);
                }
            }
            Consumer<ISchematicObj> syncDomains = o -> {
                if (o.getDomain() == null) {
                    LOGGER.log(Level.SEVERE, String.format("Topology update encountered objects with no domain.", o.getClass()));
                    o.setDomain(this.d_domain);
                    assert (false);
                }
            };
            dirtyObjs.forEach(syncDomains);
            if (!dirtyObjs.isEmpty()) {
                this.d_domain.updateSearches();
                Set<PotentialConn> potConns = this.findPotentialConns(dirtyObjs);
                this.makeConnections(potConns);
            }
            this.reset();
        }
        finally {
            this.d_domain.resumeUpdates();
            this.d_updateLock = false;
        }
    }

    private void reset() {
        this.d_adds = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_changes = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_removes = new LinkedIdentityHashSet<ISchematicObj>();
    }

    private Set<PotentialConn> findPotentialConns(Set<ISchematicObj> dirtyObjs) {
        LinkedHashSet<PotentialConn> potConns = new LinkedHashSet<PotentialConn>();
        for (ISchematicObj dirtyObj : dirtyObjs) {
            this.findPotentialConns(dirtyObj, potConns);
        }
        return potConns;
    }

    private void findPotentialConns(ISchematicObj obj, Set<PotentialConn> potConns) {
        AABox searchBox = obj.getBounds();
        AABoxTest test = new AABoxTest(searchBox, 1.0E-6);
        IResult<IDisplayableGeomSrc> result = (src, ctmt) -> {
            if (src != obj && src instanceof ISchematicObj && ((ISchematicObj)src).hasOpenSpots(obj.getClass())) {
                potConns.add(new PotentialConn(obj, (ISchematicObj)src));
            }
        };
        this.d_domain.geomLocation.getLocator().find((ITest<AABox>)test, result, 3);
    }

    private void makeConnections(Set<PotentialConn> potConns) {
        LinkedIdentityHashSet updateObjs = new LinkedIdentityHashSet(potConns.size() * 2);
        for (PotentialConn potConn : potConns) {
            updateObjs.add(potConn.obj1);
            updateObjs.add(potConn.obj2);
        }
        boolean counter = false;
        for (ISchematicObj obj : updateObjs) {
            if (!obj.updateTopo()) continue;
            for (ISchematicObj iSchematicObj : obj.getConnections()) {
                if (iSchematicObj == null) continue;
                iSchematicObj.connectTo(obj);
            }
        }
    }

    private static final class PotentialConn {
        public final ISchematicObj obj1;
        public final ISchematicObj obj2;

        public PotentialConn(ISchematicObj o1, ISchematicObj o2) {
            this.obj1 = o1;
            this.obj2 = o2;
        }

        public int hashCode() {
            return this.obj1.hashCode() + this.obj2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PotentialConn)) {
                return false;
            }
            PotentialConn c1 = (PotentialConn)obj;
            return this.obj1 == c1.obj1 && this.obj2 == c1.obj2 || this.obj1 == c1.obj2 && this.obj2 == c1.obj1;
        }
    }
}

