/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.data.IMerlinObj;
import ventus.data.Proxy;

public class Proxies
implements Serializable {
    private static final long serialVersionUID = 8953619384941835754L;
    private Map<IMerlinObj, Set<Proxy<? extends IMerlinObj>>> proxiesMap;

    public Proxies() {
        this.proxiesMap = new LinkedIdentityHashMap<IMerlinObj, Set<Proxy<? extends IMerlinObj>>>();
    }

    public Proxies(Map<IMerlinObj, Set<Proxy<? extends IMerlinObj>>> proxiesMap) {
        this.proxiesMap = proxiesMap;
    }

    public void add(Proxy<?> proxy) {
        Object obj = proxy.getObj();
        assert (obj != null);
        this.proxiesMap.computeIfAbsent((IMerlinObj)obj, (Function<IMerlinObj, Set<Proxy<? extends IMerlinObj>>>)((Function<IMerlinObj, Set>)o -> new LinkedIdentityHashSet()));
        this.proxiesMap.get(obj).add(proxy);
    }

    public void remove(Proxy<?> proxy) {
        Set<Proxy<? extends IMerlinObj>> set = this.proxiesMap.get(proxy.getObj());
        if (set == null) {
            return;
        }
        set.remove(proxy);
        if (set.isEmpty()) {
            this.proxiesMap.remove(proxy.getObj());
        }
    }

    public Set<Proxy<? extends IMerlinObj>> getProxies(IMerlinObj obj) {
        return this.proxiesMap.getOrDefault(obj, Collections.emptySet());
    }

    public <T extends IMerlinObj> Proxy<? extends T> findFirstProxy(T obj, Predicate<Proxy<? extends T>> filter) {
        return this.getProxies(obj).stream().map(p -> p).filter(filter).findFirst().orElse(null);
    }

    public Set<Proxy<? extends IMerlinObj>> getAllProxies() {
        LinkedIdentityHashSet<Proxy<? extends IMerlinObj>> allProxies = new LinkedIdentityHashSet<Proxy<? extends IMerlinObj>>();
        for (Set<Proxy<? extends IMerlinObj>> proxies : this.proxiesMap.values()) {
            allProxies.addAll(proxies);
        }
        return allProxies;
    }
}

