/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.props.PropertyDefs;
import ventus.util.MerlinUtil;

public class Composite<DataT extends IMerlinObj>
extends NamedMerlinObj
implements IMerlinObj {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<Composite> PROP_TYPES = new PropertyDefs<Composite>(Composite.class, NamedMerlinObj.PROP_TYPES, Composite::initStorage);
    @Deprecated
    @SkipDep
    private Set<IMerlinObj> d_members;
    @SkipDep
    private transient Set<IMerlinObj> d_children;
    @SkipDep
    private transient Map<Object, PropValue<?>> d_cachedProps = null;
    @SkipDep
    private transient Map<IMerlinObj.SupportMode, Set<TypedProp<?>>> d_cachedPropTypes;

    public Composite(String name) {
        super(name);
        this.initStorage();
    }

    private void initStorage() {
        this.d_cachedProps = null;
        this.d_cachedPropTypes = new HashMap(4);
        this.d_children = new LinkedIdentityHashSet<IMerlinObj>();
    }

    protected boolean getSerializeMembersEnabled() {
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initStorage();
        if (this.getSerializeMembersEnabled()) {
            this.d_children = (Set)in.readObject();
        } else {
            this.d_members = null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.getSerializeMembersEnabled()) {
            out.writeObject(this.d_children);
        }
    }

    protected void markPropsCacheDirty() {
        this.d_cachedProps = null;
        Object parent = this.getParent();
        if (parent instanceof Composite) {
            ((Composite)parent).markPropsCacheDirty();
        }
    }

    private void markTypesCacheDirty() {
        this.d_cachedPropTypes.clear();
        Object parent = this.getParent();
        if (parent instanceof Composite) {
            ((Composite)parent).markTypesCacheDirty();
        }
    }

    private Map<Object, PropValue<?>> getCachedProps() {
        if (this.d_cachedProps == null) {
            this.d_cachedProps = new HashMap();
        }
        return this.d_cachedProps;
    }

    protected boolean getCachingAllowed(TypedProp<?> prop) {
        return true;
    }

    public Composite<?> newGroup(String name) {
        return new Composite<DataT>(name);
    }

    public boolean canAddGroup() {
        return this.newGroup("") != null;
    }

    public String getNewGroupName() {
        return Intl.intl("Group Node");
    }

    @Override
    public void restoreFrom(Object obj) {
        Composite nn = (Composite)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        ArrayList<IMerlinObj> toRemove = new ArrayList<IMerlinObj>();
        ArrayList<IMerlinObj> toAdd = new ArrayList<IMerlinObj>();
        for (IMerlinObj o : this.d_children) {
            if (nn.d_children.contains(o)) continue;
            toRemove.add(o);
        }
        for (IMerlinObj o : nn.d_children) {
            if (this.d_children.contains(o)) continue;
            toAdd.add(o);
        }
        this.removeAll(toRemove);
        this.addAll(toAdd);
        this.resumeUpdates();
    }

    @Override
    public Composite<DataT> getRestoreObj() {
        Composite clone = (Composite)super.getRestoreObj();
        clone.d_children.addAll(this.d_children);
        return clone;
    }

    @Override
    public Composite<DataT> clone() {
        return (Composite)super.clone();
    }

    public Predicate<IMerlinObj> getFilter() {
        return Filters.acceptAll();
    }

    public void reorder(Collection<? extends DataT> newOrder) {
        assert (this.d_children.containsAll(newOrder) && this.d_children.size() == newOrder.size());
        this.d_children.clear();
        this.d_children.addAll(newOrder);
        this.changedEvt(VentusData.CHILDREN_CHANGED);
    }

    public boolean containsAny(Collection<? extends IMerlinObj> objs) {
        for (IMerlinObj iMerlinObj : objs) {
            if (!this.d_children.contains(iMerlinObj)) continue;
            return true;
        }
        return false;
    }

    public void insert(Collection<? extends IMerlinObj> objs, int insertPos) {
        if (objs.isEmpty()) {
            return;
        }
        assert (!this.containsAny(objs));
        if (insertPos >= this.d_children.size()) {
            this.addAll(objs);
            return;
        }
        ArrayList<IMerlinObj> newList = new ArrayList<IMerlinObj>(this.d_children);
        newList.addAll(insertPos, objs);
        this.d_children.clear();
        this.d_children.addAll(newList);
        this.doModify();
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        super.addChildren(objs);
    }

    public void insert(DataT[] objs, int[] insertPositions) {
        if (objs.length == 0) {
            return;
        }
        assert (!this.containsAny(Arrays.asList(objs)));
        assert (objs.length <= insertPositions.length);
        ArrayList<IMerlinObj> newList = new ArrayList<IMerlinObj>(this.d_children);
        for (int m = 0; m < objs.length; ++m) {
            newList.add(insertPositions[m], (IMerlinObj)objs[m]);
        }
        this.d_children.clear();
        this.d_children.addAll(newList);
        this.doModify();
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        super.addChildren(objs);
    }

    public int indexOf(IMerlinObj obj) {
        Pair<IMerlinObj, Integer> result = this.indexOf((? super IMerlinObj o) -> o == obj);
        if (result == null) {
            return -1;
        }
        return (Integer)result.v2;
    }

    public <T extends IMerlinObj> Pair<T, Integer> indexOf(Class<T> type, Predicate<? super T> test) {
        return this.indexOf((? super IMerlinObj o) -> type.isInstance(o) && test.test((Object)type.cast(o)));
    }

    public Pair<IMerlinObj, Integer> indexOf(Predicate<? super IMerlinObj> test) {
        int ix = 0;
        for (IMerlinObj child : this.d_children) {
            if (test.test(child)) {
                return new Pair<IMerlinObj, Integer>(child, ix);
            }
            ++ix;
        }
        return null;
    }

    public <T> void setChildrenValue(TypedProp<T> prop, T val) {
        this.pauseUpdates();
        CompositePropertyUtil.setValue(prop, val, theUtil.filter(this.getChildren(), IMerlinObj.class));
        this.changedEvt(prop);
        this.resumeUpdates();
    }

    @Override
    public <T> PropValue<T> getWithDetails(TypedProp<T> prop) {
        PropertyDefs<? extends IMerlinObj> props = this.getPropertyDefs();
        if (props.has(prop)) {
            return props.getValue(this, prop);
        }
        return this.getChildrenValue(prop);
    }

    public <T> PropValue<T> getChildrenValue(TypedProp<T> prop) {
        if (!this.getCachingAllowed(prop)) {
            return CompositePropertyUtil.getValue(prop, this.d_children);
        }
        Map<Object, PropValue<?>> propCache = this.getCachedProps();
        if (propCache.containsKey(prop.key)) {
            return propCache.get(prop.key);
        }
        PropValue<T> propVal = CompositePropertyUtil.getValue(prop, this.d_children);
        propCache.put(prop.key, propVal);
        return propVal;
    }

    @Override
    public Set<TypedProp<?>> getSupportedProps(IMerlinObj.SupportMode mode) {
        if (mode == IMerlinObj.SupportMode.LOCAL_ONLY) {
            return this.getPropertyDefs().props();
        }
        Set<TypedProp<?>> propTypes = this.d_cachedPropTypes.get((Object)mode);
        if (propTypes == null) {
            propTypes = CompositePropertyUtil.getSupportedProps(mode, this.d_children);
            Set<TypedProp<?>> local = this.getSupportedProps(IMerlinObj.SupportMode.LOCAL_ONLY);
            if (!local.isEmpty()) {
                propTypes = new LinkedHashSet(propTypes);
                propTypes.addAll(local);
            }
            this.d_cachedPropTypes.put(mode, propTypes);
        }
        return propTypes;
    }

    public boolean contains(IMerlinObj obj) {
        return this.d_children.contains(obj);
    }

    public boolean containsDeep(IMerlinObj obj) {
        if (this.d_children.contains(obj)) {
            return true;
        }
        for (Composite<DataT> comp : this.getComposites()) {
            if (!comp.containsDeep(obj)) continue;
            return true;
        }
        return false;
    }

    public Collection<IMerlinObj> getMembers() {
        return this.d_children;
    }

    public <T> Collection<T> getMembers(Class<T> type) {
        return theUtil.filter(this.d_children, type);
    }

    public Collection<Composite<DataT>> getComposites() {
        return new ArrayList<Composite<DataT>>(this.getMembers(Composite.class));
    }

    public Collection<IMerlinObj> getDeepMembers() {
        return this.flatten();
    }

    public Collection<IMerlinObj> flatten() {
        return this.getDeepMembers(IMerlinObj.class);
    }

    public <T> Collection<T> getDeepMembers(Class<T> type) {
        return this.flatten(type);
    }

    public <T> Collection<T> flatten(Class<T> type) {
        return MerlinUtil.flatten(this.d_children, type);
    }

    public <T> Collection<T> flatten(Class<T> type, Predicate<? super T> filter) {
        return MerlinUtil.flatten(this.d_children, type, filter);
    }

    public <T extends ISchematicRoom> Collection<T> flattenRooms(Class<T> roomClazz, Predicate<? super ISchematicRoom.Type> typeFilter) {
        return this.flatten(roomClazz, r -> typeFilter.test(r.getType()));
    }

    public <T extends ISchematicRoom> Collection<T> flattenRooms(Class<T> roomClazz, ISchematicRoom.Type type) {
        return this.flattenRooms(roomClazz, Filters.accept(type));
    }

    public Collection<Composite> getDeepNodes() {
        return this.getDeepMembers(Composite.class);
    }

    public static VentusData getDomain(Collection<? extends IMerlinObj> objs) {
        if (objs == null) {
            return null;
        }
        Iterator<? extends IMerlinObj> iterator = objs.iterator();
        if (iterator.hasNext()) {
            IMerlinObj ce = iterator.next();
            return (VentusData)ce.getDomain();
        }
        return null;
    }

    public void clear() {
        this.pauseUpdates();
        ArrayList<IMerlinObj> members = new ArrayList<IMerlinObj>(this.d_children);
        this.d_children.clear();
        this.doModify();
        super.removeChildren(members);
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        this.resumeUpdates();
    }

    public boolean isEmpty() {
        return this.d_children.isEmpty();
    }

    public void prune() {
        this.pauseUpdates();
        for (Composite member : new ArrayList<Composite>(this.getMembers(Composite.class))) {
            member.prune();
            if (!member.isEmpty()) continue;
            this.remove(member);
        }
        this.resumeUpdates();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_children;
    }

    public void add(IMerlinObj obj) {
        if (!this.getFilter().test(obj)) {
            System.err.println("Adding non-accepted object to group: [group=" + this.getName() + "], [object=" + MerlinUtil.getName(obj) + "]");
        }
        this.d_children.add(obj);
        this.doModify();
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        super.addChildren(new IMerlinObj[]{obj});
    }

    public void addAll(Collection<? extends IMerlinObj> objs) {
        this.pauseUpdates();
        for (IMerlinObj iMerlinObj : objs) {
            this.add(iMerlinObj);
        }
        this.resumeUpdates();
    }

    public void addAll(IMerlinObj ... objs) {
        this.addAll(Arrays.asList(objs));
    }

    public boolean remove(IMerlinObj obj) {
        boolean result = this.d_children.remove(obj);
        this.doModify();
        if (result) {
            super.removeChild(obj);
            this.markPropsCacheDirty();
            this.markTypesCacheDirty();
        }
        return result;
    }

    public boolean removeAll(Collection<? extends IMerlinObj> objs) {
        boolean removed = false;
        this.pauseUpdates();
        for (IMerlinObj iMerlinObj : objs) {
            removed |= this.remove(iMerlinObj);
        }
        this.resumeUpdates();
        return removed;
    }

    public boolean removeDeep(IMerlinObj obj) {
        if (this.d_children.remove(obj)) {
            return true;
        }
        for (Composite<DataT> comp : this.getComposites()) {
            if (!comp.removeDeep(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T extends IMerlinObj> Composite<T> findParent(Composite<T> root, T searchFor) {
        ArrayDeque search = new ArrayDeque();
        search.addFirst(root);
        while (!search.isEmpty()) {
            Composite container = (Composite)search.removeFirst();
            if (container.contains(searchFor)) {
                return container;
            }
            search.addAll(container.getComposites());
        }
        return null;
    }

    protected void doModify() {
    }
}

