/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.util.IResponder;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.SubtractAction;
import ventus.actions.Undo;
import ventus.builders.NewCompUtil;
import ventus.builders.PlanarGeomBuilder;
import ventus.data.INameGenerator;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.GeomUtil;

public class RoomGeomBuilder
implements PlanarGeomBuilder.IGeomBuilder {
    private final IResponder<String> d_responder;
    private final BooleanOp d_bo;

    public RoomGeomBuilder(BooleanOp op, IResponder<String> responder) {
        this.d_bo = op;
        this.d_responder = responder;
    }

    @Override
    public void build(VentusData md, PlanarGeomBuilder builder, IGeom shape) {
        IResponder<String> responder = this.d_responder;
        BooleanOp op = this.d_bo;
        INameGenerator nameGenerator = md.roomNameGen;
        if (!(shape instanceof IPlanarFace)) {
            return;
        }
        IPlanarFace face = (IPlanarFace)shape;
        ArrayList<ICurve> boundary = new ArrayList<ICurve>();
        face.getBoundary(boundary);
        List<LineSeg> bsegs = thunderheadeng.geometry.objs.GeomUtil.getLineSegs(0.0, boundary);
        List<IParametric3D> boundaryParms = theUtil.map(bsegs, ls -> new LineSeg3D(ls.p1, ls.p2));
        Model model = new Model();
        GeomUtil.addFaceToModel(model, 0, face.getPlane(true), boundaryParms);
        int[] boundaryid = new int[]{1};
        for (Edge edge : model.getEdges()) {
            edge.groups = boundaryid;
        }
        String name = nameGenerator.getCurrentName();
        nameGenerator.nextName();
        SchematicRoom geom = new SchematicRoom(name, model);
        geom.setType(builder.get(ISchematicRoom.TYPE));
        try (VentusData.WriteLock lock = md.lockWrite();){
            String actionName = op == BooleanOp.ADD ? Intl.intl("New Room") : Intl.intl("Subtract Area");
            Undo.begin(actionName);
            ArrayList toClean = new ArrayList();
            switch (op.ordinal()) {
                case 0: {
                    this.addArea(md, geom, toClean::add);
                    break;
                }
                case 1: {
                    this.subArea(md, geom, toClean::add);
                }
            }
            SchematicRoom.cleanup(md, toClean);
            Undo.end(md);
        }
    }

    private void addArea(VentusData md, SchematicRoom room, Consumer<? super SchematicRoom> toClean) {
        toClean.accept(room);
        this.subArea(md, room, toClean);
        NewCompUtil.addSchematicComp(md, true, room);
    }

    private void subArea(VentusData md, SchematicRoom room, Consumer<? super SchematicRoom> toClean) {
        SubtractAction.subtract(VentusApp.getApp(), md, 0, toClean, room);
    }

    public static enum BooleanOp {
        ADD,
        SUBTRACT;

    }
}

