/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.floorextract;

import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AEventRec;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.QuadConsumer;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TieBreaker;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.mtproc.MTListProcessorPool;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CloseGapsAction;
import ventus.actions.SelectionObserver;
import ventus.actions.SubtractAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.floorextract.GenerateModelPropsDlg;
import ventus.builders.NewCompUtil;
import ventus.data.INameGenerator;
import ventus.data.ImportType;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.RoomUtil;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.GeomUtil;
import ventus.util.MerlinUtil;

public class GenerateModelFromBIM
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK_CONTEXT = new UIHook(new GenerateModelFromBIM(true), Intl.intl("Generate Model from BIM Selection..."));
    public static final UIHook UI_HOOK_GLOBAL = new UIHook(new GenerateModelFromBIM(false), Intl.intl("Generate Model from BIM..."));
    public static final IPropertySet.Prop<UnitDouble> MAX_SLOPE;
    public static final IPropertySet.Prop<Boolean> SLOPE_INCLUSIVE;
    public static final IPropertySet.Prop<Integer> SEARCH_OPTIONS;
    public static final IPropertySet.Prop<UnitDouble> HEAD_HEIGHT;
    public static final IPropertySet.Prop<UnitDouble> MIN_COMP_WIDTH;
    public static final IPropertySet.Prop<Boolean> CLOSE_GAPS;
    public static final IPropertySet.Prop<UnitDouble> CLOSE_GAP_TOLERANCE;
    public static final IPropertySet.Prop<Boolean> NAME_FROM_IMPORTED_GEOM;
    public static final IPropertySet.Prop<Boolean> EXTRACT_STAIRS;
    public static final IPropertySet.Prop<UnitDouble> MAX_STAIR_RISER;
    public static final IPropertySet.Prop<UnitDouble> MAX_STAIR_TREAD_GAP;
    public static final IPropertySet.Prop<Boolean> EXTRACT_DOORS;
    public static final IPropertySet.Prop<Boolean> DEL_SMALL_ROOMS;
    public static final IPropertySet.Prop<Boolean> DEL_ROOMS_IN_SOLIDS;
    public static final IPropertySet.Prop<UnitDouble> MIN_ROOM_AREA;
    public static final IPropertySet.Prop<Boolean> EXTRACT_ONLY_TOPS_OF_SOLIDS;
    public static final IPropertySet.Prop<Boolean> GENERATE_OCCUPANTS;
    public static final IPropertySet.Prop<Boolean> GENERATE_PROFILES;
    private final boolean d_context;
    private final Progress d_progress = new Progress();
    private WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
    private static final Comparator<Double> s_areaComp;
    static theTimer timer;

    public GenerateModelFromBIM(boolean context) {
        this.d_context = context;
        if (this.d_context) {
            SelectionObserver.add(this, ImportedGeom.class);
        } else {
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }
        this.sync();
    }

    @Override
    public void update(Events events) {
        if (this.d_context) {
            this.sync();
        } else if (events.getAffectedChannels(ImportedGeom.class, new Class[0]).stream().anyMatch(AEventRec::isModified)) {
            this.sync();
        }
    }

    private void sync() {
        VentusData md = VentusApp.getApp().getData();
        if (!this.d_context) {
            this.setEnabled(!md.sceneGeom.flatten(ImportedGeom.class).isEmpty());
        } else {
            this.setEnabled(!md.selection.flatten(ImportedGeom.class).isEmpty());
        }
    }

    private static Predicate<ImportType> getFloorTypeFilter() {
        return ig -> {
            switch (ig) {
                case STAIR: 
                case ESCALATOR: 
                case FLOOR: 
                case RAMP: 
                case MOVING_WALKWAY: 
                case ROOM: {
                    return true;
                }
            }
            return false;
        };
    }

    private static Predicate<ImportedGeom> getFloorFilter() {
        Predicate<ImportType> typeFilter = GenerateModelFromBIM.getFloorTypeFilter();
        return ig -> typeFilter.test(ig.getImportedType());
    }

    protected TaskProgress getProgress() {
        return this.d_progress.d_progress;
    }

    protected void checkCancelled() throws CancellationException {
        this.d_progress.d_progress.check();
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        PropertySet newProps;
        Collection<Object> pickGeom = Collections.emptyList();
        try {
            boolean valid;
            Predicate<ImportedGeom> objFilter = GenerateModelFromBIM.getFloorFilter();
            if (!this.d_context) {
                valid = !md.sceneGeom.flatten(ImportedGeom.class, objFilter).isEmpty();
            } else {
                boolean bl = valid = !md.selection.flatten(ImportedGeom.class, objFilter).isEmpty();
            }
            if (!valid) {
                String validTypes = String.join((CharSequence)"<br>", (CharSequence[])Stream.of(ImportType.values()).filter(GenerateModelFromBIM.getFloorTypeFilter()).sorted((t1, t2) -> t1.name.compareToIgnoreCase(t2.name)).map(t -> "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + t.name).toArray(String[]::new));
                assert (!validTypes.isEmpty());
                String msg = !this.d_context ? String.format("<html>" + Intl.intl("Cannot generate model elements. There must be imported objects with<br><b>Import Type</b> set to any of the following:<br>%s"), validTypes) : String.format("<html>" + Intl.intl("Cannot generate model elements. The selected objects must have<br><b>Import Type</b> set to any of the following:<br>%s"), validTypes);
                md.ui(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), msg, Intl.intl("Cannot Generate Model"), 2));
                return;
            }
            objFilter = Predicates.or(objFilter, ig -> ig.isA(ImportType.DOOR) || ig.isA(ImportType.ROOM) || ig.isA(ImportType.BUILDING));
            pickGeom = !this.d_context ? md.sceneGeom.flatten(ImportedGeom.class, objFilter) : new ArrayList<ImportedGeom>(md.selection.flatten(ImportedGeom.class, objFilter));
            Predicate<ImportedGeom> occupantFilter = ig -> ig.isA(ImportType.ROOM) || ig.isA(ImportType.BUILDING);
            boolean showOccSection = !theUtil.filter(pickGeom, occupantFilter).isEmpty();
            newProps = md.ui(() -> {
                GenerateModelPropsDlg dlg = new GenerateModelPropsDlg((Window)app.getActiveFrame(), showOccSection);
                PropertySet result = new PropertySet();
                dlg.load(result);
                if (dlg.doModal() != 1) {
                    throw new CancellationException();
                }
                dlg.save(result);
                return result;
            });
            if (pickGeom.isEmpty()) {
                return;
            }
        }
        catch (CancellationException e) {
            return;
        }
        theTimer timer = new theTimer();
        try {
            this.d_progress.reset();
            Collection<Object> geoms = pickGeom;
            ExtractResults extractResults = this.execLongReadTask(app, md, Intl.intl("Generating Model"), this.d_progress.d_progress, () -> {
                ExtractProps props = new ExtractProps(newProps);
                return this.extract(md, geoms, props);
            });
            this.applyResult(app, md, newProps, extractResults);
            if (!this.d_warnings.isEmpty()) {
                md.ui(() -> new WarningDlg<Warning>((Window)app.getActiveFrame(), Intl.intl("Model Generation Warnings"), Intl.intl("Problem generating model."), this.d_warnings).doModal());
            }
        }
        catch (CancellationException e) {
            return;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ExtractException) {
                md.ui(() -> JOptionPane.showMessageDialog(app.getActiveFrame(), e.getCause().getLocalizedMessage(), Intl.intl("Error Generating Model"), 0));
                return;
            }
            throw new RuntimeException(e.getCause());
        }
        finally {
            this.d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
            System.out.println("Elapsed: " + timer.curr());
        }
    }

    public void applyResult(VentusApp app, VentusData md, PropertySet eprops, ExtractResults extractResults) {
        LinkedIdentityHashSet<? extends ISchematicComp> toSelect = new LinkedIdentityHashSet<ISchematicComp>(extractResults.newObjs);
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Generate Model"));
            BiConsumer<Class, INameGenerator> generateNames = (clazz, nameGen) -> {
                for (ISchematicComp comp : MerlinUtil.flatten(extractResults.newObjs, clazz)) {
                    if (!comp.getName().isEmpty()) continue;
                    comp.setName(nameGen.getCurrentName());
                    nameGen.nextName();
                }
            };
            generateNames.accept(SchematicRoom.class, md.roomNameGen);
            ArrayList toClean = new ArrayList();
            IdentityHashSet<SchematicRoom> newRoomSet = new IdentityHashSet<SchematicRoom>(MerlinUtil.flatten(extractResults.newObjs, SchematicRoom.class));
            BiConsumer<SchematicRoom, SchematicRoom> selectFunc = (originalRoom, child) -> {
                if (newRoomSet.contains(originalRoom)) {
                    toSelect.remove(originalRoom);
                    toSelect.add(child);
                }
            };
            NewCompUtil.addSchematicComps(md, false, extractResults.newObjs);
            SubtractAction.subtract(app, md, 0, toClean::add, selectFunc, MerlinUtil.flatten(extractResults.newObjs, SchematicRoom.class));
            SchematicRoom.cleanup(md, toClean);
        }
        lock = md.lockWrite();
        try {
            Undo.insertUndoEntry_restoreSelection(md);
            md.selection.set(toSelect);
            Undo.end(md);
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    private static boolean isBoundaryEdge(Edge edge) {
        return edge.partOfGroup(Integer.MAX_VALUE) && !edge.faces.isEmpty() || !edge.partOfGroup(Integer.MAX_VALUE) && edge.faces.size() == 1;
    }

    private static Collection<GeomFace> findFloorFaces(ExtractInfo einfo, Collection<? extends ImportedGeom> geoms) {
        if (!einfo.getProp(EXTRACT_STAIRS).booleanValue()) {
            geoms = theUtil.filter(geoms, g -> !GenerateModelFromBIM.isAStair(g));
        }
        boolean topsOfSolids = einfo.getProp(EXTRACT_ONLY_TOPS_OF_SOLIDS);
        ArrayList<GeomFace> result = new ArrayList<GeomFace>();
        for (ImportedGeom importedGeom : geoms) {
            Collection<Pair<IPolygon, Elements.Orient>> faces = einfo.faceCache.getFaces(importedGeom);
            RTree<IPolygon> solidSearch = null;
            if (topsOfSolids && GenerateModelFromBIM.isSolid(importedGeom) || importedGeom.isA(ImportType.ROOM)) {
                solidSearch = new RTree<IPolygon>();
                for (Pair<IPolygon, Elements.Orient> face : faces) {
                    solidSearch.insert(((IPolygon)face.v1).getBoundingBox(new AABox()), (IPolygon)face.v1);
                }
            }
            Iterator<Pair<IPolygon, Elements.Orient>> fit = faces.iterator();
            int ix = 0;
            while (fit.hasNext()) {
                Boolean onTop;
                Pair<IPolygon, Elements.Orient> face = fit.next();
                Plane3d plane = ((IPolygon)face.v1).getPlane(face.v2 == Elements.Orient.CCW);
                double slope = GenerateModelFromBIM.getSlopeRad(plane.getNormal());
                if (slope >= einfo.eprops.maxSlopeRad && Math.PI - slope >= einfo.eprops.maxSlopeRad || solidSearch != null && (onTop = GenerateModelFromBIM.polyTouchingTopOfSolid((IPolygon)face.v1, solidSearch)) != null && onTop.booleanValue() == importedGeom.isA(ImportType.ROOM)) continue;
                result.add(new GeomFace(importedGeom, (IPolygon)face.v1, (Elements.Orient)((Object)face.v2), ix));
                ++ix;
            }
        }
        System.out.println("Floor face count: " + result.size());
        return result;
    }

    private ExtractResults extract(VentusData md, Collection<? extends ImportedGeom> pickGeom, ExtractProps eprops) throws ExtractException, CancellationException {
        ExtractInfo einfo = new ExtractInfo(md, eprops);
        IFilteredCollection<ImportedGeom> floorGeom = theUtil.filter(pickGeom, GenerateModelFromBIM.getFloorFilter());
        Pair<Model, LinkedHashMap<Integer, ImportedGeom>> result = this.generateFloor(einfo, floorGeom);
        NameGenerator roomNames = new NameGenerator("");
        int[] nonBoundGroup = new int[]{0};
        Model resultModel = (Model)result.v1;
        for (Face face : resultModel.getFaces()) {
            face.addGroup(0);
        }
        Iterator<AModelObj> iterator = resultModel.getEdges().iterator();
        while (iterator.hasNext()) {
            Edge edge;
            edge.addGroup(GenerateModelFromBIM.isBoundaryEdge(edge = (Edge)iterator.next()) ? 1 : 0);
        }
        for (Vertex vert : resultModel.getVerts()) {
            vert.groups = nonBoundGroup;
        }
        resultModel = this.removeInvalidRooms(einfo, resultModel);
        ArrayList<? extends ISchematicComp> newObjs = new ArrayList<ISchematicComp>();
        Consumer<Edge> addUsedEdge = e -> {};
        Predicate<Edge> keepEdges = Predicates.alwaysFalse();
        this.d_progress.nextStep(Intl.intl("Finishing up"), -1);
        int[] boundary = new int[]{1};
        for (Edge edge : resultModel.getEdges()) {
            if (edge.partOfGroup(1)) {
                edge.groups = boundary;
                continue;
            }
            edge.groups = nonBoundGroup;
        }
        SchematicRoom room = new SchematicRoom("", resultModel);
        this.checkCancelled();
        LinkedIdentityHashSet<SchematicRoom> newRooms = new LinkedIdentityHashSet<SchematicRoom>((Collection<SchematicRoom>)room.separate());
        LinkedIdentityHashMap importedRoomGeom = new LinkedIdentityHashMap();
        for (SchematicRoom newRoom : newRooms) {
            String name;
            this.checkCancelled();
            IdentityHashMap<ImportedGeom, Double> geomAreas = new IdentityHashMap<ImportedGeom, Double>();
            for (Face face : newRoom.getModel().getFaces()) {
                for (int gid : face.groups) {
                    ImportedGeom ig2 = (ImportedGeom)((LinkedHashMap)result.v2).get(gid);
                    if (ig2 == null) continue;
                    geomAreas.merge(ig2, face.getArea(), (v1, v2) -> v1 + v2);
                }
            }
            Optional<ImportedGeom> prioritisedGeom = geomAreas.entrySet().stream().max((e1, e2) -> ((ImportedGeom)e1.getKey()).isA(ImportType.ROOM) != ((ImportedGeom)e2.getKey()).isA(ImportType.ROOM) ? (((ImportedGeom)e1.getKey()).isA(ImportType.ROOM) ? 1 : -1) : Double.compare((Double)e1.getValue(), (Double)e2.getValue())).map(e -> (ImportedGeom)e.getKey());
            if (prioritisedGeom.isPresent() && prioritisedGeom.get().isA(ImportType.ROOM)) {
                ImportedGeom ig3 = prioritisedGeom.get();
                if (!importedRoomGeom.containsKey(ig3)) {
                    importedRoomGeom.put(ig3, new ArrayList());
                }
                ((Collection)importedRoomGeom.get(ig3)).add(newRoom);
            }
            if (prioritisedGeom.isPresent() && eprops.nameFromImportedGeom) {
                String n = roomNames.generateValidName(prioritisedGeom.get().getName());
                roomNames.registerName(n);
                name = n;
            } else {
                name = "";
            }
            Object object = newRoom.getModel().getFaces().iterator();
            while (object.hasNext()) {
                Face face = (Face)object.next();
                face.groups = nonBoundGroup;
            }
            newRoom.setName(name);
        }
        this.checkCancelled();
        for (SchematicRoom newRoom : newRooms) {
            newRoom.setModel(GenerateModelFromBIM.cleanup(newRoom.getModel(), keepEdges));
        }
        this.checkCancelled();
        newObjs.addAll(newRooms);
        this.checkCancelled();
        IFilteredCollection<ImportedGeom> buildingGeom = theUtil.filter(pickGeom, ig -> ig.isA(ImportType.BUILDING));
        ExtractResults results = new ExtractResults();
        results.newObjs = newObjs;
        return results;
    }

    private Model removeInvalidRooms(ExtractInfo einfo, Model floorModel) {
        this.d_progress.nextStep(Intl.intl("Closing gaps and removing invalid rooms"), -1);
        ExtractProps eprops = einfo.eprops;
        if (eprops.get(CLOSE_GAPS).booleanValue()) {
            theTimer timer = new theTimer();
            floorModel = CloseGapsAction.closeGaps(floorModel, eprops.closeGapSize);
            System.out.printf("gaps closed: %g%n", timer.curr());
        }
        this.checkCancelled();
        if (eprops.get(DEL_SMALL_ROOMS).booleanValue()) {
            this.removeSmallRooms(einfo, floorModel);
        }
        return floorModel;
    }

    private void removeSmallRooms(ExtractInfo einfo, Model floorModel) {
        ExtractProps eprops = einfo.eprops;
        ArrayList toDelete = new ArrayList();
        IdentityHashSet closed = new IdentityHashSet();
        for (Face face : floorModel.getFaces()) {
            this.checkCancelled();
            if (closed.contains(face)) continue;
            ArrayList connected = new ArrayList();
            GenerateModelFromBIM.getConnectedFaces(face, connected::add);
            double totArea = 0.0;
            for (Face cface : connected) {
                totArea += cface.getArea();
            }
            if (totArea <= eprops.minRoomArea) {
                toDelete.addAll(connected);
            }
            closed.addAll(connected);
        }
        for (Face face : toDelete) {
            this.checkCancelled();
            floorModel.deleteFace(face, true, true);
        }
    }

    private static boolean isSolid(IGeomNode node) {
        IGeom geom = node.getLocalGeom();
        if (geom.getNumPrims(1) > 0 && geom.isShell()) {
            return false;
        }
        return node.getChildren().stream().allMatch(GenerateModelFromBIM::isSolid);
    }

    private static boolean isSolid(ImportedGeom ig) {
        IGeomNode node = ig.getGeom();
        return node.getNumPrims(1) > 0 && GenerateModelFromBIM.isSolid(node);
    }

    private void removeFacesInSolids(ExtractInfo einfo, Model floorModel) throws CancellationException {
        this.checkCancelled();
        LinkedIdentityHashSet solidObjs = new LinkedIdentityHashSet();
        Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
        for (ImportedGeom ig2 : einfo.md.sceneGeom.flatten(ImportedGeom.class, obstFilter)) {
            AABox bounds;
            Iterator<Face> node = ig2.getGeom();
            if (!GenerateModelFromBIM.isSolid(ig2) || (bounds = node.getBoundingBox(new AABox())).getWidth() < 3.0E-6 || bounds.getDepth() < 3.0E-6 || bounds.getHeight() < 3.0E-6) continue;
            solidObjs.add(ig2);
        }
        if (solidObjs.isEmpty()) {
            return;
        }
        ArrayList facesToTest = new ArrayList();
        BiConsumer<Face, ImportedGeom> addFace = (face, ig) -> facesToTest.add(new Pair<Face, ImportedGeom>((Face)face, (ImportedGeom)ig));
        if (solidObjs.size() < floorModel.getFaces().size()) {
            for (ImportedGeom ig3 : solidObjs) {
                bounds = ig3.getBounds();
                for (Face f : floorModel.findFaces(bounds)) {
                    addFace.accept(f, ig3);
                }
            }
        } else {
            for (Face face2 : floorModel.getFaces()) {
                bounds = face2.getBounds();
                IResult<IDisplayableGeomSrc> result = (disp, ctmt) -> {
                    if (!(disp instanceof ImportedGeom)) {
                        return;
                    }
                    ImportedGeom ig = (ImportedGeom)disp;
                    if (!obstFilter.test(ig)) {
                        return;
                    }
                    addFace.accept(face2, ig);
                };
                einfo.md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), result, einfo.eprops.searchOptions);
            }
        }
        Set foundGeomsSet = facesToTest.stream().map(l -> (ImportedGeom)l.v2).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
        ArrayList foundGeomsList = new ArrayList(foundGeomsSet);
        Map igSearches = Collections.synchronizedMap(new IdentityHashMap());
        MTProcessor mtproc = new MTProcessor(Runtime.getRuntime().availableProcessors(), MTProcessor.Schedule.GUIDED, new MTListProcessorPool());
        this.mtproc(mtproc, foundGeomsList, (ig, tix, ix) -> {
            RTree<IPolygon> search = new RTree<IPolygon>();
            for (Pair<IPolygon, Elements.Orient> face : einfo.faceCache.getFaces((ImportedGeom)ig)) {
                search.insert(((IPolygon)face.v1).getBoundingBox(new AABox()), (IPolygon)face.v1);
            }
            igSearches.put(ig, search);
        });
        Set<Face> facesToRemove = Collections.synchronizedSet(new LinkedIdentityHashSet());
        Collections.shuffle(facesToTest, new Random(11512195L));
        this.mtproc(mtproc, facesToTest, (pair, tix, ix) -> {
            this.checkCancelled();
            Face face = (Face)pair.v1;
            if (facesToRemove.contains(face)) {
                return;
            }
            ImportedGeom ig = (ImportedGeom)pair.v2;
            RTree solidPolys = (RTree)igSearches.get(ig);
            if (GenerateModelFromBIM.faceInSolidNotTouchingTop(floorModel, face, solidPolys)) {
                facesToRemove.add(face);
            }
        });
        for (Face face3 : facesToRemove) {
            floorModel.deleteFace(face3, true, true);
        }
    }

    private static Boolean polyTouchingTopOfSolid(IPolygon poly, RTree<IPolygon> solid) {
        Random rand = new Random(11512195L);
        Supplier<Point3d> pointGen = poly.getPointGenerator(rand, false, 1.0E-6);
        int nattempts = 10;
        for (int m = 0; m < nattempts; ++m) {
            Point3d p = pointGen.get();
            if (p == null) {
                System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".polyInSolidNotTouchingTop failed to find a point in face%n", new Object[0]);
                return null;
            }
            AABox solidBounds = solid.getBoundingBox();
            if (!solidBounds.contains(p, 1.0E-6)) {
                return false;
            }
            Inter3D.PointClassify pc = Inter3D.testPointInSolid(solid, true, p, GeomConstants.VEC3D_ZNEG, 1.0E-6);
            if (pc == null) continue;
            return pc.positive;
        }
        System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".polyInSolidNotTouchingTop failed to find valid intersection ray after %d attempts%n", nattempts);
        return null;
    }

    private static boolean faceInSolidNotTouchingTop(Model model, Face face, RTree<IPolygon> solid) {
        Random rand = new Random(11512195L);
        int nattempts = 10;
        for (int m = 0; m < nattempts; ++m) {
            Point3d p = model.findRandomPointInFace(face, rand);
            if (p == null) {
                System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".faceInSolidNotTouchingTop failed to find a point in face%n", new Object[0]);
                return false;
            }
            AABox solidBounds = solid.getBoundingBox();
            if (!solidBounds.contains(p, 1.0E-6)) {
                return false;
            }
            Inter3D.PointClassify pc = Inter3D.testPointInSolid(solid, true, p, GeomConstants.VEC3D_ZPOS, 1.0E-6);
            if (pc == null) continue;
            return pc.positive;
        }
        System.err.printf(GenerateModelFromBIM.class.getSimpleName() + ".faceInSolidNotTouchingTop failed to find valid intersection ray after %d attempts%n", nattempts);
        return false;
    }

    private static Vector3d getEdgeNormal(EdgeUse eu, boolean out) {
        Vector3d eudir = eu.getTangent(0.0);
        Vector3d fnormal = eu.edge.faces.get((int)0).plane.getNormal();
        Vector3d stairDir = out ? Util3D.cross(eudir, fnormal) : Util3D.cross(fnormal, eudir);
        stairDir.z = 0.0;
        if (Util3D.safeNormalize(stairDir, 1.0E-9) == 0.0) {
            return null;
        }
        return stairDir;
    }

    private static Vector3d getEdgeNormal(Edge edge, boolean out) {
        if (edge.faces.size() != 1) {
            return null;
        }
        Face face = edge.faces.get(0);
        List<EdgeUse> eus = face.getUses(edge);
        if (eus.size() != 1) {
            return null;
        }
        return GenerateModelFromBIM.getEdgeNormal(eus.get(0), out);
    }

    private static double getOverlapAmount2d(Edge e1, Edge e2) {
        double[] overlap = GenerateModelFromBIM.getOverlap2dE1(e1, 0.0, 1.0, e2, 0.0, 1.0);
        return Math.abs(overlap[0] - overlap[1]);
    }

    private static double[][] getOverlap2d(Edge e1, double e1t1, double e1t2, Edge e2, double e2t1, double e2t2) {
        double[] e1t = GenerateModelFromBIM.getOverlap2dE1(e1, e1t1, e1t2, e2, e2t1, e2t2);
        double[] e2t = GenerateModelFromBIM.getOverlap2dE1(e2, e2t1, e2t2, e1, e1t[0], e1t[1]);
        return new double[][]{e1t, e2t};
    }

    private static double[] getOverlap2dE1(Edge e1, double e1t1, double e1t2, Edge e2, double e2t1, double e2t2) {
        double[] e1range = Util.rectify(e1t1, e1t2);
        Point3d e2p1 = e2.curve.get(e2t1);
        Point3d e2p2 = e2.curve.get(e2t2);
        e1t1 = Inter2D.nearestTOnLineSeg(e2p1.x, e2p1.y, e1.v1.loc.x, e1.v1.loc.y, e1.v2.loc.x, e1.v2.loc.y);
        e1t1 = Util.clampT(e1t1, e1range[0], e1range[1]);
        e1t2 = Inter2D.nearestTOnLineSeg(e2p2.x, e2p2.y, e1.v1.loc.x, e1.v1.loc.y, e1.v2.loc.x, e1.v2.loc.y);
        e1t2 = Util.clampT(e1t2, e1range[0], e1range[1]);
        return new double[]{e1t1, e1t2};
    }

    private static boolean isConnected(Face f1, Face f2) {
        if (f1 == f2) {
            return true;
        }
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.push(f1);
        IdentityHashSet closed = new IdentityHashSet();
        closed.add(f1);
        while (!open.isEmpty()) {
            Face f = (Face)open.pop();
            for (FaceLoop loop : f.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1)) continue;
                    for (Face aface : eu.edge.faces) {
                        if (aface == f || !closed.add(aface)) continue;
                        if (aface == f2) {
                            return true;
                        }
                        open.push(aface);
                    }
                }
            }
        }
        return false;
    }

    private static void getConnectedFaces(Face seed, Consumer<Face> result) {
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.push(seed);
        IdentityHashSet closed = new IdentityHashSet();
        closed.add(seed);
        while (!open.isEmpty()) {
            Face f = (Face)open.pop();
            result.accept(f);
            for (FaceLoop loop : f.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1)) continue;
                    for (Face aface : eu.edge.faces) {
                        if (!closed.add(aface)) continue;
                        open.push(aface);
                    }
                }
            }
        }
    }

    private static List<List<Edge>> getParallelSets(List<Edge> edges) {
        ArrayList<List<Edge>> result = new ArrayList<List<Edge>>();
        BitSet closed = new BitSet();
        for (int m = 0; m < edges.size(); ++m) {
            if (closed.get(m)) continue;
            closed.set(m);
            Edge e1 = edges.get(m);
            Vector3d e1dir = e1.curve.getTangent(0.0);
            if (Util3D.safeNormalize(e1dir, 1.0E-9) == 0.0) continue;
            ArrayList<Edge> edgeSet = new ArrayList<Edge>();
            edgeSet.add(e1);
            for (int n = m + 1; n < edges.size(); ++n) {
                if (closed.get(n)) continue;
                Edge e2 = edges.get(n);
                Vector3d e2dir = e2.curve.getTangent(0.0);
                if (Util3D.safeNormalize(e2dir, 1.0E-9) == 0.0) {
                    closed.set(n);
                    continue;
                }
                if (!Util3D.testParallel(e1dir, e2dir, 1.0E-6)) continue;
                edgeSet.add(e2);
                closed.set(n);
            }
            result.add(edgeSet);
        }
        return result;
    }

    private static double getZ(Edge edge) {
        return (edge.v1.loc.z + edge.v2.loc.z) * 0.5;
    }

    private static List<Edge> findNextStairEnd(ExtractProps eprops, List<List<Edge>> edgeSets, EdgeUse seedEdgeUse, Vector3d stairDir, boolean posDir) {
        Optional<List> oedgeSet = edgeSets.stream().filter(eset -> eset.contains(seedEdgeUse.edge)).findFirst();
        if (oedgeSet.isEmpty()) {
            return Collections.emptyList();
        }
        Edge seedEdge = seedEdgeUse.edge;
        ToDoubleFunction<Edge> getT = e -> Util3D.dot(stairDir, e.v1.loc);
        TreeMap<Double, List> sortedEdges = new TreeMap<Double, List>((e1, e2) -> theUtil.compare(e1, e2, 0.001));
        for (Edge edge : oedgeSet.get()) {
            sortedEdges.computeIfAbsent(getT.applyAsDouble(edge), e -> new ArrayList()).add(edge);
        }
        ArrayList edgeSet = new ArrayList(sortedEdges.entrySet());
        IdentityHashSet visitedEdges = new IdentityHashSet();
        Function<Pair, Pair> findEdgeOnNextStep = fromInfo -> {
            Edge fromEdge = (Edge)fromInfo.v1;
            double fromZ = GenerateModelFromBIM.getZ(fromEdge);
            int fromIx = (Integer)fromInfo.v2;
            double fromT = (Double)((Map.Entry)edgeSet.get(fromIx)).getKey();
            Face fromFace = fromEdge.faces.get(0);
            for (int m = fromIx; m < edgeSet.size(); ++m) {
                Map.Entry eentry = (Map.Entry)edgeSet.get(m);
                double t = (Double)eentry.getKey();
                if (Math.abs(t - fromT) > eprops.maxStairTreadGap) {
                    return fromInfo;
                }
                Edge bestEdge = null;
                double bestEdgeOverlap = 0.0;
                for (Edge e : (List)eentry.getValue()) {
                    double overlapAmount;
                    EdgeUse eeu;
                    Vector3d inDir;
                    List<EdgeUse> eus;
                    double z;
                    if (e == fromEdge || visitedEdges.contains(e) || e.faces.get(0) == fromFace || theUtil.eq(fromZ, z = GenerateModelFromBIM.getZ(e), 0.001) || Math.abs(z - fromZ) > eprops.maxStairRiser || (eus = e.faces.get(0).getUses(e)).size() != 1 || (inDir = GenerateModelFromBIM.getEdgeNormal(eeu = eus.get(0), false)) == null || inDir.dot(stairDir) <= 0.0 || theUtil.le0(overlapAmount = GenerateModelFromBIM.getOverlapAmount2d(fromEdge, e), 1.0E-6) || bestEdge != null && !(overlapAmount > bestEdgeOverlap)) continue;
                    bestEdge = e;
                    bestEdgeOverlap = overlapAmount;
                }
                if (bestEdge == null) continue;
                return new Pair<Object, Integer>(bestEdge, m);
            }
            return fromInfo;
        };
        Function<Pair, Pair> findNextEdgeOnCurrStep = fromInfo -> {
            int fromIx = (Integer)fromInfo.v2;
            Edge fromEdge = (Edge)fromInfo.v1;
            Face fromFace = fromEdge.faces.get(0);
            for (int m = fromIx + 1; m < edgeSet.size(); ++m) {
                Map.Entry eentry = (Map.Entry)edgeSet.get(m);
                Edge bestEdge = null;
                double bestEdgeOverlap = 0.0;
                for (Edge e : (List)eentry.getValue()) {
                    double overlapAmount;
                    EdgeUse eeu;
                    Vector3d outDir;
                    List<EdgeUse> eus;
                    Face f;
                    assert (e != fromEdge);
                    if (visitedEdges.contains(e) || !GenerateModelFromBIM.isConnected(fromFace, f = e.faces.get(0)) || (eus = f.getUses(e)).size() != 1 || (outDir = GenerateModelFromBIM.getEdgeNormal(eeu = eus.get(0), true)) == null || outDir.dot(stairDir) <= 0.0 || theUtil.le0(overlapAmount = GenerateModelFromBIM.getOverlapAmount2d(fromEdge, e), 1.0E-6) || bestEdge != null && !(overlapAmount > bestEdgeOverlap)) continue;
                    bestEdge = e;
                    bestEdgeOverlap = overlapAmount;
                }
                if (bestEdge == null) continue;
                return new Pair<Object, Integer>(bestEdge, m);
            }
            return fromInfo;
        };
        ArrayList<Edge> result = new ArrayList<Edge>();
        Consumer<Pair> addEdge = e -> {
            result.add((Edge)e.v1);
            visitedEdges.add((Edge)e.v1);
        };
        int seedListIx = -1;
        for (int m = 0; m < edgeSet.size(); ++m) {
            if (!((List)((Map.Entry)edgeSet.get(m)).getValue()).contains(seedEdge)) continue;
            seedListIx = m;
            break;
        }
        if (seedListIx == -1) {
            return Collections.emptyList();
        }
        Pair seedIx = new Pair(seedEdge, seedListIx);
        if (posDir) {
            addEdge.accept(seedIx);
            Pair nextStepEdgeIx = findEdgeOnNextStep.apply(seedIx);
            if (nextStepEdgeIx == seedIx) {
                result.clear();
                return result;
            }
            seedIx = nextStepEdgeIx;
            addEdge.accept(seedIx);
        }
        Pair edgeIx = seedIx;
        Pair nextStepEdgeIx;
        while ((nextStepEdgeIx = findNextEdgeOnCurrStep.apply(edgeIx)) != edgeIx) {
            edgeIx = nextStepEdgeIx;
            addEdge.accept(edgeIx);
            nextStepEdgeIx = findEdgeOnNextStep.apply(edgeIx);
            if (nextStepEdgeIx == edgeIx) {
                assert (result.size() > 0);
                result.remove(result.size() - 1);
                return result;
            }
            edgeIx = nextStepEdgeIx;
            addEdge.accept(edgeIx);
        }
        return result;
    }

    private boolean canReach(ExtractInfo einfo, Edge fromEdge, Edge toEdge, Predicate<? super ImportedGeom> obstFilter) {
        Vector3d normal = GenerateModelFromBIM.getEdgeNormal(fromEdge, true);
        ToDoubleFunction<Edge> getT = e -> Util3D.dot(normal, e.v1.loc);
        double t1 = getT.applyAsDouble(fromEdge);
        double t2 = getT.applyAsDouble(toEdge);
        return this.canReach(einfo, fromEdge, toEdge, Math.abs(t2 - t1), obstFilter);
    }

    private boolean canReach(ExtractInfo einfo, Edge fromEdge, Edge toEdge, double tdist, Predicate<? super ImportedGeom> obstFilter) {
        Vector3d toDir;
        ExtractProps eprops = einfo.eprops;
        double[][] overlap = GenerateModelFromBIM.getOverlap2d(fromEdge, 0.0, 1.0, toEdge, 0.0, 1.0);
        double maxShrinkDist = 0.1;
        BiFunction<Edge, double[], double[]> shrinkEdge = (edge, ts) -> {
            double length = edge.curve.length();
            double tlength = Math.abs(ts[0] - ts[1]);
            double edgeShrinkT = maxShrinkDist / length;
            double middleT = (ts[0] + ts[1]) * 0.5;
            double newWidthT = tlength - edgeShrinkT;
            if (newWidthT < 0.001 && (newWidthT = 0.001) > tlength) {
                return ts;
            }
            double halfWidthT = newWidthT * 0.5;
            return new double[]{middleT - halfWidthT, middleT + halfWidthT};
        };
        overlap[0] = shrinkEdge.apply(fromEdge, overlap[0]);
        overlap[1] = shrinkEdge.apply(toEdge, overlap[1]);
        double fromz = GenerateModelFromBIM.getZ(fromEdge);
        double toz = GenerateModelFromBIM.getZ(toEdge);
        double offsetz = Util.clampT(eprops.maxStairRiser - Math.abs(fromz - toz), 0.001, eprops.headHeight);
        BiFunction<Point3d, Double, Point3d> offsetUp = (p, z) -> new Point3d(p.x, p.y, p.z + z);
        BiFunction<Point3d, Point3d, Point3d[]> extrudeEdgeUp = (ehp1, ehp2) -> {
            Point3d p1 = (Point3d)offsetUp.apply((Point3d)ehp1, offsetz);
            Point3d p2 = (Point3d)offsetUp.apply((Point3d)ehp2, offsetz);
            Point3d p3 = (Point3d)offsetUp.apply((Point3d)ehp2, eprops.headHeight);
            Point3d p4 = (Point3d)offsetUp.apply((Point3d)ehp1, eprops.headHeight);
            return new Point3d[]{p1, p2, p3, p4};
        };
        if (theUtil.eq0(tdist, 1.0E-6)) {
            Point3d ehp22;
            Edge higherEdge = fromz > toz ? fromEdge : toEdge;
            double[] higherOverlap = fromz > toz ? overlap[0] : overlap[1];
            Point3d ehp12 = higherEdge.curve.get(higherOverlap[0]);
            Point3d[] quad = extrudeEdgeUp.apply(ehp12, ehp22 = higherEdge.curve.get(higherOverlap[1]));
            Plane3d quadPlane = Util3D.simplePolygonPlane(Arrays.asList(quad), true);
            if (quadPlane == null) {
                return true;
            }
            AABox searchBox = new AABox(quad);
            CollResult foundObjs = new CollResult(ImportedGeom.class, obstFilter);
            einfo.md.geomLocation.getLocator().find((ITest<AABox>)searchBox, foundObjs, eprops.searchOptions);
            Point3d[] triPoints = new Point3d[3];
            List<Point3d> triList = Arrays.asList(triPoints);
            for (ImportedGeom ig : foundObjs.coll) {
                this.checkCancelled();
                Collection<Pair<Triangle, Elements.Orient>> tris = einfo.faceCache.getTris(einfo.md, ig);
                for (Pair<Triangle, Elements.Orient> tri : tris) {
                    this.checkCancelled();
                    triPoints[0] = ((Triangle)tri.v1).p1;
                    triPoints[1] = ((Triangle)tri.v1).p2;
                    triPoints[2] = ((Triangle)tri.v1).p3;
                    Plane3d triPlane = Util3D.simplePolygonPlane(triList, true);
                    if (triPlane == null || !Inter3D.testConvexPolyConvexPoly(quad, quadPlane, triPoints, triPlane, 1.0E-6)) continue;
                    return false;
                }
            }
            return true;
        }
        Point3d e1p1 = fromEdge.curve.get(overlap[0][0]);
        Point3d e1p2 = fromEdge.curve.get(overlap[0][1]);
        Point3d e2p1 = toEdge.curve.get(overlap[1][0]);
        Point3d e2p2 = toEdge.curve.get(overlap[1][1]);
        Vector3d fromDir = Util3D.vector(e1p1, e1p2);
        Vector3d cross = Util3D.cross(fromDir, Util3D.vector(e1p1, e2p1));
        if (cross.z < 0.0) {
            Point3d t = e1p1;
            e1p1 = e1p2;
            e1p2 = t;
            fromDir.negate();
        }
        if ((toDir = Util3D.vector(e2p1, e2p2)).dot(fromDir) > 0.0) {
            Point3d t = e2p1;
            e2p1 = e2p2;
            e2p2 = t;
        }
        Point3d[] fromQuad = extrudeEdgeUp.apply(e1p1, e1p2);
        Point3d[] toQuad = extrudeEdgeUp.apply(e2p1, e2p2);
        ArrayList<Point3d[]> quads = new ArrayList<Point3d[]>();
        quads.add(fromQuad);
        quads.add(toQuad);
        QuadConsumer<Point3d, Point3d, Point3d, Point3d> addQuad = (p1, p2, p3, p4) -> quads.add(new Point3d[]{p1, p2, p3, p4});
        addQuad.accept(fromQuad[0], fromQuad[3], toQuad[2], toQuad[1]);
        addQuad.accept(fromQuad[1], toQuad[0], toQuad[3], fromQuad[2]);
        addQuad.accept(fromQuad[0], toQuad[1], toQuad[0], fromQuad[1]);
        addQuad.accept(fromQuad[3], fromQuad[2], toQuad[3], toQuad[2]);
        ArrayList<Plane3d> planes = new ArrayList<Plane3d>(6);
        for (Point3d[] quad : quads) {
            Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(quad), true);
            if (plane == null) continue;
            planes.add(plane);
        }
        ConvexHull ch = new ConvexHull(planes);
        AABox searchBox = new AABox();
        searchBox.add(fromQuad);
        searchBox.add(toQuad);
        CollResult foundObjs = new CollResult(ImportedGeom.class, obstFilter);
        ITest<AABox> test = box -> {
            Containment c = searchBox.test((AABox)box, 1.0E-6);
            if (c == Containment.OUTSIDE) {
                return c;
            }
            return ch.test((AABox)box, 1.0E-6);
        };
        einfo.md.geomLocation.getLocator().find(test, foundObjs, eprops.searchOptions);
        DefaultFilter pickFilter = new DefaultFilter(GeomType.FACE);
        final boolean[] intersected = new boolean[]{false};
        for (ImportedGeom ig : foundObjs.coll) {
            this.checkCancelled();
            IBoxCollector pickResult = new IBoxCollector(){

                @Override
                public void addNonFace(Object obj, int primIx, IPrimElements primElements) throws CancelObjectPicking {
                }

                @Override
                public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal, IPrimElements faceElements, IPrimProps faceProps) throws CancelObjectPicking {
                    intersected[0] = true;
                    throw new CancelObjectPicking();
                }
            };
            ig.pickBox(pickResult, pickFilter, ch);
            if (!intersected[0]) continue;
            return false;
        }
        return true;
    }

    private static Predicate<ImportedGeom> getObstFilter(ExtractInfo einfo) {
        Predicate<ImportedGeom> obstFilter = o -> !o.isA(ImportType.IGNORED) && !o.isA(ImportType.ROOM) && !o.isA(ImportType.DOOR);
        return obstFilter;
    }

    private List<Edge> getExtraStairEdges(ExtractInfo einfo, Model floorModel, Edge stairEdge, Predicate<Edge> edgeFilter) {
        if (stairEdge.faces.size() != 1) {
            return Collections.emptyList();
        }
        ExtractProps eprops = einfo.eprops;
        Face f = stairEdge.faces.get(0);
        List<EdgeUse> eus = f.getUses(stairEdge);
        if (eus.size() != 1) {
            return Collections.emptyList();
        }
        EdgeUse eu = eus.get(0);
        Vector3d normal = GenerateModelFromBIM.getEdgeNormal(eu, true);
        if (normal == null) {
            return Collections.emptyList();
        }
        Vector3d e1dir = stairEdge.curve.getTangent(0.0);
        double e1len = Util3D.safeNormalize(e1dir, 1.0E-9);
        if (e1len == 0.0) {
            return Collections.emptyList();
        }
        double xydist = eprops.maxStairTreadGap;
        double zdist = eprops.maxStairRiser;
        LineSeg ls = GenerateModelFromBIM.toLineSeg(stairEdge);
        LineSeg lsa = ls.transform(TransformUtil.translate(normal.x * xydist, normal.y * xydist, zdist).getInfo(), 0);
        LineSeg lsb = ls.transform(TransformUtil.translate(normal.x * xydist, normal.y * xydist, -zdist).getInfo(), 0);
        AABox searchBox = new AABox();
        ls.getBoundingBox(searchBox);
        lsa.getBoundingBox(searchBox);
        lsb.getBoundingBox(searchBox);
        List<Edge> nearEdges = floorModel.findEdges(searchBox);
        if (nearEdges.isEmpty()) {
            return Collections.emptyList();
        }
        ToDoubleFunction<Edge> getT = e -> Util3D.dot(normal, e.v1.loc);
        double stairEdgeT = getT.applyAsDouble(stairEdge);
        double stairEdgeZ = GenerateModelFromBIM.getZ(stairEdge);
        double overlapTol = eprops.minCompWidth / e1len;
        ArrayList<Edge> nearestEdges = new ArrayList<Edge>();
        Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
        TriConsumer<Edge, Double, Double> tryAdd = (edge, edget, tdist) -> {
            double[] edgeOverlap = null;
            ArrayList<Edge> toRemove = new ArrayList<Edge>();
            for (Edge nearestEdge : nearestEdges) {
                if (edgeOverlap == null) {
                    edgeOverlap = GenerateModelFromBIM.getOverlap2dE1(stairEdge, 0.0, 1.0, edge, 0.0, 1.0);
                    edgeOverlap = Util.rectify(edgeOverlap);
                }
                double[] nearestOverlap = GenerateModelFromBIM.getOverlap2dE1(stairEdge, 0.0, 1.0, nearestEdge, 0.0, 1.0);
                if (!theUtil.lt(edgeOverlap[0], (nearestOverlap = Util.rectify(nearestOverlap))[1], 0.001) || !theUtil.gt(edgeOverlap[1], nearestOverlap[0], 0.001)) continue;
                double nearestT = getT.applyAsDouble(nearestEdge);
                if (theUtil.gt(edget, nearestT, 0.001)) {
                    return;
                }
                toRemove.add(nearestEdge);
            }
            if (!this.canReach(einfo, stairEdge, (Edge)edge, (double)tdist, (Predicate<? super ImportedGeom>)obstFilter)) {
                return;
            }
            nearestEdges.removeAll(toRemove);
            nearestEdges.add((Edge)edge);
        };
        for (Edge edge2 : nearEdges) {
            EdgeUse eu2;
            Vector3d normal2;
            Face f2;
            List<EdgeUse> eus2;
            double edgez;
            double tdist2;
            double edget2;
            double overlap;
            Vector3d e2dir;
            if (edge2 == stairEdge || !edgeFilter.test(edge2) || Util3D.safeNormalize(e2dir = edge2.curve.getTangent(0.0), 1.0E-9) == 0.0 || !Util3D.testParallel(e1dir, e2dir, 1.0E-6) || (overlap = GenerateModelFromBIM.getOverlapAmount2d(stairEdge, edge2)) <= overlapTol || theUtil.lt(edget2 = getT.applyAsDouble(edge2), stairEdgeT, 0.001) || (tdist2 = Math.abs(edget2 - stairEdgeT)) > eprops.maxStairTreadGap || theUtil.eq(edgez = GenerateModelFromBIM.getZ(edge2), stairEdgeZ, 1.0E-6) || Math.abs(edgez - stairEdgeZ) > eprops.maxStairRiser || (eus2 = (f2 = edge2.faces.get(0)).getUses(edge2)).size() != 1 || (normal2 = GenerateModelFromBIM.getEdgeNormal(eu2 = eus2.get(0), false)) == null || normal2.dot(normal) < 0.0) continue;
            tryAdd.accept(edge2, edget2, tdist2);
        }
        return nearestEdges;
    }

    private static boolean isAStair(ImportedGeom ig) {
        switch (ig.getImportedType()) {
            case STAIR: 
            case ESCALATOR: {
                return true;
            }
        }
        return false;
    }

    private static LineSeg toLineSeg(Edge e) {
        return new LineSeg(e.v1.loc, e.v2.loc);
    }

    private static Model cleanup(Model floorModel, Predicate<Edge> usedEdges) {
        theTimer timer = new theTimer();
        Model resultModel = RoomUtil.cleanup(floorModel, 63, usedEdges, true);
        System.out.printf("room cleanup complete: %g s%n", timer.curr());
        return resultModel;
    }

    private static IPolygon newPoly(double ... vals) {
        int count = vals.length / 3;
        Point3d[] points = new Point3d[count];
        int m = 0;
        int pix = 0;
        while (m < vals.length) {
            double x = vals[m++];
            double y = vals[m++];
            double z = vals[m++];
            points[pix] = new Point3d(x, y, z);
            ++pix;
        }
        return PolyUtil.newPoly(points);
    }

    private Pair<Model, LinkedHashMap<Integer, ImportedGeom>> generateFloor(ExtractInfo einfo, Collection<? extends ImportedGeom> geom) throws ExtractException, CancellationException {
        ExtractProps eprops = einfo.eprops;
        double headHeight = eprops.headHeight;
        Collection<GeomFace> pickFaces = GenerateModelFromBIM.findFloorFaces(einfo, geom);
        if (pickFaces.isEmpty()) {
            throw new ExtractException(ExtractException.Type.NO_VALID_FACES);
        }
        Vector3d extrudeDir = new Vector3d(0.0, 0.0, headHeight);
        int wallGroup = Integer.MAX_VALUE;
        IdentityHashMap<ImportedGeom, Integer> geomIds = new IdentityHashMap<ImportedGeom, Integer>();
        LinkedHashMap idGeoms = new LinkedHashMap();
        this.d_progress.nextStep(Intl.intl("Adding floor faces"), pickFaces.size());
        Model floorModel = new Model();
        for (GeomFace face : pickFaces) {
            this.d_progress.increment();
            Integer id = geomIds.computeIfAbsent(face.geom, g -> {
                int result = einfo.nextId();
                idGeoms.put(result, g);
                return result;
            });
            GenerateModelFromBIM.addFaceToModel(einfo.md, face.face, face.orient == Elements.Orient.CCW, floorModel, id);
        }
        this.subtractObstructions(einfo, floorModel, extrudeDir, Integer.MAX_VALUE);
        if (eprops.get(DEL_SMALL_ROOMS).booleanValue()) {
            this.removeSmallRooms(einfo, floorModel);
        }
        if (eprops.get(DEL_ROOMS_IN_SOLIDS).booleanValue()) {
            this.removeFacesInSolids(einfo, floorModel);
        }
        return new Pair<Model, LinkedHashMap<Integer, ImportedGeom>>(floorModel, idGeoms);
    }

    private static double getSlopeRad(Vector3d normal) {
        double slope = 1.5707963267948966 - Math.atan2(normal.z, Math.sqrt(normal.x * normal.x + normal.y * normal.y));
        return slope;
    }

    private <T> void mtproc(MTProcessor mtproc, List<T> items, MTProcessor.IProc<T> proc) throws CancellationException {
        try {
            mtproc.process(items, proc);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private void subtractObstructions(ExtractInfo einfo, Model floorModel, Vector3d extrudeDir, int wallGroup) throws CancellationException {
        this.d_progress.nextStep(Intl.intl("Finding overhead obstructions"), floorModel.getFaces().size());
        MTProcessor mtproc = new MTProcessor(Runtime.getRuntime().availableProcessors(), MTProcessor.Schedule.GUIDED, new MTListProcessorPool());
        VentusData md = einfo.md;
        FaceCache faceCache = einfo.faceCache;
        int options = einfo.eprops.searchOptions;
        md.geomLocation.updateDirty();
        Predicate<ImportedGeom> obstFilter = GenerateModelFromBIM.getObstFilter(einfo);
        Locator[] geomFinders = new Locator[mtproc.getNumThreads()];
        for (int m = 0; m < mtproc.getNumThreads(); ++m) {
            geomFinders[m] = new Locator<ImportedGeom>(ImportedGeom.class, obstFilter);
        }
        ArrayList obstructions = new ArrayList();
        this.mtproc(mtproc, new ArrayList<Face>(floorModel.getFaces()), (face, tix, ix) -> {
            this.d_progress.increment();
            AABox extrudedBounds = face.getBounds();
            extrudedBounds = new AABox(extrudedBounds.getMin(), Util3D.add(extrudedBounds.getMax(), (Tuple3d)extrudeDir));
            Locator geomFinder = geomFinders[tix];
            geomFinder.reset(extrudedBounds);
            md.geomLocation.getLocator().find((ITest<AABox>)geomFinder.test, geomFinder.result, options);
            if (geomFinder.getResult().isEmpty()) {
                return;
            }
            NavigableMap<Double, Pair<ImportedGeom, AABox>> overhangFaces = new TreeMap(s_areaComp);
            for (ImportedGeom potGeom : geomFinder.getResult()) {
                this.checkCancelled();
                AABox bb = potGeom.getBounds();
                double area = bb.getWidth() * bb.getDepth();
                overhangFaces.put(area, new Pair<ImportedGeom, AABox>(potGeom, bb));
            }
            overhangFaces = overhangFaces.descendingMap();
            List list = obstructions;
            synchronized (list) {
                obstructions.add(new Pair(new Pair<Face, AABox>((Face)face, extrudedBounds), overhangFaces.values()));
            }
        });
        int totalFacePairs = 0;
        for (Pair entry2 : obstructions) {
            for (Pair obstruction : (Collection)entry2.v2) {
                totalFacePairs += faceCache.getFaces((ImportedGeom)obstruction.v1).size();
            }
        }
        this.d_progress.nextStep(Intl.intl("Subtractring obstructions"), totalFacePairs);
        ArrayList toDelete = new ArrayList();
        ArrayList toAdd = new ArrayList();
        this.mtproc(mtproc, obstructions, (entry, tix, ix) -> {
            this.checkCancelled();
            Face face = (Face)((Pair)entry.v1).v1;
            AABox extrudedBounds = (AABox)((Pair)entry.v1).v2;
            Collection overhangFaces = (Collection)entry.v2;
            Plane3d bplane = face.plane;
            if (bplane.z < 0.0) {
                bplane = bplane.negate();
            }
            Matrix4d xform = Util.translateMat(extrudeDir.x, extrudeDir.y, extrudeDir.z);
            Plane3d tplane = bplane.transformBy(xform);
            Model newFaceModel = new Model();
            newFaceModel.addFace(face);
            Plane3d floorPlane = face.plane;
            double iz = 1.0 / floorPlane.z;
            Matrix4d projectionXform = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -floorPlane.x * iz, -floorPlane.y * iz, 0.0, -floorPlane.w * iz, 0.0, 0.0, 0.0, 1.0);
            boolean modified = false;
            AABox facebb = new AABox();
            Iterator potGeomIt = overhangFaces.iterator();
            while (potGeomIt.hasNext()) {
                PlaneCat tcat;
                Pair potGeom = (Pair)potGeomIt.next();
                this.checkCancelled();
                AABox bb = (AABox)potGeom.v2;
                Point3d[] points = bb.getVerts();
                PlaneCat bcat = GenerateModelFromBIM.categorizePointsForSubtract(bplane, points);
                if (bcat.equals((Object)PlaneCat.PLANE_BELOW) || bcat.equals((Object)PlaneCat.PLANE_ALIGNED) || (tcat = GenerateModelFromBIM.categorizePointsForSubtract(tplane, points)).equals((Object)PlaneCat.PLANE_ABOVE) || tcat.equals((Object)PlaneCat.PLANE_ALIGNED)) continue;
                Collection<Pair<IPolygon, Elements.Orient>> gfaces = faceCache.getFaces((ImportedGeom)potGeom.v1);
                if (bcat.equals((Object)PlaneCat.PLANE_ABOVE) && tcat.equals((Object)PlaneCat.PLANE_BELOW)) {
                    int fix = 0;
                    for (Pair<IPolygon, Elements.Orient> gfaceInfo : gfaces) {
                        this.d_progress.increment();
                        IPolygon gface = (IPolygon)gfaceInfo.v1;
                        facebb.reset();
                        gface.getBoundingBox(facebb);
                        if (!extrudedBounds.intersects(facebb, 1.0E-6)) continue;
                        Point3d[] verts = GenerateModelFromBIM.getVerts(gface, false);
                        modified |= GenerateModelFromBIM.projectAndSubtract(newFaceModel, verts, gface.getPlane(true), face.plane, projectionXform, wallGroup);
                        if (newFaceModel.getFaces().isEmpty()) {
                            this.d_progress.increment(gfaces.size() - fix - 1);
                            break;
                        }
                        ++fix;
                    }
                } else {
                    Object activeFaces = new ArrayList<IPolygon>(2);
                    ArrayList<IPolygon> clipFaces = new ArrayList(2);
                    int fix = 0;
                    for (Pair<IPolygon, Elements.Orient> gfaceInfo : gfaces) {
                        ArrayList<IPolygon> temp;
                        IPolygon poly;
                        PlaneCat ftcat;
                        Point3d[] verts;
                        PlaneCat fbcat;
                        this.d_progress.increment();
                        IPolygon gface = (IPolygon)gfaceInfo.v1;
                        facebb.reset();
                        gface.getBoundingBox(facebb);
                        if (!extrudedBounds.intersects(facebb, 1.0E-6) || (fbcat = GenerateModelFromBIM.categorizePointsForSubtract(bplane, verts = GenerateModelFromBIM.getVerts(gface, false))).equals((Object)PlaneCat.PLANE_BELOW) || fbcat.equals((Object)PlaneCat.PLANE_ALIGNED) || (ftcat = GenerateModelFromBIM.categorizePointsForSubtract(tplane, verts)).equals((Object)PlaneCat.PLANE_ABOVE) || ftcat.equals((Object)PlaneCat.PLANE_ALIGNED)) continue;
                        activeFaces.clear();
                        activeFaces.add(gface);
                        if (fbcat.equals((Object)PlaneCat.PLANE_INTERSECTING)) {
                            clipFaces.clear();
                            Iterator iterator = activeFaces.iterator();
                            while (iterator.hasNext()) {
                                poly = (IPolygon)iterator.next();
                                GenerateModelFromBIM.clipFace(poly, bplane, true, (Collection<IPolygon>)clipFaces);
                            }
                            temp = activeFaces;
                            activeFaces = clipFaces;
                            clipFaces = temp;
                        }
                        if (ftcat.equals((Object)PlaneCat.PLANE_INTERSECTING)) {
                            clipFaces.clear();
                            temp = activeFaces.iterator();
                            while (temp.hasNext()) {
                                poly = (IPolygon)temp.next();
                                GenerateModelFromBIM.clipFace(poly, tplane, false, clipFaces);
                            }
                            temp = activeFaces;
                            activeFaces = clipFaces;
                            clipFaces = temp;
                        }
                        Plane3d gfacePlane = gface.getPlane(true);
                        Iterator iterator = activeFaces.iterator();
                        while (iterator.hasNext()) {
                            IPolygon poly2 = (IPolygon)iterator.next();
                            modified |= GenerateModelFromBIM.projectAndSubtract(newFaceModel, GenerateModelFromBIM.getVerts(poly2, false), gfacePlane, face.plane, projectionXform, wallGroup);
                        }
                        if (newFaceModel.getFaces().isEmpty()) {
                            this.d_progress.increment(gfaces.size() - fix - 1);
                            break;
                        }
                        ++fix;
                    }
                }
                if (!newFaceModel.getFaces().isEmpty()) continue;
                int skipCount = 0;
                while (potGeomIt.hasNext()) {
                    skipCount += faceCache.getFaces((ImportedGeom)((Pair)potGeomIt.next()).v1).size();
                }
                this.d_progress.increment(skipCount);
                break;
            }
            if (modified) {
                List list = toDelete;
                synchronized (list) {
                    toDelete.add(face);
                }
                list = toAdd;
                synchronized (list) {
                    toAdd.add(newFaceModel.getFaces());
                }
            }
        });
        for (Face face2 : toDelete) {
            floorModel.deleteFace(face2, true, true);
        }
        for (Collection newFaces : toAdd) {
            floorModel.add(newFaces, Collections.emptyList(), Collections.emptyList());
        }
    }

    private static Point3d[] getOuterVerts(Face face) {
        FaceLoop outerLoop = face.outerLoop();
        if (outerLoop == null) {
            return new Point3d[0];
        }
        ArrayList<Point3d> verts = new ArrayList<Point3d>(outerLoop.edges.size());
        for (EdgeUse eu : outerLoop.edges) {
            verts.add(eu.v1().loc);
        }
        return verts.toArray(new Point3d[verts.size()]);
    }

    private static Point3d[] getVerts(IPolygon face, boolean copy) {
        return PolyUtil.getAllVerts(face, copy);
    }

    private static void clipFace(IPolygon poly, Plane3d plane, boolean keepAbove, Collection<IPolygon> resultPolys) {
        if (!GenerateModelFromBIM.isConvex(poly)) {
            List<Triangle> tris = thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(0.0, poly);
            for (Triangle tri : tris) {
                GenerateModelFromBIM.clipFace(tri, plane, keepAbove, resultPolys);
            }
            return;
        }
        assert (poly.getNumLoops() == 1);
        int numPoints = poly.getNumPoints(0);
        ArrayList<Point3d> tempList = new ArrayList<Point3d>(numPoints);
        for (int m = 0; m < numPoints; ++m) {
            Point3d intersection;
            Point3d p1 = poly.getPoint(0, m);
            Point3d p2 = poly.getPoint(0, (m + 1) % numPoints);
            boolean p1Pos = theUtil.ge0(plane.dot(p1), 1.0E-6);
            boolean p2Pos = theUtil.ge0(plane.dot(p2), 1.0E-6);
            if (p1Pos == keepAbove) {
                tempList.add(p1);
            }
            if (p1Pos == p2Pos || (intersection = Inter3D.lineSegPlaneIntersection(p1, p2, plane, 0.0)) == null) continue;
            tempList.add(intersection);
        }
        if (tempList.size() > 2) {
            resultPolys.add(PolyUtil.newPoly(tempList.toArray(new Point3d[tempList.size()])));
        }
    }

    private static boolean isConvex(IPolygon poly) {
        if (poly.getNumLoops() > 1) {
            return false;
        }
        Point3d[] verts = PolyUtil.getAllVerts(poly, false);
        return verts.length == 3 || Util3D.isConvex(1.0E-6, verts);
    }

    private static PlaneCat categorizePointsForSubtract(Plane3d plane, Point3d ... points) {
        int aboveCount = 0;
        int belowCount = 0;
        int onCount = 0;
        for (Point3d p : points) {
            double dot = plane.dot(p);
            if (theUtil.eq0(dot, 1.0E-6)) {
                ++onCount;
                continue;
            }
            if (dot > 0.0) {
                ++aboveCount;
                continue;
            }
            ++belowCount;
        }
        if (aboveCount == points.length) {
            return PlaneCat.PLANE_ABOVE;
        }
        if (onCount == points.length) {
            return PlaneCat.PLANE_ALIGNED;
        }
        if (belowCount + onCount == points.length) {
            return PlaneCat.PLANE_BELOW;
        }
        return PlaneCat.PLANE_INTERSECTING;
    }

    private static boolean projectAndSubtract(Model floorModel, Point3d[] projectionFace, Plane3d projectionFacePlane, Plane3d projectionPlane, Matrix4d projectToPlaneXform, int wallGroup) {
        int id;
        boolean hasArea;
        ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
        for (int m = 0; m < projectionFace.length; ++m) {
            Point3d p1 = projectionFace[m];
            Point3d p2 = projectionFace[(m + 1) % projectionFace.length];
            LineSeg3D ls = new LineSeg3D(Util3D.xform(projectToPlaneXform, p1), Util3D.xform(projectToPlaneXform, p2));
            curves.add(ls);
        }
        if (!theUtil.eq0(projectionFacePlane.z, 1.0E-6) && (hasArea = GenerateModelFromBIM.addFaceToModel(floorModel, id = 0x7FFFFFFE, projectionPlane, curves))) {
            double areaSubtracted = 0.0;
            ArrayList<Face> wallGroupa = new ArrayList<Face>(floorModel.getFaces(id));
            for (Face subFace : wallGroupa) {
                if (subFace.groups.length > 1) {
                    areaSubtracted += subFace.getArea();
                }
                floorModel.deleteFace(subFace, true, true);
            }
            return theUtil.gt0(areaSubtracted, 1.0E-6);
        }
        Integer id2 = 0x7FFFFFFD;
        GenerateModelFromBIM.addEdgesToModel(floorModel, id2, curves);
        boolean modified = false;
        ArrayList<Edge> delEdges = new ArrayList<Edge>();
        for (Edge e : floorModel.getEdges(id2)) {
            if (!e.faces.isEmpty()) {
                e.removeGroup(id2);
                e.addGroup(wallGroup);
                modified = true;
                continue;
            }
            delEdges.add(e);
        }
        for (Edge e : delEdges) {
            floorModel.deleteEdge(e, true);
        }
        return modified;
    }

    private static boolean addFaceToModel(VentusData md, IFace face, boolean ccw, Model model, int groupid) {
        return GeomUtil.addFaceToModel(face, ccw, model, groupid, md.simParams.edgeError, md.simParams.faceError);
    }

    private static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> curves) {
        return GeomUtil.addFaceToModel(model, groupid, plane, curves);
    }

    private static void addEdgesToModel(Model model, int groupid, Collection<? extends IParametric3D> curves) {
        model.addEdges(groupid, curves);
    }

    static {
        UI_HOOK_CONTEXT.setShortDesc(Intl.intl("Generates model elements from selected BIM objects (e.g. rooms, doors, stairs)"));
        UI_HOOK_GLOBAL.setShortDesc(Intl.intl("Generates model elements from all imported BIM objects (e.g. rooms, doors, stairs)"));
        MAX_SLOPE = new IPropertySet.Prop<UnitDouble>("MAX_SLOPE", new UnitDouble(45.0, NonSI.DEGREE_ANGLE));
        SLOPE_INCLUSIVE = new IPropertySet.Prop<Boolean>("SLOPE_INCLUSIVE", false);
        SEARCH_OPTIONS = new IPropertySet.Prop<Integer>("SEARCH_OPTIONS", 3);
        HEAD_HEIGHT = new IPropertySet.Prop<UnitDouble>("HEAD_HEIGHT", new UnitDouble(1.8, SI.METER));
        MIN_COMP_WIDTH = new IPropertySet.Prop<UnitDouble>("MIN_COMP_WIDTH", new UnitDouble(0.5, SI.METER));
        CLOSE_GAPS = new IPropertySet.Prop<Boolean>("CLOSE_GAPS", true);
        CLOSE_GAP_TOLERANCE = new IPropertySet.Prop<UnitDouble>("CLOSE_GAP_TOLERANCE", new UnitDouble(0.15, SI.METER));
        NAME_FROM_IMPORTED_GEOM = new IPropertySet.Prop<Boolean>("NAME_FROM_IMPORTED_GEOM", true);
        EXTRACT_STAIRS = new IPropertySet.Prop<Boolean>("EXTRACT_STAIRS", true);
        MAX_STAIR_RISER = new IPropertySet.Prop<UnitDouble>("MAX_STAIR_RISER", new UnitDouble(0.4, SI.METER));
        MAX_STAIR_TREAD_GAP = new IPropertySet.Prop<UnitDouble>("MAX_STAIR_TREAD_GAP", new UnitDouble(0.1, SI.METER));
        EXTRACT_DOORS = new IPropertySet.Prop<Boolean>("EXTRACT_DOORS", true);
        DEL_SMALL_ROOMS = new IPropertySet.Prop<Boolean>("DEL_SMALL_ROOMS", true);
        DEL_ROOMS_IN_SOLIDS = new IPropertySet.Prop<Boolean>("DEL_ROOMS_IN_SOLIDS", true);
        MIN_ROOM_AREA = new IPropertySet.Prop<UnitDouble>("MIN_ROOM_AREA", ((UnitDouble)GenerateModelFromBIM.CLOSE_GAP_TOLERANCE.defVal).multiply((UnitDouble)GenerateModelFromBIM.CLOSE_GAP_TOLERANCE.defVal));
        EXTRACT_ONLY_TOPS_OF_SOLIDS = new IPropertySet.Prop<Boolean>("EXTRACT_ONLY_TOPS_OF_SOLIDS", true);
        GENERATE_OCCUPANTS = new IPropertySet.Prop<Boolean>("GENERATE_OCCUPANTS", true);
        GENERATE_PROFILES = new IPropertySet.Prop<Boolean>("GENERATE_PROFILES", true);
        s_areaComp = new TieBreaker<Double>((o1, o2) -> o1.compareTo((Double)o2));
        timer = new theTimer();
    }

    private static class Progress {
        private final TaskProgress d_progress = new TaskProgress();
        private final int d_totalSteps = 7;
        private int d_step = 0;
        private int d_progressIx = 0;

        public void reset() {
            this.d_step = 0;
            this.d_progress.reset();
        }

        public void resetStep(int max) {
            this.d_progress.setIndeterminate(max == -1);
            if (max != -1) {
                this.d_progress.reset(max);
            }
            this.d_progressIx = 0;
        }

        public void skipStep() {
            this.d_progress.setIndeterminate(false);
            this.d_progress.reset(100);
            this.d_progress.setProgress(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextStep(String msg, int max) {
            TaskProgress taskProgress = this.d_progress;
            synchronized (taskProgress) {
                ++this.d_step;
                this.d_progress.setMessage(String.format(Intl.intl("Step %d/%d: %s"), this.d_step, 7, msg));
                this.resetStep(max);
            }
        }

        public void increment() throws CancellationException {
            this.increment(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increment(int count) throws CancellationException {
            TaskProgress taskProgress = this.d_progress;
            synchronized (taskProgress) {
                this.d_progressIx += count;
                this.set(this.d_progressIx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int progress) throws CancellationException {
            TaskProgress taskProgress = this.d_progress;
            synchronized (taskProgress) {
                if (progress == -1) {
                    this.d_progress.setIndeterminate(true);
                } else {
                    this.d_progress.setIndeterminate(false);
                    this.d_progress.setProgress(progress);
                    this.d_progress.check();
                }
            }
        }
    }

    private static class ExtractResults {
        public Collection<? extends ISchematicComp> newObjs = Collections.emptyList();
        public IDistributedVal<UnitDouble> preEvacTime = null;

        private ExtractResults() {
        }
    }

    private static class ExtractException
    extends Exception {
        private static final long serialVersionUID = 7371118916953033117L;
        public final Type type;

        public ExtractException(Type type) {
            super(type.msg);
            this.type = type;
        }

        public static enum Type {
            NO_VALID_FACES(Intl.intl("There was no geometry matching the specified criteria."));

            public final String msg;

            private Type(String msg) {
                this.msg = msg;
            }
        }
    }

    private static class ExtractInfo {
        public final VentusData md;
        public final ExtractProps eprops;
        public final FaceCache faceCache;
        public int nextid = 100;

        public ExtractInfo(VentusData md, ExtractProps eprops) {
            this.md = md;
            this.eprops = eprops;
            this.faceCache = new FaceCache(md);
        }

        public int nextId() {
            return this.nextid++;
        }

        public <T> T getProp(IPropertySet.Prop<T> prop) {
            return this.eprops.get(prop);
        }
    }

    private static class FaceCache {
        private final VentusData md;
        private final Map<ImportedGeom, Collection<Pair<IPolygon, Elements.Orient>>> cache;
        private final Map<ImportedGeom, Collection<Pair<Triangle, Elements.Orient>>> triCache;

        public FaceCache(VentusData md) {
            this.md = md;
            this.cache = new IdentityHashMap<ImportedGeom, Collection<Pair<IPolygon, Elements.Orient>>>();
            this.triCache = new IdentityHashMap<ImportedGeom, Collection<Pair<Triangle, Elements.Orient>>>();
        }

        public synchronized Collection<Pair<IPolygon, Elements.Orient>> getFaces(ImportedGeom ig) {
            return this.cache.computeIfAbsent(ig, geom -> {
                IGeomNode fnode = geom.getGeom().flatten();
                IElemSource orients = (IElemSource)((Object)fnode.getLocalElements().get(Elements.ORIENT));
                List<IFace> faces = thunderheadeng.geometry.objs.GeomUtil.explode(fnode.getLocalGeom(), IFace.class);
                ArrayList<Pair<IPolygon, Elements.Orient>> polys = new ArrayList<Pair<IPolygon, Elements.Orient>>(faces.size());
                int ix = 0;
                for (IFace face : faces) {
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)orients.getPrimElement(ix)));
                    if (face instanceof IPolygon) {
                        polys.add(new Pair<IPolygon, Elements.Orient>((IPolygon)face, orient));
                        continue;
                    }
                    for (Triangle tri : thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(this.md.simParams.faceError, face)) {
                        polys.add(new Pair<Triangle, Elements.Orient>(tri, orient));
                    }
                }
                return polys;
            });
        }

        public synchronized Collection<Pair<Triangle, Elements.Orient>> getTris(VentusData md, ImportedGeom ig) {
            return this.triCache.computeIfAbsent(ig, geom -> {
                Collection<Pair<IPolygon, Elements.Orient>> polys = this.getFaces((ImportedGeom)geom);
                if (polys.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<Pair<Triangle, Elements.Orient>> tris = new ArrayList<Pair<Triangle, Elements.Orient>>();
                for (Pair<IPolygon, Elements.Orient> poly : polys) {
                    Mesh mesh = ((IPolygon)poly.v1).triangulate(md.simParams.faceError);
                    int m = 0;
                    while (m < mesh.indices.length) {
                        Point3d p1 = mesh.vertices[mesh.indices[m++]];
                        Point3d p2 = mesh.vertices[mesh.indices[m++]];
                        Point3d p3 = mesh.vertices[mesh.indices[m++]];
                        tris.add(new Pair<Triangle, Elements.Orient>(new Triangle(p1, p2, p3), (Elements.Orient)((Object)((Object)poly.v2))));
                    }
                }
                return tris;
            });
        }
    }

    public static class ExtractProps {
        public final IPropertySet props;
        public final double maxSlopeRad;
        public final boolean slopeInclusive;
        public final int searchOptions;
        public final double headHeight;
        public final double minCompWidth;
        public final double closeGapSize;
        public final boolean nameFromImportedGeom;
        public final double maxStairRiser;
        public final double maxStairTreadGap;
        public final double minRoomArea;

        ExtractProps(IPropertySet props) {
            this.props = props;
            this.maxSlopeRad = this.get(MAX_SLOPE).get(SI.RADIAN);
            this.slopeInclusive = this.get(SLOPE_INCLUSIVE);
            this.searchOptions = this.get(SEARCH_OPTIONS);
            this.headHeight = this.get(HEAD_HEIGHT).get(SI.METER);
            this.minCompWidth = this.get(MIN_COMP_WIDTH).get(SI.METER);
            this.closeGapSize = this.get(CLOSE_GAP_TOLERANCE).get(SI.METER);
            this.nameFromImportedGeom = this.get(NAME_FROM_IMPORTED_GEOM);
            this.maxStairRiser = this.get(MAX_STAIR_RISER).get(SI.METER);
            this.maxStairTreadGap = this.get(MAX_STAIR_TREAD_GAP).get(SI.METER);
            this.minRoomArea = this.get(MIN_ROOM_AREA).get(SI.METER.pow(2));
        }

        public <T> T get(IPropertySet.Prop<T> prop) {
            return this.props.get(prop);
        }
    }

    private static class GeomFace {
        public final ImportedGeom geom;
        public final int faceix;
        public final IPolygon face;
        public final Elements.Orient orient;

        public GeomFace(ImportedGeom geom, IPolygon face, Elements.Orient orient, int faceix) {
            this.geom = geom;
            this.face = face;
            this.orient = orient;
            this.faceix = faceix;
        }

        public int hashCode() {
            return System.identityHashCode(this.geom) + this.faceix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GeomFace)) {
                return false;
            }
            GeomFace gf = (GeomFace)obj;
            return this.geom == gf.geom && this.faceix == gf.faceix;
        }
    }

    private static class Locator<T extends IDisplayableGeomSrc> {
        public AABoxTest test = new AABoxTest(new AABox(), 1.0E-6);
        public final CollResult<IDisplayableGeomSrc, T> result;

        public Locator(Class<T> clazz, Predicate<T> filter) {
            this.result = new CollResult(clazz, filter);
        }

        private void reset(AABox testBox) {
            this.test = new AABoxTest(testBox, 1.0E-6);
            this.result.coll.clear();
        }

        public Collection<T> getResult() {
            return this.result.coll;
        }
    }

    private static enum PlaneCat {
        PLANE_ABOVE,
        PLANE_BELOW,
        PLANE_INTERSECTING,
        PLANE_ALIGNED;

    }
}

