/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Warning;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.TransformAction;
import ventus.actions.Undo;
import ventus.actions.copypaste.Paste;
import ventus.actions.copypaste.PasteHints;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.IMerlinGeomSrc;
import ventus.util.MerlinUtil;

public class CopyPasteUtil {
    public static boolean isGeomRoot(String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName) || FloorComposite.class.getName().equals(mdRootClassName);
    }

    public static Composite<IMerlinObj> getGeomRoot(VentusData md, String mdRootClassName) {
        Composite root;
        if (GeomComposite.class.getName().equals(mdRootClassName)) {
            root = md.sceneGeom;
        } else if (FloorComposite.class.getName().equals(mdRootClassName)) {
            root = md.floors;
        } else {
            throw new IllegalArgumentException("No root for " + mdRootClassName);
        }
        return root;
    }

    public static Composite<IMerlinObj> getDefaultRoot(VentusData md, IDomainObject pasteObj, String mdRootClassName) {
        if (CopyPasteUtil.isGeomRoot(mdRootClassName)) {
            return CopyPasteUtil.getGeomRoot(md, mdRootClassName);
        }
        EntryPoint<IDomainObject> ep = EntryPointFactory.get(pasteObj);
        return ep.getRootComposite(md);
    }

    public static String getRootString(VentusData md, IDomainObject pasteObj) {
        Object[] rootPath;
        String mdRootClassName = "";
        EntryPoint<IDomainObject> ep = EntryPointFactory.get(pasteObj);
        Composite<IMerlinObj> root = ep.getRootComposite(md);
        if (root != null && (rootPath = md.hierarchy.getPath(root)).length > 1 && rootPath[0] == md) {
            mdRootClassName = rootPath[1].getClass().getName();
        }
        return mdRootClassName;
    }

    public static void pasteInto(VentusData md, Composite dest, IDomainObject pasteObj, int insertIx) {
        Undo.UndoOp op = insertIx != -1 ? new Undo.InsertOp(dest, Collections.singleton(pasteObj), insertIx) : new Undo.AddOp(dest, Collections.singleton(pasteObj));
        Undo.insertEntry(md, op.perform());
    }

    public static boolean compositeCanContain(Composite comp, IDomainObject obj) {
        HashMap exclusiveParentChildMap = new HashMap();
        for (Map.Entry entry : exclusiveParentChildMap.entrySet()) {
            Class parentClass = (Class)entry.getKey();
            Class childClass = (Class)entry.getValue();
            if (parentClass.isAssignableFrom(comp.getClass()) && !childClass.isAssignableFrom(obj.getClass())) {
                return false;
            }
            if (!childClass.isAssignableFrom(obj.getClass()) || parentClass.isAssignableFrom(comp.getClass())) continue;
            return false;
        }
        return true;
    }

    private static Composite getDeepestComposite(IDomainObject pasteObj, Object[] path) {
        Composite deepest = null;
        for (Object obj : path) {
            if (!(obj instanceof Composite) || !CopyPasteUtil.compositeCanContain((Composite)obj, pasteObj)) continue;
            deepest = (Composite)obj;
        }
        return deepest;
    }

    public static Composite getBestPasteTarget(VentusData md, IDomainObject pasteObj, Composite defaultRoot, Collection<Composite<IMerlinObj>> selectedComposites, Collection<IMerlinObj> selectedLeaves) {
        HashSet<IMerlinObj> potentialTargets = new HashSet<IMerlinObj>();
        potentialTargets.add(defaultRoot);
        potentialTargets.addAll(selectedComposites);
        potentialTargets.addAll(selectedLeaves);
        HashMap<Composite, Object[]> compatTargets = new HashMap<Composite, Object[]>();
        for (Object e : potentialTargets) {
            Composite deepestComp;
            Object[] path = md.hierarchy.getPath(e);
            if (path == null || path.length <= 1 || path[1] != defaultRoot || (deepestComp = CopyPasteUtil.getDeepestComposite(pasteObj, path)) == null) continue;
            compatTargets.put(deepestComp, md.hierarchy.getPath(deepestComp));
        }
        ArrayList sortedTargets = new ArrayList(compatTargets.keySet());
        Collections.sort(sortedTargets, (a, b) -> {
            Object[] pathToA = (Object[])compatTargets.get(a);
            Object[] pathToB = (Object[])compatTargets.get(b);
            return Integer.compare(pathToB.length, pathToA.length);
        });
        return compatTargets.isEmpty() ? null : (Composite)sortedTargets.get(0);
    }

    public static void renamePasteObj(Collection<INamed> siblingsToBe, IDomainObject pasteObj) {
        if (pasteObj instanceof INamed) {
            HashSet<String> inUseNames = new HashSet<String>();
            for (INamed siblingToBe : siblingsToBe) {
                inUseNames.add(siblingToBe.getName());
            }
            String srcName = ((INamed)((Object)pasteObj)).getName();
            String dstName = srcName;
            if (inUseNames.contains(dstName)) {
                dstName = String.format("%s - Copy", srcName);
            }
            int n = 2;
            while (inUseNames.contains(dstName)) {
                dstName = String.format("%s - Copy (%d)", srcName, n);
                ++n;
            }
            ((INamed)((Object)pasteObj)).setName(dstName);
        }
    }

    public static PasteHints getGeomPasteHints(VentusData md, IDomainObject pasteObj) {
        PasteHints hints = new PasteHints();
        AABoxTest test = new AABoxTest(CopyPasteUtil.getBounds(pasteObj), 1.0E-6);
        final ArrayList hitComps = new ArrayList();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src instanceof ISchematicComp) {
                    hitComps.add((ISchematicComp)src);
                }
            }
        };
        md.geomLocation.getLocator().find((ITest<AABox>)test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        hints.geomTransformShouldPrompt = !hitComps.isEmpty();
        return hints;
    }

    private static AABox getBounds(IDomainObject<VentusData> obj) {
        Collection<IMerlinGeomSrc> elems = CopyPasteUtil.flattenToType(obj, IMerlinGeomSrc.class);
        AABox bounds = new AABox();
        for (IMerlinGeomSrc elem : elems) {
            bounds.add(elem.getBounds());
        }
        return bounds;
    }

    public static <T> Collection<T> flattenToType(IDomainObject<VentusData> obj, Class<T> type) {
        if (obj instanceof Composite) {
            return ((Composite)obj).flatten(type);
        }
        if (obj != null && type.isAssignableFrom(obj.getClass())) {
            return Arrays.asList(obj);
        }
        assert (false) : "Unknown geom element: " + String.valueOf(obj != null ? obj.getClass() : "");
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pasteIntoAndTransform(VentusData md, VentusApp app, IDomainObject pasteObj, PasteHints hints, Consumer<? super IDomainObject> pastedObjs, Composite<IMerlinObj> insertRoot, int insertIx, boolean shouldRename) {
        Collection<IMerlinObj> merlinObjs = CopyPasteUtil.flattenToType(pasteObj, IMerlinObj.class);
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Set Offset"));
            Undo.insertUndoEntry_restoreSelection(md);
            if (shouldRename) {
                Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
                CopyPasteUtil.renamePasteObj(nameSibs, pasteObj);
            }
            CopyPasteUtil.pasteInto(md, insertRoot, pasteObj, insertIx);
            Undo.begin("", false);
            try {
                ArrayList toClean = new ArrayList();
                ArrayList toPostUpdate = new ArrayList();
                TransformAction.transform(app, md, toClean::add, toPostUpdate::add, merlinObjs.stream().filter(o -> !(o instanceof Composite)).collect(Collectors.toList()), 0, hints.geomTransform);
                SchematicRoom.cleanup(md, toClean);
            }
            finally {
                Undo.end(md);
            }
            Undo.end(md);
        }
        pastedObjs.accept(pasteObj);
    }

    public static boolean validInsertRoot(Class caller, IDomainObject pasteObj, IDomainObject pasteLoc, Consumer<? super Warning> warnings) {
        if (pasteLoc == null) {
            warnings.accept(CopyPasteUtil.getInsertRootWarning(caller, pasteObj));
        }
        return pasteLoc != null;
    }

    public static Warning getInsertRootWarning(Class caller, IDomainObject obj) {
        String name = String.format("%s:%s", MerlinUtil.getName(obj), obj.getClass().getSimpleName());
        System.err.printf("[WARN] [%s] unable to determine valid insert location: %s%n", caller.getName(), obj);
        return new Warning(Intl.intl("Unable to determine valid insert location."), String.format(Intl.intl("%s object was not pasted."), name));
    }

    public static Warning getPasteSupportWarning(IDomainObject obj, boolean onCopy) {
        String name = String.format("%s:%s", MerlinUtil.getName(obj), obj.getClass().getSimpleName());
        System.err.printf("[WARN] [%s] unsupported object skipped: %s%n", Paste.class.getName(), obj);
        return new Warning(String.format(Intl.intl("%s is not currently supported for copy/paste."), obj.getClass().getSimpleName()), onCopy ? String.format(Intl.intl("%s was not copied."), name) : String.format(Intl.intl("%s was not pasted."), name));
    }

    public static Warning getPasteDependencySupportWarning(IDirectDependent dependent, IDomainObject dependency) {
        String name = String.format("%s:%s", MerlinUtil.getName(dependency), dependency.getClass().getSimpleName());
        System.err.printf("[WARN] [%s] unresolved paste dependency %s%n", Paste.class.getName(), dependency);
        return new Warning(String.format(Intl.intl("%s is not currently supported for copy/paste."), dependency.getClass().getSimpleName()), String.format(Intl.intl("%1$s paste dependency: %2$s was removed."), dependent.getClass().getSimpleName(), name));
    }
}

