/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Warning;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.Paste;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.VentusCopyDataContainer;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.io.VentusIO;

public class Copy
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Copy16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Copy(), Intl.intl("&Copy...,C,Copy selected objects"), ICON);

    public Copy() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    public static boolean canCopy(VentusData md, Collection<PasteHandler> handlers) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        Map<IDomainObject, String> objMap = Copy.getPasteMap(md);
        boolean canCopy = false;
        for (Map.Entry<IDomainObject, String> entry : objMap.entrySet()) {
            if (Paste.isUnsupported(handlers, entry.getKey(), entry.getValue())) {
                warnings.add(CopyPasteUtil.getPasteSupportWarning(entry.getKey(), true));
                continue;
            }
            canCopy = true;
        }
        if (!canCopy) {
            Paste.showWarnings(VentusApp.getApp(), warnings);
        }
        return canCopy;
    }

    public static Map<IDomainObject, String> getPasteMap(VentusData md) {
        LinkedHashMap<IDomainObject, String> objMap = new LinkedHashMap<IDomainObject, String>();
        IFilteredCollection<IDomainObject> rawObjs = md.selection.get(IDomainObject.class, Predicates.alwaysTrue());
        for (IDomainObject obj : rawObjs) {
            Object[] pathToObj = md.hierarchy.getPath(obj);
            if (pathToObj[0] != md) {
                System.err.printf("object not reachable from MerlinData, skipping: [%s] %s%n", obj.getClass().getName(), obj.toString());
                continue;
            }
            assert (pathToObj.length > 1 && pathToObj[0] == md);
            String mdRootClassName = "";
            if (pathToObj.length > 1) {
                mdRootClassName = pathToObj[1].getClass().getName();
                objMap.put(obj, mdRootClassName);
            }
            if (pathToObj.length != 2) continue;
            objMap.remove(obj);
            Composite mdRoot = (Composite)pathToObj[1];
            for (IDomainObject iDomainObject : mdRoot.getChildren()) {
                objMap.put(iDomainObject, mdRootClassName);
            }
        }
        return objMap;
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Clipboard systemClipboard = defaultToolkit.getSystemClipboard();
        if (Copy.canCopy(md, Paste.getPasteHandlers(app))) {
            Map<IDomainObject, String> objMap = Copy.getPasteMap(md);
            VentusCopyDataContainer data = new VentusCopyDataContainer(VentusIO.Version.curr().num, objMap);
            ObjectSelection contents = new ObjectSelection(data, data.toString(), VentusCopyDataContainer.DATAFLAVOR_BINARY);
            systemClipboard.setContents(contents, null);
        }
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(!md.selection.isEmpty(IDomainObject.class));
    }
}

