/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.cad.out.TeciGeomWriter;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.data.image.BGImage;
import ventus.gui.guiUtil;
import ventus.io.FileUtil;
import ventus.util.MerlinUtil;

public class WriteVis
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new WriteVis(), Intl.intl("Save Imported Geometry file...,-,Write Imported Geometry file"));

    @Override
    public void run(VentusApp app, VentusData md) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(md.getNewFilename(FileUtil.Types.GEOM), MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_GEOM);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        try {
            WriteVis.writeVis(md, f, true);
        }
        catch (IOException e) {
            guiUtil.showError(app, Intl.intl("Geom File Error"), Intl.intl("Could not create file"), (Throwable)e);
        }
    }

    public static boolean writeVis(VentusData md, File f, boolean force) throws IOException {
        DisplayRecorder displays = new DisplayRecorder();
        Collection<BGImage> bgImages = md.sceneGeom.getDeepMembers(BGImage.class);
        Collection bgWrappers = bgImages.stream().map(BGWrapper::new).collect(Collectors.toList());
        displays.record(md.sceneGeom, md.sceneGeom.flatten(ImportedGeom.class, obj -> !obj.isA(BIMType.Space)), ImportedGeomWrapper::new);
        List<TeciGeomWriter.IObject> objects = displays.getAllDisplays();
        if (!force && objects.isEmpty() && bgWrappers.isEmpty()) {
            f.delete();
            return false;
        }
        TeciGeomWriter.writeVis(f, new TeciGeomWriter.Options(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR), MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR)), objects, bgWrappers);
        return true;
    }

    private static class DisplayRecorder {
        public final Set<IMerlinObj> usedGroups = new LinkedIdentityHashSet<IMerlinObj>();
        public final List<TeciGeomWriter.IObject> nonGroups = new ArrayList<TeciGeomWriter.IObject>();

        private DisplayRecorder() {
        }

        public void recordAncestors(Object root, IMerlinObj obj) {
            if (obj == root) {
                return;
            }
            Object parent = obj.getParent();
            if (parent instanceof IMerlinObj && parent != root) {
                this.recordAncestors(root, (IMerlinObj)parent);
                this.usedGroups.add((IMerlinObj)parent);
            }
        }

        public <T extends IMerlinObj> void record(Object root, Collection<T> objs, Function<T, TeciGeomWriter.IObject> convert) {
            for (IMerlinObj obj : objs) {
                this.recordAncestors(root, obj);
            }
            for (IMerlinObj obj : objs) {
                this.nonGroups.add(convert.apply(obj));
            }
        }

        public List<TeciGeomWriter.IObject> getAllDisplays() {
            ArrayList<TeciGeomWriter.IObject> objects = new ArrayList<TeciGeomWriter.IObject>(this.usedGroups.size() + this.nonGroups.size());
            objects.addAll(theUtil.map(this.usedGroups, CompositeWrapper::new));
            objects.addAll(this.nonGroups);
            return objects;
        }
    }

    private static class BGWrapper
    implements TeciGeomWriter.BGImage {
        public final BGImage img;

        public BGWrapper(BGImage img) {
            this.img = img;
        }

        @Override
        public Matrix4d getLWXform() {
            return this.img.getLWXform();
        }

        @Override
        public float getOpacity() {
            return this.img.getOpacity();
        }

        @Override
        public String getName() {
            return this.img.getName();
        }

        @Override
        public IImage getImage() {
            return this.img.getImage();
        }
    }

    private static class CompositeWrapper
    extends AGeomWrapper<IMerlinObj> {
        public CompositeWrapper(IMerlinObj elem) {
            super(elem);
        }

        @Override
        public TeciGeomWriter.Type getType() {
            return TeciGeomWriter.Type.GROUP;
        }

        @Override
        public DisplayGeom getDisplay() {
            return DisplayGeom.EMPTY;
        }

        @Override
        public boolean isVisible() {
            PropValue<Boolean> visible = this.obj.getWithDetails(VentusData.VISIBILITY);
            return visible.orElse(visible.isNonUniform());
        }
    }

    private static class ImportedGeomWrapper
    extends AGeomWrapper<ImportedGeom> {
        public ImportedGeomWrapper(ImportedGeom ig) {
            super(ig);
        }

        @Override
        public DisplayGeom getDisplay() {
            return ((ImportedGeom)this.obj).getDisplayGeom();
        }

        @Override
        public boolean isVisible() {
            return ((ImportedGeom)this.obj).isVisible();
        }

        @Override
        public TeciGeomWriter.Type getType() {
            return TeciGeomWriter.Type.GENERIC;
        }
    }

    private static abstract class AGeomWrapper<T extends IMerlinObj>
    implements TeciGeomWriter.IObject {
        public final T obj;

        public AGeomWrapper(T ig) {
            this.obj = ig;
        }

        @Override
        public String getName() {
            return MerlinUtil.getName(this.obj);
        }

        @Override
        public long getId() {
            return this.obj.getResultsId();
        }

        @Override
        public long getParentId() {
            Object parent = this.obj.getParent();
            if (parent instanceof IMerlinObj && parent != this.obj.getDomain()) {
                return ((IMerlinObj)parent).getResultsId();
            }
            return 0L;
        }

        @Override
        public Collection<Integer> getFDSRepIds() {
            return Collections.emptyList();
        }
    }
}

