/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropValue;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.VentusApp;
import ventus.actions.Undo;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.util.MerlinUtil;

public class Visibility {
    public static void setVisibility(VentusData md, Collection<?> toShow, Collection<?> toHide, boolean hideFirst) {
        Function<Collection, Set> flattenToSupported = coll -> new LinkedIdentityHashSet<IMerlinObj>(MerlinUtil.flatten(coll, IMerlinObj.class, o -> o.isSupportedLocally(VentusData.VISIBILITY)));
        Set showObjs = flattenToSupported.apply(toShow);
        Set hideObjs = flattenToSupported.apply(toHide);
        if (Visibility.containsClipped(md, toShow)) {
            hideObjs.removeAll(md.floors.getMembers());
            showObjs.addAll(md.floors.getMembers());
        }
        Consumer<Set> insertRestoreVis = objs -> objs.forEach(obj -> obj.insertUndoEntry_propRestore(VentusData.VISIBILITY));
        if (hideFirst) {
            hideObjs.removeAll(showObjs);
            Undo.insertUndoEntry_restoreSelection(md);
            insertRestoreVis.accept(hideObjs);
            insertRestoreVis.accept(showObjs);
            Visibility.setVisibility(md, hideObjs, false);
            Visibility.setVisibility(md, showObjs, true);
        } else {
            showObjs.removeAll(hideObjs);
            Undo.insertUndoEntry_restoreSelection(md);
            insertRestoreVis.accept(showObjs);
            insertRestoreVis.accept(hideObjs);
            Visibility.setVisibility(md, showObjs, true);
            Visibility.setVisibility(md, hideObjs, false);
        }
    }

    private static boolean containsClipped(VentusData md, Collection<?> objs) {
        VentusApp app = VentusApp.getApp();
        if (app == null) {
            return false;
        }
        GlobalDisplayMgr dispMgr = app.getModelView().getDisplayManager();
        for (Object o : MerlinUtil.flatten(objs)) {
            if (!dispMgr.isClippedByFloor(o)) continue;
            return true;
        }
        return false;
    }

    private static void setVisibility(VentusData vd, Collection<? extends IMerlinObj> objs, boolean visibility) {
        for (IMerlinObj iMerlinObj : objs) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(iMerlinObj);
            ep.setVisible(vd, iMerlinObj, visibility);
        }
    }

    public static ConvexHull[] getVisibleFloorHulls(VentusData vd) {
        Floor[] visibleFloors = (Floor[])vd.floors.getMembers(Floor.class).stream().filter(GeomComposite::isVisible).toArray(Floor[]::new);
        return vd.floors.getClippingRegions(visibleFloors);
    }

    public static boolean isVisible(VentusData vd, IMerlinObj obj, ConvexHull[] visibleFloorHulls) {
        PropValue<Boolean> visibleProp = obj.getWithDetails(VentusData.VISIBILITY);
        if (visibleProp.isUnsupported() || visibleProp.isUniform() && !visibleProp.get().booleanValue()) {
            return false;
        }
        PropValue<Boolean> enabledProp = obj.getWithDetails(VentusData.ENABLED);
        if (enabledProp.isUniform() && !enabledProp.get().booleanValue()) {
            return false;
        }
        ModelView modelView = VentusApp.getApp().getModelView();
        if (!modelView.isVisible(obj.getClass())) {
            return false;
        }
        if (obj instanceof IMerlinGeomSrc) {
            IMerlinGeomSrc geomSrc = (IMerlinGeomSrc)((Object)obj);
            if (modelView.getDisplayManager().isClippedByFloor(obj)) {
                AABox objBounds = geomSrc.getBounds();
                boolean intersectsFloor = false;
                for (ConvexHull hull : visibleFloorHulls) {
                    if (!hull.containsAtLeastPart(objBounds)) continue;
                    intersectsFloor = true;
                    break;
                }
                if (!intersectsFloor) {
                    return false;
                }
            }
        }
        return true;
    }
}

