/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import javax.swing.Icon;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.unitsystem.EnglishUS;
import ventus.unitsystem.SIUS;

public class New
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/New16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new New(), Intl.intl("&New,N,New Model,Create a new model"), ICON);

    @Override
    public void run(VentusApp app, VentusData md) {
        if (!app.promptSaveIfModified()) {
            return;
        }
        New.newModel(app, md);
    }

    public static boolean newModel(VentusApp app, VentusData md) {
        app.getModelView().getRenderComp().pauseRender();
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.insertEntry_breakChain(md);
            String unitSystemPref = MerlinPrefs.getString(MerlinPrefs.KEY_UNITSYSTEM_PROP);
            if (unitSystemPref != null && unitSystemPref.equals(EnglishUS.getInstance().getSystemName())) {
                app.getData().setUnitSystem(EnglishUS.getInstance());
            } else {
                app.getData().setUnitSystem(SIUS.getInstance());
            }
            md.reset();
        }
        app.getModelView().reset();
        app.getModelView().getRenderComp().resumeRender(true);
        return true;
    }
}

