/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.actions.ChangeGroupAction;
import ventus.actions.Delete;
import ventus.actions.NewFloor;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorOptions;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.geom.Geometry;
import ventus.util.MerlinUtil;

public class FloorSortActions {
    public static Collection<ISchematicComp> getSortableObjs(VentusData md, Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, ISchematicComp.class, o -> FloorSortActions.isSortable(md, o));
    }

    public static boolean isSortable(VentusData md, ISchematicComp obj) {
        return md.hierarchy.isDescendent(md.floors, obj);
    }

    public static void updateComponentFloors(VentusData md, Collection<? extends ISchematicComp> comps) {
        if (!md.floorOptions.get(FloorOptions.AUTO_SELECT_FLOOR).booleanValue()) {
            return;
        }
        assert (comps.stream().allMatch(o -> FloorSortActions.isSortable(md, o))) : "updateComponentFloors must only be called on sortable components. Call getSortableObjs() to obtain";
        for (ISchematicComp iSchematicComp : comps) {
            FloorSortActions.chooseFloor(md, iSchematicComp);
        }
        FloorSortActions.resortComponents(md, comps, md.floors.getMembers(Floor.class));
    }

    public static void resortComponents(VentusData md, Collection<? extends ISchematicComp> components, Collection<? extends Floor> allowedFloors) {
        if (components.isEmpty() || allowedFloors.isEmpty()) {
            return;
        }
        Set<Object> floors = allowedFloors instanceof Set ? (Set<Object>)allowedFloors : new IdentityHashSet<Floor>(allowedFloors);
        components = new ArrayList<ISchematicComp>(components);
        LinkedIdentityHashMap groupMap = new LinkedIdentityHashMap();
        for (ISchematicComp iSchematicComp : components) {
            Floor desiredFloor = FloorSortActions.findFloor(md, iSchematicComp);
            if (!floors.contains(desiredFloor) || FloorSortActions.getParentFloor(md, iSchematicComp) == desiredFloor) continue;
            Composite<?> moveToGroup = FloorSortActions.getMoveToGroup(md, desiredFloor, iSchematicComp, groupMap);
            ChangeGroupAction.move(md, Arrays.asList(iSchematicComp), moveToGroup, moveToGroup.getChildren().size());
        }
        LinkedIdentityHashSet delGroups = new LinkedIdentityHashSet();
        for (Pair oldGroup : groupMap.keySet()) {
            if (!((Composite)oldGroup.v2).isEmpty()) continue;
            delGroups.add((Composite)oldGroup.v2);
        }
        Delete.headlessDelete(md, delGroups, true);
    }

    private static Floor getParentFloor(VentusData md, Object comp) {
        Object parent = md.hierarchy.getParent(comp);
        while (parent != null && !(parent instanceof Floor)) {
            parent = md.hierarchy.getParent(parent);
        }
        return (Floor)parent;
    }

    private static Composite<?> getMoveToGroup(VentusData md, Floor newFloor, IMerlinObj obj, Map<Pair<Floor, Composite<?>>, Composite<?>> groupMap) {
        Object[] path = md.hierarchy.getPath(obj);
        Composite currGroup = newFloor;
        boolean replicatingGroups = false;
        for (int m = 0; m < path.length - 1; ++m) {
            Object oldParent = path[m];
            if (!replicatingGroups) {
                replicatingGroups |= oldParent instanceof Floor;
                continue;
            }
            Composite oldGroup = (Composite)oldParent;
            Composite<?> newGroup = FloorSortActions.getNewGroup(md, newFloor, currGroup, oldGroup, groupMap);
            assert (newGroup != null);
            currGroup = newGroup;
        }
        return currGroup;
    }

    private static Composite<?> getNewGroup(VentusData md, Floor newFloor, Composite<?> parent, Composite<?> oldGroup, Map<Pair<Floor, Composite<?>>, Composite<?>> groupMap) {
        Composite<?> newGroup = groupMap.get(new Pair(newFloor, oldGroup));
        if (newGroup == null) {
            newGroup = FloorSortActions.findGroup(parent, oldGroup.getName());
            if (newGroup == null) {
                newGroup = new GeomComposite(oldGroup.getName());
                Undo.insertUndoEntry_delete(md, parent, newGroup);
                parent.add(newGroup);
            }
            groupMap.put(new Pair(newFloor, oldGroup), newGroup);
        }
        return newGroup;
    }

    private static Composite<?> findGroup(Composite<?> parent, String name) {
        Collection<Composite> members = parent.getMembers(Composite.class);
        for (Composite member : members) {
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public static Composite<?> chooseGroup(VentusData md, ISchematicComp comp) {
        Floor floor = FloorSortActions.chooseFloor(md, comp);
        if (floor == FloorSortActions.getParentFloor(md, comp)) {
            return (Composite)md.hierarchy.getParent(comp);
        }
        return floor.getWorkingGeomGroup();
    }

    public static Floor chooseFloor(VentusData md, ISchematicComp comp) {
        AABox bounds;
        if (md.floorOptions.get(FloorOptions.AUTO_SELECT_FLOOR).booleanValue() && (bounds = comp.getBounds()).isValid()) {
            UnitDouble z = new UnitDouble(bounds.getMinZ(), Geometry.LENGTH_UNIT);
            return FloorSortActions.chooseFloor(md, z);
        }
        Floor existing = FloorSortActions.getParentFloor(md, comp);
        if (existing != null) {
            return existing;
        }
        return md.activeFloor();
    }

    public static Floor chooseFloor(VentusData md, UnitDouble z) {
        if (!md.floorOptions.get(FloorOptions.AUTO_SELECT_FLOOR).booleanValue()) {
            return md.activeFloor();
        }
        Floor[] surrFloors = md.floors.getSurroundingFloors(z);
        z = FloorSortActions.calcFloorLoc(md, surrFloors, z);
        if (FloorSortActions.isEmptyModel(md)) {
            md.floors.getActive().insertUndoEntry_propRestore(Floor.WORKING_Z);
            md.floors.getActive().setWorkingZ(z);
            return md.floors.getActive();
        }
        if (FloorSortActions.shouldCreateNewFloor(md, z, surrFloors)) {
            return NewFloor.createFloor(md, z, false, false);
        }
        return FloorSortActions.findFloor(surrFloors);
    }

    private static boolean isEmptyModel(VentusData md) {
        return md.floors.getDeepMembers(IMerlinObj.class).size() == 1 && md.floors.getActive().getWorkingZ().equals(new UnitDouble(0.0, SI.METER));
    }

    private static boolean shouldCreateNewFloor(VentusData md, UnitDouble z, Floor[] surrFloors) {
        if (md.floorOptions.get(FloorOptions.AUTO_CREATE_FLOOR).booleanValue()) {
            if (surrFloors[0] == null) {
                return true;
            }
            double minDist = md.floorOptions.get(FloorOptions.MIN_AUTO_FLOOR_DIST).getValue(Geometry.LENGTH_UNIT);
            for (Floor floor : surrFloors) {
                double dist;
                if (floor == null || !theUtil.lt(dist = floor.getWorkingZ().diff(z).getValue(Geometry.LENGTH_UNIT), minDist, 1.0E-6)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static UnitDouble calcFloorLoc(VentusData md, Floor[] surrFloors, UnitDouble zud) {
        double div;
        Floor baseFloor = FloorSortActions.findFloor(surrFloors);
        double z = zud.getValue(Geometry.LENGTH_UNIT);
        double baseZ = baseFloor.getWorkingZ().getValue(Geometry.LENGTH_UNIT);
        double dist = z - baseZ;
        double minDist = md.floorOptions.get(FloorOptions.MIN_AUTO_FLOOR_DIST).getValue(Geometry.LENGTH_UNIT);
        double v2 = baseZ + minDist * Math.ceil(div = dist / minDist);
        if (theUtil.eq(z, v2, 1.0E-6)) {
            return new UnitDouble(v2, Geometry.LENGTH_UNIT);
        }
        double v1 = baseZ + minDist * Math.floor(div);
        return new UnitDouble(v1, Geometry.LENGTH_UNIT);
    }

    public static Floor findFloor(VentusData md, UnitDouble z) {
        return FloorSortActions.findFloor(md.floors.getSurroundingFloors(z));
    }

    private static Floor findFloor(Floor[] surrFloors) {
        return surrFloors[0] != null ? surrFloors[0] : surrFloors[1];
    }

    public static Floor findFloor(VentusData md, ISchematicComp comp) {
        AABox bounds = comp.getBounds();
        if (!bounds.isValid()) {
            return md.activeFloor();
        }
        return FloorSortActions.findFloor(md, new UnitDouble(bounds.getMinZ(), Geometry.LENGTH_UNIT));
    }
}

