/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.image.PDFConverter;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.image.BGImage;
import ventus.data.image.ImageGroup;
import ventus.data.image.RasterImage;
import ventus.geom.Geometry;
import ventus.mv.MerlinColors;

public class AddBGImage
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("ventus/icons/backgroundImage16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new AddBGImage(), Intl.intl("New Background Image..."), ICON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(VentusApp app, VentusData md) {
        IntermediateGraphicsXfer igx = new IntermediateGraphicsXfer();
        try {
            UnitDouble defZ = md.activeFloor().getWorkingZ();
            BGImageDlg.ImageInfo info = md.ui(() -> AddBGImage.newBGImage(app.getMainFrame(), defZ, igx));
            if (info == null) {
                return;
            }
            BGImage newImg = new BGImage(info.image.getFilename(), info.image);
            AddBGImage.applyBGInfo(newImg, info);
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("New Image"));
                AddBGImage.addBGImage(md, newImg);
                Undo.end(md);
            }
        }
        finally {
            igx.release();
        }
    }

    public static BGImageDlg.ImageInfo newBGImage(Window parent, UnitDouble defZ, IntermediateGraphicsXfer<String> igx) {
        return AddBGImage.showBGImageDlg(parent, null, igx, defZ);
    }

    public static BGImageDlg.ImageInfo editBGImage(Window parent, BGImage img, IntermediateGraphicsXfer<String> igx) {
        double defZ = img.getAnchorModel().z();
        return AddBGImage.showBGImageDlg(parent, img, igx, new UnitDouble(defZ, Geometry.LENGTH_UNIT));
    }

    private static BGImageDlg.ImageInfo showBGImageDlg(Window parent, BGImage img, IntermediateGraphicsXfer<String> igx, UnitDouble defZ) {
        VentusApp app = VentusApp.getApp();
        HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>> colorMap = new HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>>();
        colorMap.put(BGImageDlg.Colors.AXIS, MerlinColors.AXIS_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_BOX, MerlinColors.AXIS_BOX_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_TEXT, MerlinColors.AXIS_TEXT_COLOR);
        colorMap.put(BGImageDlg.Colors.BACKGROUND, MerlinColors.BACKGROUND_COLOR);
        colorMap.put(BGImageDlg.Colors.ORIGIN, MerlinColors.ORIGIN2D_COLOR);
        ImageLoader imgLoader = new ImageLoader(parent, defZ);
        BGImageDlg.ImageInfo existing = null;
        if (img != null) {
            existing = new BGImageDlg.ImageInfo(img.getImage(), img.getTransformInfo(), img.getOpacity());
        }
        return BGImageDlg.editImage(parent, app.getModelView().getRenderComp(), app.getColorManager(), colorMap, imgLoader, app.getUnitSystem().getLength(), igx, existing);
    }

    public static void applyBGInfo(BGImage img, BGImageDlg.ImageInfo info) {
        img.setImage(info.image);
        img.setFilename(info.image.getFilename());
        img.setTransformInfo(info.xform.anchorImage, new UnitPoint3D(info.xform.anchorModel, Geometry.LENGTH_UNIT), info.xform.aImage, info.xform.bImage, new UnitDouble(info.xform.distABModel, Geometry.LENGTH_UNIT), new UnitDouble(info.xform.abAngle, Geometry.ANGLE_UNIT));
        img.setOpacity(info.opacity);
    }

    public static void addBGImage(VentusData md, RasterImage image) {
        ImageGroup ig = AddBGImage.getBGGroup(md);
        Undo.insertUndoEntry_delete(md, ig, image);
        ig.add(image);
        Undo.insertUndoEntry_restoreSelection(md);
        md.selection.set(image);
    }

    private static ImageGroup getBGGroup(VentusData md) {
        Collection<ImageGroup> igroups = md.sceneGeom.getMembers(ImageGroup.class);
        if (!igroups.isEmpty()) {
            return igroups.iterator().next();
        }
        ImageGroup ig = new ImageGroup();
        Undo.insertUndoEntry_delete(md, md.sceneGeom, ig);
        md.sceneGeom.insert(Arrays.asList(ig), 0);
        return ig;
    }

    private static class ImageLoader
    implements BGImageDlg.IImageLoader {
        public final UnitDouble d_defZ;
        private final Window d_dlgParent;

        public ImageLoader(Window dlgParent, UnitDouble defZ) {
            this.d_dlgParent = dlgParent;
            this.d_defZ = defZ;
        }

        @Override
        public File choose(Component parent, File currFile) {
            guiJFXFileChooser chooser = new guiJFXFileChooser(currFile != null ? currFile.getAbsolutePath() : null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, FileFilters.EXT_FILTER_BMP, FileFilters.EXT_FILTER_GIF, FileFilters.EXT_FILTER_JPEG_ALL, FileFilters.EXT_FILTER_PNG, FileFilters.EXT_FILTER_PDF, FileFilters.EXT_FILTER_TIFF, FileFilters.EXT_FILTER_TARGA);
            File f = chooser.showOpenDialog();
            if (f != null) {
                MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
            }
            return f;
        }

        @Override
        public Pair<Image, BGImageXform> load(File file) throws IOException {
            try {
                IImage image = PDFConverter.convertPDFtoImage(file, this.d_dlgParent);
                if (image == null) {
                    String filename = file.getAbsolutePath();
                    image = ImageManager.getImage(filename);
                }
                if (!(image instanceof Image)) {
                    throw new IOException(Intl.intl("Could not load image."));
                }
                BGImageXform xform = new BGImageXform(null, new Point3d(0.0, 0.0, this.d_defZ.getValue(Geometry.LENGTH_UNIT)), null, null, Double.NaN, 0.0);
                return new Pair<Image, BGImageXform>((Image)image, xform);
            }
            catch (OutOfMemoryError e) {
                throw new IOException(Intl.intl("Unable to load image file, the file is too large."));
            }
            catch (CancelledException e) {
                return null;
            }
        }
    }
}

