/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import ventus.EntryPointFactory;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;

public class VentusDepSnapshot
extends DepSnapshot<VentusData> {
    public VentusDepSnapshot(VentusData vd) {
        super(vd, new Callback(vd));
    }

    public VentusDepSnapshot(VentusData vd, Collection<?> interestingDepOns) {
        super(vd, (DepSnapshot.ICallback)new Callback(vd), interestingDepOns);
    }

    public VentusDepSnapshot(VentusData vd, Predicate<Object> interestingDepOns) {
        super(vd, (DepSnapshot.ICallback)new Callback(vd), interestingDepOns);
    }

    private static final class Callback
    implements DepSnapshot.ICallback {
        private final VentusData d_data;

        private Callback(VentusData data) {
            this.d_data = data;
        }

        @Override
        public Iterable<?> getChildren(Object obj) {
            if (obj instanceof IMerlinObj) {
                return ((IMerlinObj)obj).getChildren();
            }
            return Collections.emptyList();
        }

        @Override
        public boolean getDomainRequiresAtLeastOne(Object o) {
            return EntryPointFactory.get(o).getDomainRequiredType(this.d_data, o) != null;
        }

        @Override
        public boolean isSkippable(Class<?> clazz) {
            return UnitDouble.class.isAssignableFrom(clazz) || Unit.class.isAssignableFrom(clazz) || IGeom.class.isAssignableFrom(clazz) || IGeomNode.class.isAssignableFrom(clazz) || IElemSource.class.isAssignableFrom(clazz) || IPropsSrc.class.isAssignableFrom(clazz) || Model.class.isAssignableFrom(clazz) || AModelObj.class.isAssignableFrom(clazz);
        }
    }
}

