/*
 * Decompiled with CFR 0.152.
 */
package ventus.unitsystem;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.IUnitSrc;
import ventus.VentusApp;
import ventus.unitsystem.MerlinUnitType;

public abstract class UnitSystem {
    public static final int LENGTH = 0;
    public static final int TIME = 1;
    public static final int AREA = 2;
    public static final int VELOCITY = 3;
    public static final int SHORT_LENGTH = 4;
    public static final int ANGLE = 5;
    public static final int ACCEL = 6;
    public static final int PERSONS = 7;
    public static final int PERSONS_DENSITY = 8;
    public static final int PERCENT = 9;
    public static final int NONE = 10;
    public static final int ANGLE_SPEED = 11;
    public static final int ZOOM_SPEED = 12;
    public static final int EXTINCTION_COEFFICIENT = 13;
    public static final int TEMPERATURE = 14;
    public static final int PRESSURE = 15;
    public static final int VOLUME = 16;
    public static final int DESIGN_FLOW_RATE = 17;
    public static final int MOLECULAR_MASS = 18;
    public static final int DIFFUSION_COEFFICIENT = 19;
    public static final int SPECIFIC_HEAT = 20;
    public static final int SPECIES_DIAMETER = 21;
    public static final int DENSITY = 22;
    public static final int SPECIES_DECAY_RATE = 23;
    public static final int UVGI_SUSCEPTIBILITY = 24;
    public static final int SPECIES_CONCENTRATION = 25;
    public static final int MASS_RATE = 26;
    private static final Map<Unit, Integer> s_unitTypeMap = new HashMap<Unit, Integer>();
    private final String d_name;
    private final Map<Integer, Unit> d_typeUnitMap;

    public UnitSystem(String name) {
        this.d_name = name;
        this.d_typeUnitMap = new HashMap<Integer, Unit>();
    }

    protected void addUnit(int type, Unit unit, boolean defForType) {
        this.d_typeUnitMap.put(type, unit);
        s_unitTypeMap.put(unit, type);
        if (defForType) {
            s_unitTypeMap.put(unit.getSystemUnit(), type);
        }
    }

    public String getSystemName() {
        return this.d_name;
    }

    public static int getType(Unit u) {
        Integer type = s_unitTypeMap.get(u);
        if (type == null) {
            type = s_unitTypeMap.get(u.getSystemUnit());
        }
        if (type == null) {
            return -1;
        }
        return type;
    }

    public static IUnitSrc getType(int unitId, boolean observeChanges) {
        MerlinUnitType ut = new MerlinUnitType(unitId);
        if (observeChanges) {
            Objects.requireNonNull(VentusApp.getApp()).getData().getEvents().addObserver(ut);
        }
        return ut;
    }

    public Unit getUnit(int type) {
        return this.d_typeUnitMap.get(type);
    }

    public Unit getLength() {
        return this.getUnit(0);
    }

    public Unit getTime() {
        return this.getUnit(1);
    }

    public Unit getArea() {
        return this.getUnit(2);
    }

    public Unit getPersonsDensity() {
        return this.getUnit(8);
    }

    public Unit getAngle() {
        return this.getUnit(5);
    }

    public Unit getTemperature() {
        return this.getUnit(14);
    }

    public Unit getPressure() {
        return this.getUnit(15);
    }

    public Unit getVolume() {
        return this.getUnit(16);
    }

    public Unit getDesignFlowRate() {
        return this.getUnit(17);
    }

    public Unit getVelocity() {
        return this.getUnit(3);
    }

    public Unit getMassRate() {
        return this.getUnit(26);
    }

    public Unit getDensity() {
        return this.getUnit(22);
    }
}

