/*
 * Decompiled with CFR 0.152.
 */
package ventus.treeview;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import thunderheadeng.gui.AbstractDnDTree;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ContextMenuListener;
import thunderheadeng.gui.ContextMenuModel;
import thunderheadeng.gui.IDnDTreeModel;
import thunderheadeng.gui.SecondClickRenameListener;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.EditProps;
import ventus.actions.ShowView;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.copypaste.Copy;
import ventus.actions.copypaste.Paste;
import ventus.actions.importgeom.Import;
import ventus.data.IMerlinObj;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.feature.comps.IDefaultAction;
import ventus.gui.guiUtil;
import ventus.treeview.CellEditor;
import ventus.treeview.CellRenderer;
import ventus.treeview.DescendentComp;
import ventus.treeview.Model;
import ventus.treeview.SelectionHandler;
import ventus.treeview.TVEntryPoint;
import ventus.treeview.Util;
import ventus.treeview.actions.BeginRename;

public class TreeView
extends AbstractDnDTree
implements ContextMenuModel,
IEventObserver {
    private static final long serialVersionUID = -1742237433017336355L;
    private final VentusData d_data;
    private final Model d_model;
    private final SelectionHandler d_selectionHandler;
    private final FriendlyExpansionHack d_expansionHack;
    private final SelectionScroller d_selScroll;
    private AutoExpandAction d_autoExpandAction;
    private Action d_collapseAllAction;
    private Action d_expandAllAction;
    private final List<UIHook> d_doubleClickActions = new ArrayList<UIHook>();
    private TreePath[] d_preExpandSelectionPaths;

    public TreeView(VentusData md) {
        super(new Model(md));
        this.setSelectionModel(new VentusTreeSelectionModel());
        this.d_data = md;
        this.d_model = (Model)this.getModel();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setExpandsSelectedPaths(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(true);
        this.setLargeModel(true);
        this.setSelectNodeOnCollapse(false);
        this.setCellRenderer(new CellRenderer(this.d_data));
        this.setRowHeight(0);
        this.setToggleClickCount(0);
        this.setEditable(true);
        this.setCellEditor(new CellEditor(this.d_data, this, (CellRenderer)this.getCellRenderer()));
        this.d_selectionHandler = new SelectionHandler(this.d_data, this.getSelectionModel(), (Model)this.getModel());
        this.d_expansionHack = new FriendlyExpansionHack(this, this.d_data);
        this.d_selScroll = new SelectionScroller(this, this.d_model);
        this.addMouseListener(new MouseEditListener());
        this.addMouseListener(new PthSecondClickRenameListener(this));
        this.addMouseListener(new SelectionRemovalListener());
        this.addMouseListener(new ContextMenuListener(this));
        this.expandRootNode(md.floors);
        this.getInputMap().put((KeyStroke)Copy.UI_HOOK.getValue("AcceleratorKey"), Copy.UI_HOOK);
        this.getInputMap().put((KeyStroke)Paste.UI_HOOK.getValue("AcceleratorKey"), Paste.UI_HOOK);
        this.d_data.getEvents().addObserver(this);
        this.setMinimumSize(new Dimension(200, 200));
        this.d_doubleClickActions.add(EditProps.UI_HOOK);
        this.d_doubleClickActions.add(ShowView.CONTEXT_HOOK);
        VentusApp.getApp().getComponents(IDefaultAction.class).stream().flatMap(ctxComp -> ctxComp.getDoubleClickActions().stream()).forEach(dblClickHook -> this.d_doubleClickActions.add((UIHook)dblClickHook));
    }

    public void showCurrentSelection() {
        MerlinSelectionModel sel = this.d_data.selection;
        Set selObjs = sel.getSelected(Object.class);
        for (Object o : selObjs) {
            TreePath path = this.d_model.getPath(o);
            if (path == null) continue;
            this.scrollPathToVisible(path);
        }
    }

    @Override
    public void collapsePath(TreePath path) {
        this.d_preExpandSelectionPaths = this.getSelectionPaths();
        super.collapsePath(path);
    }

    @Override
    public void expandPath(TreePath path) {
        this.d_preExpandSelectionPaths = this.getSelectionPaths();
        super.expandPath(path);
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        super.removeSelectionPaths(paths);
    }

    public JToggleButton getAutoExpandButton() {
        if (this.d_autoExpandAction == null) {
            this.d_autoExpandAction = new AutoExpandAction(this);
        }
        return guiUtil.createToolbarToggleButton(this.d_autoExpandAction);
    }

    public JButton getCollapseAllButton() {
        if (this.d_collapseAllAction == null) {
            this.d_collapseAllAction = new UIHook(new CollapseAllAction(), Intl.intl("Collapse All"), ((BasicTreeUI)this.getUI()).getExpandedIcon(), 0);
        }
        return guiUtil.createToolbarButton(this.d_collapseAllAction);
    }

    public JButton getExpandAllButton() {
        if (this.d_expandAllAction == null) {
            this.d_expandAllAction = new UIHook(new ExpandAllAction(), Intl.intl("Expand All"), ((BasicTreeUI)this.getUI()).getCollapsedIcon(), 0);
        }
        return guiUtil.createToolbarButton(this.d_expandAllAction);
    }

    public void collapseAll(IMerlinObj obj) {
        Collection<? extends IMerlinObj> children = obj.getChildren();
        if (!children.isEmpty()) {
            TreePath path;
            for (IMerlinObj iMerlinObj : children) {
                this.collapseAll(iMerlinObj);
            }
            if (obj != this.d_data && (path = this.d_model.getPath(obj)) != null) {
                this.collapsePath(path);
            }
        }
    }

    public void expandAll(IMerlinObj obj) {
        Collection<? extends IMerlinObj> children = obj.getChildren();
        if (!children.isEmpty()) {
            TreePath path = this.d_model.getPath(obj);
            if (path != null) {
                this.expandPath(path);
            }
            for (IMerlinObj iMerlinObj : children) {
                this.expandAll(iMerlinObj);
            }
        }
    }

    @Override
    public JPopupMenu getContextMenu(MouseEvent e) {
        if (!this.isEnabled()) {
            return null;
        }
        TreePath clickPath = this.getPathForLocation(e.getX(), e.getY());
        if (clickPath == null) {
            this.clearSelection();
            return null;
        }
        if (!this.isPathSelected(clickPath)) {
            this.setSelectionPath(clickPath);
        }
        return VentusApp.getApp().getContextMenu();
    }

    private void expandRootNode(IMerlinObj o) {
        TreePath path = this.d_model.getPath(o);
        if (path != null) {
            this.expandPath(path);
        }
    }

    @Override
    public void update(Events events) {
        if (this.d_selectionHandler.lock()) {
            this.d_model.update(events);
            this.d_expansionHack.update(events);
            this.d_selectionHandler.unlock();
            this.d_selectionHandler.update(events);
        }
    }

    public class VentusTreeSelectionModel
    extends DefaultTreeSelectionModel {
        @Override
        public void clearSelection() {
            if (TreeView.this.d_preExpandSelectionPaths != null && TreeView.this.d_preExpandSelectionPaths.length > 0) {
                TreeView.this.d_preExpandSelectionPaths = null;
                return;
            }
            super.clearSelection();
        }
    }

    private class FriendlyExpansionHack {
        private final TreeView d_ptv;
        private boolean d_enableAutoExpand;
        private final VentusData d_md;

        public FriendlyExpansionHack(TreeView ptv, VentusData md) {
            this.d_ptv = ptv;
            this.d_md = md;
            this.d_enableAutoExpand = false;
        }

        public void setEnableSelectionTracking(boolean enabled) {
            this.d_enableAutoExpand = enabled;
        }

        public boolean isEnabledSelectionTracking() {
            return this.d_enableAutoExpand;
        }

        public void update(Events events) {
            Model model = (Model)this.d_ptv.getModel();
            for (EventChannel<VentusData> channel : events.getAffectedChannels(VentusData.class, new Class[0])) {
                if (!channel.containsChange(Import.MODEL_IMPORTED) && !channel.containsChange(VentusData.MODEL_LOADED) && !channel.containsChange(VentusData.MODEL_RESET)) continue;
                TreePath rootPath = model.getPath(model.getRoot());
                model.fireTreeStructureChanged(new TreeModelEvent((Object)this, rootPath));
                TreeView.this.expandRootNode(this.d_md.floors);
                return;
            }
            IEventRecord<Object> objEvts = events.getEvents(Object.class, VentusData.class);
            TreeSet<TreePath> toExpand = new TreeSet<TreePath>(new DescendentComp());
            for (Object o : objEvts.getAddedObjs()) {
                TreePath path;
                Object parent;
                TVEntryPoint<Object> ep = Util.getEP(o);
                if (ep == null || (parent = ep.getParent(TreeView.this.d_data, o)) == null || (path = TreeView.this.d_model.getPath(parent)) == null || !this.canExpand(o)) continue;
                toExpand.add(path);
            }
            for (TreePath path : toExpand) {
                this.d_ptv.expandPath(path);
            }
            for (Object obj : objEvts.getChangedObjs(VentusData.SELECTION_CHANGED)) {
                TreePath path;
                if (!TreeView.this.d_data.selection.isSelected(obj) || !this.canExpand(obj) || Util.objectsParentIsSelected(TreeView.this.d_data, obj) || (path = TreeView.this.d_model.getPath(obj)) == null) continue;
                TreeView.this.makeVisible(path);
            }
        }

        private boolean canExpand(Object o) {
            return this.d_enableAutoExpand || o instanceof IMerlinObj && EntryPointFactory.get((IMerlinObj)o).tvEntryPoint.getForcedAutoexpand(TreeView.this.d_data, (IMerlinObj)o);
        }
    }

    private static class SelectionScroller
    implements TreeSelectionListener {
        private final JTree d_tree;
        private final IDnDTreeModel d_model;
        private boolean d_enable;

        public SelectionScroller(JTree tree, IDnDTreeModel model) {
            this.d_tree = tree;
            this.d_model = model;
            this.d_tree.addTreeSelectionListener(this);
            this.d_enable = false;
        }

        public void setEnabled(boolean enable) {
            this.d_enable = enable;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.d_enable && e.isAddedPath() && !this.d_model.isDragging()) {
                this.d_tree.scrollPathToVisible(e.getNewLeadSelectionPath());
            }
        }
    }

    private class MouseEditListener
    extends MouseAdapter {
        private MouseEditListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getButton() != 1 || evt.getClickCount() != 2) {
                return;
            }
            TreePath clickPath = TreeView.this.getPathForLocation(evt.getX(), evt.getY());
            if (clickPath != null && TreeView.this.getSelectionModel().isPathSelected(clickPath) && TreeView.this.getPathBounds(clickPath).contains(evt.getPoint())) {
                for (UIHook hook : TreeView.this.d_doubleClickActions) {
                    if (!hook.isEnabled()) continue;
                    hook.run(evt.getComponent());
                    break;
                }
            }
        }
    }

    private class PthSecondClickRenameListener
    extends SecondClickRenameListener {
        PthSecondClickRenameListener(JTree tree) {
            super(tree);
        }

        @Override
        protected boolean canRename(MouseEvent evt, int mouseButtonNumber, TreePath clickPath, TreePath secondClickPath) {
            return TreeView.this.getSelectionModel().isPathSelected(clickPath) && TreeView.this.getPathBounds(clickPath).contains(evt.getPoint()) && mouseButtonNumber == evt.getButton() && evt.getButton() == 1 && evt.getClickCount() == 1 && clickPath.equals(secondClickPath) && evt.getSource() instanceof TreeView;
        }

        @Override
        protected Action getRenameAction(TreePath pth) {
            TVEntryPoint<Object> ep;
            BeginRename a = null;
            Object obj = pth.getLastPathComponent();
            if (obj instanceof IMerlinObj && (ep = Util.getEP((IMerlinObj)obj)) != null && ep.canRename(TreeView.this.d_data, obj)) {
                a = new BeginRename((TreeView)this.d_tree, (IMerlinObj)obj);
            }
            return a;
        }
    }

    private class SelectionRemovalListener
    extends MouseAdapter {
        private SelectionRemovalListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            TreePath clickPath = TreeView.this.getExtendedPathForLocation(evt.getX(), evt.getY());
            if (clickPath == null) {
                Undo.begin(Intl.intl("Clear Selection"));
                Undo.insertUndoEntry_restoreSelection(TreeView.this.d_data);
                boolean modified = !TreeView.this.d_data.selection.isEmpty();
                TreeView.this.d_data.selection.clear();
                Undo.end(TreeView.this.d_data, modified);
            }
        }
    }

    private static class AutoExpandAction
    extends BooleanAction {
        private static final long serialVersionUID = 7180023957755234151L;
        private final TreeView d_tv;
        public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Refresh16.gif");

        public AutoExpandAction(TreeView tv) {
            super(Intl.intl("Auto Expand Selection"), false, ICON);
            this.d_tv = tv;
            this.d_tv.d_expansionHack.setEnableSelectionTracking(false);
            this.d_tv.d_selScroll.setEnabled(false);
        }

        @Override
        protected void stateChanged() {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(VentusApp app, VentusData md) {
                    boolean newState = !d_tv.d_expansionHack.isEnabledSelectionTracking();
                    d_tv.d_expansionHack.setEnableSelectionTracking(newState);
                    d_tv.d_selScroll.setEnabled(newState);
                    if (newState) {
                        MerlinSelectionModel sel = md.selection;
                        Set<Object> selObjs = sel.getSelectedWithChildren(Object.class);
                        for (Object o : selObjs) {
                            TreePath path = d_tv.d_model.getPath(o);
                            if (path == null) continue;
                            d_tv.scrollPathToVisible(path);
                        }
                    }
                }
            };
            UIHook.run(null, UIHook.formatForActionLog(this), op, 0);
        }
    }

    private class CollapseAllAction
    extends AMerlinOp {
        private CollapseAllAction() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            md.ui(() -> TreeView.this.collapseAll(TreeView.this.d_data));
        }
    }

    private class ExpandAllAction
    extends AMerlinOp {
        private ExpandAllAction() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            md.ui(() -> TreeView.this.expandAll(TreeView.this.d_data));
        }
    }
}

