/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.util.ArrayList;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.util.theUtil;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.geom.GeomLocator;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.snappers.GridSnapper;

public class MerlinPickRoot
implements IPickRoot {
    private static final Class[] PICK_PREFS = new Class[]{IHandle.class, ISchematicComp.class};
    private final VentusData d_data;
    private final ModelView d_mv;

    public MerlinPickRoot(VentusData md, ModelView mv) {
        this.d_data = md;
        this.d_mv = mv;
    }

    @Override
    public IPickSession beginPicking() {
        return new Session();
    }

    private class Session
    implements IPickSession {
        private final Camera d_camera;
        private final Predicate<Object> d_isWireframe;
        private int d_active;
        private VentusData.ReadLock d_lock;

        private Session() {
            this.d_camera = MerlinPickRoot.this.d_mv.getMainView().getCamera();
            this.d_isWireframe = MerlinPickRoot.this.d_mv.getDisplayManager().getWireframeTester();
            this.d_active = 0;
            this.d_lock = null;
        }

        @Override
        public boolean isActive() {
            return this.d_active > 0;
        }

        @Override
        public void begin() {
            if (this.d_active++ == 0) {
                assert (this.d_lock == null);
                this.d_lock = MerlinPickRoot.this.d_data.lockRead();
            }
        }

        @Override
        public void end() {
            if (--this.d_active == 0) {
                assert (this.d_lock != null);
                this.d_lock.close();
                this.d_lock = null;
            }
            assert (this.d_active >= 0);
        }

        @Override
        public IPickConfig[] getPickConfigs() {
            assert (this.isActive());
            ArrayList<IPickConfig> configs = new ArrayList<IPickConfig>();
            configs.add(new SchematicConfig());
            boolean allVisible = true;
            ArrayList<ImportConfig> floorConfigs = new ArrayList<ImportConfig>();
            for (Floor floor : MerlinPickRoot.this.d_data.floors.getMembers(Floor.class)) {
                if (!floor.isVisible()) continue;
                ConvexHull clip = MerlinPickRoot.this.d_data.floors.getClippingRegion(floor);
                floorConfigs.add(new ImportConfig(clip));
                allVisible &= clip.acceptsAll();
            }
            if (allVisible) {
                configs.add(new ImportConfig(new ConvexHull(new Plane3d[0])));
            } else {
                configs.addAll(floorConfigs);
            }
            return theUtil.toArray(configs, IPickConfig.class);
        }

        @Override
        public boolean isVisible(IPickConfig config, Object o) {
            assert (this.isActive());
            if (MerlinPickRoot.this.d_mv.getManipMgr().isManipulating() && (o instanceof IHandle || MerlinPickRoot.this.d_mv.getManipMgr().isManipulating(o))) {
                return false;
            }
            return MerlinPickRoot.this.d_data.isVisible(o);
        }

        @Override
        public boolean isWireframe(IPickConfig config, Object o) {
            assert (this.isActive());
            return this.d_isWireframe.test(o);
        }

        @Override
        public boolean isOcclusionTarget(Object o, boolean occludeGuides) {
            assert (this.isActive());
            if (occludeGuides) {
                return true;
            }
            if (o instanceof GridSnapper) {
                return this.d_camera instanceof PerspectiveCamera;
            }
            return !(o instanceof ISnapConstraint);
        }

        @Override
        public boolean isOcclusionSource(Object o) {
            assert (this.isActive());
            return !(o instanceof IHandle);
        }

        @Override
        public int compare(Object o1, Object o2) {
            assert (this.isActive());
            int diff = this.getClassPreference(o1) - this.getClassPreference(o2);
            if (diff == 0) {
                // empty if block
            }
            return diff;
        }

        private int getClassPreference(Object obj) {
            for (int m = 0; m < PICK_PREFS.length; ++m) {
                if (!PICK_PREFS[m].isInstance(obj)) continue;
                return m;
            }
            return PICK_PREFS.length;
        }

        private double getVolume(Object o) {
            if (o instanceof IMerlinGeomSrc) {
                AABox bounds = ((IMerlinGeomSrc)o).getBounds();
                return bounds != null ? bounds.volume(2.220446049250313E-16) : Double.MAX_VALUE;
            }
            return Double.MAX_VALUE;
        }

        public boolean isFloorFilteredGeom(VentusData md, Object object) {
            return MerlinPickRoot.this.d_mv.getDisplayManager().isClippedByFloor(object);
        }

        @Override
        public void pickPoints(IPickable obj, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            assert (this.isActive());
            obj.pickPoints(isects, filter, rayBegin, rayDirN, maxDist, tester, MerlinPickRoot.this.d_mv.getDisplayProps());
        }

        @Override
        public void pickBox(IPickable obj, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            assert (this.isActive());
            obj.pickBox(result, filter, region, MerlinPickRoot.this.d_mv.getDisplayProps());
        }

        private void findAdditionalSnaps(ITest<AABox> test, IResult<IPickable> result) {
            IPickSession.findAdditionalSnaps(test, result, this.d_camera, MerlinPickRoot.this.d_mv.getManipMgr().isManipulating(), () -> {
                Tool tool = MerlinPickRoot.this.d_mv.getTools().getCurrentTool();
                if (tool instanceof IAdvancedTool) {
                    return ((IAdvancedTool)tool).getAngledSnapBasis();
                }
                return null;
            });
        }

        public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick, boolean filterByFloor) {
            assert (this.isActive());
            GeomLocator locator = MerlinPickRoot.this.d_data.geomLocation.getLocator();
            IResult<IPickable> baseResult = result;
            IResult<IDisplayableGeomSrc> fresult = (obj, ctmt) -> {
                if (obj instanceof IPickable && filterByFloor == this.isFloorFilteredGeom(MerlinPickRoot.this.d_data, obj)) {
                    baseResult.mark((IPickable)((Object)obj), ctmt);
                }
            };
            int options = 0;
            if (quick) {
                options |= 4;
            }
            locator.find(test, fresult, options);
        }

        private class SchematicConfig
        implements IPickConfig {
            private SchematicConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return new ConvexHull(new Plane3d[0]);
            }

            @Override
            public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick) {
                Session.this.findAdditionalSnaps(test, result);
                Session.this.find(test, result, quick, false);
            }
        }

        private class ImportConfig
        implements IPickConfig {
            private final ConvexHull d_clip;

            public ImportConfig(ConvexHull ch) {
                this.d_clip = ch;
            }

            @Override
            public ConvexHull getClippingRegion() {
                return this.d_clip;
            }

            @Override
            public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick) {
                Session.this.find(test, result, quick, true);
            }
        }
    }
}

