/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypedProp;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.NewGroup;
import ventus.actions.SetActiveFloor;
import ventus.actions.SetWorkingGroup;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.floorextract.GenerateModelFromBIM;
import ventus.data.Composite;
import ventus.data.CompositePropertyUtil;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.IOpacity;
import ventus.data.ImportType;
import ventus.data.ImportedGeom;
import ventus.data.MerlinSelectionModel;
import ventus.data.NamedMerlinObj;
import ventus.data.Opacity;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.FloorOptions;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.comps.INameRibbonPropProvider;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.results.DataNode;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.gui.MaterialBtn;
import ventus.gui.MerlinUDF;
import ventus.gui.NodeComboBox;
import ventus.gui.NodeComboModel;
import ventus.gui.guiUtil;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;
import ventus.util.MerlinUtil;

public final class SelectionRibbonEditorPanel
extends SelectionEditorPanel<ISelectionRibbon> {
    static final long serialVersionUID = 1L;
    private final SelectionEditorPanel.EditorPanel d_floorSect;
    private final SelectionEditorPanel.EditorPanel d_roomInfoSect;
    private final BoundsSect d_boundsSect;
    private final SelectionEditorPanel.EditorPanel d_sceneGeomSect;
    private final NewCompGroupPnl d_newCompGroupPnl;
    private final FloorSortPnl d_floorSortPnl;
    private final ActiveFloorPnl d_activeFloorPnl;
    private final SelectionEditorPanel.EditorPanel d_generateModelFromBIM;
    private final SelectionEditorPanel.EditorPanel d_generateModelFromBIMSel;
    private static final guiLabel s_dmyLbl = new guiLabel("blah");

    public SelectionRibbonEditorPanel(VentusData vd) {
        super(vd, () -> VentusApp.getApp().getComponents(ISelectionRibbon.class));
        this.d_newCompGroupPnl = new NewCompGroupPnl(vd);
        this.d_floorSortPnl = new FloorSortPnl(vd);
        this.d_activeFloorPnl = new ActiveFloorPnl(vd);
        this.d_generateModelFromBIM = new GenerateModelSect(true);
        this.d_generateModelFromBIMSel = new GenerateModelSect(false);
        this.d_floorSect = new FloorSect();
        this.d_roomInfoSect = new RoomInfoSect();
        this.d_boundsSect = new BoundsSect();
        this.d_sceneGeomSect = new SceneGeomPnl();
        this.updatePanels();
        this.updateLayout();
    }

    private static void adjustHeight(JComponent comp) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, SelectionRibbonEditorPanel.s_dmyLbl.getPreferredSize().height - 2));
    }

    @Override
    protected List<SelectionEditorPanel.EditorPanel> getActivePanels(Set<IMerlinObj> objs) {
        ArrayList<SelectionEditorPanel.EditorPanel> activePanels = new ArrayList<SelectionEditorPanel.EditorPanel>();
        MerlinSelectionModel sel = this.d_md.selection;
        if (objs.isEmpty()) {
            activePanels.add(this.d_floorSortPnl);
            activePanels.add(this.d_newCompGroupPnl);
            activePanels.add(this.d_activeFloorPnl);
            return activePanels;
        }
        Set<TypedProp<?>> propTypes = CompositePropertyUtil.getSupportedProps(IMerlinObj.SupportMode.INTERSECTION, objs);
        Set<TypedProp<?>> unshared = CompositePropertyUtil.getSupportedProps(IMerlinObj.SupportMode.UNION, objs);
        GridBagHelper propgb = new GridBagHelper(new SelectionEditorPanel.EditorPanel());
        propgb.rowSpace = 1;
        GroupedSequence nameRoot = new GroupedSequence("nameRoot", 0, null);
        if (SelectionRibbonEditorPanel.shouldAddNameProp(propTypes, unshared)) {
            nameRoot.add(0, (panel, rowPropgb) -> SelectionRibbonEditorPanel.addNameProp(panel, rowPropgb, objs.stream().allMatch(obj -> EntryPointFactory.get(obj).tvEntryPoint.canRename(this.d_md, (IMerlinObj)obj))));
        }
        if (SelectionRibbonEditorPanel.shouldAddVisibilityProp(propTypes, unshared)) {
            nameRoot.add(50, SelectionRibbonEditorPanel::addVisibilityProp);
        }
        for (INameRibbonPropProvider provider : VentusApp.getApp().getComponents(INameRibbonPropProvider.class)) {
            if (!provider.isEnabled(propTypes, unshared)) continue;
            provider.addPropAdders(nameRoot);
        }
        GridBagHelper namePropgb = propgb;
        nameRoot.traverse(seq -> {
            Object patt0$temp = seq.current.data;
            if (patt0$temp instanceof INameRibbonPropProvider.INameRibbonPropAdder) {
                INameRibbonPropProvider.INameRibbonPropAdder adder = (INameRibbonPropProvider.INameRibbonPropAdder)patt0$temp;
                GridBagHelper rowPropgb = SelectionRibbonEditorPanel.prepareNewPropRow(namePropgb, activePanels, 1);
                SelectionEditorPanel.EditorPanel panel = (SelectionEditorPanel.EditorPanel)rowPropgb.getPanel();
                adder.add(panel, rowPropgb);
            }
        });
        int colorCount = 0;
        if (SelectionRibbonEditorPanel.testMaterialProp(propTypes, unshared)) {
            ++colorCount;
        }
        if (SelectionRibbonEditorPanel.testColorProp(propTypes)) {
            ++colorCount;
        }
        if (SelectionRibbonEditorPanel.testOpacityProp(propTypes)) {
            ++colorCount;
        }
        propgb = SelectionRibbonEditorPanel.prepareNewPropRow(propgb, activePanels, colorCount);
        SelectionRibbonEditorPanel.addMaterialProp(propTypes, unshared, propgb);
        SelectionRibbonEditorPanel.addColorProp(propTypes, propgb, sel);
        SelectionRibbonEditorPanel.addOpacityProp(propTypes, propgb);
        SelectionRibbonEditorPanel.finalizePropPnl(propgb, activePanels);
        activePanels.addAll(this.loadEditorsFromRibbons(propTypes, unshared));
        if (propTypes.contains(ISchematicRoom.AREA)) {
            activePanels.add(this.d_roomInfoSect);
        }
        for (IMerlinObj ice : objs) {
            if (!(ice instanceof IMerlinGeomSrc)) continue;
            activePanels.add(this.d_boundsSect);
            break;
        }
        if (propTypes.contains(Floor.WORKING_Z) && propTypes.contains(Floor.ZMIN_FILTER) && propTypes.contains(Floor.ZMAX_FILTER)) {
            activePanels.add(this.d_floorSect);
        }
        if (SelectionRibbonEditorPanel.filter(objs, FlowPath.class).size() > 0) {
            activePanels.remove(this.d_boundsSect);
        }
        if (SelectionRibbonEditorPanel.filter(objs, AHSPoint.class).size() > 0) {
            activePanels.remove(this.d_boundsSect);
        }
        if (SelectionRibbonEditorPanel.filter(objs, DataNode.VisLeaf.class).size() > 0) {
            activePanels.remove(this.d_boundsSect);
        }
        if (propTypes.contains(ImportedGeom.PROP_OBJECT_TYPE) && propTypes.contains(ImportedGeom.PROP_IMPORTED_TYPE)) {
            activePanels.add(this.d_sceneGeomSect);
        }
        return activePanels;
    }

    @Override
    protected void updateLayout() {
        EventQueue.invokeLater(() -> {
            this.removeAll();
            for (SelectionEditorPanel.EditorPanel panel : this.d_activePanels) {
                this.addSeparator();
                this.addSection(panel);
            }
            SwingUtilities.updateComponentTreeUI(this);
        });
    }

    private static boolean shouldAddNameProp(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(NamedMerlinObj.NAME);
    }

    private static void addNameProp(SelectionEditorPanel.EditorPanel panel, GridBagHelper propgb, boolean editable) {
        guiTextField fldName = new guiTextField();
        Dimension d = fldName.getPreferredSize();
        fldName.setPreferredSize(new Dimension((int)(1.5 * (double)d.width), d.height));
        fldName.setEditable(editable);
        panel.addConnection(new PropConnections.NamePropConnection(fldName));
        propgb.addRow(guiUtil.lblProp(NamedMerlinObj.NAME), fldName, 0, 1.0);
    }

    public static boolean shouldAddVisibilityProp(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(VentusData.VISIBILITY);
    }

    private static void addVisibilityProp(SelectionEditorPanel.EditorPanel panel, GridBagHelper propgb) {
        guiMultiStateCheckBox ckVisible = new guiMultiStateCheckBox(VentusData.VISIBILITY.name);
        panel.addConnection(new PropConnections.VisPropConnection(ckVisible));
        propgb.addRow(ckVisible, 0);
    }

    private static GridBagHelper prepareNewPropRow(GridBagHelper gb, List<SelectionEditorPanel.EditorPanel> panels, int rowsToAdd) {
        if (gb.getCurrentRow() + rowsToAdd > 3) {
            panels.add((SelectionEditorPanel.EditorPanel)gb.getPanel());
            SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel();
            gb = new GridBagHelper(panel);
            gb.rowSpace = 1;
        }
        return gb;
    }

    private static void finalizePropPnl(GridBagHelper gb, List<SelectionEditorPanel.EditorPanel> panels) {
        if (gb.getCurrentRow() > 0) {
            panels.add((SelectionEditorPanel.EditorPanel)gb.getPanel());
        }
    }

    private static boolean testMaterialProp(Set<TypedProp<?>> propTypes, Set<TypedProp<?>> propTypesUnion) {
        return propTypes.contains(VentusData.MATERIAL) || SelectionRibbonEditorPanel.testColorProp(propTypes) && propTypesUnion.contains(VentusData.MATERIAL);
    }

    private static void addMaterialProp(Set<TypedProp<?>> propTypes, Set<TypedProp<?>> propTypesUnion, GridBagHelper propgb) {
        if (SelectionRibbonEditorPanel.testMaterialProp(propTypes, propTypesUnion)) {
            MaterialBtn btn = new MaterialBtn(true);
            ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new PropConnections.MaterialConn(btn));
            propgb.addRow(guiUtil.lblProp(VentusData.MATERIAL), btn, 1.0, 0);
        }
    }

    private static boolean testColorProp(Set<TypedProp<?>> propTypes) {
        return propTypes.contains(VentusData.COLOR);
    }

    private static void addColorProp(Set<TypedProp<?>> propTypes, GridBagHelper propgb, MerlinSelectionModel sel) {
        if (SelectionRibbonEditorPanel.testColorProp(propTypes)) {
            JComponent lblComp;
            ColorButton cb = SelectionRibbonEditorPanel.newColorButton();
            ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new PropConnections.ColorConn(cb));
            if (sel.isDeepEmpty(ImportedGeom.class)) {
                guiMultiStateCheckBox colorCB = new guiMultiStateCheckBox(String.format(Intl.intl("%s:"), VentusData.COLOR.name));
                LinkStatus.link((AbstractButton)colorCB, cb);
                ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new PropConnections.BoolPropConnection(new ColorDefProp(), colorCB));
                lblComp = colorCB;
            } else {
                lblComp = guiUtil.lblProp(VentusData.COLOR);
            }
            propgb.addRow(lblComp, cb, 1.0, 0);
        }
    }

    private static boolean testOpacityProp(Set<TypedProp<?>> propTypes) {
        return propTypes.contains(VentusData.OPACITY);
    }

    private static void addOpacityProp(Set<TypedProp<?>> propTypes, GridBagHelper propgb) {
        if (SelectionRibbonEditorPanel.testOpacityProp(propTypes)) {
            MerlinUDF opacityFld = new MerlinUDF(NonSI.PERCENT);
            ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new OpacityConn(opacityFld));
            propgb.addRow(guiUtil.lblProp(VentusData.OPACITY), opacityFld, 1.0);
        }
    }

    private static ColorButton newColorButton() {
        ColorButton cb = new ColorButton(1);
        cb.setText(Intl.intl("<multiple>"));
        Insets margin = cb.getMargin();
        cb.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        return cb;
    }

    private static class NewCompGroupPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 5997508668479008215L;
        private final VentusData d_md;
        private final NodeComboBox<?> d_nodeCB;
        private final guiLabel d_nodeLbl;

        public NewCompGroupPnl(VentusData md) {
            this.d_md = md;
            SchematicNodeComboModel nodeModel = new SchematicNodeComboModel(md);
            this.d_nodeCB = new NodeComboBox<GeomComposite>(nodeModel);
            Dimension prefSize = this.d_nodeCB.getPreferredSize();
            if (prefSize.width < 300) {
                prefSize.width = 120;
                this.d_nodeCB.setPreferredSize(prefSize);
            }
            SelectionRibbonEditorPanel.adjustHeight(this.d_nodeCB);
            this.d_nodeLbl = new guiLabel(Intl.intl("Group:"));
            guiLabel title = new guiLabel(Intl.intl("New Schematic Components"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            gb.addRow(title, 0);
            gb.addIdentRow(this.d_nodeLbl, this.d_nodeCB);
            gb.finalizeRows();
        }

        private void updateEnabledStatus() {
            boolean nodeEnabled = this.d_md.floorOptions.get(FloorOptions.AUTO_SELECT_FLOOR) == false;
            this.d_nodeLbl.setEnabled(nodeEnabled);
            this.d_nodeCB.setEnabled(nodeEnabled);
        }

        @Override
        public void bind(Collection<IMerlinObj> arg0) {
            super.bind(arg0);
            this.updateEnabledStatus();
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(FloorOptions.class)) {
                this.updateEnabledStatus();
            }
        }
    }

    private static class FloorSortPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -1767295841240590359L;
        private final guiMultiStateCheckBox d_autoCreateFloorsCB = new guiMultiStateCheckBox(Intl.intl("Automatically create levels"));
        private final guiUnitDoubleField d_autoFloorDistFld;
        private final guiMultiStateCheckBox d_autoSortCompsCB;

        public FloorSortPnl(VentusData md) {
            guiUtil.setLongTooltip(this.d_autoCreateFloorsCB, Intl.intl("Automatically create new levels when adding/modifying schematics\ncomponents if they are outside the <b>Level height</b> of the previous level."));
            guiLabel distLbl = new guiLabel(Intl.intl("Default Height:"));
            distLbl.setToolTipText(Intl.intl("The minimum distance between levels to automatically create a new level."));
            this.d_autoFloorDistFld = new MerlinUDF(0, DoubleVR.above(0.0, false));
            this.d_autoSortCompsCB = new guiMultiStateCheckBox(Intl.intl("Auto sort schematics components"));
            guiUtil.setLongTooltip(this.d_autoSortCompsCB, Intl.intl("Automatically sort new and modified schematics components (rooms, doors, etc.)\ninto appropriate levels."));
            this.d_autoFloorDistFld.setPreferredSize(new Dimension(this.d_autoFloorDistFld.getPreferredSize().width, this.d_autoCreateFloorsCB.getPreferredSize().height - 2));
            LinkStatus.link2((AbstractButton)this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            LinkStatus.link2((AbstractButton)this.d_autoSortCompsCB, this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            this.addConnection(new FloorBoolConn(FloorOptions.AUTO_SELECT_FLOOR, this.d_autoSortCompsCB));
            this.addConnection(new AutoFloorDistUDConn(FloorOptions.MIN_AUTO_FLOOR_DIST, this.d_autoFloorDistFld));
            this.addConnection(new FloorBoolConn(FloorOptions.AUTO_CREATE_FLOOR, this.d_autoCreateFloorsCB));
            guiLabel title = new guiLabel(Intl.intl("Level Creation/Sorting"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(title, 2);
            gb.indent();
            gb.addRow(this.d_autoSortCompsCB, GridBagHelper.REMAINING);
            gb.addRow(this.d_autoCreateFloorsCB, GridBagHelper.REMAINING);
            gb.indent();
            gb.addRow(distLbl, this.d_autoFloorDistFld);
            gb.finalizeRows();
        }

        @Override
        public void update(Events events) {
            if (!events.isAffected(FloorOptions.class)) {
                return;
            }
            super.update(events);
        }
    }

    private static class ActiveFloorPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 0L;

        public ActiveFloorPnl(VentusData md) {
            guiMultiStateCheckBox showPrevLevel = new guiMultiStateCheckBox(Intl.intl("Show lower level"));
            showPrevLevel.setToolTipText(Intl.intl("Shows the level immediately below the active level. This also applies when making a level active."));
            TriConsumer<VentusData, Collection<? extends IMerlinObj>, Boolean> additionalAction = (vd, objs, showBelow) -> SetActiveFloor.setFloorBelowVisible(md, md.floors.getActive(), showBelow);
            this.addConnection(new FloorBoolConn(FloorOptions.SHOW_LOWER_FLOOR, showPrevLevel, additionalAction));
            guiMultiStateCheckBox limitSelActive = new guiMultiStateCheckBox(Intl.intl("Limit selection to active floor"));
            limitSelActive.setToolTipText("<html>" + Intl.intl("If only the active level and the level below are visible, 2D/3D selection<br>is limited to objects on the active level."));
            this.addConnection(new FloorBoolConn(FloorOptions.LIMIT_SELECTION_TO_ACTIVE, limitSelActive));
            guiUtil.link((AbstractButton)showPrevLevel, limitSelActive);
            guiLabel title = new guiLabel(Intl.intl("Active Level"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            gb.addRow(title, 0);
            gb.addIdentRow(showPrevLevel, 0);
            gb.addIdentRow(limitSelActive, 0);
            gb.finalizeRows();
        }

        @Override
        public void update(Events events) {
            if (!events.isAffected(FloorOptions.class)) {
                return;
            }
            super.update(events);
        }
    }

    private static class GenerateModelSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -4666497424727293639L;

        public GenerateModelSect(boolean global) {
            JButton btn = global ? new JButton(GenerateModelFromBIM.UI_HOOK_GLOBAL) : new JButton(GenerateModelFromBIM.UI_HOOK_CONTEXT);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(btn, 1.0, 0);
        }
    }

    private static class FloorSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 5269600870831455532L;

        public FloorSect() {
            MerlinUDF workingZFld = new MerlinUDF(0);
            MerlinUDF heightFld = new MerlinUDF(0);
            MerlinUDF zminFld = new MerlinUDF(0);
            zminFld.aliasValue(Floor.CURR_FLOOR, Intl.intl("CURR_LEVEL"), "");
            MerlinUDF zmaxFld = new MerlinUDF(0);
            zmaxFld.aliasValue(Floor.NEXT_FLOOR, Intl.intl("NEXT_LEVEL"), "");
            this.addConnection(new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(Floor.WORKING_Z), workingZFld));
            this.addConnection(new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(Floor.HEIGHT), heightFld));
            this.addConnection(new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(Floor.ZMIN_FILTER), zminFld));
            this.addConnection(new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(Floor.ZMAX_FILTER), zmaxFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("Working Z:"), workingZFld, 1.0, 0);
            gb.addRow(Intl.intl("Level Height:"), heightFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Min Filter:"), zminFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Max Filter:"), zmaxFld, 1.0, 0);
        }
    }

    private static class RoomInfoSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7471856652914712994L;
        private final guiUnitDoubleField d_fldArea;
        private final guiUnitDoubleField d_fldVolume;
        private final guiUnitDoubleField d_fldHeight;
        private volatile Thread d_lastUpdaterThread = null;
        private final guiLabel d_labArea = guiUtil.lbl(Intl.intl("Area:"), Intl.intl("The total floor area of the selection."));
        private final guiLabel d_labVolume;
        private final guiLabel d_labHeight;

        public RoomInfoSect() {
            this.d_fldArea = new MerlinUDF(2);
            this.d_fldArea.setEditable(false);
            this.d_labVolume = guiUtil.lbl(Intl.intl("Volume:"), Intl.intl("The total volume of the selection."));
            this.d_fldVolume = new MerlinUDF(16);
            this.d_fldVolume.setEditable(false);
            this.d_labHeight = guiUtil.lbl(Intl.intl("Height:"), Intl.intl("The level height of the selection."));
            this.d_fldHeight = new MerlinUDF(0);
            this.d_fldHeight.setEditable(false);
            Dimension preferredSize = this.d_fldArea.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.15);
            this.d_fldArea.setPreferredSize(preferredSize);
            this.d_fldVolume.setPreferredSize(preferredSize);
            this.d_fldHeight.setPreferredSize(preferredSize);
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagUtil.add(p, this.d_labVolume, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldVolume, 1, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labArea, 0, 1, 1, 1, 3, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldArea, 1, 1, 1, 1, 3, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labHeight, 0, 2, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldHeight, 1, 2, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
            this.addConnection(new Updater());
            this.addConnection(new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(ISchematicRoom.HEIGHT), this.d_fldHeight));
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.colSpace, 3);
            gb.addRow(this.d_labArea, this.d_fldArea, 1.0, 0);
            gb.addRow(this.d_labVolume, this.d_fldVolume, 1.0, 0);
            gb.popSpacing();
        }

        private UnitDouble accumulateUD(TypedProp<UnitDouble> prop, Collection<IMerlinObj> objs, Unit defUnit) {
            UnitDouble udSum = null;
            Collection<IMerlinObj> dColl = MerlinUtil.flattenComposites(objs);
            for (IMerlinObj leaf : dColl) {
                if (this.d_lastUpdaterThread != Thread.currentThread()) {
                    return new UnitDouble(0.0, defUnit);
                }
                PropValue<UnitDouble> property = leaf.getWithDetails(prop);
                if (!property.isUniform() || property.get() == null) continue;
                UnitDouble ud = property.get();
                if (udSum == null) {
                    udSum = ud;
                    continue;
                }
                udSum = udSum.add(ud);
            }
            if (udSum == null) {
                udSum = new UnitDouble(0.0, defUnit);
            }
            return udSum;
        }

        private class Updater
        implements PropConnections.IPropConnection {
            private Collection<IMerlinObj> d_objs;

            private Updater() {
            }

            @Override
            public void bind(Collection<IMerlinObj> objs) {
                this.d_objs = objs;
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                this.d_objs = Collections.EMPTY_LIST;
                RoomInfoSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                RoomInfoSect.this.d_lastUpdaterThread = new Thread(new PropUpdater(this.d_objs));
                RoomInfoSect.this.d_lastUpdaterThread.start();
            }
        }

        private class PropUpdater
        implements Runnable {
            private final Collection<IMerlinObj> d_elements;

            public PropUpdater(Collection<IMerlinObj> elements) {
                this.d_elements = elements;
            }

            @Override
            public void run() {
                VentusData vd = VentusApp.getAppData();
                try (VentusData.ReadLock lock = vd.lockRead();){
                    UnitSystem us = VentusApp.getApp().getUnitSystem();
                    UnitDouble area = RoomInfoSect.this.accumulateUD(ISchematicRoom.AREA, this.d_elements, us.getUnit(2));
                    UnitDouble volume = RoomInfoSect.this.accumulateUD(ISchematicRoom.VOLUME, this.d_elements, us.getUnit(16));
                    if (RoomInfoSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                        return;
                    }
                    EventQueue.invokeLater(() -> {
                        RoomInfoSect.this.d_fldArea.setValue(area);
                        RoomInfoSect.this.d_fldVolume.setValue(volume);
                    });
                }
            }
        }
    }

    private static class BoundsSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -6736958249381526284L;
        private final guiTextField d_xBoundsFld;
        private final guiTextField d_yBoundsFld;
        private final guiTextField d_zBoundsFld;
        private volatile Thread d_lastUpdaterThread = null;

        public BoundsSect() {
            this.setPreferredSize(new Dimension(150, 70));
            this.d_xBoundsFld = new guiTextField();
            this.d_yBoundsFld = new guiTextField();
            this.d_zBoundsFld = new guiTextField();
            this.d_xBoundsFld.setEditable(false);
            this.d_yBoundsFld.setEditable(false);
            this.d_zBoundsFld.setEditable(false);
            Dimension preferredSize = this.d_xBoundsFld.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.3);
            this.d_xBoundsFld.setPreferredSize(preferredSize);
            this.d_yBoundsFld.setPreferredSize(preferredSize);
            this.d_zBoundsFld.setPreferredSize(preferredSize);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            this.addConnection(new Updater());
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.colSpace, 3);
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            gb.popSpacing();
        }

        private void updateMinMax(Set<IMerlinObj> objs) {
            AABox bb = new AABox();
            if (objs != null) {
                for (IMerlinObj ice : objs) {
                    if (!(ice instanceof IMerlinGeomSrc)) continue;
                    AABox box = ((IMerlinGeomSrc)((Object)ice)).getBounds();
                    bb.add(box);
                }
            }
            Unit u = Geometry.LENGTH_UNIT;
            Point3d boundsMin = bb.getMin();
            Point3d boundsMax = bb.getMax();
            UnitSystem us = VentusApp.getApp().getUnitSystem();
            Unit length = us.getLength();
            BiFunction<Double, Double, String> formatBounds = (min, max) -> {
                if (min > max) {
                    return Intl.intl("<unknown>");
                }
                if (max - min >= Double.MAX_VALUE) {
                    return Intl.intl("<infinite>");
                }
                return String.format("%1.2f %s, %1.2f %s", UnitDouble.convert(min, u, length), length, UnitDouble.convert(max, u, length), length);
            };
            TriConsumer<guiTextField, Double, Double> updateFld = (fld, min, max) -> {
                String boundsStr = (String)formatBounds.apply((Double)min, (Double)max);
                fld.setText(boundsStr);
                fld.setToolTipText(boundsStr);
                fld.setCaretPosition(0);
            };
            updateFld.accept(this.d_xBoundsFld, boundsMin.x, boundsMax.x);
            updateFld.accept(this.d_yBoundsFld, boundsMin.y, boundsMax.y);
            updateFld.accept(this.d_zBoundsFld, boundsMin.z, boundsMax.z);
        }

        private class Updater
        implements PropConnections.IPropConnection {
            private Updater() {
            }

            @Override
            public void bind(Collection<IMerlinObj> objs) {
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                BoundsSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                BoundsSect.this.d_lastUpdaterThread = new Thread(new PropUpdater());
                BoundsSect.this.d_lastUpdaterThread.start();
            }
        }

        private class PropUpdater
        implements Runnable {
            @Override
            public void run() {
                if (BoundsSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MerlinSelectionModel sel = VentusApp.getApp().getData().selection;
                        Set<IMerlinObj> objs = sel.getSelected(IMerlinObj.class);
                        BoundsSect.this.updateMinMax(objs);
                    }
                });
            }
        }
    }

    private static class SceneGeomPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 7501610581410197415L;

        public SceneGeomPnl() {
            guiTextField objType = new guiTextField();
            this.addConnection(new PropConnections.TextPropConnection((TypedProp<String>)ImportedGeom.PROP_OBJECT_TYPE, objType));
            objType.setEnabled(false);
            guiComboBox<ImportType> importTypes = guiUtil.newCombo(type -> {
                if (type == null) {
                    return new Pair<String, Object>("", null);
                }
                return new Pair<String, String>(type.name, type.desc);
            }, Stream.of(ImportType.values()).sorted((t1, t2) -> {
                if (t1 == t2) {
                    return 0;
                }
                if (t1 == ImportType.IGNORED) {
                    return -1;
                }
                if (t2 == ImportType.IGNORED) {
                    return 1;
                }
                return t1.name.compareToIgnoreCase(t2.name);
            }).collect(Collectors.toList()));
            this.addConnection(new PropConnections.ComboPropConn<ImportType>(new CompElementActions.DefProp(ImportedGeom.PROP_IMPORTED_TYPE), importTypes));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            guiLabel typelbl = new guiLabel(Intl.intl("Object Type:"));
            typelbl.setToolTipText(Intl.intl("The object type as specified in the imported file."));
            guiLabel itypelbl = new guiLabel(Intl.intl("Import Type:"));
            itypelbl.setToolTipText("<html>" + Intl.intl("The object type used when generating model elements.<br>This is determined automatically if imported from an IFC file."));
            gb.addRow(typelbl, objType, 1.0, 0);
            gb.addRow(itypelbl, importTypes, 1.0, 0);
        }
    }

    private static class ColorDefProp
    implements CompElementActions.IObjectProp<IMerlinObj, Boolean> {
        private final CompElementActions.DefProp<IMerlinObj, Color> d_wrappedProp = new CompElementActions.DefProp(VentusData.COLOR);

        @Override
        public void set(VentusData md, Collection<? extends IMerlinObj> objs, Boolean newVal) {
            Color newColor = this.getNewColor(newVal);
            this.d_wrappedProp.set(md, objs, newColor);
        }

        @Override
        public PropValue<Boolean> get(VentusData md, Collection<? extends IMerlinObj> objs) {
            PropValue<Color> val = this.d_wrappedProp.get(md, objs);
            return val.map(v -> v != null);
        }

        private Color getNewColor(Boolean newVal) {
            if (!newVal.booleanValue()) {
                return null;
            }
            return Color.WHITE;
        }
    }

    private static class OpacityConn
    extends PropConnections.UDPropConnection {
        public OpacityConn(guiUnitDoubleField fld) {
            super(new OpacityUDProp(), fld);
            fld.setEmptyAllowed(true);
            fld.setValueRange(UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            fld.setColumns(5);
        }

        private static class OpacityUDProp
        implements CompElementActions.IObjectProp<IMerlinObj, UnitDouble> {
            private final CompElementActions.IObjectProp<IMerlinObj, IOpacity> d_opacity = new CompElementActions.DefProp<IMerlinObj, IOpacity>(VentusData.OPACITY);

            private OpacityUDProp() {
            }

            @Override
            public PropValue<UnitDouble> get(VentusData md, Collection<? extends IMerlinObj> objs) {
                return this.d_opacity.get(md, objs).map(opac -> {
                    double cval = opac.getValue();
                    return new UnitDouble(Math.round(cval * 100.0), NonSI.PERCENT);
                });
            }

            @Override
            public void set(VentusData md, Collection<? extends IMerlinObj> objs, UnitDouble newVal) {
                UnitDouble udval = newVal;
                Opacity opacityVal = new Opacity((float)(udval.getValue(NonSI.PERCENT) * 0.01));
                this.d_opacity.set(md, objs, opacityVal);
            }
        }
    }

    private static class FloorBoolConn
    extends PropConnections.BoolPropConnection {
        public FloorBoolConn(TypedProp<Boolean> prop, guiMultiStateCheckBox cb) {
            this(prop, cb, (a, b, c) -> {});
        }

        public FloorBoolConn(TypedProp<Boolean> prop, guiMultiStateCheckBox cb, TriConsumer<VentusData, Collection<? extends IMerlinObj>, Boolean> additionalAction) {
            super((CompElementActions.IObjectProp<IMerlinObj, Boolean>)new FloorProp<Boolean>(prop, additionalAction), cb);
        }

        @Override
        protected boolean isDataEmpty() {
            return false;
        }
    }

    private static class FloorProp<ValT>
    implements CompElementActions.IObjectProp<IMerlinObj, ValT> {
        private final TypedProp<ValT> d_floorProp;
        private final TriConsumer<VentusData, Collection<? extends IMerlinObj>, ValT> d_additionalAction;

        public FloorProp(TypedProp<ValT> floorProp) {
            this(floorProp, (d, objs, newVal) -> {});
        }

        public FloorProp(TypedProp<ValT> floorProp, TriConsumer<VentusData, Collection<? extends IMerlinObj>, ValT> additionalAction) {
            this.d_floorProp = floorProp;
            this.d_additionalAction = additionalAction;
        }

        @Override
        public PropValue<ValT> get(VentusData md, Collection<? extends IMerlinObj> objs) {
            return md.floorOptions.getWithDetails(this.d_floorProp);
        }

        @Override
        public void set(VentusData md, Collection<? extends IMerlinObj> objs, ValT newVal) {
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_restore(md, md.floorOptions);
            md.floorOptions.set(this.d_floorProp, newVal);
            this.d_additionalAction.accept(md, objs, newVal);
            Undo.end(md);
        }
    }

    private static class AutoFloorDistUDConn
    extends PropConnections.UDPropConnection {
        public AutoFloorDistUDConn(TypedProp<UnitDouble> prop, guiUnitDoubleField fld) {
            super((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new FloorProp<UnitDouble>(prop, (md, objs, newVal) -> {
                Collection<Floor> floors = md.floors.getMembers(Floor.class);
                if (floors.size() == 1) {
                    Floor baseFloor = floors.iterator().next();
                    Application app = Application.getApp();
                    if (baseFloor.getChildren().size() == 0 && app != null) {
                        String msg = Intl.intl("Would you like to apply the new Default Height to the base level?");
                        String title = Intl.intl("Apply Default Height");
                        int opts = 0;
                        int result = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, title, opts);
                        if (result == 0) {
                            baseFloor.setHeight((UnitDouble)newVal);
                        }
                    }
                }
            }), fld);
        }

        @Override
        protected boolean isDataEmpty() {
            return false;
        }
    }

    private static class SchematicNodeComboModel
    extends NodeComboModel<GeomComposite> {
        private static final long serialVersionUID = -5915100069213541260L;
        private static final String NEW_GROUP_ITEM = Intl.intl("<Add New...>");
        private final VentusData d_data;
        private final ListDataListener d_listener;

        public SchematicNodeComboModel(VentusData md) {
            super(md, GeomComposite.class, new RootFinder());
            this.d_data = md;
            this.d_listener = new ListDataListener(this){

                @Override
                public void contentsChanged(final ListDataEvent e) {
                    AMerlinOp op = new AMerlinOp(this){

                        @Override
                        public void run(VentusApp app, VentusData md) {
                            try (VentusData.WriteLock lock = md.lockWrite();){
                                Undo.begin(Intl.intl("Change Working Group"));
                                NodeComboModel model = (NodeComboModel)e.getSource();
                                SetWorkingGroup.setWorkingGroup(md, md.activeFloor(), (GeomComposite)model.getSelectedNode());
                                Undo.end(md);
                            }
                        }
                    };
                    UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.SchematicNodeComboModel.ListDataListener.contentsChanged", op, 20);
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            };
            md.getEvents().addObserver(this);
        }

        @Override
        protected Collection<?> getObjects() {
            Collection<?> superObjs = super.getObjects();
            ArrayList<Object> objs = new ArrayList<Object>(superObjs.size() + 2);
            objs.add(NEW_GROUP_ITEM);
            objs.add(new JSeparator(0));
            objs.addAll(superObjs);
            return objs;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == NEW_GROUP_ITEM) {
                AMerlinOp op = new AMerlinOp(this){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        Floor activeFloor = md.floors.getActive();
                        NewGroup.addNewGroup(VentusApp.getApp(), md, Arrays.asList(activeFloor), activeFloor);
                    }
                };
                UIHook.run(null, "SelectionEditorPanel.SchematicNodeComboModel.setSelectedItem", op, 20);
            } else {
                super.setSelectedItem(anObject);
            }
        }

        @Override
        public void update(Events events) {
            this.removeListDataListener(this.d_listener);
            super.update(events);
            boolean update = false;
            for (EventChannel<FloorComposite> eventChannel : events.getAffectedChannels(FloorComposite.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(FloorComposite.ACTIVE_FLOOR)) continue;
                update = true;
                break;
            }
            for (EventChannel<Composite> eventChannel : events.getAffectedChannels(Floor.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(Floor.WORKING_GROUP)) continue;
                update = true;
                break;
            }
            if (update) {
                this.setSelectedNode(this.d_data.activeFloor().getWorkingGeomGroup());
            }
            this.addListDataListener(this.d_listener);
        }

        private static class RootFinder
        implements NodeComboModel.RootFinder<GeomComposite> {
            private RootFinder() {
            }

            @Override
            public Collection<? extends GeomComposite<?>> getRoots(VentusData md) {
                return Arrays.asList(md.activeFloor());
            }

            @Override
            public boolean includeRoot() {
                return true;
            }

            @Override
            public Predicate<? super GeomComposite> getFilter(VentusData md) {
                return Predicates.alwaysTrue();
            }
        }
    }
}

