/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.util.Observable;
import java.util.Observer;
import ventus.data.ImportedGeom;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.GeomDispMgr;
import ventus.mv.displays.IMerlinDisplay;
import ventus.mv.displays.IPropsDisplay;
import ventus.util.MerlinProps;

public abstract class APropsDisplay<T extends MerlinProps>
implements Observer,
IPropsDisplay<T> {
    private final ModelView d_mv;
    private final MerlinProps.WeakRef<T> d_builder;
    private final GeomDispMgr.Display d_geomDisplay;

    public APropsDisplay(ModelView mv) {
        this.d_mv = mv;
        this.d_builder = new MerlinProps.WeakRef(this);
        this.d_geomDisplay = new GeomDispMgr.Display(mv.getDisplayProps(), this.constructGeom());
    }

    protected abstract IMerlinGeomSrc constructGeom(T var1);

    protected abstract Object[] getInterestingChanges();

    private IMerlinGeomSrc constructGeom() {
        IMerlinGeomSrc source = null;
        if (!this.d_builder.isNull()) {
            source = this.constructGeom(this.d_builder.val());
        }
        return source == null ? new ImportedGeom("") : source;
    }

    @Override
    public void update(Observable o, Object arg) {
        Object[] changes = this.getInterestingChanges();
        if (!this.d_builder.isNull() && (changes.length == 0 || ((MerlinProps)this.d_builder.val()).aPropChanged(changes))) {
            this.updateDisplay();
            this.d_mv.repaint();
        }
    }

    @Override
    public void setProps(T props) {
        this.d_builder.set(props);
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.d_geomDisplay.setSource(this.constructGeom());
    }

    @Override
    public IMerlinDisplay getDisplay() {
        return this.d_geomDisplay;
    }
}

