/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.StringRenderer;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;
import ventus.mv.displays.IMerlinDisplay;

public abstract class AEdgeLengthDisplay<T extends IDisplayableGeomSrc>
implements IMerlinDisplay {
    protected ArrayList<StringRenderer> d_texts;
    protected final ArrayList<TextRenderer> d_textRenderers;
    private final IMerlinDisplay d_geomDisplay;
    private final int TEXTS = 30;

    public AEdgeLengthDisplay(IMerlinDisplay d) {
        this.d_geomDisplay = d;
        this.d_texts = new ArrayList();
        this.d_textRenderers = new ArrayList();
        for (int i = 0; i < 30; ++i) {
            StringRenderer text = new StringRenderer();
            TextRenderer tr = this.genTextRenderer();
            this.d_textRenderers.add(tr);
            text.setRenderer(tr);
            this.d_texts.add(text);
        }
    }

    private TextRenderer genTextRenderer() {
        TextRenderer tr = new TextRenderer();
        tr.setFontSize(16.0f);
        tr.setLeaderEnabled(false);
        tr.setMode(0);
        tr.setRenderType(0);
        tr.setPadding(new int[]{4, 4, 4, 4});
        tr.setFontColor(Color.GREEN);
        return tr;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_geomDisplay.setVisible(visible);
        for (StringRenderer tr : this.d_texts) {
            tr.setVisible(visible);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_geomDisplay.setSelected(selected);
    }

    @Override
    public void update() {
        ArrayList<String> s = this.getLabelTexts(30);
        for (int i = 0; i < s.size() && i < 30; ++i) {
            this.d_texts.get(i).setString(s.get(i));
            this.updateTextLocation(i);
        }
    }

    @Override
    public IDisplayable[] getDisplayObjs() {
        int i;
        int numGeomDisp = this.d_geomDisplay.getDisplayObjs().length;
        int n = numGeomDisp + this.d_texts.size();
        IDisplayable[] displays = new IDisplayable[n + 1];
        for (i = 0; i < numGeomDisp; ++i) {
            displays[i] = this.d_geomDisplay.getDisplayObjs()[i];
        }
        for (i = 0; i < this.d_texts.size(); ++i) {
            displays[i + numGeomDisp] = this.d_texts.get(i);
        }
        return displays;
    }

    public abstract ArrayList<String> getLabelTexts(int var1);

    public abstract void updateTextLocation(int var1);
}

