/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Properties;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.colorscheme.ColorMgr;
import thunderheadeng.gui.colorscheme.ColorScheme;
import thunderheadeng.scene3d.SceneColors;
import thunderheadeng.util.IPropertySet;
import ventus.Intl;

public class MerlinColors
extends ColorMgr {
    public static final IPropertySet.Prop<Color> BACKGROUND_COLOR = new IPropertySet.Prop<Color>("background", new Color(5527918));
    public static final IPropertySet.Prop<Color> BACKGROUND_COLOR2 = new IPropertySet.Prop<Color>("background2", new Color(3027784));
    public static final IPropertySet.Prop<Color> TEXT_COLOR = new IPropertySet.Prop<Color>("text", Color.WHITE);
    public static final IPropertySet.Prop<Color> AXIS_COLOR = new IPropertySet.Prop<Color>("axis", Color.YELLOW);
    public static final IPropertySet.Prop<Color> AXIS_BOX_COLOR = new IPropertySet.Prop<Color>("axis.box", new Color(6909833));
    public static final IPropertySet.Prop<Color> AXIS_TEXT_COLOR = new IPropertySet.Prop<Color>("axis.text", new Color(0xCCCCCC));
    public static final IPropertySet.Prop<Color> SNAP_TO_GRID_COLOR = new IPropertySet.Prop<Color>("snapto.lines", new Color(6383231));
    public static final IPropertySet.Prop<Color> SNAP_TO_POINTS_COLOR = new IPropertySet.Prop<Color>("snapto.points", new Color(9015209));
    public static final IPropertySet.Prop<Color> ORIGIN2D_COLOR = new IPropertySet.Prop<Color>("origin2D", new Color(0.65f, 0.65f, 0.65f));
    public static final IPropertySet.Prop<Color> BOUNDARY_COLOR = new IPropertySet.Prop<Color>("boundary", Color.WHITE);
    private final ColorScheme d_blackBackground;
    private final ColorScheme d_whiteBackground;
    private final ColorScheme d_darkScheme;
    private final ColorScheme d_lightScheme;
    public static final ColorScheme DEFAULT = new ColorScheme(Intl.intl("Default"));

    public MerlinColors() {
        this.addScheme(DEFAULT);
        this.setCurrentColorScheme(DEFAULT);
        this.d_blackBackground = new ColorScheme(Intl.intl("Black Background"));
        this.setBlackColors(this.d_blackBackground);
        this.addScheme(this.d_blackBackground);
        this.d_whiteBackground = new ColorScheme(Intl.intl("White Background"));
        MerlinColors.setWhiteColors(this.d_whiteBackground);
        this.addScheme(this.d_whiteBackground);
        this.d_darkScheme = new ColorScheme(Intl.intl("Dark"));
        this.setDarkColors(this.d_darkScheme);
        this.addScheme(this.d_darkScheme);
        this.d_lightScheme = new ColorScheme(Intl.intl("Light"));
        this.setLightColors(this.d_lightScheme);
        this.addScheme(this.d_lightScheme);
        ColorScheme custom = new ColorScheme(Intl.intl("Custom"));
        this.setBlackColors(custom);
        this.addScheme(custom);
    }

    @Override
    public void load(Properties props) {
        super.load(props);
        this.setBlackColors(this.d_blackBackground);
        MerlinColors.setWhiteColors(this.d_whiteBackground);
        MerlinColors.setDefaultColors(DEFAULT);
    }

    private void setDarkColors(ColorScheme scheme) {
        scheme.setColor(BACKGROUND_COLOR, new Color(12605));
        scheme.setColor(BACKGROUND_COLOR2, new Color(9520));
        scheme.setColor(TEXT_COLOR, Color.WHITE);
        scheme.setColor(AXIS_COLOR, new Color(2526162));
        scheme.setColor(AXIS_BOX_COLOR, new Color(5795445));
        scheme.setColor(AXIS_TEXT_COLOR, new Color(15657173));
        scheme.setColor(ORIGIN2D_COLOR, new Color(5795445));
        scheme.setColor(SNAP_TO_GRID_COLOR, new Color(472642));
        scheme.setColor(SNAP_TO_POINTS_COLOR, new Color(5795445));
        scheme.setColor(SceneColors.TOOL_COLOR, new Color(3716604));
        scheme.setColor(SceneColors.TOOL_GUIDES_COLOR, new Color(2526162));
        scheme.setColor(SceneColors.SNAP_POINT_COLOR, new Color(13842050));
        scheme.setColor(BOUNDARY_COLOR, new Color(15657173));
    }

    private void setLightColors(ColorScheme scheme) {
        scheme.setColor(BACKGROUND_COLOR, new Color(16182744));
        scheme.setColor(BACKGROUND_COLOR2, new Color(0xFFFFEC));
        scheme.setColor(TEXT_COLOR, Color.WHITE);
        scheme.setColor(AXIS_COLOR, new Color(2526162));
        scheme.setColor(AXIS_BOX_COLOR, new Color(9675169));
        scheme.setColor(AXIS_TEXT_COLOR, new Color(472642));
        scheme.setColor(ORIGIN2D_COLOR, new Color(9675169));
        scheme.setColor(SNAP_TO_GRID_COLOR, new Color(15657173));
        scheme.setColor(SNAP_TO_POINTS_COLOR, new Color(9675169));
        scheme.setColor(SceneColors.TOOL_COLOR, new Color(26536));
        scheme.setColor(SceneColors.TOOL_GUIDES_COLOR, new Color(2526162));
        scheme.setColor(SceneColors.SNAP_POINT_COLOR, new Color(14430767));
        scheme.setColor(BOUNDARY_COLOR, new Color(472642));
    }

    private void setBlackColors(ColorScheme scheme) {
        scheme.setColor(BACKGROUND_COLOR, Color.BLACK);
        scheme.setColor(BACKGROUND_COLOR2, Color.BLACK);
        scheme.setColor(TEXT_COLOR, Color.WHITE);
        scheme.setColor(AXIS_COLOR, Color.YELLOW);
        scheme.setColor(AXIS_BOX_COLOR, Color.DARK_GRAY);
        scheme.setColor(AXIS_TEXT_COLOR, Color.WHITE);
        scheme.setColor(ORIGIN2D_COLOR, new Color(0.45f, 0.45f, 0.45f));
        scheme.setColor(SNAP_TO_GRID_COLOR, Color.DARK_GRAY);
        scheme.setColor(SNAP_TO_POINTS_COLOR, Color.LIGHT_GRAY);
        scheme.setColor(SceneColors.TOOL_COLOR, Color.GREEN);
        scheme.setColor(SceneColors.TOOL_GUIDES_COLOR, Color.GREEN.darker().darker());
        scheme.setColor(SceneColors.SNAP_POINT_COLOR, Color.GREEN.brighter());
        scheme.setColor(BOUNDARY_COLOR, Color.WHITE);
    }

    private static void setWhiteColors(ColorScheme scheme) {
        scheme.setColor(BACKGROUND_COLOR, Color.white);
        scheme.setColor(BACKGROUND_COLOR2, Color.white);
        scheme.setColor(TEXT_COLOR, Color.black);
        scheme.setColor(AXIS_COLOR, Color.blue);
        scheme.setColor(AXIS_BOX_COLOR, Color.lightGray);
        scheme.setColor(AXIS_TEXT_COLOR, Color.black);
        scheme.setColor(ORIGIN2D_COLOR, Color.black);
        scheme.setColor(SNAP_TO_GRID_COLOR, new Color(0.9f, 0.9f, 0.9f));
        scheme.setColor(SNAP_TO_POINTS_COLOR, new Color(0.55f, 0.55f, 0.55f));
        scheme.setColor(SceneColors.TOOL_COLOR, new Color(0.251f, 0.251f, 1.0f));
        scheme.setColor(SceneColors.TOOL_GUIDES_COLOR, new Color(0.376f, 0.722f, 1.0f));
        scheme.setColor(SceneColors.SNAP_POINT_COLOR, Color.BLUE.brighter());
        scheme.setColor(BOUNDARY_COLOR, Color.BLACK);
    }

    private static void setDefaultColors(ColorScheme scheme) {
        scheme.setColor(SceneColors.TOOL_COLOR, new Color(0.251f, 0.251f, 1.0f));
        scheme.setColor(SceneColors.TOOL_GUIDES_COLOR, new Color(0.376f, 0.722f, 1.0f));
        scheme.setColor(SceneColors.SNAP_POINT_COLOR, Color.BLUE.brighter());
    }

    @Override
    public void store(Properties props) {
        ArrayList<ColorChangedListener> listeners = new ArrayList<ColorChangedListener>(this.getListeners());
        for (ColorChangedListener listener : listeners) {
            this.removeColorChangedListener(listener);
        }
        this.removeScheme(this.d_blackBackground.getName());
        this.removeScheme(this.d_whiteBackground.getName());
        this.removeScheme(DEFAULT.getName());
        super.store(props);
    }

    static {
        MerlinColors.setDefaultColors(DEFAULT);
    }
}

