/*
 * Decompiled with CFR 0.152.
 */
package ventus.legacy.v0201.feature.flowpaths;

import java.awt.Color;
import java.util.function.Function;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.data.Composite;
import ventus.feature.flowpaths.FlowElement;

public class FlowElementRoot
extends Composite<FlowElement> {
    private static final long serialVersionUID = 1L;

    public FlowElementRoot(String name) {
        super(name);
    }

    public static enum Default {
        WALL(type -> {
            FlowElement wall = new FlowElement(Intl.intl("WALL"), null, new Color(175, 50, 50), FlowElement.PowerlawModel.LEAKAGE_AREA);
            wall.set(FlowElement.DISCHARGE_COEFFICIENT, 0.6);
            wall.set(FlowElement.PRESSURE_EXPONENT, 0.65);
            wall.set(FlowElement.PRESSURE_DIFFERENCE, new UnitDouble(10.0, SI.PASCAL));
            wall.set(FlowElement.LEAKAGE_AREA_TYPE, FlowElement.LeakageAreaType.AREA);
            wall.set(FlowElement.LEAKAGE_AREA_PER_ITEM, new UnitDouble(3.5E-4, SI.METER.pow(2)));
            return wall;
        }),
        DOOR(type -> {
            FlowElement door = new FlowElement(Intl.intl("DOOR"), null, new Color(50, 175, 50), FlowElement.PowerlawModel.LEAKAGE_AREA);
            door.set(FlowElement.DISCHARGE_COEFFICIENT, 0.6);
            door.set(FlowElement.PRESSURE_EXPONENT, 0.65);
            door.set(FlowElement.PRESSURE_DIFFERENCE, new UnitDouble(10.0, SI.PASCAL));
            door.set(FlowElement.LEAKAGE_AREA_TYPE, FlowElement.LeakageAreaType.ITEM);
            door.set(FlowElement.LEAKAGE_AREA_PER_ITEM, new UnitDouble(0.0158, SI.METER.pow(2)));
            return door;
        }),
        STAIRWELL(type -> {
            FlowElement stairwell = new FlowElement(Intl.intl("STAIRWELL"), null, new Color(50, 50, 175), FlowElement.PowerlawModel.STAIRWELL);
            stairwell.set(FlowElement.CROSS_SECTIONAL_AREA, new UnitDouble(12.5, SI.METER.pow(2)));
            stairwell.set(FlowElement.PEOPLE_DENSITY, new UnitDouble(0.0, Unit.ONE.divide(SI.METER.pow(2))));
            stairwell.set(FlowElement.STAIR_TREADS_OPEN, false);
            stairwell.set(FlowElement.PRESSURE_EXPONENT, 0.5);
            return stairwell;
        }),
        ELEVATOR(type -> {
            FlowElement elevator = new FlowElement(Intl.intl("ELEVATOR"), null, new Color(142, 50, 175), FlowElement.PowerlawModel.SHAFT);
            elevator.set(FlowElement.CROSS_SECTIONAL_AREA, new UnitDouble(6.0, SI.METER.pow(2)));
            elevator.set(FlowElement.PERIMETER, new UnitDouble(10.0, SI.METER));
            elevator.set(FlowElement.ROUGHNESS, new UnitDouble(0.1, SI.METER));
            elevator.set(FlowElement.REYNOLDS_NUMBER, 1000.0);
            return elevator;
        }),
        HOLE(type -> {
            FlowElement hole = new FlowElement(Intl.intl("HOLE"), null, new Color(33, 45, 39), FlowElement.PowerlawModel.ORIFICE_AREA);
            hole.set(FlowElement.CROSS_SECTIONAL_AREA, new UnitDouble(0.1, SI.METER.pow(2)));
            hole.set(FlowElement.DISCHARGE_COEFFICIENT, 0.6);
            hole.set(FlowElement.PRESSURE_EXPONENT, 0.5);
            hole.set(FlowElement.REYNOLDS_NUMBER, 30.0);
            return hole;
        });

        public final Function<Default, FlowElement> create;

        private Default(Function<Default, FlowElement> create) {
            this.create = create;
        }
    }
}

