/*
 * Decompiled with CFR 0.152.
 */
package ventus.io.contamx;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;
import ventus.gui.RunSimDlg;
import ventus.io.contamx.PrjData;

public class RunUtil {
    private static File cxExe(String installDir, String name) {
        return new File(installDir + "\\contam-3.4.0.5-win32", name);
    }

    public static int run(String installFolder, File input, PrjData data, RunSimDlg dlg) throws IOException, InterruptedException {
        if (dlg != null) {
            dlg.setTitleFromPath(input.getName());
        }
        File contamx = RunUtil.cxExe(installFolder, "contamx3.exe");
        ProcessBuilder pbSim = new ProcessBuilder(contamx.getPath(), input.getName());
        pbSim.directory(input.getParentFile());
        int errcode = RunUtil.exec(dlg, pbSim, List.of());
        if (errcode == 0) {
            File simread = RunUtil.cxExe(installFolder, "simread.exe");
            ProcessBuilder pbOutputGen = new ProcessBuilder(simread.getPath(), input.getName());
            pbOutputGen.directory(input.getParentFile());
            ArrayList<String> inputs = new ArrayList<String>();
            if (data.nn > 0) {
                inputs.add("y");
                inputs.add("");
                inputs.add("");
                inputs.add("2");
            }
            if (data.nzone > 0) {
                inputs.add("y");
                inputs.add("");
            }
            if (data.npath > 0) {
                inputs.add("y");
                inputs.add("");
            }
            RunUtil.exec(dlg, pbOutputGen, inputs);
        }
        return errcode;
    }

    private static int exec(RunSimDlg dlg, ProcessBuilder pb, List<String> processInput) throws IOException, InterruptedException {
        List<String> errs = Arrays.asList("WARNING", "ERROR", "FATAL");
        if (dlg != null) {
            dlg.printToLog("CMD: " + Arrays.toString(pb.command().toArray()));
        }
        Process p = pb.start();
        if (dlg != null) {
            dlg.setState(1);
        }
        Semaphore sem = new Semaphore(1);
        Consumer<BufferedReader> writeDlg = reader -> reader.lines().forEachOrdered(line -> {
            try {
                if (dlg != null) {
                    sem.acquire();
                    String first = Arrays.stream(line.split(" ")).findFirst().orElse("");
                    if (errs.contains(first)) {
                        dlg.printToWarn((String)line);
                    } else {
                        dlg.printToLog((String)line);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                sem.release();
            }
        });
        Thread writerThread = new Thread(() -> {
            try (PrintWriter writer = RunUtil.createWriter(p.getOutputStream());){
                for (String line : processInput) {
                    writer.println(line);
                }
            }
        });
        writerThread.start();
        Thread stdOutThread = new Thread(() -> {
            try (BufferedReader reader = RunUtil.createReader(p.getInputStream());){
                writeDlg.accept(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        stdOutThread.start();
        Thread stdErrThread = new Thread(() -> {
            try (BufferedReader reader = RunUtil.createReader(p.getErrorStream());){
                writeDlg.accept(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        stdErrThread.start();
        int result = p.waitFor();
        stdErrThread.join();
        stdOutThread.join();
        if (dlg != null) {
            dlg.printToLog("EXIT CODE: " + result);
        }
        return result;
    }

    private static PrintWriter createWriter(OutputStream os) {
        return new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    private static BufferedReader createReader(InputStream os) {
        return new BufferedReader(new InputStreamReader(os, StandardCharsets.UTF_8));
    }

    public static void fixSqlite3OutputFilename(File prjFile, String baseName) {
        if (!prjFile.exists()) {
            return;
        }
        File outputFolder = prjFile.getParentFile();
        File[] files = outputFolder.listFiles();
        if (files == null) {
            return;
        }
        File found = null;
        for (File f : files) {
            String fn = f.getName();
            if (!fn.startsWith(baseName) || !fn.endsWith(".sqlite3") || f.lastModified() <= prjFile.lastModified()) continue;
            found = f;
            break;
        }
        if (found != null && !baseName.equals(FilenameUtils.getBaseName(found.getPath()))) {
            String baseNameWithScenarioId = FilenameUtils.getBaseName(prjFile.getPath());
            boolean result = found.renameTo(new File(outputFolder, baseNameWithScenarioId + ".sqlite3"));
            assert (result) : "rename failed";
        }
    }
}

